/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util;

import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;

public class SettingsRepoUtils {
    public static void showRepo(NutsApplicationContext context, NutsRepository repository, String prefix) {
        boolean enabled = repository.config().isEnabled();
        String disabledString = enabled ? "" : " <DISABLED>";
        NutsPrintStream out = context.getSession().out();
        out.print(prefix);
        NutsTexts factory = NutsTexts.of((NutsSession)context.getSession());
        if (enabled) {
            out.print((NutsString)factory.ofStyled(repository.getName() + disabledString, NutsTextStyle.primary2()));
        } else {
            out.print("```error " + repository.getName() + disabledString + "```");
        }
        out.print(" : " + repository.getRepositoryType() + " " + repository.config().getLocation());
        out.println();
    }

    public static void showRepoTree(NutsApplicationContext context, NutsRepository repository, String prefix) {
        SettingsRepoUtils.showRepo(context, repository, prefix);
        String prefix1 = prefix + "  ";
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository c : repository.config().getMirrors()) {
                SettingsRepoUtils.showRepoTree(context, c, prefix1);
            }
        }
    }
}

