/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.Arrays;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsUserSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        return NutsSettingsUserSubCommand.exec(null, cmdLine, autoSave, session);
    }

    public static boolean exec(NutsRepository editedRepo, NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"add user", "au"}) != null) {
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryId", (NutsSession)session)).getString());
            }
            if (repository == null) {
                String user = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Username", (NutsSession)session)).getString();
                char[] password = cmdLine.nextNonOption(NutsArgumentName.of((String)"Password", (NutsSession)session)).getString().toCharArray();
                if (cmdLine.isExecMode()) {
                    session.security().addUser(user).setCredentials(password).run();
                }
            } else {
                String user = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Username", (NutsSession)session)).getString();
                char[] password = cmdLine.nextNonOption(NutsArgumentName.of((String)"Password", (NutsSession)session)).getString().toCharArray();
                String mappedUser = null;
                char[] remotePassword = null;
                if (!cmdLine.isEmpty()) {
                    mappedUser = cmdLine.nextNonOption(NutsArgumentName.of((String)"RemoteId", (NutsSession)session)).getString();
                    remotePassword = cmdLine.nextNonOption(NutsArgumentName.of((String)"RemotePassword", (NutsSession)session)).getString().toCharArray();
                }
                if (cmdLine.isExecMode()) {
                    repository.security().addUser(user).setCredentials(password).setRemoteIdentity(mappedUser).setRemoteCredentials(remotePassword).run();
                }
            }
            if (cmdLine.isExecMode()) {
                session.config().save();
            }
            return true;
        }
        NutsPrintStream out = session.out();
        if (cmdLine.next(new String[]{"list users", "lu"}) != null) {
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"repository", (NutsSession)session)).getString());
            }
            if (cmdLine.isExecMode()) {
                NutsUser[] security = repository == null ? session.security().findUsers() : repository.security().findUsers();
                for (NutsUser u : security) {
                    out.printf("User: %s%n", new Object[]{u.getUser()});
                    if (!NutsBlankable.isBlank((String)u.getRemoteIdentity())) {
                        out.printf("   Mapper to  : %s%n", new Object[]{u.getRemoteIdentity()});
                    }
                    out.printf("   Password   : %s%n", new Object[]{u.hasCredentials() ? "Set" : "None"});
                    out.printf("   Groups     : %s%n", new Object[]{u.getGroups().length == 0 ? "None" : Arrays.asList(u.getGroups())});
                    out.printf("   Rights     : %s%n", new Object[]{u.getPermissions().length == 0 ? "None" : Arrays.asList(u.getPermissions())});
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"password", "passwd", "pwd"}) != null) {
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryId", (NutsSession)session)).getString());
            }
            String user = null;
            char[] password = null;
            char[] oldPassword = null;
            do {
                if (cmdLine.next(new String[]{"--user"}) != null) {
                    user = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Username", (NutsSession)session)).getString();
                    continue;
                }
                if (cmdLine.next(new String[]{"--password"}) != null) {
                    password = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Password", (NutsSession)session)).getString().toCharArray();
                    continue;
                }
                if (cmdLine.next(new String[]{"--old-password"}) != null) {
                    oldPassword = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"OldPassword", (NutsSession)session)).getString().toCharArray();
                    continue;
                }
                cmdLine.setCommandName("config password").unexpectedArgument();
            } while (cmdLine.hasNext());
            if (cmdLine.isExecMode()) {
                boolean admin = repository == null ? session.security().isAllowed("admin") : repository.security().isAllowed("admin");
                if (oldPassword == null && !admin) {
                    oldPassword = session.getTerminal().readPassword("Old Password:", new Object[0]);
                }
                if (password == null) {
                    password = session.getTerminal().readPassword("Password:", new Object[0]);
                }
                if (repository == null) {
                    session.security().updateUser(user).setCredentials(password).setOldCredentials(oldPassword).run();
                } else {
                    repository.security().updateUser(user).setCredentials(password).setOldCredentials(oldPassword).run();
                }
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"edit user", "eu"}) != null) {
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryId", (NutsSession)session)).getString());
            }
            String user = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Username", (NutsSession)session)).getString();
            if (cmdLine.isExecMode()) {
                NutsUser u = null;
                u = repository == null ? session.security().findUser(user) : repository.security().getEffectiveUser(user);
                if (u == null) {
                    throw new NutsElementNotFoundException(session, NutsMessage.cstyle((String)"no such user %s", (Object[])new Object[]{user}));
                }
            }
            String lastOption = "";
            block18: while (cmdLine.hasNext()) {
                if (cmdLine.next(new String[]{"--add-group"}) != null) {
                    lastOption = "--add-group";
                    continue;
                }
                if (cmdLine.next(new String[]{"--remove-group"}) != null) {
                    lastOption = "--remove-group";
                    continue;
                }
                if (cmdLine.next(new String[]{"--add-right"}) != null) {
                    lastOption = "--add-right";
                    continue;
                }
                if (cmdLine.next(new String[]{"--remove-right"}) != null) {
                    lastOption = "--remove-right";
                    continue;
                }
                if (cmdLine.next(new String[]{"--mapped-user"}) != null) {
                    lastOption = "--mapped-user";
                    continue;
                }
                if (cmdLine.next(new String[]{"--password"}) != null) {
                    lastOption = "--password";
                    continue;
                }
                switch (lastOption) {
                    case "--add-group": {
                        String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Group", (NutsSession)session)).getString();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).addGroup(a).run();
                            continue block18;
                        }
                        session.security().updateUser(user).addGroup(a).run();
                        continue block18;
                    }
                    case "--remove-group": {
                        String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Group", (NutsSession)session)).getString();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).removeGroup(a).run();
                            continue block18;
                        }
                        session.security().updateUser(user).removeGroup(a).run();
                        continue block18;
                    }
                    case "--add-right": {
                        String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Right", (NutsSession)session)).getString();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).addPermission(a).run();
                            continue block18;
                        }
                        session.security().updateUser(user).addPermission(a).run();
                        continue block18;
                    }
                    case "--remove-right": {
                        String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"Right", (NutsSession)session)).getString();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).removePermission(a).run();
                            continue block18;
                        }
                        session.security().updateUser(user).removePermission(a).run();
                        continue block18;
                    }
                    case "--mapped-user": {
                        String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RemoteIdentity", (NutsSession)session)).getString();
                        if (!cmdLine.isExecMode()) continue block18;
                        if (repository != null) {
                            repository.security().updateUser(user).setRemoteIdentity(a).run();
                            continue block18;
                        }
                        session.security().updateUser(user).setRemoteIdentity(a).run();
                        continue block18;
                    }
                    case "--password": {
                        char[] pwd = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"password", (String)"Password", (NutsSession)session)).getString().toCharArray();
                        char[] old = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"password", (String)"OldPassword", (NutsSession)session)).getString().toCharArray();
                        if (cmdLine.isExecMode()) {
                            if (repository != null) {
                                repository.security().updateUser(user).setCredentials(pwd).setOldCredentials(old).run();
                            } else {
                                session.security().updateUser(user).setCredentials(pwd).setOldCredentials(old).run();
                            }
                        }
                        Arrays.fill(pwd, '\u0000');
                        Arrays.fill(old, '\u0000');
                        continue block18;
                    }
                }
                cmdLine.setCommandName("config edit user").unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"unsecure"}) != null) {
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryId", (NutsSession)session)).getString());
            }
            if (cmdLine.isExecMode()) {
                char[] credentials = null;
                if (!session.security().isAdmin()) {
                    credentials = session.getTerminal().readPassword("Enter password : ", new Object[0]);
                }
                if (session.security().setSecureMode(false, credentials)) {
                    out.println("<<unsecure box activated.Anonymous has all rights.>>");
                } else {
                    out.println("<<unsecure box is already activated.>>");
                }
                if (credentials != null) {
                    Arrays.fill(credentials, '\u0000');
                }
            }
            session.config().save();
            return true;
        }
        if (cmdLine.next(new String[]{"secure"}) != null) {
            char[] credentials = null;
            if (!session.security().isAdmin()) {
                credentials = session.getTerminal().readPassword("Enter password : ", new Object[0]);
            }
            NutsRepository repository = null;
            if (editedRepo != null) {
                repository = editedRepo;
            } else if (cmdLine.next(new String[]{"--repo", "-r"}) != null) {
                repository = session.repos().getRepository(cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryId", (NutsSession)session)).getString());
            }
            if (cmdLine.isExecMode()) {
                if (session.security().setSecureMode(true, credentials)) {
                    out.println("\"\"secure box activated.\"\"");
                } else {
                    out.println("\"\"secure box already activated.\"\"");
                }
            }
            if (credentials != null) {
                Arrays.fill(credentials, '\u0000');
            }
            session.config().save();
            return true;
        }
        return false;
    }
}

