/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsConstants;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.repository.config.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.AbstractNutsUpdateUserCommand;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;

public class DefaultNutsUpdateUserCommand
extends AbstractNutsUpdateUserCommand {
    public DefaultNutsUpdateUserCommand(NutsWorkspace ws) {
        super(ws);
    }

    public DefaultNutsUpdateUserCommand(NutsRepository repo) {
        super(repo.getWorkspace());
    }

    public NutsUpdateUserCommand run() {
        this.checkSession();
        NutsSession ws = this.getSession();
        NutsWorkspaceSecurityManager sec = ws.security().setSession(ws);
        if (this.getCredentials() != null && !NutsBlankable.isBlank((String)new String(this.getCredentials()))) {
            sec.checkAllowed("set-password", "set-user-credentials");
            String currentLogin = sec.getCurrentUsername();
            if (NutsBlankable.isBlank((String)this.login)) {
                if (!"anonymous".equals(currentLogin)) {
                    this.login = currentLogin;
                } else {
                    throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not logged in", (Object[])new Object[0]));
                }
            }
            if (this.repo != null) {
                NutsRepositoryConfigModel rconf = NutsRepositoryConfigManagerExt.of(this.repo.config()).getModel();
                NutsUserConfig u = rconf.getUser(this.login, ws);
                if (u == null) {
                    throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"no such user %s", (Object[])new Object[]{this.login}));
                }
                this.fillNutsUserConfig(u);
                rconf.setUser(u, this.session);
            } else {
                DefaultNutsWorkspaceConfigModel wconf = NutsWorkspaceConfigManagerExt.of(this.session.config()).getModel();
                NutsUserConfig u = wconf.getUser(this.login, ws);
                if (u == null) {
                    throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"no such user %s", (Object[])new Object[]{this.login}));
                }
                this.fillNutsUserConfig(u);
                wconf.setUser(u, this.session);
            }
        }
        return this;
    }

    protected void fillNutsUserConfig(NutsUserConfig u) {
        this.checkSession();
        NutsSession ws = this.getSession();
        NutsWorkspaceSecurityManager wsec = ws.security().setSession(ws);
        String currentLogin = wsec.getCurrentUsername();
        if (!currentLogin.equals(this.login)) {
            this.repo.security().setSession(ws).checkAllowed("admin", "set-user-credentials");
        }
        if (!wsec.isAllowed("admin")) {
            wsec.checkCredentials(u.getCredentials().toCharArray(), this.getOldCredentials());
        }
        if (this.getCredentials() != null) {
            u.setCredentials(CoreStringUtils.chrToStr(wsec.createCredentials(this.getCredentials(), false, CoreStringUtils.strToChr(u.getCredentials()))));
        }
        if (this.getRemoteCredentials() != null) {
            u.setRemoteCredentials(CoreStringUtils.chrToStr(wsec.createCredentials(this.getRemoteCredentials(), true, CoreStringUtils.strToChr(u.getRemoteCredentials()))));
        }
        if (this.resetGroups) {
            u.setGroups(new String[0]);
        }
        if (this.resetPermissions) {
            u.setPermissions(new String[0]);
        }
        LinkedHashSet g = new LinkedHashSet(u.getGroups() == null ? new ArrayList() : Arrays.asList(u.getGroups()));
        g.addAll(this.groups);
        for (String group : this.rm_groups) {
            g.remove(group);
        }
        u.setGroups(g.toArray(new String[0]));
        LinkedHashSet<String> r = new LinkedHashSet<String>(u.getPermissions() == null ? new ArrayList() : Arrays.asList(u.getPermissions()));
        for (String group : this.permissions) {
            if (!NutsConstants.Permissions.ALL.contains(group.toLowerCase()) && !NutsConstants.Permissions.ALL.contains("!" + group.toLowerCase())) continue;
            r.add(group);
        }
        for (String group : this.rm_permissions) {
            r.remove(group);
        }
        u.setPermissions(r.toArray(new String[0]));
        if (this.remoteIdentity != null) {
            u.setRemoteIdentity(this.remoteIdentity);
        }
        if (this.remoteCredentials != null) {
            u.setRemoteCredentials(this.remoteIdentity);
        }
    }
}

