/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.AbstractNutsAddUserCommand;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;

public class DefaultNutsAddUserCommand
extends AbstractNutsAddUserCommand {
    public DefaultNutsAddUserCommand(NutsWorkspace ws) {
        super(ws);
    }

    public DefaultNutsAddUserCommand(NutsRepository repo) {
        super(repo.getWorkspace());
    }

    public NutsAddUserCommand run() {
        if (NutsBlankable.isBlank((String)this.getUsername())) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid user", (Object[])new Object[0]));
        }
        this.checkSession();
        if (this.repo != null) {
            NutsRepositorySecurityManager sec = this.repo.security().setSession(this.session);
            NutsUserConfig security = new NutsUserConfig(this.getUsername(), CoreStringUtils.chrToStr(sec.createCredentials(this.getCredentials(), false, null)), this.getGroups(), this.getPermissions());
            security.setRemoteIdentity(this.getRemoteIdentity());
            security.setRemoteCredentials(CoreStringUtils.chrToStr(sec.createCredentials(this.getRemoteCredentials(), true, null)));
            NutsRepositoryConfigManagerExt.of(this.repo.config()).getModel().setUser(security, this.getSession());
        } else {
            this.checkSession();
            NutsSession ws = this.getSession();
            NutsWorkspaceSecurityManager sec = ws.security();
            NutsUserConfig security = new NutsUserConfig(this.getUsername(), CoreStringUtils.chrToStr(sec.createCredentials(this.getCredentials(), false, null)), this.getGroups(), this.getPermissions());
            security.setRemoteIdentity(this.getRemoteIdentity());
            security.setRemoteCredentials(CoreStringUtils.chrToStr(sec.createCredentials(this.getRemoteCredentials(), true, null)));
            NutsWorkspaceConfigManagerExt.of(ws.config()).getModel().setUser(security, ws);
        }
        return this;
    }
}

