/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsWorkspaceCommandBase;

public abstract class AbstractNutsAddUserCommand
extends NutsWorkspaceCommandBase<NutsAddUserCommand>
implements NutsAddUserCommand {
    protected String login;
    protected String remoteIdentity;
    protected char[] remoteCredentials;
    protected char[] password;
    protected final Set<String> permissions = new HashSet<String>();
    protected final Set<String> groups = new HashSet<String>();
    protected NutsRepository repo;

    public AbstractNutsAddUserCommand(NutsWorkspace ws) {
        super(ws, "add-user");
    }

    public AbstractNutsAddUserCommand(NutsRepository repo) {
        super(repo.getWorkspace(), "add-user");
        this.repo = repo;
    }

    public String getUsername() {
        return this.login;
    }

    public AbstractNutsAddUserCommand setUsername(String username) {
        this.login = username;
        return this;
    }

    public char[] getCredentials() {
        return this.password;
    }

    public AbstractNutsAddUserCommand setCredentials(char[] password) {
        this.password = password;
        return this;
    }

    public char[] getRemoteCredentials() {
        return this.remoteCredentials;
    }

    public AbstractNutsAddUserCommand setRemoteCredentials(char[] password) {
        this.remoteCredentials = password;
        return this;
    }

    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public AbstractNutsAddUserCommand setRemoteIdentity(String remoteIdentity) {
        this.remoteIdentity = remoteIdentity;
        return this;
    }

    public AbstractNutsAddUserCommand addPermissions(String ... permissions) {
        if (permissions != null) {
            return this.addPermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsAddUserCommand removePermissions(String ... permissions) {
        if (permissions != null) {
            return this.removePermissions(Arrays.asList(permissions));
        }
        return this;
    }

    public AbstractNutsAddUserCommand addPermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String permission : permissions) {
                if (permission == null) continue;
                this.permissions.add(permission);
            }
        }
        return this;
    }

    public AbstractNutsAddUserCommand removePermissions(Collection<String> permissions) {
        if (permissions != null) {
            for (String permission : permissions) {
                if (permission == null) continue;
                this.permissions.remove(permission);
            }
        }
        return this;
    }

    public AbstractNutsAddUserCommand addGroups(String ... groups) {
        if (groups != null) {
            return this.addPermissions(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsAddUserCommand removeGroups(String ... groups) {
        if (groups != null) {
            return this.removeGroups(Arrays.asList(groups));
        }
        return this;
    }

    public AbstractNutsAddUserCommand addGroup(String group) {
        if (group != null) {
            this.groups.add(group);
        }
        return this;
    }

    public AbstractNutsAddUserCommand addPermission(String permission) {
        if (permission != null) {
            this.permissions.add(permission);
        }
        return this;
    }

    public AbstractNutsAddUserCommand addGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.add(right);
            }
        }
        return this;
    }

    public AbstractNutsAddUserCommand removeGroups(Collection<String> groups) {
        if (groups != null) {
            for (String right : groups) {
                if (right == null) continue;
                this.groups.remove(right);
            }
        }
        return this;
    }

    public String[] getPermissions() {
        return this.permissions.toArray(new String[0]);
    }

    public String[] getGroups() {
        return this.groups.toArray(new String[0]);
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        switch (a.getKey().getString()) {
            default: 
        }
        return super.configureFirst(cmdLine);
    }
}

