/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.updatestats;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUpdateStatisticsCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.updatestats.AbstractNutsUpdateStatisticsCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsUpdateStatisticsCommand
extends AbstractNutsUpdateStatisticsCommand {
    public DefaultNutsUpdateStatisticsCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsUpdateStatisticsCommand run() {
        boolean processed = false;
        NutsSession session = this.getSession();
        this.checkSession();
        for (String repository : this.getRepositrories()) {
            processed = true;
            NutsRepository repo = this.getSession().repos().getRepository(repository);
            NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
            repoSPI.updateStatistics().setSession(session).run();
        }
        for (Path repositoryPath : this.getPaths()) {
            processed = true;
            if (repositoryPath == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing location %s", (Object[])new Object[]{repositoryPath}));
            }
            if (!Files.isDirectory(repositoryPath, new LinkOption[0])) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"expected folder at location %s", (Object[])new Object[]{repositoryPath}));
            }
            File[] mavenRepoRootFiles = repositoryPath.toFile().listFiles(x -> x.getName().equals("index.html") || x.getName().equals("plugin-management.html") || x.getName().equals("distribution-management.html") || x.getName().equals("dependency-info.html") || x.getName().equals("dependency-convergence.html") || x.getName().equals("dependencies.html") || x.getName().equals("plugins.html") || x.getName().equals("project-info.html") || x.getName().equals("project-summary.html"));
            if (mavenRepoRootFiles != null && mavenRepoRootFiles.length > 3) {
                new MavenRepositoryFolderHelper(null, this.getSession(), NutsPath.of((Path)repositoryPath, (NutsSession)session)).reindexFolder(this.getSession());
                if (!session.isPlainTrace()) continue;
                session.getTerminal().out().resetLine().printf("[%s] updated maven index %s%n", new Object[]{this.getSession().locations().getWorkspaceLocation(), repositoryPath});
                continue;
            }
            File[] nutsRepoRootFiles = repositoryPath.toFile().listFiles(x -> x.getName().equals("nuts-repository.json"));
            if (nutsRepoRootFiles == null || nutsRepoRootFiles.length <= 0) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported repository folder", (Object[])new Object[0]));
            }
            new NutsRepositoryFolderHelper(null, session, NutsPath.of((Path)repositoryPath, (NutsSession)session), false, "stats", null).reindexFolder(session);
            if (!session.isPlainTrace()) continue;
            session.out().resetLine().printf("[%s] updated stats %s%n", new Object[]{this.getSession().locations().getWorkspaceLocation(), repositoryPath});
        }
        NutsTexts factory = NutsTexts.of((NutsSession)this.getSession());
        if (!processed) {
            if (session.isPlainTrace()) {
                session.out().resetLine().printf("%s updating workspace stats%n", new Object[]{this.getSession().locations().getWorkspaceLocation()});
            }
            for (NutsRepository repo : this.getSession().repos().getRepositories()) {
                if (session.isPlainTrace()) {
                    session.out().resetLine().printf("%s updating stats %s%n", new Object[]{this.getSession().locations().getWorkspaceLocation(), repo});
                }
                NutsWorkspaceUtils.of(session).repoSPI(repo).updateStatistics().setSession(session).run();
            }
        }
        return this;
    }

    public void add(String repo) {
        if (repo == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing repo or path", (Object[])new Object[0]));
        }
        if (repo.equals(".") || repo.equals("..") || repo.contains("/") || repo.contains("\\")) {
            this.addPath(Paths.get(repo, new String[0]));
        } else {
            this.addRepo(repo);
        }
    }
}

