/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.repo;

import java.util.Arrays;
import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.user.NutsSettingsUserSubCommand;
import net.thevpc.nuts.spi.NutsRepositoryLocation;

public class NutsSettingsRepositorySubCommand
extends AbstractNutsSettingsSubCommand {
    public static RepoInfo repoInfo(NutsRepository x, boolean tree, NutsSession session) {
        return new RepoInfo(x.getName(), x.config().getType(), x.config().getLocationPath(), x.config().isEnabled() ? RepoStatus.enabled : RepoStatus.disabled, tree ? (RepoInfo[])Arrays.stream(x.config().setSession(session).getMirrors()).map(e -> NutsSettingsRepositorySubCommand.repoInfo(e, tree, session)).toArray(RepoInfo[]::new) : null);
    }

    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        NutsPrintStream out = session.out();
        if (cmdLine.next(new String[]{"add repo", "ar"}) != null) {
            String location = null;
            String repositoryName = null;
            String parent = null;
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            block27: while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.peek();
                boolean enabled = a.isActive();
                switch (a.getKey().getString()) {
                    case "-l": 
                    case "--location": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block27;
                        location = val;
                        continue block27;
                    }
                    case "--name": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block27;
                        repositoryName = val;
                        continue block27;
                    }
                    case "--parent": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block27;
                        parent = val;
                        continue block27;
                    }
                    case "--env": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block27;
                        NutsArgument vv = NutsArgument.of((String)val, (NutsSession)session);
                        env.put(vv.getKey() == null ? null : vv.getKey().getString(), vv.getValue() == null ? null : vv.getValue().getString());
                        continue block27;
                    }
                }
                if (session.configureFirst(cmdLine)) continue;
                if (a.isOption()) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                if (repositoryName == null) {
                    repositoryName = cmdLine.next().getString();
                    continue;
                }
                if (location == null) {
                    location = cmdLine.next().getString();
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (repositoryName == null) {
                cmdLine.required();
            }
            if (cmdLine.isExecMode()) {
                NutsRepository repo = null;
                NutsAddRepositoryOptions o = new NutsAddRepositoryOptions().setName(repositoryName).setLocation(repositoryName).setConfig(location == null ? null : new NutsRepositoryConfig().setName(repositoryName).setLocation(NutsRepositoryLocation.of(location)).setEnv(env));
                if (parent == null) {
                    repo = session.repos().addRepository(o);
                } else {
                    NutsRepository p = session.repos().getRepository(parent);
                    repo = p.config().addMirror(o);
                }
                out.printf((Object)"repository added successfully%n");
                session.config().save();
            }
            cmdLine.setCommandName("config add repo").unexpectedArgument();
            return true;
        }
        if (cmdLine.next(new String[]{"remove repo", "rr"}) != null) {
            String repositoryName = null;
            String parent = null;
            block28: while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.peek();
                boolean enabled = a.isActive();
                switch (a.getKey().getString()) {
                    case "--name": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block28;
                        repositoryName = val;
                        continue block28;
                    }
                    case "--parent": {
                        String val = cmdLine.nextString(new String[0]).getValue().getString();
                        if (!enabled) continue block28;
                        parent = val;
                        continue block28;
                    }
                }
                if (session.configureFirst(cmdLine)) continue;
                if (a.isOption()) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                if (repositoryName != null) {
                    cmdLine.unexpectedArgument();
                    continue;
                }
                repositoryName = cmdLine.next().getString();
            }
            if (repositoryName == null) {
                cmdLine.required();
            }
            if (cmdLine.isExecMode()) {
                if (parent == null) {
                    session.repos().removeRepository(repositoryName);
                } else {
                    NutsRepository p = session.repos().getRepository(parent);
                    p.config().removeMirror(repositoryName);
                }
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"list repos", "lr"}) != null) {
            cmdLine.setCommandName("config list repos");
            String parent = null;
            while (cmdLine.hasNext()) {
                block30: while (cmdLine.hasNext()) {
                    NutsArgument a = cmdLine.peek();
                    boolean enabled = a.isActive();
                    switch (a.getKey().getString()) {
                        case "--parent": {
                            String val = cmdLine.nextString(new String[0]).getValue().getString();
                            if (!enabled) continue block30;
                            parent = val;
                            continue block30;
                        }
                    }
                    if (session.configureFirst(cmdLine)) continue;
                    if (a.isOption()) {
                        cmdLine.unexpectedArgument();
                        continue;
                    }
                    if (parent != null) {
                        cmdLine.unexpectedArgument();
                        continue;
                    }
                    parent = cmdLine.next().getString();
                }
            }
            if (cmdLine.isExecMode()) {
                NutsRepository[] r = parent == null ? session.repos().getRepositories() : session.repos().getRepository(parent).config().getMirrors();
                out.printlnf((Object)Arrays.stream(session.repos().getRepositories()).map(x -> NutsSettingsRepositorySubCommand.repoInfo(x, session.getOutputFormat() != NutsContentType.TABLE && session.getOutputFormat() != NutsContentType.PLAIN, session)).toArray());
            }
            return true;
        }
        if (cmdLine.next(new String[]{"enable repo", "er"}) != null) {
            this.enableRepo(cmdLine, autoSave, session, true);
            return true;
        }
        if (cmdLine.next(new String[]{"disable repo", "er"}) != null) {
            this.enableRepo(cmdLine, autoSave, session, true);
            return true;
        }
        if (cmdLine.next(new String[]{"edit repo", "er"}) != null) {
            String repoId = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryName", (NutsSession)session)).getString();
            if (cmdLine.next(new String[]{"add repo", "ar"}) != null) {
                String repositoryName = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"NewRepositoryName", (NutsSession)session)).getString();
                String location = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"folder", (NutsSession)session)).getString();
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                NutsRepository repo = editedRepo.config().addMirror(new NutsAddRepositoryOptions().setName(repositoryName).setLocation(repositoryName).setConfig(new NutsRepositoryConfig().setName(repositoryName).setLocation(NutsRepositoryLocation.of((String)location))));
                session.config().save();
            } else if (cmdLine.next(new String[]{"remove repo", "rr"}) != null) {
                String location = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"RepositoryName", (NutsSession)session)).getString();
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                editedRepo.config().removeMirror(location);
                session.config().save();
            } else if (cmdLine.next(new String[]{"enable", "br"}) != null) {
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                editedRepo.config().setEnabled(true);
                session.config().save();
            } else if (cmdLine.next(new String[]{"disable", "dr"}) != null) {
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                editedRepo.config().setEnabled(true);
                session.config().save();
            } else if (cmdLine.next(new String[]{"list repos", "lr"}) != null) {
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                NutsRepository[] linkRepositories = editedRepo.config().setSession(session).isSupportedMirroring() ? editedRepo.config().setSession(session).getMirrors() : new NutsRepository[]{};
                out.printf("%s sub repositories.%n", new Object[]{linkRepositories.length});
                NutsTableFormat t = NutsTableFormat.of((NutsSession)session);
                NutsMutableTableModel m = NutsMutableTableModel.of((NutsSession)session);
                t.setValue((Object)m);
                m.addHeaderCells(new Object[]{"Id", "Enabled", "Type", "Location"});
                while (cmdLine.hasNext()) {
                    if (t.configureFirst(cmdLine)) continue;
                    cmdLine.setCommandName("config edit repo").unexpectedArgument();
                }
                for (NutsRepository repository : linkRepositories) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = NutsTexts.of((NutsSession)session).ofStyled(repository.getName(), NutsTextStyle.primary4());
                    objectArray[1] = repository.config().isEnabled() ? (repository.isEnabled() ? NutsTexts.of((NutsSession)session).ofStyled("ENABLED", NutsTextStyle.success()) : NutsTexts.of((NutsSession)session).ofStyled("<RT-DISABLED>", NutsTextStyle.error())) : NutsTexts.of((NutsSession)session).ofStyled("<DISABLED>", NutsTextStyle.error());
                    objectArray[2] = repository.getRepositoryType();
                    objectArray[3] = repository.config().getLocation().toString();
                    m.addRow(objectArray);
                }
                out.printf((Object)t.toString());
            } else if (cmdLine.next(new String[]{"-h", "-?", "--help"}) != null) {
                out.printf("edit repository %s add repo ...%n", new Object[]{repoId});
                out.printf("edit repository %s remove repo ...%n", new Object[]{repoId});
                out.printf("edit repository %s list repos ...%n", new Object[]{repoId});
            } else {
                NutsRepository editedRepo = session.repos().getRepository(repoId);
                if (!NutsSettingsUserSubCommand.exec(editedRepo, cmdLine, autoSave, session)) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"config edit repo: Unsupported command %s", (Object[])new Object[]{cmdLine}));
                }
            }
            return true;
        }
        return false;
    }

    private void enableRepo(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session, boolean enableRepo) {
        String repositoryName = null;
        block6: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            boolean enabled = a.isActive();
            switch (a.getKey().getString()) {
                case "--name": {
                    String val = cmdLine.nextString(new String[0]).getValue().getString();
                    if (!enabled) continue block6;
                    repositoryName = val;
                    continue block6;
                }
            }
            if (session.configureFirst(cmdLine)) continue;
            if (a.isOption()) {
                cmdLine.unexpectedArgument();
                continue;
            }
            if (repositoryName == null) {
                repositoryName = cmdLine.next().getString();
                continue;
            }
            cmdLine.unexpectedArgument();
        }
        if (repositoryName == null) {
            cmdLine.required();
        }
        if (cmdLine.isExecMode()) {
            NutsRepository editedRepo = session.repos().getRepository(repositoryName);
            editedRepo.config().setEnabled(enableRepo);
            session.config().save();
        }
    }

    public static class RepoInfo {
        String name;
        String type;
        NutsPath location;
        RepoStatus enabled;
        RepoInfo[] mirrors;

        public RepoInfo(String name, String type, NutsPath location, RepoStatus enabled, RepoInfo[] mirrors) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.enabled = enabled;
            this.mirrors = mirrors;
        }

        public RepoInfo() {
        }

        public RepoInfo[] getMirrors() {
            return this.mirrors;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public NutsPath getLocation() {
            return this.location;
        }

        public void setLocation(NutsPath location) {
            this.location = location;
        }

        public RepoStatus getEnabled() {
            return this.enabled;
        }

        public void setEnabled(RepoStatus enabled) {
            this.enabled = enabled;
        }
    }

    public static enum RepoStatus {
        enabled,
        disabled;

    }
}

