/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.win;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.win.WindowFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;

public class WindowsNdi
extends BaseSystemNdi {
    public WindowsNdi(NutsSession session) {
        super(session);
    }

    @Override
    protected NutsShellFamily[] getShellGroups() {
        LinkedHashSet<NutsShellFamily> all = new LinkedHashSet<NutsShellFamily>(Arrays.asList(this.session.env().getShellFamilies()));
        all.retainAll(Arrays.asList(NutsShellFamily.WIN_CMD, NutsShellFamily.WIN_POWER_SHELL));
        return all.toArray(new NutsShellFamily[0]);
    }

    @Override
    protected String createNutsScriptContent(NutsId fnutsId, NdiScriptOptions options, NutsShellFamily shellFamily) {
        StringBuilder command = new StringBuilder();
        command.append(this.getExecFileName("nuts")).append(" ").append(NutsShellHelper.of(shellFamily).varRef("NUTS_OPTIONS")).append(" ");
        if (options.getLauncher().getNutsOptions() != null) {
            for (String o : options.getLauncher().getNutsOptions()) {
                command.append(" ").append(o);
            }
        }
        command.append(" \"").append(fnutsId).append("\"");
        command.append(" %*");
        return command.toString();
    }

    @Override
    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
    }

    @Override
    public String getExecFileName(String name) {
        return name + ".cmd";
    }

    @Override
    protected FreeDesktopEntryWriter createFreeDesktopEntryWriter() {
        return new WindowFreeDesktopEntryWriter(this.session.env().getDesktopPath() == null ? null : NutsPath.of((Path)this.session.env().getDesktopPath(), (NutsSession)this.getSession()), this.session);
    }

    @Override
    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public boolean isShortcutFileNameUserFriendly() {
        return true;
    }

    @Override
    public String getTemplateName(String name, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case WIN_CMD: {
                return "template-" + name + ".cmd";
            }
            case WIN_POWER_SHELL: {
                return "template-" + name + ".ps1";
            }
        }
        return "template-" + name + ".cmd";
    }

    @Override
    public NdiScriptInfo[] getNutsTerm(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(new NutsShellFamily[]{NutsShellFamily.WIN_CMD}).map(x -> this.getNutsTerm(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    @Override
    public NdiScriptInfo getNutsTerm(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case WIN_CMD: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveBinFolder().resolve("nuts-term.cmd");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-term", NutsShellFamily.WIN_CMD, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case WIN_POWER_SHELL: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveBinFolder().resolve("nuts-term.ps1");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-term", NutsShellFamily.WIN_POWER_SHELL, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsEnv(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case WIN_CMD: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.cmd");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-env", NutsShellFamily.WIN_CMD, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case WIN_POWER_SHELL: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.ps1");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-env", NutsShellFamily.WIN_POWER_SHELL, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsTermInit(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case WIN_CMD: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.cmd");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-term-init", NutsShellFamily.WIN_CMD, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case WIN_POWER_SHELL: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.ps1");
                    }

                    @Override
                    public PathInfo create() {
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-term-init", NutsShellFamily.WIN_POWER_SHELL, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsInit(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case WIN_CMD: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.cmd");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.WIN_CMD, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(WindowsNdi.this);
                    }
                };
            }
            case WIN_POWER_SHELL: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.ps1");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return WindowsNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.WIN_POWER_SHELL, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(WindowsNdi.this);
                    }
                };
            }
        }
        return null;
    }
}

