/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.NutsSysExecUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.AbstractFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnixFreeDesktopEntryWriter
extends AbstractFreeDesktopEntryWriter {
    private final NutsSession session;
    private final NutsPath desktopPath;

    public UnixFreeDesktopEntryWriter(NutsSession session, NutsPath desktopPath) {
        this.session = session;
        this.desktopPath = desktopPath;
    }

    @Override
    public PathInfo[] writeShortcut(FreeDesktopEntry descriptor, NutsPath path, boolean doOverride, NutsId id) {
        path = NutsPath.of((String)this.ensureName(path == null ? null : path.toString(), descriptor.getOrCreateDesktopEntry().getName(), "desktop"), (NutsSession)this.session);
        PathInfo.Status s = this.tryWrite(descriptor, path);
        return new PathInfo[]{new PathInfo("desktop-shortcut", id, path, s)};
    }

    @Override
    public PathInfo[] writeDesktop(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NutsId id) {
        fileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        NutsPath q = this.desktopPath.resolve(fileName);
        return this.writeShortcut(descriptor, q, doOverride, id);
    }

    @Override
    public PathInfo[] writeMenu(FreeDesktopEntry descriptor, String fileName, boolean doOverride, NutsId id) {
        String desktopFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "desktop"), new String[0]).getFileName().toString();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        FreeDesktopEntry.Group root = descriptor.getOrCreateDesktopEntry();
        NutsPath folder4shortcuts = NutsPath.ofUserHome((NutsSession)this.session).resolve(".local/share/applications");
        folder4shortcuts.mkdirs();
        NutsPath shortcutFile = folder4shortcuts.resolve(desktopFileName);
        all.add(new PathInfo("desktop-icon", id, shortcutFile, this.tryWrite(descriptor, shortcutFile)));
        ArrayList<String> categories = new ArrayList<String>(root.getCategories());
        if (categories.isEmpty()) {
            categories.add("/");
        }
        NutsPath folder4menus = NutsPath.ofUserHome((NutsSession)this.session).resolve(".config/menus/applications-merged");
        folder4menus.mkdirs();
        String menuFileName = Paths.get(this.ensureName(fileName, descriptor.getOrCreateDesktopEntry().getName(), "menu"), new String[0]).getFileName().toString();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.newDocument();
            for (String menuPath : categories) {
                String[] part = (String[])Arrays.stream((menuPath == null ? "" : menuPath).split("/")).filter(x -> !x.isEmpty()).toArray(String[]::new);
                if (part.length == 0) {
                    part = new String[]{"Applications"};
                } else if (!part[0].equals("Applications")) {
                    ArrayList<String> li = new ArrayList<String>();
                    li.add("Applications");
                    li.addAll(Arrays.asList(part));
                    part = li.toArray(new String[0]);
                }
                this.createMenuXmlElement(part, desktopFileName, dom);
            }
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            tr.transform(new DOMSource(dom), new StreamResult(b));
            NutsPath menuFile = folder4menus.resolve(menuFileName);
            all.add(new PathInfo("desktop-menu", id, menuFile, CoreIOUtils.tryWrite(b.toByteArray(), menuFile, this.session)));
        }
        catch (ParserConfigurationException | TransformerException ex) {
            throw new RuntimeException(ex);
        }
        if (all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.updateDesktopMenus();
        }
        return all.toArray(new PathInfo[0]);
    }

    private void callMeMaye(String ... command) {
        ArrayList<String> cmdList = new ArrayList<String>(Arrays.asList(command));
        String sysCmd = (String)cmdList.remove(0);
        Path a = NutsSysExecUtils.sysWhich(sysCmd);
        if (a != null) {
            cmdList.add(0, a.toString());
            String outStr = this.session.exec().setCommand(cmdList).addCommand(new String[0]).setExecutionType(NutsExecutionType.SYSTEM).setRedirectErrorStream(true).grabOutputString().run().getOutputString().trim();
            if (this.session.isPlainTrace() && !outStr.isEmpty()) {
                this.session.out().println(CoreStringUtils.prefixLinesOsNL(outStr, "[" + sysCmd + "] "));
            }
        }
    }

    private void updateDesktopMenus() {
        this.callMeMaye("kbuildsycoca5");
        this.callMeMaye("update-desktop-database", System.getProperty("user.home") + "/.local/share/applications");
        this.callMeMaye("xdg-desktop-menu", "forceupdate");
    }

    private String getDesktopEnvironment() {
        return System.getenv("XDG_SESSION_DESKTOP");
    }

    private Element ensureXmlChild(Node parent, String name) {
        NodeList cn = parent.getChildNodes();
        for (int i = 0; i < cn.getLength(); ++i) {
            Element e;
            String nn;
            Node ci = cn.item(i);
            if (!(ci instanceof Element) || !name.equals(nn = (e = (Element)ci).getNodeName())) continue;
            return e;
        }
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element elem = doc.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    private void createMenuXmlElement(String[] a, String name, Node parent) {
        if (a.length == 1) {
            Element emenu = this.ensureXmlChild(parent, "Menu");
            Element ename = this.ensureXmlChild(emenu, "Name");
            ename.setTextContent(a[0]);
            Element einclude = this.ensureXmlChild(emenu, "Include");
            Element efilename = this.ensureXmlChild(einclude, "Filename");
            efilename.setTextContent(name);
        } else {
            Element emenu = this.ensureXmlChild(parent, "Menu");
            Element ename = this.ensureXmlChild(emenu, "Name");
            ename.setTextContent(a[0]);
            this.createMenuXmlElement(Arrays.copyOfRange(a, 1, a.length), name, emenu);
        }
    }

    public void write(FreeDesktopEntry file, Path out) {
        NutsPath.of((Path)out, (NutsSession)this.session).mkParentDirs();
        try (PrintStream p = new PrintStream(Files.newOutputStream(out, new OpenOption[0]));){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public PathInfo.Status tryWrite(FreeDesktopEntry file, NutsPath out) {
        out.mkParentDirs();
        return CoreIOUtils.tryWrite(this.writeAsString(file).getBytes(), out, this.session);
    }

    public String writeAsString(FreeDesktopEntry file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        this.write(file, out);
        out.flush();
        return bos.toString();
    }

    public void write(FreeDesktopEntry file, File out) {
        NutsPath.of((File)out, (NutsSession)this.session).mkParentDirs();
        try (PrintStream p = new PrintStream(out);){
            this.write(file, p);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public void write(FreeDesktopEntry file, NutsPrintStream out) {
        this.write(file, out.asPrintStream());
    }

    public void write(FreeDesktopEntry file, PrintStream out) {
        out.println("#!/usr/bin/env xdg-open");
        for (FreeDesktopEntry.Group group : file.getGroups()) {
            out.println();
            String gn = group.getGroupName();
            if (gn == null || gn.trim().length() == 0) {
                throw new IllegalArgumentException("invalid group name");
            }
            FreeDesktopEntry.Type t = group.getType();
            if (t == null) {
                throw new IllegalArgumentException("missing type");
            }
            out.println("[" + gn.trim() + "]");
            for (Map.Entry<String, Object> e : group.toMap().entrySet()) {
                Object value = e.getValue();
                String key = e.getKey();
                if (value instanceof FreeDesktopEntry.Type) {
                    String v = value.toString().toLowerCase();
                    v = Character.toUpperCase(v.charAt(0)) + v.substring(1);
                    out.println(key + "=" + v);
                    continue;
                }
                if (value instanceof Boolean || value instanceof String) {
                    out.println(key + "=" + value);
                    continue;
                }
                if (value instanceof List) {
                    char sep = ';';
                    out.println(key + "=" + ((List)value).stream().map(x -> {
                        StringBuilder sb = new StringBuilder();
                        for (char c : x.toCharArray()) {
                            if (c == sep || c == '\\') {
                                sb.append('\\');
                            }
                            sb.append(c);
                        }
                        return sb.toString();
                    }).collect(Collectors.joining("" + sep)));
                    continue;
                }
                throw new IllegalArgumentException("unsupported value type for " + key);
            }
        }
    }
}

