/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsQuestionParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.NutsValidationException;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.UnixFreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;

public class AnyNixNdi
extends BaseSystemNdi {
    public AnyNixNdi(NutsSession session) {
        super(session);
    }

    @Override
    protected NutsShellFamily[] getShellGroups() {
        LinkedHashSet<NutsShellFamily> all = new LinkedHashSet<NutsShellFamily>(Arrays.asList(this.session.env().getShellFamilies()));
        all.retainAll(Arrays.asList(NutsShellFamily.SH, NutsShellFamily.FISH));
        return all.toArray(new NutsShellFamily[0]);
    }

    @Override
    public boolean isShortcutFileNameUserFriendly() {
        return false;
    }

    @Override
    public String createNutsScriptContent(NutsId fnutsId, NdiScriptOptions options, NutsShellFamily shellFamily) {
        StringBuilder command = new StringBuilder();
        command.append(this.getExecFileName("nuts")).append(" ").append(NutsShellHelper.of(shellFamily).varRef("NUTS_OPTIONS")).append(" ");
        if (options.getLauncher().getNutsOptions() != null) {
            for (String no : options.getLauncher().getNutsOptions()) {
                command.append(" ").append(no);
            }
        }
        command.append(" \"").append(fnutsId).append("\"");
        command.append(" \"$@\"");
        return command.toString();
    }

    @Override
    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
        final NutsTexts factory = NutsTexts.of((NutsSession)this.session);
        if (Arrays.stream(updatedPaths).anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED) && this.session.isTrace()) {
            if (this.session.isPlainTrace()) {
                this.session.out().resetLine().printf("%s %s to point to workspace %s%n", new Object[]{this.session.isYes() ? factory.ofStyled("force updating", NutsTextStyle.warn().append(NutsTextStyle.underlined())) : factory.ofStyled("force updating", NutsTextStyle.warn()), factory.builder().appendJoined((Object)", ", (Collection)Arrays.stream(updatedPaths).map(x -> factory.ofStyled(x.getPath().getName(), NutsTextStyle.path())).collect(Collectors.toList())), this.session.locations().getWorkspaceLocation()});
            }
            final String sysRcName = NutsShellHelper.of(this.session.env().getShellFamily()).getSysRcName();
            this.session.getTerminal().ask().resetLine().forBoolean("```error ATTENTION``` You may need to re-run terminal or issue \"%s\" in your current terminal for new environment to take effect.%nPlease type 'ok' if you agree, 'why' if you need more explanation or 'cancel' to cancel updates.", new Object[]{factory.ofStyled(". ~/" + sysRcName, NutsTextStyle.path())}).setHintMessage(NutsMessage.plain((String)"")).setSession(this.session).setParser((NutsQuestionParser)new NutsQuestionParser<Boolean>(){

                public Boolean parse(Object response, Boolean defaultValue, NutsQuestion<Boolean> question) {
                    if (response instanceof Boolean) {
                        return (Boolean)response;
                    }
                    if (response == null || response instanceof String && response.toString().length() == 0) {
                        response = defaultValue;
                    }
                    if (response == null) {
                        throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"sorry... but you need to type 'ok', 'why' or 'cancel'", (Object[])new Object[0]));
                    }
                    String r = response.toString();
                    if ("ok".equalsIgnoreCase(r)) {
                        return true;
                    }
                    if ("why".equalsIgnoreCase(r)) {
                        NutsPrintStream out = AnyNixNdi.this.session.out();
                        out.resetLine();
                        out.printf("\\\"%s\\\" is a special file in your home that is invoked upon each interactive terminal launch.%n", new Object[]{factory.ofStyled(sysRcName, NutsTextStyle.path())});
                        out.print("It helps configuring environment variables. ```sh nuts``` make usage of such facility to update your **PATH** env variable\n");
                        out.print("to point to current ```sh nuts``` workspace, so that when you call a ```sh nuts``` command it will be resolved correctly...\n");
                        out.printf("However updating \\\"%s\\\" does not affect the running process/terminal. So you have basically two choices :%n", new Object[]{factory.ofStyled(sysRcName, NutsTextStyle.path())});
                        out.print(" - Either to restart the process/terminal (konsole, term, xterm, sh, bash, ...)%n");
                        out.printf(" - Or to run by your self the \\\"%s\\\" script (don\\'t forget the leading dot)%n", new Object[]{factory.ofStyled(". ~/" + sysRcName, NutsTextStyle.path())});
                        throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"Try again...", (Object[])new Object[0]));
                    }
                    if ("cancel".equalsIgnoreCase(r) || "cancel!".equalsIgnoreCase(r)) {
                        throw new NutsUserCancelException(AnyNixNdi.this.session);
                    }
                    throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"sorry... but you need to type 'ok', 'why' or 'cancel'", (Object[])new Object[0]));
                }
            }).getValue();
        }
    }

    @Override
    public String getExecFileName(String name) {
        return name;
    }

    @Override
    protected FreeDesktopEntryWriter createFreeDesktopEntryWriter() {
        return new UnixFreeDesktopEntryWriter(this.session, this.session.env().getDesktopPath() == null ? null : NutsPath.of((Path)this.session.env().getDesktopPath(), (NutsSession)this.getSession()));
    }

    @Override
    public String getTemplateName(String name, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return "template-" + name + ".sh";
            }
            case FISH: {
                return "template-" + name + ".fish";
            }
        }
        return "template-" + name + ".sh";
    }

    @Override
    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public NdiScriptInfo[] getNutsTerm(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(new NutsShellFamily[]{NutsShellFamily.SH}).map(x -> this.getNutsTerm(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    @Override
    public NdiScriptInfo getNutsTerm(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveBinFolder().resolve(AnyNixNdi.this.getExecFileName("nuts-term"));
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term", NutsShellFamily.SH, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveBinFolder().resolve(AnyNixNdi.this.getExecFileName("nuts-term"));
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term", NutsShellFamily.FISH, "nuts-term", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsEnv(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.sh");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-env", NutsShellFamily.SH, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-env.fish");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-env", NutsShellFamily.FISH, "nuts-env", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsTermInit(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term-init", NutsShellFamily.FISH, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-term-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-term-init", NutsShellFamily.SH, "nuts-term-init", options.resolveNutsApiId(), options).setPath(this.path()).build();
                    }
                };
            }
        }
        return null;
    }

    @Override
    public NdiScriptInfo getIncludeNutsInit(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case ZSH: 
            case KSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.SH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(AnyNixNdi.this);
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return AnyNixNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.FISH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(AnyNixNdi.this);
                    }
                };
            }
        }
        return null;
    }
}

