/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsSupportMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.id.util.NutsIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.shell.NutsShellHelper;
import net.thevpc.nuts.runtime.standalone.shell.ReplaceString;
import net.thevpc.nuts.runtime.standalone.shell.ScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.AbstractSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script.FromTemplateScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.script.SimpleScriptBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;

public abstract class BaseSystemNdi
extends AbstractSystemNdi {
    public static final ReplaceString COMMENT_LINE_CONFIG_HEADER = new ReplaceString("net.thevpc.nuts configuration", "((net[.]thevpc[.]nuts)|(net[.]thevpc[.]nuts.toolbox[.]ndi)|(net[.]vpc[.]app[.]nuts)) configuration");

    public BaseSystemNdi(NutsSession session) {
        super(session);
    }

    public NdiScriptInfo[] getSysRC(NdiScriptOptions options) {
        ArrayList<RcNdiScriptInfo> scriptInfos = new ArrayList<RcNdiScriptInfo>();
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        for (NutsShellFamily sf : this.session.env().getShellFamilies()) {
            String z = NutsShellHelper.of(sf).getSysRcName();
            if (visited.contains(z)) continue;
            visited.add(z);
            RcNdiScriptInfo i = new RcNdiScriptInfo(z, options, sf);
            scriptInfos.add(i);
        }
        return scriptInfos.toArray(new NdiScriptInfo[0]);
    }

    public NdiScriptInfo[] getIncludeNutsInit(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsInit(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public NdiScriptInfo getIncludeNutsInit(final NdiScriptOptions options, NutsShellFamily shellFamily) {
        switch (shellFamily) {
            case SH: 
            case BASH: 
            case CSH: 
            case KSH: 
            case ZSH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.sh");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return BaseSystemNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.SH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(BaseSystemNdi.this);
                    }
                };
            }
            case FISH: {
                return new NdiScriptInfo(){

                    @Override
                    public NutsPath path() {
                        return options.resolveIncFolder().resolve(".nuts-init.fish");
                    }

                    @Override
                    public PathInfo create() {
                        NutsPath apiConfigFile = this.path();
                        return BaseSystemNdi.this.scriptBuilderTemplate("nuts-init", NutsShellFamily.FISH, "nuts-init", options.resolveNutsApiId(), options).setPath(apiConfigFile).buildAddLine(BaseSystemNdi.this);
                    }
                };
            }
        }
        return null;
    }

    public NdiScriptInfo[] getIncludeNutsTermInit(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsTermInit(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    protected abstract NutsShellFamily[] getShellGroups();

    public abstract NdiScriptInfo getIncludeNutsTermInit(NdiScriptOptions var1, NutsShellFamily var2);

    public FromTemplateScriptBuilder scriptBuilderTemplate(String templateName, NutsShellFamily shellFamily, String type, NutsId anyId, NdiScriptOptions options) {
        return ScriptBuilder.fromTemplate(templateName, shellFamily, type, anyId, this, options);
    }

    public SimpleScriptBuilder scriptBuilderSimple(NutsShellFamily shellFamily, String type, NutsId anyId, NdiScriptOptions options) {
        return ScriptBuilder.simple(shellFamily, type, anyId, this);
    }

    public NdiScriptInfo[] getNutsTerm(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getNutsTerm(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public abstract NdiScriptInfo getNutsTerm(NdiScriptOptions var1, NutsShellFamily var2);

    public NdiScriptInfo[] getIncludeNutsEnv(NdiScriptOptions options) {
        return (NdiScriptInfo[])Arrays.stream(this.getShellGroups()).map(x -> this.getIncludeNutsEnv(options, (NutsShellFamily)x)).filter(Objects::nonNull).toArray(NdiScriptInfo[]::new);
    }

    public abstract NdiScriptInfo getIncludeNutsEnv(NdiScriptOptions var1, NutsShellFamily var2);

    public NdiScriptInfo getNutsStart(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public NutsPath path() {
                return options.resolveBinFolder().resolve(BaseSystemNdi.this.getExecFileName("nuts"));
            }

            @Override
            public PathInfo create() {
                return null;
            }
        };
    }

    public NutsPath getBinScriptFile(String name, NdiScriptOptions options) {
        NutsPath pp = NutsPath.of((String)name, (NutsSession)options.getSession());
        if (!pp.isName()) {
            return pp.toAbsolute();
        }
        return options.resolveBinFolder().resolve(this.getExecFileName(name)).toAbsolute();
    }

    protected abstract String createNutsScriptContent(NutsId var1, NdiScriptOptions var2, NutsShellFamily var3);

    @Override
    public PathInfo[] createArtifactScript(NdiScriptOptions options) {
        NutsId nid = NutsId.of((String)options.getId(), (NutsSession)this.session);
        ArrayList<PathInfo> r = new ArrayList<PathInfo>();
        if (this.isNutsBootId(nid)) {
            r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
        } else {
            NutsDefinition appDef;
            if (options.isAddNutsScript()) {
                r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
            }
            NutsDefinition fetched = null;
            if (nid.getVersion().isBlank()) {
                fetched = (NutsDefinition)this.session.search().setSession(this.session.copy()).addId(options.getId()).setLatest(true).getResultDefinitions().required();
                nid = fetched.getId().getShortId();
            }
            String n = nid.getArtifactId();
            NutsPath ff = this.getBinScriptFile(n, options);
            String s = options.getLauncher().getCustomScriptPath();
            if (NutsBlankable.isBlank((String)s)) {
                appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), "%n", null, appDef.getDescriptor(), this.session).buildName();
                s = this.getBinScriptFile(s, options).toString();
            } else if (NutsPath.of((String)s, (NutsSession)this.session).isName()) {
                appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), s, null, appDef.getDescriptor(), this.session).buildName();
                s = this.getBinScriptFile(s, options).toString();
            } else {
                appDef = this.loadIdDefinition(nid);
                s = s + File.separator + NameBuilder.id(appDef.getId(), this.getExecFileName("%n"), null, appDef.getDescriptor(), this.session).buildName();
            }
            NutsShellFamily shellFamily = this.getShellGroups()[0];
            r.add(this.scriptBuilderTemplate("body", shellFamily, "artifact", nid, options).setPath(s).println(this.createNutsScriptContent(nid, options, shellFamily)).build());
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.DESKTOP, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateCustomShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.SHORTCUT, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.MENU, options.copy().setId(nid.toString()))));
            }
        }
        return r.toArray(new PathInfo[0]);
    }

    @Override
    public void removeNutsScript(String id, String switchWorkspaceLocation, NutsSession session) {
        NdiScriptOptions options = new NdiScriptOptions().setSession(session);
        options.getLauncher().setSwitchWorkspaceLocation(switchWorkspaceLocation);
        NutsId nid = NutsId.of((String)id, (NutsSession)session);
        NutsPath f = this.getBinScriptFile(nid.getArtifactId(), options);
        NutsTexts factory = NutsTexts.of((NutsSession)this.session);
        if (f.isRegularFile() && session.getTerminal().ask().resetLine().forBoolean("tool %s will be removed. Confirm?", new Object[]{factory.ofStyled(CoreIOUtils.betterPath(f.toString()), NutsTextStyle.path())}).setDefaultValue((Object)true).setSession(session).getBooleanValue().booleanValue()) {
            f.delete();
            if (session.isPlainTrace()) {
                session.out().printf("tool %s removed.%n", new Object[]{factory.ofStyled(CoreIOUtils.betterPath(f.toString()), NutsTextStyle.path())});
            }
        }
    }

    @Override
    public PathInfo[] switchWorkspace(NdiScriptOptions options) {
        options = options.copy();
        options.getLauncher().setSystemWideConfig(Boolean.valueOf(true));
        PathInfo[] v = this.createBootScripts(options);
        if (this.session.isPlainTrace()) {
            this.session.out().printf("```sh nuts``` switched to workspace %s to point to %s\n", new Object[]{options.getWorkspaceLocation(), options.getNutsApiVersion()});
        }
        return v;
    }

    @Override
    public boolean isNutsBootId(NutsId nid) {
        return "nuts".equals(nid.getShortName()) || "net.thevpc.nuts:nuts".equals(nid.getShortName());
    }

    @Override
    public PathInfo[] addScript(NdiScriptOptions options, String[] all) {
        List<String> idsToInstall = Arrays.asList(all);
        NutsSession session = options.getSession();
        NutsWorkspaceUtils.checkSession(this.getSession().getWorkspace(), options.getSession());
        Path workspaceLocation = session.locations().getWorkspaceLocation().toFile();
        ArrayList<PathInfo> result = new ArrayList<PathInfo>();
        Boolean systemWideConfig = options.getLauncher().getSystemWideConfig();
        if (!idsToInstall.isEmpty()) {
            NdiScriptOptions oo;
            NutsId nid;
            if (systemWideConfig == null) {
                systemWideConfig = workspaceLocation.equals(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".config/nuts/").resolve("default-workspace"));
            }
            boolean includeEnv = options.isIncludeEnv();
            for (String id : idsToInstall) {
                NutsId nid2 = NutsId.of((String)id, (NutsSession)session);
                if (nid2 == null) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to create script for %s : invalid id", (Object[])new Object[]{id}), 100);
                }
                if (nid2.getVersion().isBlank()) continue;
                includeEnv = true;
            }
            String linkNameCurrent = options.getLauncher().getCustomScriptPath();
            List nutsIds = idsToInstall.stream().filter(x -> this.isNutsBootId(NutsId.of((String)x, (NutsSession)session))).collect(Collectors.toList());
            List nonNutsIds = idsToInstall.stream().filter(x -> !this.isNutsBootId(NutsId.of((String)x, (NutsSession)session))).collect(Collectors.toList());
            boolean bootAlreadyProcessed = false;
            for (String id : nutsIds) {
                try {
                    String verString;
                    nid = NutsId.of((String)id, (NutsSession)session);
                    bootAlreadyProcessed = true;
                    if (!nid.getVersion().isBlank() && ((verString = nid.getVersion().toString()).equalsIgnoreCase("current") || verString.equalsIgnoreCase("curr"))) {
                        id = nid.builder().setVersion(session.getWorkspace().getApiId().getVersion()).build().toString();
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException | NutsIOException e) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to add launcher for %s : %s", (Object[])new Object[]{id, e}), e);
                }
            }
            if (!bootAlreadyProcessed && !nonNutsIds.isEmpty()) {
                NdiScriptOptions oo2 = options.copy().setId(options.resolveNutsApiId().toString());
                oo2.getLauncher().setCustomScriptPath(null);
                oo2.getLauncher().setCustomScriptPath(linkNameCurrent);
                oo2.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                result.addAll(Arrays.asList(this.createBootScripts(oo2)));
            }
            for (String id : nonNutsIds) {
                try {
                    nid = NutsId.of((String)id, (NutsSession)session);
                    if (nid == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to create script for %s : invalid id", (Object[])new Object[]{id}), 100);
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                    oo.setIncludeEnv(includeEnv);
                    oo.setSession(session);
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException | NutsIOException e) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to add launcher for %s : %s", (Object[])new Object[]{id, e}), e);
                }
            }
        }
        return result.toArray(new PathInfo[0]);
    }

    public PathInfo[] createBootScripts(NdiScriptOptions options) {
        String preferredName = options.getLauncher().getShortcutName();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        for (NdiScriptInfo i : this.getIncludeNutsEnv(options)) {
            all.add(i.create());
        }
        for (NdiScriptInfo i : this.getIncludeNutsInit(options)) {
            all.add(i.create());
        }
        String scriptPath = options.getLauncher().getCustomScriptPath();
        all.add(this.scriptBuilderTemplate("nuts", this.getShellGroups()[0], "nuts", options.resolveNutsApiId(), options).setPath(this.getBinScriptFile(NameBuilder.id(options.resolveNutsApiId(), scriptPath, "%n", options.resolveNutsApiDef().getDescriptor(), this.session).buildName(), options)).build());
        for (NdiScriptInfo i : this.getIncludeNutsTermInit(options)) {
            all.add(i.create());
        }
        for (NdiScriptInfo i : this.getNutsTerm(options)) {
            all.add(i.create());
        }
        if (options.getLauncher().getSystemWideConfig() != null && options.getLauncher().getSystemWideConfig().booleanValue()) {
            for (NdiScriptInfo ndiScriptInfo : this.getSysRC(options)) {
                PathInfo sysRC = ndiScriptInfo.create();
                if (sysRC == null) continue;
                all.add(sysRC);
            }
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem.DESKTOP, options)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem.MENU, options)));
            }
        } else {
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.DESKTOP, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.MENU, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateCustomShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.SHORTCUT, options, scriptPath, preferredName)));
            }
        }
        if (options.getLauncher().getSystemWideConfig() != null && options.getLauncher().getSystemWideConfig().booleanValue() && all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.onPostGlobal(options, all.toArray(new PathInfo[0]));
        }
        return all.toArray(new PathInfo[0]);
    }

    private NutsDefinition loadIdDefinition(NutsId nid) {
        return (NutsDefinition)this.session.search().addId(nid).setLatest(true).setEffective(true).setDistinct(true).getResultDefinitions().singleton();
    }

    public NutsSupportMode getDesktopIntegrationSupport(NutsDesktopIntegrationItem target) {
        return this.session.env().getDesktopIntegrationSupport(target);
    }

    protected boolean matchCondition(NutsSupportCondition createDesktop, NutsSupportMode desktopIntegrationSupport) {
        if (desktopIntegrationSupport == null) {
            desktopIntegrationSupport = NutsSupportMode.UNSUPPORTED;
        }
        return desktopIntegrationSupport.acceptCondition(createDesktop, this.session);
    }

    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
    }

    public NutsWorkspaceBootConfig loadSwitchWorkspaceLocationConfig(String switchWorkspaceLocation) {
        NutsWorkspaceBootConfig bootConfig = this.session.config().loadBootConfig(switchWorkspaceLocation, false, true);
        if (bootConfig == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid workspace: %s", (Object[])new Object[]{switchWorkspaceLocation}));
        }
        return bootConfig;
    }

    private String prepareLinkName(String linkName) {
        if (linkName == null) {
            linkName = "%n-%v";
        } else if (Files.isDirectory(Paths.get(linkName, new String[0]), new LinkOption[0])) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        } else if (linkName.endsWith("/") || linkName.endsWith("\\")) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        }
        return linkName;
    }

    public boolean saveFile(Path filePath, String content, boolean force) {
        try {
            String fileContent = "";
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                fileContent = new String(Files.readAllBytes(filePath));
            }
            if (force || !content.trim().equals(fileContent.trim())) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, content.getBytes(), new OpenOption[0]);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public List<String> splitLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null) {
            return lines;
        }
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
        return lines;
    }

    public PathInfo addFileLine(String type, NutsId id, NutsPath filePath, ReplaceString commentLine, String contentToAdd, ReplaceString header, NutsShellFamily shellFamily) {
        filePath = filePath.toAbsolute();
        List<String> contentToAddRows = this.splitLines(contentToAdd);
        boolean found = false;
        ArrayList<String> newFileContentRows = new ArrayList<String>();
        List<String> oldFileContentRows = null;
        NutsShellHelper sh = NutsShellHelper.of(shellFamily);
        if (filePath.isRegularFile()) {
            String fileContentString = new String(filePath.readAllBytes());
            oldFileContentRows = this.splitLines(fileContentString);
            while (!oldFileContentRows.isEmpty()) {
                if (oldFileContentRows.get(0).trim().isEmpty()) {
                    oldFileContentRows.remove(0);
                    continue;
                }
                if (!oldFileContentRows.get(oldFileContentRows.size() - 1).trim().isEmpty()) break;
                oldFileContentRows.remove(oldFileContentRows.size() - 1);
            }
            for (int i = 0; i < oldFileContentRows.size(); ++i) {
                String row = oldFileContentRows.get(i);
                if (sh.isComments(row.trim()) && commentLine.matches(sh.trimComments(row.trim()))) {
                    String clta = sh.toCommentLine(commentLine.getReplacement());
                    if (!clta.equals(row)) {
                        // empty if block
                    }
                    if (newFileContentRows.size() > 0 && ((String)newFileContentRows.get(newFileContentRows.size() - 1)).trim().length() > 0) {
                        newFileContentRows.add("");
                    }
                    newFileContentRows.add(clta);
                    found = true;
                    ++i;
                    ArrayList<String> old = new ArrayList<String>();
                    while (i < oldFileContentRows.size()) {
                        String s = oldFileContentRows.get(i);
                        if (s.trim().isEmpty()) {
                            ++i;
                            break;
                        }
                        if (s.trim().startsWith("#")) break;
                        ++i;
                        old.add(s.trim());
                    }
                    newFileContentRows.addAll(contentToAddRows);
                    newFileContentRows.add("");
                    while (i < oldFileContentRows.size()) {
                        newFileContentRows.add(oldFileContentRows.get(i));
                        ++i;
                    }
                    continue;
                }
                newFileContentRows.add(row);
            }
        }
        if (!(header == null || newFileContentRows.size() != 0 && header.matches(((String)newFileContentRows.get(0)).trim()))) {
            newFileContentRows.add(0, header.getReplacement());
        }
        if (!found) {
            if (newFileContentRows.size() > 0 && !((String)newFileContentRows.get(0)).trim().isEmpty()) {
                newFileContentRows.add("");
            }
            newFileContentRows.add(sh.toCommentLine(commentLine.getReplacement()));
            newFileContentRows.addAll(contentToAddRows);
            newFileContentRows.add("");
        }
        byte[] newContent = String.join((CharSequence)sh.newlineString(), newFileContentRows).getBytes();
        return new PathInfo(type, id, filePath, CoreIOUtils.tryWrite(newContent, filePath, this.session));
    }

    public PathInfo removeFileCommented2Lines(String type, NutsId id, NutsPath filePath, String commentLine, boolean force, NutsShellFamily shellFamily) {
        filePath = filePath.toAbsolute();
        boolean alreadyExists = filePath.exists();
        boolean found = false;
        boolean updatedFile = false;
        NutsShellHelper sh = NutsShellHelper.of(shellFamily);
        ArrayList<String> lines = new ArrayList<String>();
        if (filePath.isRegularFile()) {
            String fileContent = new String(filePath.readAllBytes());
            String[] fileRows = fileContent.split("[\n\r]");
            for (int i = 0; i < fileRows.length; ++i) {
                String row = fileRows[i];
                if (row.trim().equals(sh.toCommentLine(commentLine))) {
                    found = true;
                    i += 2;
                    while (i < fileRows.length) {
                        lines.add(fileRows[i]);
                        ++i;
                    }
                    continue;
                }
                lines.add(row);
            }
        }
        if (found) {
            updatedFile = true;
        }
        if (force || updatedFile) {
            filePath.mkParentDirs();
            filePath.writeBytes((String.join((CharSequence)sh.newlineString(), lines) + sh.newlineString()).getBytes());
        }
        return new PathInfo(type, id, filePath, updatedFile ? (alreadyExists ? PathInfo.Status.OVERRIDDEN : PathInfo.Status.CREATED) : PathInfo.Status.DISCARDED);
    }

    protected abstract String getExecFileName(String var1);

    protected abstract FreeDesktopEntryWriter createFreeDesktopEntryWriter();

    public PathInfo[] createShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NutsId id, String path, FreeDesktopEntry.Group shortcut) {
        ArrayList<PathInfo> results = new ArrayList<PathInfo>();
        FreeDesktopEntryWriter ww = this.createFreeDesktopEntryWriter();
        if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.DESKTOP) {
            results.addAll(Arrays.asList(ww.writeDesktop(shortcut, path, true, id)));
        } else if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.MENU) {
            results.addAll(Arrays.asList(ww.writeMenu(shortcut, path, true, id)));
        } else if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.SHORTCUT) {
            results.addAll(Arrays.asList(ww.writeShortcut(shortcut, path == null ? null : NutsPath.of((String)path, (NutsSession)this.session), true, id)));
        } else {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
        }
        return results.toArray(new PathInfo[0]);
    }

    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    protected int compareIconExtensions(String a, String b) {
        int ai = this.resolveIconExtensionPriority(a);
        int bi = this.resolveIconExtensionPriority(b);
        return Integer.compare(bi, ai);
    }

    protected int compareIconPaths(String a, String b) {
        String n1 = NutsPath.of((String)a, (NutsSession)this.session).getLastExtension();
        String n2 = NutsPath.of((String)b, (NutsSession)this.session).getLastExtension();
        return this.compareIconExtensions(n1, n2);
    }

    protected String resolveBestIcon(NutsId appId, String ... iconPaths) {
        List all;
        if ((iconPaths = this.toAbsoluteIconPaths(appId, iconPaths)) != null && (all = Arrays.stream(iconPaths).map(x -> x == null ? "" : x.trim()).filter(x -> !x.isEmpty()).filter(x -> this.resolveIconExtensionPriority(NutsPath.of((String)x, (NutsSession)this.session).getLastExtension()) >= 0).sorted(this::compareIconPaths).collect(Collectors.toList())).size() > 0) {
            return (String)all.get(0);
        }
        return null;
    }

    public String resolveIcon(String iconPath, NutsId appId) {
        if (!NutsBlankable.isBlank((String)iconPath)) {
            return iconPath;
        }
        return this.getPreferredIconPath(appId);
    }

    public String[] toAbsoluteIconPaths(NutsId appId, String[] iconPaths) {
        if (iconPaths == null) {
            return null;
        }
        return (String[])Arrays.stream(iconPaths).map(x -> this.toAbsoluteIconPath(appId, (String)x)).toArray(String[]::new);
    }

    public String toAbsoluteIconPath(NutsId appId, String iconPath) {
        if (NutsBlankable.isBlank((String)iconPath)) {
            return iconPath;
        }
        if (iconPath.startsWith("classpath://")) {
            return "nuts-resource://" + appId.getLongName() + "" + iconPath.substring("classpath://".length() - 1);
        }
        return iconPath;
    }

    public String getPreferredIconPath(NutsId appId) {
        if (NutsIdUtils.isApiId(appId)) {
            NutsId rt = NutsIdUtils.findRuntimeForApi(appId.getVersion().getValue(), this.getSession());
            if (rt == null) {
                rt = this.session.getWorkspace().getRuntimeId();
            }
            return this.getPreferredIconPath(rt);
        }
        NutsDefinition appDef = (NutsDefinition)this.session.search().addId(appId).setLatest(true).setEffective(true).setDistinct(true).getResultDefinitions().singleton();
        String descAppIcon = this.resolveBestIcon(appDef.getId(), appDef.getDescriptor().getIcons());
        if (descAppIcon == null) {
            NutsId rid;
            if (this.isNutsBootId(appDef.getId()) || appDef.getId().getGroupId().equals("net.thevpc.nuts") || appDef.getId().getGroupId().startsWith("net.thevpc.nuts.")) {
                rid = this.session.getWorkspace().getRuntimeId();
                descAppIcon = this.resolveBestIcon(rid, "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.svg", "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.png", "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts.ico");
            } else if (appDef.getId().getGroupId().startsWith("net.thevpc.nuts")) {
                rid = this.session.getWorkspace().getRuntimeId();
                descAppIcon = this.resolveBestIcon(rid, "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.svg", "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.png", "nuts-resource://" + rid.getLongName() + "/net/thevpc/nuts/runtime/nuts-app.ico");
            }
        }
        String iconPath = null;
        if (descAppIcon != null) {
            String descAppIcon0 = descAppIcon;
            String descAppIconDigest = NutsDigest.of((NutsSession)this.session).md5().setSource((InputStream)new ByteArrayInputStream(descAppIcon0.getBytes())).computeString();
            NutsPath p0 = NutsPath.of((String)descAppIcon, (NutsSession)this.session);
            descAppIcon = this.toAbsoluteIconPath(appId, descAppIcon);
            String bestName = descAppIconDigest + "." + p0.getLastExtension();
            NutsPath localIconPath = this.session.locations().getStoreLocation(appDef.getId(), NutsStoreLocation.CACHE).resolve("icons").resolve(bestName);
            if (localIconPath.isRegularFile()) {
                iconPath = localIconPath.toString();
            } else {
                NutsPath p = NutsPath.of((String)descAppIcon, (NutsSession)this.session);
                if (p.exists()) {
                    NutsCp.of((NutsSession)this.session).from(p).to(localIconPath).addOptions(new NutsPathOption[]{NutsPathOption.SAFE, NutsPathOption.LOG, NutsPathOption.TRACE}).run();
                    iconPath = localIconPath.toString();
                }
            }
        }
        if (iconPath == null) {
            iconPath = this.getDefaultIconPath();
        }
        return iconPath;
    }

    public Path getShortcutPath(NdiScriptOptions options) {
        NutsDefinition appDef = (NutsDefinition)options.getSession().search().addId(options.getId()).setLatest(true).setEffective(true).setDistinct(true).getResultDefinitions().singleton();
        String fileName = options.getLauncher().getCustomScriptPath();
        fileName = this.resolveShortcutFileName(appDef.getId(), appDef.getDescriptor(), fileName, null);
        return Paths.get(fileName, new String[0]);
    }

    public PathInfo[] createShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options) {
        String cwd;
        String apiVersion = options.getNutsApiVersion().toString();
        if (apiVersion == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing nuts-api version to link to", (Object[])new Object[0]));
        }
        NutsId apiId = this.session.getWorkspace().getApiId().builder().setVersion(apiVersion).build();
        NutsDefinition apiDefinition = (NutsDefinition)this.session.search().addId(apiId).setFailFast(true).setLatest(true).setContent(true).setDistinct(true).getResultDefinitions().singleton();
        NutsSession session = options.getSession();
        NutsId appId = NutsId.of((String)options.getId(), (NutsSession)session);
        NutsDefinition appDef = this.loadIdDefinition(appId);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getNutsStart(options).path().toString());
        cmd.add("-y");
        cmd.add(appId.toString());
        if (options.getLauncher().getArgs() != null) {
            cmd.addAll(options.getLauncher().getArgs());
        }
        if ((cwd = options.getLauncher().getWorkingDirectory()) == null) {
            cwd = System.getProperty("user.home");
        }
        String iconPath = this.resolveIcon(options.getLauncher().getIcon(), appId);
        String shortcutName = options.getLauncher().getShortcutName();
        if (shortcutName == null && nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.SHORTCUT && (shortcutName = options.getLauncher().getCustomShortcutPath()) == null) {
            shortcutName = options.getLauncher().getCustomScriptPath();
        }
        if ((shortcutName = NameBuilder.extractPathName(shortcutName)).isEmpty()) {
            shortcutName = "%N";
        }
        shortcutName = shortcutName + "%s%v%s%h";
        shortcutName = NameBuilder.label(appDef.getId(), shortcutName, null, appDef.getDescriptor(), this.session).buildName();
        String execCmd = NutsCommandLine.of(cmd, (NutsSession)this.session).toString();
        FreeDesktopEntry.Group sl = FreeDesktopEntry.Group.desktopEntry(shortcutName, execCmd, cwd);
        sl.setStartNotify(true);
        sl.setIcon(iconPath);
        sl.setGenericName(apiDefinition.getDescriptor().getGenericName());
        sl.setComment(appDef.getDescriptor().getDescription());
        sl.setTerminal(options.getLauncher().isOpenTerminal());
        if (options.getLauncher().getMenuCategory() != null) {
            sl.addCategory(options.getLauncher().getMenuCategory());
        } else {
            sl.setCategories(Arrays.asList(appDef.getDescriptor().getCategories()));
        }
        String preferredPath = this.getShortcutPath(options).toString();
        return this.createShortcut(nutsDesktopIntegrationItem, appId, preferredPath, sl);
    }

    protected String getDefaultIconPath() {
        return "apper";
    }

    public PathInfo[] createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options) {
        String fileName = options.resolveNutsApiId().getShortName().replace(':', '-');
        String name = "Nuts Terminal";
        return this.createLaunchTermShortcut(nutsDesktopIntegrationItem, options, fileName, name);
    }

    public abstract boolean isShortcutFileNameUserFriendly();

    public String resolveShortcutFileName(NutsId id, NutsDescriptor descriptor, String fileName, String name) {
        if (NutsBlankable.isBlank((String)fileName)) {
            if (this.isShortcutFileNameUserFriendly()) {
                fileName = name;
            }
            if (NutsBlankable.isBlank((String)fileName)) {
                fileName = this.isShortcutFileNameUserFriendly() ? "%N%s%v%s%h" : "%g-%n-%v%s%h";
            }
        }
        fileName = (this.isShortcutFileNameUserFriendly() ? NameBuilder.label(id, fileName, null, descriptor, this.session) : NameBuilder.id(id, fileName, null, descriptor, this.session)).buildName();
        return fileName;
    }

    public PathInfo[] createLaunchTermShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options, String fileName, String name) {
        String cmd = this.getNutsTerm(options)[0].path().toString();
        fileName = this.resolveShortcutFileName(options.resolveNutsApiId(), options.resolveNutsApiDef().getDescriptor(), fileName, name);
        if (name == null) {
            name = NameBuilder.label(options.resolveNutsApiId(), "Nuts Terminal%s%v%s%h", null, options.resolveNutsApiDef().getDescriptor(), this.session).buildName();
        }
        String execCmd = NutsCommandLine.of((String[])new String[]{cmd}, (NutsSession)this.session).toString();
        return this.createShortcut(nutsDesktopIntegrationItem, options.resolveNutsApiId(), fileName, FreeDesktopEntry.Group.desktopEntry(name, execCmd, System.getProperty("user.home")).setIcon(this.resolveIcon(null, options.resolveNutsApiId())).setStartNotify(true).addCategory("/Utility/Nuts").setGenericName(options.resolveNutsApiDef().getDescriptor().getGenericName()).setComment(options.resolveNutsApiDef().getDescriptor().getDescription()).setTerminal(true));
    }

    public ReplaceString getCommentLineConfigHeader() {
        return COMMENT_LINE_CONFIG_HEADER;
    }

    public abstract String getTemplateName(String var1, NutsShellFamily var2);

    private class RcNdiScriptInfo
    implements NdiScriptInfo {
        private final String bashrcName;
        private final NdiScriptOptions options;
        private final NutsShellFamily shellFamily;

        public RcNdiScriptInfo(String bashrcName, NdiScriptOptions options, NutsShellFamily shellFamily) {
            this.bashrcName = bashrcName;
            this.options = options;
            this.shellFamily = shellFamily;
        }

        @Override
        public NutsPath path() {
            if (this.bashrcName == null) {
                return null;
            }
            return NutsPath.of((String)System.getProperty("user.home"), (NutsSession)BaseSystemNdi.this.session).resolve(this.bashrcName);
        }

        @Override
        public PathInfo create() {
            NutsPath apiConfigFile = this.path();
            if (apiConfigFile == null) {
                return null;
            }
            NutsShellHelper sh = NutsShellHelper.of(this.shellFamily);
            return BaseSystemNdi.this.addFileLine("sysrc", this.options.resolveNutsApiId(), apiConfigFile, BaseSystemNdi.this.getCommentLineConfigHeader(), sh.getCallScriptCommand(BaseSystemNdi.this.getIncludeNutsInit(this.options, this.shellFamily).path().toString(), new String[0]), sh.getShebanSh(), this.shellFamily);
        }
    }
}

