/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.optional.mslink.OptionalMsLinkHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.SystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.LinuxNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.unix.MacosNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.win.WindowsNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;

public class NutsSettingsNdiSubCommand
extends AbstractNutsSettingsSubCommand {
    public static SystemNdi createNdi(NutsSession session) {
        BaseSystemNdi ndi = null;
        NutsWorkspaceEnvManager workspaceEnvManager = session.env();
        switch (workspaceEnvManager.getOsFamily()) {
            case LINUX: 
            case UNIX: {
                ndi = new LinuxNdi(session);
                break;
            }
            case MACOS: {
                ndi = new MacosNdi(session);
                break;
            }
            case WINDOWS: {
                if (!OptionalMsLinkHelper.isSupported()) break;
                ndi = new WindowsNdi(session);
            }
        }
        return ndi;
    }

    public void runAddLauncher(NutsCommandLine commandLine, NutsSession session) {
        NdiScriptOptions options = new NdiScriptOptions();
        options.setSession(session.copy());
        ArrayList<String> idsToInstall = new ArrayList<String>();
        boolean missingAnyArgument = true;
        boolean ignoreUnsupportedOs = false;
        commandLine.setCommandName("settings add launcher");
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextBoolean(new String[]{"-t", "--fetch"});
            if (a != null) {
                options.setFetch(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextString(new String[]{"-d", "--workdir"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setWorkingDirectory(a.getValue().getString());
                continue;
            }
            a = commandLine.nextString(new String[]{"--icon"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setIcon(a.getValue().getString());
                continue;
            }
            a = commandLine.next(new String[]{"--menu"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setCreateMenuShortcut(this.parseCond(a));
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-category"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setMenuCategory(a.getValue().getString());
                if (options.getLauncher().getMenuCategory() == null || options.getLauncher().getMenuCategory().isEmpty() || options.getLauncher().getCreateMenuShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateMenuShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--desktop"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setCreateDesktopShortcut(this.parseCond(a));
                continue;
            }
            a = commandLine.nextString(new String[]{"--desktop-name"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setShortcutName(a.getValue().getString());
                if (options.getLauncher().getCreateDesktopShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateDesktopShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-name"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setShortcutName(a.getValue().getString());
                if (options.getLauncher().getCreateDesktopShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateMenuShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--shortcut-name"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setShortcutName(a.getValue().getString());
                if (options.getLauncher().getCreateCustomShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateCustomShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextString(new String[]{"--shortcut-path"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setCustomShortcutPath(a.getValue().getString());
                if (options.getLauncher().getCreateCustomShortcut() != NutsSupportCondition.NEVER) continue;
                options.getLauncher().setCreateCustomShortcut(NutsSupportCondition.PREFERRED);
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-x", "--external", "--spawn"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--spawn");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-b", "--embedded"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--embedded");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--terminal"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setOpenTerminal(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"-e", "--env"});
            if (a != null) {
                options.setIncludeEnv(a.getBooleanValue());
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--system"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--system");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--current-user"});
            if (a != null) {
                if (!a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--current-user");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--as-root"});
            if (a != null) {
                if (!a.isActive() || !a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--as-root");
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--sudo"});
            if (a != null) {
                if (!a.isActive() || !a.getBooleanValue()) continue;
                options.getLauncher().getNutsOptions().add("--sudo");
                continue;
            }
            a = commandLine.nextString(new String[]{"--run-as"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().getNutsOptions().add("--run-as=" + a.getValue().getString());
                continue;
            }
            a = commandLine.nextString(new String[]{"-X", "--exec-options"});
            if (a != null) {
                options.getLauncher().getNutsOptions().add("--exec-options=" + a.getValue().getString());
                continue;
            }
            a = commandLine.nextString(new String[]{"-i", "--installed"});
            if (a != null) {
                session.setConfirm(NutsConfirmationMode.YES);
                for (NutsId resultId : session.search().setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(true)).getResultIds()) {
                    idsToInstall.add(resultId.getLongName());
                    missingAnyArgument = false;
                }
                continue;
            }
            a = commandLine.nextString(new String[]{"-c", "--companions"});
            if (a != null) {
                session.setConfirm(NutsConfirmationMode.YES);
                for (NutsId companion : session.extensions().getCompanionIds()) {
                    idsToInstall.add(((NutsId)session.search().addId(companion).setLatest(true).getResultIds().required()).getLongName());
                    missingAnyArgument = false;
                }
                continue;
            }
            a = commandLine.nextString(new String[]{"--switch"});
            if (a != null) {
                if (!a.isActive()) continue;
                options.getLauncher().setSystemWideConfig(Boolean.valueOf(a.getBooleanValue()));
                continue;
            }
            a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isActive()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().getKey().getString().equals("-w") || commandLine.peek().getKey().getString().equals("--workspace")) {
                a = commandLine.nextString(new String[0]);
                if (!a.isActive()) continue;
                options.getLauncher().setSwitchWorkspaceLocation(a.getValue().getString());
                continue;
            }
            if (commandLine.peek().getKey().getString().equals("-n") || commandLine.peek().getKey().getString().equals("--name")) {
                a = commandLine.nextString(new String[0]);
                if (!a.isActive()) continue;
                options.getLauncher().setCustomScriptPath(a.getValue().getString());
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            idsToInstall.add(commandLine.next().getString());
            missingAnyArgument = false;
        }
        if (missingAnyArgument) {
            commandLine.required();
        }
        if (commandLine.isExecMode()) {
            SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
            if (ndi == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s", (Object[])new Object[]{session.env().getOs()}), 2);
            }
            if (!idsToInstall.isEmpty()) {
                this.printResults(session, ndi.addScript(options, idsToInstall.toArray(new String[0])));
            }
        }
    }

    private NutsSupportCondition parseCond(NutsArgument a) {
        String s;
        switch (s = a.getValue().getString("")) {
            case "supported": {
                return NutsSupportCondition.SUPPORTED;
            }
            case "never": {
                return NutsSupportCondition.NEVER;
            }
            case "always": {
                return NutsSupportCondition.ALWAYS;
            }
            case "preferred": 
            case "": {
                return NutsSupportCondition.PREFERRED;
            }
        }
        if (a.getBooleanValue()) {
            return NutsSupportCondition.PREFERRED;
        }
        return NutsSupportCondition.NEVER;
    }

    public void runRemoveLauncher(NutsCommandLine commandLine, NutsSession session) {
        ArrayList<String> idsToUninstall = new ArrayList<String>();
        boolean forceAll = false;
        boolean missingAnyArgument = true;
        boolean ignoreUnsupportedOs = false;
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isActive()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            idsToUninstall.add(commandLine.next().getString());
            missingAnyArgument = false;
        }
        if (missingAnyArgument) {
            commandLine.required();
        }
        if (commandLine.isExecMode()) {
            SystemNdi ndi;
            if (forceAll) {
                session.setConfirm(NutsConfirmationMode.YES);
            }
            if ((ndi = NutsSettingsNdiSubCommand.createNdi(session)) == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s", (Object[])new Object[]{session.env().getOs()}), 2);
            }
            boolean subTrace = session.isTrace();
            if (!session.isPlainTrace()) {
                subTrace = false;
            }
            if (!idsToUninstall.isEmpty()) {
                for (String id : idsToUninstall) {
                    try {
                        ndi.removeNutsScript(id, null, session.copy().setTrace(Boolean.valueOf(subTrace)));
                    }
                    catch (UncheckedIOException | NutsIOException e) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to run script %s : %s", (Object[])new Object[]{id, e}), e);
                    }
                }
            }
        }
    }

    public void runSwitch(NutsCommandLine commandLine, NutsSession session) {
        String switchWorkspaceLocation = null;
        String switchWorkspaceApi = null;
        boolean ignoreUnsupportedOs = false;
        NutsSupportCondition createDesktop = NutsSupportCondition.NEVER;
        NutsSupportCondition createMenu = NutsSupportCondition.NEVER;
        String menuCategory = null;
        String shortcutName = null;
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextString(new String[]{"--ignore-unsupported-os"});
            if (a != null) {
                if (!a.isActive()) continue;
                ignoreUnsupportedOs = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().getKey().getString().equals("-w") || commandLine.peek().getKey().getString().equals("--workspace")) {
                switchWorkspaceLocation = commandLine.nextString(new String[0]).getValue().getString();
                continue;
            }
            if (commandLine.peek().getKey().getString().equals("-a") || commandLine.peek().getKey().getString().equals("--api")) {
                switchWorkspaceApi = commandLine.nextString(new String[0]).getValue().getString();
                continue;
            }
            a = commandLine.next(new String[]{"--menu"});
            if (a != null) {
                if (!a.isActive()) continue;
                createMenu = this.parseCond(a);
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-category"});
            if (a != null) {
                if (!a.isActive() || (menuCategory = a.getValue().getString()) == null || menuCategory.isEmpty() || createMenu != NutsSupportCondition.NEVER) continue;
                createMenu = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.nextString(new String[]{"--menu-name"});
            if (a != null) {
                if (!a.isActive() || (shortcutName = a.getValue().getString()) == null || shortcutName.isEmpty() || createMenu != NutsSupportCondition.NEVER) continue;
                createMenu = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.nextString(new String[]{"--desktop-name"});
            if (a != null) {
                if (!a.isActive() || (shortcutName = a.getValue().getString()) == null || shortcutName.isEmpty() || createDesktop != NutsSupportCondition.NEVER) continue;
                createDesktop = NutsSupportCondition.PREFERRED;
                continue;
            }
            a = commandLine.next(new String[]{"--desktop"});
            if (a != null) {
                if (!a.isActive()) continue;
                createDesktop = this.parseCond(a);
                continue;
            }
            if (commandLine.peek().isOption()) {
                commandLine.unexpectedArgument();
                continue;
            }
            if (switchWorkspaceLocation == null) {
                switchWorkspaceLocation = commandLine.next().getString();
                continue;
            }
            if (switchWorkspaceApi == null) {
                switchWorkspaceApi = commandLine.next().getString();
                continue;
            }
            if (commandLine.peek().isOption()) {
                session.configureLast(commandLine);
                continue;
            }
            commandLine.unexpectedArgument();
        }
        if (commandLine.isExecMode()) {
            SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
            if (ndi == null) {
                if (ignoreUnsupportedOs) {
                    return;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"platform not supported : %s ", (Object[])new Object[]{session.env().getOs()}), 2);
            }
            if (switchWorkspaceLocation != null || switchWorkspaceApi != null) {
                NdiScriptOptions oo = new NdiScriptOptions().setSession(session);
                oo.getLauncher().setSwitchWorkspaceLocation(switchWorkspaceLocation);
                oo.getLauncher().setCreateDesktopShortcut(createDesktop);
                oo.getLauncher().setMenuCategory(menuCategory);
                oo.getLauncher().setCreateMenuShortcut(createMenu);
                oo.getLauncher().setShortcutName(shortcutName);
                ndi.switchWorkspace(oo);
            }
        }
    }

    private void printResults(NutsSession session, PathInfo[] result) {
        if (session.isTrace()) {
            result = (PathInfo[])Arrays.stream(result).filter(x -> x.getStatus() != PathInfo.Status.DISCARDED).toArray(PathInfo[]::new);
            if (session.isPlainTrace()) {
                int namesSize = Arrays.stream(result).mapToInt(x -> x.getPath().getName().length()).max().orElse(1);
                for (PathInfo ndiScriptInfo : result) {
                    session.out().resetLine().printf("%s script %-" + namesSize + "s for %s at %s%n", new Object[]{ndiScriptInfo.getStatus() == PathInfo.Status.OVERRIDDEN ? NutsTexts.of((NutsSession)session).ofStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()})) : NutsTexts.of((NutsSession)session).ofStyled("install", NutsTextStyle.success()), NutsTexts.of((NutsSession)session).ofStyled(ndiScriptInfo.getPath().getName(), NutsTextStyle.path()), ndiScriptInfo.getId(), NutsTexts.of((NutsSession)session).ofStyled(CoreIOUtils.betterPath(ndiScriptInfo.getPath().toString()), NutsTextStyle.path())});
                }
            } else {
                session.out().printlnf((Object)result);
            }
        }
    }

    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"add launcher", "lna"}) != null) {
            this.runAddLauncher(cmdLine, session);
            return true;
        }
        if (cmdLine.next(new String[]{"remove launcher", "lnrm"}) != null) {
            this.runRemoveLauncher(cmdLine, session);
            return true;
        }
        if (cmdLine.next(new String[]{"switch", "lnsw"}) != null) {
            this.runSwitch(cmdLine, session);
            return true;
        }
        return false;
    }
}

