/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspaceBootConfig;

public class NdiScriptOptions
implements Cloneable {
    private String id;
    private boolean forceBoot;
    private boolean fetch;
    private boolean includeEnv;
    private boolean addNutsScript;
    private NutsLauncherOptions launcher = new NutsLauncherOptions();
    private String nutsVersion;
    private NutsSession session;
    private NutsId nutsApiId;
    private NutsPath nutsApiJarPath;
    private NutsWorkspaceBootConfig workspaceBootConfig;

    public NutsLauncherOptions getLauncher() {
        return this.launcher;
    }

    public NdiScriptOptions setLauncher(NutsLauncherOptions launcher) {
        this.launcher = launcher;
        return this;
    }

    public boolean isAddNutsScript() {
        return this.addNutsScript;
    }

    public NdiScriptOptions setAddNutsScript(boolean addNutsScript) {
        this.addNutsScript = addNutsScript;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public NdiScriptOptions setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isForceBoot() {
        return this.forceBoot;
    }

    public NdiScriptOptions setForceBoot(boolean forceBoot) {
        this.forceBoot = forceBoot;
        return this;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public NdiScriptOptions setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NdiScriptOptions setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public boolean isIncludeEnv() {
        return this.includeEnv;
    }

    public NdiScriptOptions setIncludeEnv(boolean includeEnv) {
        this.includeEnv = includeEnv;
        return this;
    }

    public NdiScriptOptions copy() {
        NdiScriptOptions c;
        try {
            c = (NdiScriptOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        c.setLauncher(c.getLauncher() == null ? null : c.getLauncher().copy());
        return c;
    }

    public NutsPath resolveNutsApiJarPath() {
        if (this.nutsApiJarPath == null) {
            NutsId nid = this.resolveNutsApiId();
            if (this.getLauncher().getSwitchWorkspaceLocation() == null) {
                NutsDefinition apiDef = (NutsDefinition)this.session.search().addId(nid).setOptional(Boolean.valueOf(false)).setLatest(true).setContent(true).getResultDefinitions().required();
                this.nutsApiJarPath = apiDef.getPath();
            } else {
                NutsWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
                this.nutsApiJarPath = NutsPath.of((String)bootConfig.getStoreLocation(nid, NutsStoreLocation.LIB), (NutsSession)this.session);
                this.session.locations().getDefaultIdFilename(nid);
            }
        }
        return this.nutsApiJarPath;
    }

    public NutsPath resolveBinFolder() {
        return this.resolveNutsAppsFolder().resolve("bin");
    }

    public NutsPath resolveIncFolder() {
        return this.resolveNutsAppsFolder().resolve("inc");
    }

    public NutsPath resolveNutsAppsFolder() {
        NutsSession ws = this.session;
        NutsWorkspaceBootConfig bootConfig = null;
        NutsId apiId = this.session.getWorkspace().getApiId();
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return NutsPath.of((String)bootConfig.getStoreLocation(apiId, NutsStoreLocation.APPS), (NutsSession)this.session);
        }
        return ws.locations().getStoreLocation(apiId, NutsStoreLocation.APPS);
    }

    public NutsPath resolveNutsApiAppsFolder() {
        NutsSession ws = this.session;
        NutsWorkspaceBootConfig bootConfig = null;
        NutsId apiId = ws.getWorkspace().getApiId().builder().setVersion(this.nutsVersion).build();
        apiId = ((NutsDefinition)this.session.search().addId(apiId).setLatest(true).setFailFast(true).setContent(true).setDistinct(true).getResultDefinitions().singleton()).getId();
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return NutsPath.of((String)bootConfig.getStoreLocation(apiId, NutsStoreLocation.APPS), (NutsSession)this.session);
        }
        return ws.locations().getStoreLocation(apiId, NutsStoreLocation.APPS);
    }

    public NutsDefinition resolveNutsApiDef() {
        return (NutsDefinition)this.session.search().addId(this.resolveNutsApiId()).setLatest(true).setContent(true).setFailFast(true).setDistinct(true).getResultDefinitions().singleton();
    }

    public NutsId resolveNutsApiId() {
        if (this.nutsApiId == null) {
            if (this.getLauncher().getSwitchWorkspaceLocation() == null) {
                this.nutsApiId = this.nutsVersion == null ? this.session.getWorkspace().getApiId() : (NutsId)this.session.search().addId(this.session.getWorkspace().getApiId().builder().setVersion(this.nutsVersion).build()).setLatest(true).setDistinct(true).getResultIds().singleton();
            } else {
                NutsWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
                NutsVersion _latestVersion = null;
                try {
                    _latestVersion = Files.list(Paths.get(bootConfig.getStoreLocation(this.session.getWorkspace().getApiId(), NutsStoreLocation.CONFIG), new String[0]).getParent()).filter(f -> NutsVersion.of((String)f.getFileName().toString(), (NutsSession)this.session).getLong(0, -1L) == -1L && Files.exists(f.resolve("nuts-api-boot-config.json"), new LinkOption[0])).map(f -> NutsVersion.of((String)f.getFileName().toString(), (NutsSession)this.session)).sorted(Comparator.reverseOrder()).findFirst().orElse(null);
                }
                catch (IOException e) {
                    throw new NutsIOException(this.session, (Throwable)e);
                }
                if (_latestVersion == null) {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing nuts-api version to link to", (Object[])new Object[0]));
                }
                this.nutsApiId = this.session.getWorkspace().getApiId().builder().setVersion(_latestVersion).build();
            }
        }
        return this.nutsApiId;
    }

    public NutsVersion getNutsApiVersion() {
        return this.resolveNutsApiId().getVersion();
    }

    public Path getWorkspaceLocation() {
        if (this.getLauncher().getSwitchWorkspaceLocation() != null) {
            NutsWorkspaceBootConfig bootConfig = this.loadSwitchWorkspaceLocationConfig(this.getLauncher().getSwitchWorkspaceLocation());
            return Paths.get(bootConfig.getEffectiveWorkspace(), new String[0]);
        }
        return this.session.locations().getWorkspaceLocation().toFile();
    }

    public NutsWorkspaceBootConfig loadSwitchWorkspaceLocationConfig(String switchWorkspaceLocation) {
        if (this.workspaceBootConfig == null) {
            this.workspaceBootConfig = this.session.config().loadBootConfig(switchWorkspaceLocation, false, true);
            if (this.workspaceBootConfig == null) {
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid workspace: %s", (Object[])new Object[]{switchWorkspaceLocation}));
            }
        }
        return this.workspaceBootConfig;
    }
}

