/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi;

import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class NameBuilder {
    private NutsId id;
    private NutsDescriptor descriptor;
    private String preferredName;
    private String defaultName;
    private NutsSession session;
    private boolean preferId;

    public NameBuilder(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session, boolean preferId) {
        this.id = id;
        this.preferredName = preferredName;
        this.descriptor = descriptor;
        this.session = session;
        this.preferId = preferId;
        if (defaultName == null) {
            defaultName = "";
        }
        if ((defaultName = defaultName.trim()).isEmpty()) {
            defaultName = preferId ? "%n%s%v%s%h" : "%N%s%v%s%h";
        }
        this.defaultName = defaultName;
    }

    public static NameBuilder id(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session) {
        return new NameBuilder(id, preferredName, defaultName, descriptor, session, true);
    }

    public static NameBuilder label(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session) {
        return new NameBuilder(id, preferredName, defaultName, descriptor, session, false);
    }

    public static String extractPathName(String s) {
        if (s == null) {
            return "";
        }
        int i = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        if (i >= 0) {
            return s.substring(i + 1).trim();
        }
        return s.trim();
    }

    private String toValidString(String s) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            for (char c : s.toCharArray()) {
                sb.append(this.toValidChar(c));
            }
        }
        return sb.toString();
    }

    private String toValidChar(char c) {
        if (c == ' ') {
            if (this.preferId) {
                return "-";
            }
            return " ";
        }
        if (Character.isWhitespace(c)) {
            return "_";
        }
        switch (c) {
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '/': 
            case ':': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': {
                return "-";
            }
        }
        return String.valueOf(c);
    }

    public String buildName() {
        int i;
        String s = this.preferredName;
        if (s != null && (i = Math.max(s.lastIndexOf(47), s.lastIndexOf(92))) >= 0) {
            String p = s.substring(0, i + 1);
            String n = s.substring(i + 1);
            return p + this.buildName(n);
        }
        return this.buildName(s);
    }

    private String buildName(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.trim()).isEmpty()) {
            s = this.defaultName;
        }
        BuildAccumulator h = new BuildAccumulator();
        char[] charArray = s.toCharArray();
        block9: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '%' && i + 1 < charArray.length) {
                char cc = charArray[++i];
                switch (cc) {
                    case 'v': {
                        h.append(this.id.getVersion().toString());
                        break;
                    }
                    case 'g': {
                        h.append(this.id.getGroupId());
                        break;
                    }
                    case 'n': {
                        h.append(this.id.getArtifactId());
                        break;
                    }
                    case 'N': {
                        String str = this.descriptor.getName();
                        if (str == null) {
                            str = "";
                        }
                        if ((str = str.trim()).isEmpty()) {
                            str = this.id.getArtifactId();
                        }
                        h.append(str);
                        break;
                    }
                    case 'h': {
                        if (NutsWorkspaceUtils.isUserDefaultWorkspace(this.session)) continue block9;
                        h.append(this.session.getWorkspace().getHashName());
                        break;
                    }
                    case 'a': {
                        h.appendValid(CoreStringUtils.joinAndTrimToNull(this.id.getCondition().getArch()));
                        break;
                    }
                    case 's': {
                        h.sep();
                        break;
                    }
                    default: {
                        h.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '%') continue;
            if (c == '/' || c == '\\') {
                h.append(c);
                continue;
            }
            h.appendValid(c);
        }
        if (h.isEmpty()) {
            h.appendValid(this.id.getArtifactId());
        }
        return h.toString();
    }

    class BuildAccumulator {
        StringBuilder sb = new StringBuilder();
        boolean wasSep = false;

        BuildAccumulator() {
        }

        boolean isEmpty() {
            return this.sb.length() == 0;
        }

        void sep() {
            this.wasSep = true;
        }

        void appendValid(char c) {
            this.append(NameBuilder.this.toValidChar(c));
        }

        void append(char c) {
            this.wasSep = false;
            this.sb.append(c);
        }

        void appendValid(String str) {
            this.append(NameBuilder.this.toValidString(str));
        }

        void append(String str) {
            if (str != null && !str.isEmpty()) {
                if (this.wasSep) {
                    this.sb.append(NameBuilder.this.toValidChar(' '));
                    this.wasSep = false;
                }
                this.sb.append(NameBuilder.this.toValidString(str));
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

