/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstallLogRecord;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsLogSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"set loglevel", "sll"}) != null) {
            if (cmdLine.next(new String[]{"verbose", "finest"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.FINEST, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"fine"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.FINE, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"finer"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.FINER, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"info"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.INFO, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"warning"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.WARNING, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"severe", "error"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.SEVERE, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"config"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.CONFIG, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"off"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.OFF, (NutsSession)session);
                }
            } else if (cmdLine.next(new String[]{"all"}) != null) {
                if (cmdLine.isExecMode()) {
                    NutsLogger.setTermLevel((Level)Level.ALL, (NutsSession)session);
                }
            } else if (cmdLine.isExecMode()) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid loglevel", (Object[])new Object[0]));
            }
            cmdLine.setCommandName("config log").unexpectedArgument();
            return true;
        }
        if (cmdLine.next(new String[]{"get loglevel"}) != null) {
            if (cmdLine.isExecMode()) {
                Logger rootLogger = Logger.getLogger("");
                session.out().printf("%s%n", new Object[]{rootLogger.getLevel().toString()});
            }
        } else if (cmdLine.next(new String[]{"install-log"}) != null) {
            if (cmdLine.isExecMode()) {
                if (session.isPlainOut()) {
                    for (NutsInstallLogRecord r : NutsWorkspaceExt.of(session).getInstalledRepository().findLog(session)) {
                        NutsTexts txt = NutsTexts.of((NutsSession)session);
                        session.out().printf("%s %s %s %s %s %s %s%n", new Object[]{r.getDate(), r.getUser(), r.getAction(), r.isSucceeded() ? txt.ofStyled("Succeeded", NutsTextStyle.success()) : txt.ofStyled("Failed", NutsTextStyle.fail()), r.getId() == null ? "" : r.getId(), r.getForId() == null ? "" : r.getForId(), NutsUtilStrings.trim((String)r.getMessage())});
                    }
                } else {
                    session.out().printlnf((Object)NutsWorkspaceExt.of(session).getInstalledRepository().findLog(session).toList());
                }
            }
            return true;
        }
        return false;
    }
}

