/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPlatformManager;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsJavaSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (autoSave == null) {
            autoSave = false;
        }
        NutsPrintStream out = session.out();
        NutsWorkspaceConfigManager conf = session.config();
        NutsPlatformManager platforms = session.env().platforms();
        if (cmdLine.next(new String[]{"add java"}) != null) {
            if (cmdLine.next(new String[]{"--search"}) != null) {
                ArrayList<String> extraLocations = new ArrayList<String>();
                while (cmdLine.hasNext()) {
                    extraLocations.add(cmdLine.next().getString());
                }
                if (extraLocations.isEmpty()) {
                    for (NutsPlatformLocation loc : platforms.searchSystemPlatforms(NutsPlatformFamily.JAVA)) {
                        platforms.addPlatform(loc);
                    }
                } else {
                    for (String extraLocation : extraLocations) {
                        for (NutsPlatformLocation loc : platforms.searchSystemPlatforms(NutsPlatformFamily.JAVA, extraLocation)) {
                            platforms.addPlatform(loc);
                        }
                    }
                }
                cmdLine.setCommandName("config java").unexpectedArgument();
                if (autoSave.booleanValue()) {
                    conf.save(false);
                }
            } else {
                while (cmdLine.hasNext()) {
                    NutsPlatformLocation loc = platforms.resolvePlatform(NutsPlatformFamily.JAVA, cmdLine.next().getString(), null);
                    if (loc == null) continue;
                    platforms.addPlatform(loc);
                }
                if (autoSave.booleanValue()) {
                    conf.save(false);
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"remove java"}) != null) {
            while (cmdLine.hasNext()) {
                String name = cmdLine.next().getString();
                NutsPlatformLocation loc = platforms.findPlatformByName(NutsPlatformFamily.JAVA, name);
                if (loc == null && (loc = platforms.findPlatformByPath(NutsPlatformFamily.JAVA, name)) == null) {
                    loc = platforms.findPlatformByVersion(NutsPlatformFamily.JAVA, name);
                }
                if (loc == null) continue;
                platforms.removePlatform(loc);
            }
            if (autoSave.booleanValue()) {
                conf.save(false);
            }
            return true;
        }
        if (cmdLine.next(new String[]{"list java"}) != null) {
            NutsTableFormat t = NutsTableFormat.of((NutsSession)session).setVisibleHeader(true);
            NutsMutableTableModel m = NutsMutableTableModel.of((NutsSession)session);
            t.setValue((Object)m);
            m.addHeaderCells(new Object[]{"Name", "Version", "Path"});
            while (cmdLine.hasNext()) {
                if (t.configureFirst(cmdLine)) continue;
                cmdLine.setCommandName("config list java").unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                NutsPlatformLocation[] sdks = platforms.findPlatforms(NutsPlatformFamily.JAVA, null);
                Arrays.sort(sdks, new Comparator<NutsPlatformLocation>(){

                    @Override
                    public int compare(NutsPlatformLocation o1, NutsPlatformLocation o2) {
                        int x = o1.getName().compareTo(o2.getName());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getVersion().compareTo(o2.getVersion());
                        if (x != 0) {
                            return x;
                        }
                        x = o1.getPath().compareTo(o2.getPath());
                        if (x != 0) {
                            return x;
                        }
                        return x;
                    }
                });
                for (NutsPlatformLocation jloc : sdks) {
                    m.addRow(new Object[]{jloc.getName(), jloc.getVersion(), jloc.getPath()});
                }
                out.print(t.format());
            }
            return true;
        }
        return false;
    }
}

