/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.imports;

import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsImportSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"list imports", "li"}) != null) {
            cmdLine.setCommandName("config list imports").unexpectedArgument();
            if (cmdLine.isExecMode()) {
                for (String imp : session.imports().getAllImports()) {
                    session.out().printf("%s%n", new Object[]{imp});
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"clear imports", "ci"}) != null) {
            cmdLine.setCommandName("config clear imports").unexpectedArgument();
            if (cmdLine.isExecMode()) {
                session.imports().clearImports();
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"import", "ia"}) != null) {
            do {
                String a = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"import", (NutsSession)session)).getString();
                if (!cmdLine.isExecMode()) continue;
                session.imports().addImports(new String[]{a});
            } while (cmdLine.hasNext());
            if (cmdLine.isExecMode()) {
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"unimport", "ir"}) != null) {
            while (cmdLine.hasNext()) {
                String ii = cmdLine.required().nextNonOption(NutsArgumentName.of((String)"import", (NutsSession)session)).getString();
                if (!cmdLine.isExecMode()) continue;
                session.imports().removeImports(new String[]{ii});
            }
            if (cmdLine.isExecMode()) {
                session.config().save();
            }
            return true;
        }
        return false;
    }
}

