/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.delete;

import java.util.HashSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsDeleteFoldersSubCommand
extends AbstractNutsSettingsSubCommand {
    private static void deleteRepoCache(NutsRepository repository, NutsSession session, boolean force) {
        NutsPath s = repository.config().getStoreLocation(NutsStoreLocation.CACHE);
        if (s != null && s.exists()) {
            session.out().printf("```error deleting``` %s folder %s ...%n", new Object[]{NutsTexts.of((NutsSession)session).ofStyled("cache", NutsTextStyle.primary1()), s});
            if (force || session.getTerminal().ask().resetLine().forBoolean("force delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                s.delete();
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository mirror : repository.config().getMirrors()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(mirror, session, force);
            }
        }
    }

    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        for (NutsStoreLocation value : NutsStoreLocation.values()) {
            String cmdName = "delete " + value.id();
            cmdLine.setCommandName("settings " + cmdName);
            if (cmdLine.next(new String[]{cmdName}) == null) continue;
            boolean force = false;
            HashSet<NutsStoreLocation> locationsToDelete = new HashSet<NutsStoreLocation>();
            locationsToDelete.add(value);
            while (cmdLine.hasNext()) {
                NutsArgument a = cmdLine.nextBoolean(new String[]{"-y", "--yes"});
                if (a != null) {
                    force = a.getBooleanValue();
                    continue;
                }
                if (!cmdLine.peek().isOption()) {
                    String s = cmdLine.peek().toString();
                    try {
                        locationsToDelete.add(NutsStoreLocation.valueOf((String)s.toUpperCase()));
                    }
                    catch (Exception ex) {
                        cmdLine.unexpectedArgument();
                    }
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                for (NutsStoreLocation folder : locationsToDelete) {
                    this.deleteWorkspaceFolder(session, folder, force);
                }
            }
            return true;
        }
        return false;
    }

    private void deleteWorkspaceFolder(NutsSession session, NutsStoreLocation folder, boolean force) {
        NutsPath sstoreLocation = session.locations().getStoreLocation(folder);
        if (sstoreLocation != null) {
            NutsTexts factory = NutsTexts.of((NutsSession)session);
            if (sstoreLocation.exists()) {
                session.out().printf("```error deleting``` %s for workspace %s folder %s ...%n", new Object[]{factory.ofStyled(folder.id(), NutsTextStyle.primary1()), factory.ofStyled(session.getWorkspace().getName(), NutsTextStyle.primary1()), factory.ofStyled(sstoreLocation.toString(), NutsTextStyle.path())});
                if (force || session.getTerminal().ask().resetLine().forBoolean("force delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                    sstoreLocation.delete();
                }
            }
        }
        for (NutsRepository repository : session.repos().getRepositories()) {
            this.deleteRepoFolder(repository, session, folder, force);
        }
    }

    private void deleteRepoFolder(NutsRepository repository, NutsSession session, NutsStoreLocation folder, boolean force) {
        NutsPath sstoreLocation = session.locations().getStoreLocation(folder);
        if (sstoreLocation != null) {
            NutsTexts factory = NutsTexts.of((NutsSession)session);
            if (sstoreLocation.exists()) {
                session.out().printf("```error deleting``` %s for repository %s folder %s ...%n", new Object[]{factory.ofStyled(folder.id(), NutsTextStyle.primary1()), factory.ofStyled(repository.getName(), NutsTextStyle.primary1()), factory.ofStyled(sstoreLocation.toString(), NutsTextStyle.path())});
                if (force || session.getTerminal().ask().resetLine().forBoolean("Force Delete?", new Object[0]).setDefaultValue((Object)false).setSession(session).getBooleanValue().booleanValue()) {
                    sstoreLocation.delete();
                }
            }
        }
        if (repository.config().isSupportedMirroring()) {
            for (NutsRepository subRepository : repository.config().getMirrors()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(subRepository, session, force);
            }
        }
    }

    private void deleteCache(NutsSession session, boolean force) {
        NutsPath sstoreLocation = session.locations().getStoreLocation(NutsStoreLocation.CACHE);
        if (sstoreLocation != null) {
            if (sstoreLocation.exists()) {
                sstoreLocation.delete();
            }
            for (NutsRepository repository : session.repos().getRepositories()) {
                NutsSettingsDeleteFoldersSubCommand.deleteRepoCache(repository, session, force);
            }
        }
    }
}

