/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.connect;

import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsScheduler;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.NutsSysExecUtils;
import net.thevpc.nuts.runtime.standalone.executor.system.PipeRunnable;
import net.thevpc.nuts.runtime.standalone.io.util.NonBlockingInputStreamAdapter;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsConnectSubCommand
extends AbstractNutsSettingsSubCommand {
    public static final int DEFAULT_ADMIN_SERVER_PORT = 8898;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(NutsCommandLine commandLine, Boolean autoSave, NutsSession session) {
        String cmd0 = commandLine.toString();
        if (commandLine.next(new String[]{"connect"}) != null) {
            char[] password = null;
            String server = null;
            while (commandLine.hasNext()) {
                NutsArgument a = commandLine.nextString(new String[]{"--password"});
                if (a != null) {
                    password = a.getValue().getString("").toCharArray();
                    continue;
                }
                if (commandLine.peek().isOption()) {
                    session.configureLast(commandLine);
                    continue;
                }
                server = commandLine.nextRequiredNonOption(NutsArgumentName.of((String)"ServerAddress", (NutsSession)session)).getString();
                commandLine.setCommandName("settings connect").unexpectedArgument();
            }
            if (!commandLine.isExecMode()) {
                return true;
            }
            String login = null;
            int port = -1;
            if (server == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing address", (Object[])new Object[0]));
            }
            if (server.contains("@")) {
                login = server.substring(0, server.indexOf("@"));
                server = server.substring(server.indexOf("@") + 1);
            }
            if (server.contains(":")) {
                port = CoreNumberUtils.convertToInteger(server.substring(server.indexOf(":") + 1), -1);
                server = server.substring(0, server.indexOf(":"));
            }
            if (!NutsBlankable.isBlank(login) && NutsBlankable.isBlank((char[])password)) {
                password = session.getTerminal().readPassword("Password:", new Object[0]);
            }
            Socket socket = null;
            try {
                try {
                    String line;
                    int validPort = port <= 0 ? 8898 : port;
                    socket = new Socket(InetAddress.getByName(server), validPort);
                    PipeRunnable rr = NutsSysExecUtils.pipe("pipe-out-socket-" + server + ":" + validPort, cmd0, "connect-socket", new NonBlockingInputStreamAdapter("pipe-out-socket-" + server + ":" + validPort, socket.getInputStream()), session.out().asPrintStream(), session);
                    NutsScheduler.of((NutsSession)session).executorService().submit(rr);
                    PrintStream out = new PrintStream(socket.getOutputStream());
                    if (!NutsBlankable.isBlank((String)login)) {
                        out.printf("connect ==%s %s== %n", login, new String(password));
                    }
                    while ((line = session.getTerminal().readLine("", new Object[0])) != null) {
                        if (line.trim().length() <= 0) continue;
                        if (line.trim().equals("quit")) break;
                        if (line.trim().equals("exit")) {
                            break;
                        }
                        out.printf("%s%n", line);
                    }
                }
                finally {
                    if (socket != null) {
                        socket.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new NutsExecutionException(session, NutsMessage.plain((String)"settings connect failed"), (Throwable)ex, 2);
            }
            return true;
        }
        return false;
    }
}

