/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.backup;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCompress;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUncompress;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsBackupSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine commandLine, Boolean autoSave, NutsSession session) {
        if (commandLine.next(new String[]{"backup"}) != null) {
            commandLine.setCommandName("settings backup");
            String file = null;
            while (commandLine.hasNext()) {
                NutsArgument a = commandLine.nextString(new String[]{"--file", "-f"});
                if (a != null) {
                    file = a.getValue().getString("");
                    continue;
                }
                if (commandLine.peek().isNonOption()) {
                    file = commandLine.nextString(new String[0]).getValue().getString("");
                    continue;
                }
                session.configureLast(commandLine);
            }
            if (commandLine.isExecMode()) {
                ArrayList<String> all = new ArrayList<String>();
                all.add(session.locations().getWorkspaceLocation().toFile().resolve("nuts-workspace.json").toString());
                for (NutsStoreLocation value : NutsStoreLocation.values()) {
                    NutsPath r = session.locations().getStoreLocation(value);
                    if (!r.isDirectory()) continue;
                    all.add(r.toString());
                }
                if (file == null || file.isEmpty()) {
                    file = session.getWorkspace().getName() + ".zip";
                } else if (file.endsWith("/") || file.endsWith("\\")) {
                    file = file + session.getWorkspace().getName() + ".zip";
                } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                    file = file + File.separator + session.getWorkspace().getName() + ".zip";
                }
                if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0) {
                    file = file + ".zip";
                }
                NutsCompress cmp = NutsCompress.of((NutsSession)session);
                for (String s : all) {
                    cmp.addSource(s);
                }
                cmp.to(file).run();
            }
            return true;
        }
        if (commandLine.next(new String[]{"restore"}) != null) {
            commandLine.setCommandName("settings restore");
            String file = null;
            String ws = null;
            while (commandLine.hasNext()) {
                NutsArgument a = commandLine.nextString(new String[]{"--file", "-f"});
                if (a != null) {
                    file = a.getValue().getString("");
                    continue;
                }
                a = commandLine.nextString(new String[]{"--workspace", "-w"});
                if (a != null) {
                    ws = a.getValue().getString("");
                    continue;
                }
                if (commandLine.peek().isNonOption()) {
                    file = commandLine.nextString(new String[0]).getValue().getString("");
                    continue;
                }
                session.configureLast(commandLine);
            }
            if (file == null || file.isEmpty()) {
                file = session.getWorkspace().getName() + ".zip";
            } else if (file.endsWith("/") || file.endsWith("\\")) {
                file = file + session.getWorkspace().getName() + ".zip";
            } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + File.separator + session.getWorkspace().getName() + ".zip";
            }
            if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0 && !Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + ".zip";
            }
            if (!Files.isRegularFile(Paths.get(file, new String[0]), new LinkOption[0])) {
                commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
            }
            if (commandLine.isExecMode()) {
                final NutsObjectElement[] nutsWorkspaceConfigRef = new NutsObjectElement[1];
                final NutsElements elem = NutsElements.of((NutsSession)session);
                NutsUncompress.of((NutsSession)session).from(file).visit(new NutsIOUncompressVisitor(){

                    public boolean visitFolder(String path) {
                        return true;
                    }

                    public boolean visitFile(String path, InputStream inputStream) {
                        if ("/nuts-workspace.json".equals(path)) {
                            NutsObjectElement e;
                            nutsWorkspaceConfigRef[0] = e = ((NutsObjectElement)elem.json().parse(inputStream, NutsObjectElement.class)).asObject();
                            return false;
                        }
                        return true;
                    }
                });
                if (nutsWorkspaceConfigRef[0] == null) {
                    commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
                }
                if (ws == null || ws.isEmpty()) {
                    NutsElements prv = elem.setSession(session);
                    ws = nutsWorkspaceConfigRef[0].get((NutsElement)prv.ofString("name")).asString();
                }
                if (ws == null || ws.isEmpty()) {
                    commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
                }
                String platformHomeFolder = NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)session.config().stored().isGlobal(), (String)ws);
                NutsUncompress.of((NutsSession)session).from(file).to(platformHomeFolder).setSkipRoot(true).run();
                if (session.isPlainTrace()) {
                    session.out().printf("restore %s to %s %n", new Object[]{file, platformHomeFolder});
                }
            }
            return true;
        }
        return false;
    }
}

