/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.AbstractNutsSettingsSubCommand;

public class NutsSettingsAliasSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"list aliases"}) != null) {
            cmdLine.setCommandName("settings list aliases");
            final ArrayList<String> toList = new ArrayList<String>();
            while (cmdLine.hasNext()) {
                if (!cmdLine.peek().isOption()) {
                    NutsArgument a = cmdLine.next();
                    toList.add(a.toString());
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                List r = session.commands().findAllCommands().stream().filter(new Predicate<NutsWorkspaceCustomCommand>(){

                    @Override
                    public boolean test(NutsWorkspaceCustomCommand nutsWorkspaceCommandAlias) {
                        if (toList.isEmpty()) {
                            return true;
                        }
                        for (String s : toList) {
                            if (!(s.contains("*") ? Pattern.compile(s.replace("*", ".*")).matcher(nutsWorkspaceCommandAlias.getName()).matches() : s.equals(nutsWorkspaceCommandAlias.getName()))) continue;
                            return true;
                        }
                        return false;
                    }
                }).sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList());
                if (session.isPlainOut()) {
                    NutsPropertiesFormat.of((NutsSession)session).setValue((Object)r.stream().collect(Collectors.toMap(NutsWorkspaceCustomCommand::getName, x -> NutsCommandLine.of((String[])x.getCommand(), (NutsSession)session).toString(), (x, y) -> {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"duplicate %s", (Object[])new Object[]{x}));
                    }, LinkedHashMap::new))).println();
                } else {
                    session.out().printlnf(r.stream().map(x -> new AliasInfo((NutsWorkspaceCustomCommand)x, session)).collect(Collectors.toList()));
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"remove alias"}) != null) {
            if (cmdLine.isExecMode()) {
                while (cmdLine.hasNext()) {
                    session.commands().removeCommand(cmdLine.next().toString());
                }
                session.config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"add alias"}) != null) {
            if (cmdLine.isExecMode()) {
                String n = null;
                LinkedHashMap<String, AliasInfo> toAdd = new LinkedHashMap<String, AliasInfo>();
                while (cmdLine.hasNext()) {
                    if (!cmdLine.peek().isOption()) {
                        NutsArgument a = cmdLine.next();
                        if (a.isKeyValue()) {
                            if (n != null) {
                                cmdLine.pushBack(a);
                                cmdLine.unexpectedArgument();
                            }
                            toAdd.put(a.getKey().getString(), new AliasInfo(a.getKey().getString(), a.getValue().getString(), null, null, null));
                            continue;
                        }
                        if (n == null) {
                            n = a.toString();
                            continue;
                        }
                        toAdd.put(n, new AliasInfo(n, a.toString(), null, null, null));
                        n = null;
                        continue;
                    }
                    cmdLine.unexpectedArgument();
                }
                if (toAdd.isEmpty()) {
                    cmdLine.required();
                }
                for (AliasInfo value : toAdd.values()) {
                    session.commands().addCommand(new NutsCommandConfig().setCommand(NutsCommandLine.of((String)value.command, (NutsSession)session).toStringArray()).setName(value.name).setExecutorOptions(NutsCommandLine.of((String)value.executionOptions, (NutsSession)session).toStringArray()));
                }
                session.config().save();
            }
            return true;
        }
        return false;
    }

    public static class AliasInfo {
        public String name;
        public String command;
        public String factoryId;
        public NutsId owner;
        public String executionOptions;

        public AliasInfo(String name, String command, String factoryId, NutsId owner, String executionOptions) {
            this.name = name;
            this.command = command;
            this.factoryId = factoryId;
            this.owner = owner;
            this.executionOptions = executionOptions;
        }

        public AliasInfo(NutsWorkspaceCustomCommand a, NutsSession ws) {
            this.name = a.getName();
            this.command = NutsCommandLine.of((String[])a.getCommand(), (NutsSession)ws).toString();
            this.executionOptions = NutsCommandLine.of((String[])a.getExecutorOptions(), (NutsSession)ws).toString();
            this.factoryId = a.getFactoryId();
            this.owner = a.getOwner();
        }

        public String getName() {
            return this.name;
        }

        public String getCommand() {
            return this.command;
        }

        public String getFactoryId() {
            return this.factoryId;
        }

        public NutsId getOwner() {
            return this.owner;
        }

        public String getExecutionOptions() {
            return this.executionOptions;
        }
    }
}

