/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandExecOptions;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreArrayUtils;

public class DefaultNutsWorkspaceCustomCommand
implements NutsWorkspaceCustomCommand {
    private NutsLogger LOG;
    private String name;
    private NutsId owner;
    private String factoryId;
    private String[] command;
    private String[] helpCommand;
    private String helpText;
    private String[] executorOptions;
    private NutsWorkspace ws;

    public DefaultNutsWorkspaceCustomCommand(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsWorkspaceCustomCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public NutsId getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public DefaultNutsWorkspaceCustomCommand setName(String name) {
        this.name = name;
        return this;
    }

    public void exec(String[] args, NutsCommandExecOptions options, NutsSession session) {
        String[] executorOptions = options.getExecutorOptions();
        executorOptions = CoreArrayUtils.concatArrays(this.getExecutorOptions(), executorOptions);
        ArrayList<String> r = new ArrayList<String>(Arrays.asList(this.getCommand()));
        r.addAll(Arrays.asList(args));
        args = r.toArray(new String[0]);
        session.exec().addCommand(args).addExecutorOptions(executorOptions).setDirectory(options.getDirectory()).setFailFast(true).setSession(session).setEnv(options.getEnv()).setExecutionType(options.getExecutionType()).setFailFast(true).run();
    }

    public void dryExec(String[] args, NutsCommandExecOptions options, NutsSession session) throws NutsExecutionException {
        String[] executorOptions = options.getExecutorOptions();
        executorOptions = CoreArrayUtils.concatArrays(this.getExecutorOptions(), executorOptions);
        ArrayList<String> r = new ArrayList<String>(Arrays.asList(this.getCommand()));
        r.addAll(Arrays.asList(args));
        args = r.toArray(new String[0]);
        session.exec().addCommand(args).addExecutorOptions(executorOptions).setDirectory(options.getDirectory()).setFailFast(true).setSession(session).setEnv(options.getEnv()).setExecutionType(options.getExecutionType()).setFailFast(true).run();
    }

    public String getHelpText(NutsSession session) throws NutsExecutionException {
        if (!NutsBlankable.isBlank((String)this.helpText)) {
            return this.helpText;
        }
        if (this.helpCommand != null && this.helpCommand.length > 0) {
            try {
                return session.exec().addCommand(this.helpCommand).setFailFast(false).setRedirectErrorStream(true).grabOutputString().run().getOutputString();
            }
            catch (Exception ex) {
                this._LOGOP(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to retrieve help for {0}", (Object[])new Object[]{this.getName()}));
                return "failed to retrieve help for " + this.getName();
            }
        }
        return null;
    }

    public String[] getCommand() {
        return this.command == null ? new String[]{} : Arrays.copyOf(this.command, this.command.length);
    }

    public DefaultNutsWorkspaceCustomCommand setCommand(String[] command) {
        this.command = command;
        return this;
    }

    public String[] getExecutorOptions() {
        return this.executorOptions == null ? new String[]{} : Arrays.copyOf(this.executorOptions, this.command.length);
    }

    public DefaultNutsWorkspaceCustomCommand setExecutorOptions(String[] executorOptions) {
        this.executorOptions = executorOptions;
        return this;
    }

    public NutsCommandConfig toCommandConfig() {
        return new NutsCommandConfig().setCommand(this.getCommand()).setFactoryId(this.getFactoryId()).setOwner(this.getOwner()).setExecutorOptions(this.getExecutorOptions()).setName(this.getName()).setHelpCommand(this.helpCommand).setHelpText(this.helpText);
    }

    public DefaultNutsWorkspaceCustomCommand setOwner(NutsId owner) {
        this.owner = owner;
        return this;
    }

    public DefaultNutsWorkspaceCustomCommand setFactoryId(String factoryId) {
        this.factoryId = factoryId;
        return this;
    }

    public DefaultNutsWorkspaceCustomCommand setHelpCommand(String[] helpCommand) {
        this.helpCommand = helpCommand;
        return this;
    }

    public DefaultNutsWorkspaceCustomCommand setHelpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public void setWs(NutsWorkspace ws) {
        this.ws = ws;
    }

    public String toString() {
        return "DefaultNutsWorkspaceCommand{name=" + this.name + ", owner=" + this.owner + ", factoryId=" + this.factoryId + ", command=" + Arrays.toString(this.command) + ", executorOptions=" + Arrays.toString(this.executorOptions) + '}';
    }
}

