/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;

public class ConfigNutsWorkspaceCommandFactory
implements NutsWorkspaceCommandFactory {
    private NutsLogger LOG;
    private NutsWorkspace ws;

    public ConfigNutsWorkspaceCommandFactory(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(ConfigNutsWorkspaceCommandFactory.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public void configure(NutsCommandFactoryConfig config) {
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getFactoryId() {
        return "default";
    }

    public NutsCommandConfig findCommand(String name, NutsSession session) {
        NutsCommandConfig c;
        this.checkSession(session);
        NutsPath file = this.getCommandsFolder(session).resolve(name + ".nuts-cmd.json");
        if (file.exists() && (c = (NutsCommandConfig)NutsElements.of((NutsSession)session).json().parse(file, NutsCommandConfig.class)) != null) {
            c.setName(name);
            return c;
        }
        return null;
    }

    public List<NutsCommandConfig> findCommands(NutsSession session) {
        return this.findCommands((Predicate<NutsCommandConfig>)null, session);
    }

    public NutsPath getStoreLocation(NutsSession session) {
        this.checkSession(session);
        return session.locations().getStoreLocation(session.getWorkspace().getApiId(), NutsStoreLocation.APPS);
    }

    private NutsPath getCommandsFolder(NutsSession session) {
        this.checkSession(session);
        return this.getStoreLocation(session).resolve("cmd");
    }

    public void uninstallCommand(String name, NutsSession session) {
        this.checkSession(session);
        NutsPath file = this.getCommandsFolder(session).resolve(name + ".nuts-cmd.json");
        if (file.exists()) {
            file.delete();
            NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
        }
    }

    protected void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
    }

    public void installCommand(NutsCommandConfig command, NutsSession session) {
        this.checkSession(session);
        NutsPath path = this.getCommandsFolder(session).resolve(command.getName() + ".nuts-cmd.json");
        NutsElements.of((NutsSession)session).json().setValue((Object)command).setNtf(false).print(path);
        NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
    }

    public List<NutsCommandConfig> findCommands(NutsId id, NutsSession session) {
        return this.findCommands((NutsCommandConfig value) -> CoreFilterUtils.matchesSimpleNameStaticVersion(value.getOwner(), id), session);
    }

    public List<NutsCommandConfig> findCommands(Predicate<NutsCommandConfig> filter, NutsSession session) {
        this.checkSession(session);
        ArrayList<NutsCommandConfig> all = new ArrayList<NutsCommandConfig>();
        NutsPath storeLocation = this.getCommandsFolder(session);
        if (!storeLocation.isDirectory()) {
            return all;
        }
        storeLocation.list().forEach(file -> {
            String fileName = file.getName();
            if (file.getName().endsWith(".nuts-cmd.json")) {
                NutsCommandConfig c = null;
                try {
                    c = (NutsCommandConfig)NutsElements.of((NutsSession)session).json().parse(file, NutsCommandConfig.class);
                }
                catch (Exception ex) {
                    this._LOGOP(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to parse {0}", (Object[])new Object[]{file}));
                }
                if (c != null) {
                    c.setName(fileName.substring(0, fileName.length() - ".nuts-cmd.json".length()));
                    if (filter == null || filter.test(c)) {
                        all.add(c);
                    }
                }
            }
        });
        return all;
    }
}

