/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceCommandFactory;

public class CommandNutsWorkspaceCommandFactory
implements NutsWorkspaceCommandFactory {
    private int priority = 10;
    private String factoryId;
    private String[] findCommand;
    private String[] execCommand;
    private String[] listCommand;
    private NutsSession ws;

    public CommandNutsWorkspaceCommandFactory(NutsSession ws) {
        this.ws = ws;
    }

    public void configure(NutsCommandFactoryConfig config) {
        Map p;
        this.factoryId = config.getFactoryId();
        this.factoryId = "command";
        this.priority = config.getPriority();
        if (this.priority <= 0) {
            this.priority = 1;
        }
        if ((p = config.getParameters()) != null) {
            this.findCommand = this.validateCommand((String)p.get("find"));
            this.execCommand = this.validateCommand((String)p.get("exec"));
            String slistCommand = (String)p.get("list");
            String[] stringArray = this.listCommand = slistCommand == null ? new String[]{} : NutsCommandLine.of((String)slistCommand, (NutsSession)this.ws).toStringArray();
            if (this.listCommand.length > 0 && !this.listCommand[0].contains(":")) {
                this.listCommand = new String[0];
            }
        }
    }

    private String[] replaceParam(String[] command, String name) {
        String[] command2 = Arrays.copyOf(command, command.length);
        for (int i = 0; i < command2.length; ++i) {
            if (!command2[i].equals("%n")) continue;
            command2[i] = name;
        }
        return command2;
    }

    private String[] validateCommand(String command) {
        if (command == null) {
            return new String[0];
        }
        String[] commandArr = NutsCommandLine.of((String)command, (NutsSession)this.ws).toStringArray();
        if (commandArr.length == 0) {
            return commandArr;
        }
        boolean found = false;
        for (String s : commandArr) {
            if (!s.equals("%n")) continue;
            found = true;
            break;
        }
        if (!found) {
            commandArr = Arrays.copyOf(commandArr, commandArr.length + 1);
            commandArr[commandArr.length - 1] = "%n";
        }
        if (commandArr.length > 0 && !commandArr[0].contains(":")) {
            commandArr = new String[]{};
        }
        return commandArr;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public NutsCommandConfig findCommand(String name, NutsSession session) {
        if (this.findCommand.length > 0 && this.execCommand.length > 0) {
            String[] fc = this.replaceParam(this.findCommand, name);
            String[] ec = this.replaceParam(this.execCommand, name);
            NutsExecCommand exec = session.exec().addCommand(fc).setSession(session).setRedirectErrorStream(true).grabOutputString().run();
            int r = exec.getResult();
            if (r == 0) {
                return new NutsCommandConfig().setFactoryId(this.getFactoryId()).setOwner(NutsId.of((String)ec[0], (NutsSession)session)).setName(name).setCommand(Arrays.copyOfRange(ec, 1, ec.length));
            }
        }
        return null;
    }

    public List<NutsCommandConfig> findCommands(NutsSession session) {
        NutsExecCommand b;
        int r;
        ArrayList<NutsCommandConfig> c = new ArrayList<NutsCommandConfig>();
        if (this.listCommand.length > 0 && (r = (b = session.exec().addCommand(this.listCommand).setSession(session).setRedirectErrorStream(true).grabOutputString()).getResult()) == 0) {
            for (String s : b.getOutputString().split("\n")) {
                if ((s = s.trim()).length() <= 0) continue;
                c.add(new NutsCommandConfig().setName(s).setCommand(new String[]{"nsh", s}));
            }
        }
        return c;
    }
}

