/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilters;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsFilters;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterOr;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsPatternIdFilter;
import net.thevpc.nuts.runtime.standalone.io.util.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsInstallStatuses;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsRepositoryAndFetchMode;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.DefaultNutsFetchCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.AbstractNutsSearchCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNutsSearch;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsSearchCommand
extends AbstractNutsSearchCommand {
    public DefaultNutsSearchCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsSearchCommand copy() {
        DefaultNutsSearchCommand b = new DefaultNutsSearchCommand(this.ws);
        b.copyFrom(this);
        return b;
    }

    public NutsFetchCommand toFetch() {
        this.checkSession();
        NutsFetchCommand t = ((NutsFetchCommand)new DefaultNutsFetchCommand(this.ws).copyFromDefaultNutsQueryBaseOptions(this)).setSession(this.getSession());
        if (this.getDisplayOptions().isRequireDefinition()) {
            t.setContent(true);
        }
        DefaultNutsSearch bs = this.build();
        t.setRepositoryFilter(bs.getRepositoryFilter());
        return t;
    }

    private NutsRepositoryFilter createRepositoryFilter(NutsInstallStatusFilter status, NutsIdFilter _idFilter, NutsSession session) {
        boolean searchInInstalled = true;
        boolean searchInOtherRepositories = true;
        if (status != null && Arrays.stream(NutsInstallStatuses.ALL_DEPLOYED).noneMatch(x -> status.acceptInstallStatus(x, session))) {
            searchInInstalled = false;
        }
        if (status != null && Arrays.stream(NutsInstallStatuses.ALL_UNDEPLOYED).noneMatch(x -> status.acceptInstallStatus(x, session))) {
            searchInOtherRepositories = false;
        }
        ArrayList<Object> otherFilters = new ArrayList<Object>();
        if (_idFilter != null && _idFilter.getFilterOp() == NutsFilterOp.AND) {
            searchInOtherRepositories = true;
            for (NutsFilter subFilter : _idFilter.getSubFilters()) {
                if (subFilter instanceof NutsInstallStatusIdFilter) {
                    NutsInstallStatusFilter status2 = ((NutsInstallStatusIdFilter)subFilter).getInstallStatus();
                    if (searchInInstalled && status != null && Arrays.stream(NutsInstallStatuses.ALL_DEPLOYED).noneMatch(x -> status2.acceptInstallStatus(x, session))) {
                        searchInInstalled = false;
                    }
                    if (searchInOtherRepositories && status != null && Arrays.stream(NutsInstallStatuses.ALL_UNDEPLOYED).noneMatch(x -> status2.acceptInstallStatus(x, session))) {
                        searchInOtherRepositories = false;
                    }
                }
                if (!(subFilter instanceof NutsRepositoryFilter)) continue;
                otherFilters.add((NutsRepositoryFilter)subFilter);
            }
        }
        NutsRepositoryFilters repository = NutsRepositoryFilters.of((NutsSession)session);
        if (!searchInInstalled && searchInOtherRepositories) {
            otherFilters.add(repository.installedRepo().neg());
        } else if (searchInInstalled && !searchInOtherRepositories) {
            otherFilters.add(repository.installedRepo());
        } else if (!searchInInstalled && !searchInOtherRepositories) {
            otherFilters.add(repository.never());
        }
        if (otherFilters.isEmpty()) {
            return null;
        }
        NutsRepositoryFilter r = (NutsRepositoryFilter)otherFilters.get(0);
        for (int i = 1; i < otherFilters.size(); ++i) {
            r = r.and((NutsRepositoryFilter)otherFilters.get(i));
        }
        return r;
    }

    private DefaultNutsSearch build() {
        NutsRepositoryFilter extraRepositoryFilter;
        NutsPatternIdFilter f;
        this.checkSession();
        NutsSession session = this.getSession();
        HashSet<String> someIds = new HashSet<String>();
        for (NutsId id : this.getIds()) {
            someIds.add(id.toString());
        }
        if (this.getIds().length == 0 && this.isCompanion()) {
            someIds.addAll(this.session.extensions().getCompanionIds().stream().map(NutsId::getShortName).collect(Collectors.toList()));
        }
        if (this.getIds().length == 0 && this.isRuntime()) {
            someIds.add("net.thevpc.nuts:nuts-runtime");
        }
        HashSet<String> goodIds = new HashSet<String>();
        HashSet<String> wildcardIds = new HashSet<String>();
        for (String someId : someIds) {
            if (NutsPatternIdFilter.containsWildcad(someId)) {
                wildcardIds.add(someId);
                continue;
            }
            goodIds.add(someId);
        }
        Object idFilter0 = this.getIdFilter();
        if (idFilter0 instanceof NutsPatternIdFilter && !(f = (NutsPatternIdFilter)idFilter0).isWildcard()) {
            goodIds.add(f.getId().toString());
            idFilter0 = null;
        }
        if (idFilter0 instanceof NutsIdFilterOr) {
            ArrayList<NutsIdFilter> oo = new ArrayList<NutsIdFilter>(Arrays.asList(((NutsIdFilterOr)idFilter0).getChildren()));
            boolean someChange = false;
            Iterator it = oo.iterator();
            while (it.hasNext()) {
                NutsPatternIdFilter f2;
                NutsIdFilter curr = (NutsIdFilter)it.next();
                if (!(curr instanceof NutsPatternIdFilter) || (f2 = (NutsPatternIdFilter)curr).isWildcard()) continue;
                goodIds.add(f2.getId().toString());
                it.remove();
                someChange = true;
            }
            if (someChange) {
                idFilter0 = oo.isEmpty() ? null : (NutsIdFilter)NutsIdFilters.of((NutsSession)this.session).any((NutsFilter[])oo.toArray(new NutsIdFilter[0]));
            }
        }
        NutsDescriptorFilters dfilter = NutsDescriptorFilters.of((NutsSession)session);
        NutsDescriptorFilter _descriptorFilter = (NutsDescriptorFilter)dfilter.always();
        NutsIdFilter _idFilter = (NutsIdFilter)NutsIdFilters.of((NutsSession)this.session).always();
        NutsDependencyFilter depFilter = (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)session).always();
        NutsRepositoryFilter rfilter = (NutsRepositoryFilter)this.session.repos().filter().always();
        for (String j : this.getScripts()) {
            if (NutsBlankable.isBlank((String)j)) continue;
            if (CoreStringUtils.containsTopWord(j, "descriptor")) {
                _descriptorFilter = _descriptorFilter.and((NutsDescriptorFilter)dfilter.parse(j));
                continue;
            }
            if (CoreStringUtils.containsTopWord(j, "dependency")) {
                depFilter = depFilter.and((NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)session).parse(j));
                continue;
            }
            _idFilter = _idFilter.and((NutsIdFilter)NutsIdFilters.of((NutsSession)session).parse(j));
        }
        NutsDescriptorFilter packs = dfilter.byPackaging(this.getPackaging());
        NutsDescriptorFilter archs = dfilter.byArch(this.getArch());
        _descriptorFilter = _descriptorFilter.and(packs).and(archs);
        NutsRepositoryFilter _repositoryFilter = rfilter.and(this.getRepositoryFilter());
        _descriptorFilter = _descriptorFilter.and(this.getDescriptorFilter());
        _idFilter = _idFilter.and(idFilter0);
        if (this.getInstallStatus() != null) {
            _idFilter = _idFilter.and(NutsIdFilters.of((NutsSession)session).byInstallStatus(this.getInstallStatus()));
        }
        if (this.getDefaultVersions() != null) {
            _idFilter = _idFilter.and(NutsIdFilters.of((NutsSession)session).byDefaultVersion(this.getDefaultVersions()));
        }
        if (this.execType != null) {
            switch (this.execType) {
                case "lib": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byFlag(new NutsDescriptorFlag[]{NutsDescriptorFlag.EXEC}).neg());
                    break;
                }
                case "exec": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byFlag(new NutsDescriptorFlag[]{NutsDescriptorFlag.EXEC}));
                    break;
                }
                case "app": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byFlag(new NutsDescriptorFlag[]{NutsDescriptorFlag.APP}));
                    break;
                }
                case "extension": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byExtension(this.targetApiVersion));
                    break;
                }
                case "runtime": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byRuntime(this.targetApiVersion));
                    break;
                }
                case "companions": {
                    _descriptorFilter = _descriptorFilter.and(dfilter.byCompanion(this.targetApiVersion));
                }
            }
        } else if (this.targetApiVersion != null) {
            _descriptorFilter = _descriptorFilter.and(dfilter.byApiVersion(this.targetApiVersion));
        }
        if (!this.lockedIds.isEmpty()) {
            _descriptorFilter = _descriptorFilter.and(dfilter.byLockedIds((String[])this.lockedIds.stream().map(NutsId::getFullName).toArray(String[]::new)));
        }
        if (!wildcardIds.isEmpty()) {
            _idFilter = _idFilter.and(NutsIdFilters.of((NutsSession)session).byName(wildcardIds.toArray(new String[0])));
        }
        if ((extraRepositoryFilter = this.createRepositoryFilter(this.installStatus, _idFilter, this.getSession())) != null) {
            _repositoryFilter = _repositoryFilter.and(extraRepositoryFilter);
        }
        return new DefaultNutsSearch(goodIds.toArray(new String[0]), _repositoryFilter, _idFilter, _descriptorFilter, this.getSession());
    }

    @Override
    public NutsIterator<NutsId> getResultIdIteratorBase(Boolean forceInlineDependencies) {
        boolean inlineDependencies = forceInlineDependencies == null ? this.isInlineDependencies() : forceInlineDependencies.booleanValue();
        DefaultNutsSearch search = this.build();
        ArrayList allResults = new ArrayList();
        this.checkSession();
        NutsSession session = search.getSession();
        NutsWorkspaceUtils.checkSession(session.getWorkspace(), session);
        NutsIdFilter sIdFilter = search.getIdFilter();
        NutsRepositoryFilter sRepositoryFilter = search.getRepositoryFilter();
        NutsDescriptorFilter sDescriptorFilter = search.getDescriptorFilter();
        String[] regularIds = search.getRegularIds();
        NutsFetchStrategy fetchMode = NutsWorkspaceHelper.validate(session.getFetchStrategy());
        HashSet<NutsRepository> consideredRepos = new HashSet<NutsRepository>();
        NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(session);
        NutsElements elems = NutsElements.of((NutsSession)session);
        if (regularIds.length > 0) {
            for (String id : regularIds) {
                NutsId nutsId2 = NutsId.of((String)id, (NutsSession)session);
                if (nutsId2 == null) continue;
                ArrayList<Object> nutsId22 = new ArrayList<Object>();
                if (NutsBlankable.isBlank((String)nutsId2.getGroupId())) {
                    if (nutsId2.getArtifactId().equals("nuts")) {
                        nutsId22.add(nutsId2.builder().setGroupId("net.thevpc.nuts").build());
                    } else {
                        List installedIds = Collections.emptyList();
                        if (!nutsId2.getArtifactId().contains("*")) {
                            NutsRepositorySPI repoSPI = wu.repoSPI(NutsWorkspaceExt.of(this.getWorkspace()).getInstalledRepository());
                            NutsIterator nutsIterator = repoSPI.search().setFetchMode(NutsFetchMode.LOCAL).setFilter(NutsIdFilters.of((NutsSession)session).byName(new String[]{nutsId2.builder().setGroupId("*").build().toString()})).setSession(this.getSession()).getResult();
                            installedIds = IteratorUtils.toList(nutsIterator);
                        }
                        if (!installedIds.isEmpty()) {
                            nutsId22.addAll(installedIds);
                        } else {
                            for (String string : session.imports().getAllImports()) {
                                nutsId22.add(nutsId2.builder().setGroupId(string).build());
                                nutsId22.add(nutsId2.builder().setGroupId(string + "." + nutsId2.getArtifactId()).build());
                            }
                        }
                    }
                } else {
                    nutsId22.add(nutsId2);
                }
                ArrayList toConcat = new ArrayList();
                for (NutsId nutsId3 : nutsId22) {
                    NutsIdFilter idFilter2 = (NutsIdFilter)NutsFilters.of((NutsSession)session).all(new NutsFilter[]{sIdFilter, NutsIdFilters.of((NutsSession)session).byName(new String[]{nutsId3.getFullName()})});
                    NutsIdFilter filter = CoreFilterUtils.simplify(CoreFilterUtils.idFilterOf(nutsId3.getProperties(), idFilter2, sDescriptorFilter, session));
                    List<NutsRepositoryAndFetchMode> repositoryAndFetchModes = wu.filterRepositoryAndFetchModes(NutsRepositorySupportedAction.SEARCH, nutsId3, sRepositoryFilter, fetchMode, session);
                    ArrayList idLocal = new ArrayList();
                    ArrayList idRemote = new ArrayList();
                    for (NutsFetchMode fm : new NutsFetchMode[]{NutsFetchMode.LOCAL, NutsFetchMode.REMOTE}) {
                        ArrayList idLookup = fm == NutsFetchMode.LOCAL ? idLocal : idRemote;
                        for (NutsRepositoryAndFetchMode repoAndMode : repositoryAndFetchModes) {
                            if (repoAndMode.getFetchMode() != fm) continue;
                            consideredRepos.add(repoAndMode.getRepository());
                            NutsRepositorySPI repoSPI = wu.repoSPI(repoAndMode.getRepository());
                            idLookup.add(IteratorBuilder.of(repoSPI.searchVersions().setId(nutsId3).setFilter(filter).setSession(session).setFetchMode(repoAndMode.getFetchMode()).getResult(), session).named(elems.ofObject().set("description", "searchVersions").set("repository", repoAndMode.getRepository().getName()).set("filter", NutsDescribables.resolveOrDestruct((Object)filter, (NutsElements)elems)).build()).safeIgnore().iterator());
                        }
                    }
                    toConcat.add(fetchMode.isStopFast() ? IteratorUtils.coalesce(IteratorUtils.concat(idLocal), IteratorUtils.concat(idRemote)) : IteratorUtils.concatLists(idLocal, idRemote));
                }
                if (nutsId2.getGroupId() == null) {
                    NutsSearchCommand search2 = session.search().setSession(session).setRepositoryFilter(search.getRepositoryFilter()).setDescriptorFilter(search.getDescriptorFilter());
                    search2.setIdFilter(NutsIdFilters.of((NutsSession)session).byName(new String[]{nutsId2.builder().setGroupId("*").build().toString()}).and(search.getIdFilter()));
                    NutsIterator nutsIterator = search2.getResultIds().iterator();
                    allResults.add(IteratorUtils.coalesce(IteratorUtils.concat(toConcat), nutsIterator));
                    continue;
                }
                allResults.add(IteratorUtils.concat(toConcat));
            }
        } else {
            NutsIdFilter filter = CoreFilterUtils.simplify(CoreFilterUtils.idFilterOf(null, sIdFilter, sDescriptorFilter, session));
            ArrayList all = new ArrayList();
            for (NutsRepositoryAndFetchMode repoAndMode : wu.filterRepositoryAndFetchModes(NutsRepositorySupportedAction.SEARCH, null, sRepositoryFilter, fetchMode, session)) {
                consideredRepos.add(repoAndMode.getRepository());
                NutsSession finalSession1 = session;
                all.add(IteratorBuilder.of(wu.repoSPI(repoAndMode.getRepository()).search().setFilter(filter).setSession(finalSession1).setFetchMode(repoAndMode.getFetchMode()).getResult(), session).safeIgnore().named(elems.ofObject().set("description", "searchRepository").set("repository", repoAndMode.getRepository().getName()).set("fetchMode", repoAndMode.getFetchMode().id()).set("filter", NutsDescribables.resolveOrDestruct((Object)filter, (NutsElements)elems)).build()).iterator());
            }
            allResults.add(fetchMode.isStopFast() ? IteratorUtils.coalesce(all) : IteratorUtils.concat(all));
        }
        Object baseIterator = IteratorUtils.concat(allResults);
        if (inlineDependencies) {
            if (this.isLatest() || this.isDistinct()) {
                if (!this.isLatest() && this.isDistinct()) {
                    baseIterator = IteratorBuilder.of(baseIterator, session).distinct(NutsFunction.of(nutsId -> nutsId.getLongId().toString(), (String)"getLongId")).iterator();
                } else if (this.isLatest() && this.isDistinct()) {
                    NutsIterator curr = baseIterator;
                    baseIterator = IteratorBuilder.ofSupplier(() -> {
                        LinkedHashMap<String, NutsId> visited = new LinkedHashMap<String, NutsId>();
                        while (curr.hasNext()) {
                            NutsId nutsId = (NutsId)curr.next();
                            String k = nutsId.getShortName();
                            NutsId old = (NutsId)visited.get(k);
                            if (old != null && !old.getVersion().isBlank() && old.getVersion().compareTo(nutsId.getVersion()) >= 0) continue;
                            visited.put(k, nutsId);
                        }
                        return visited.values().iterator();
                    }, e -> NutsDescribables.resolveOrDestruct((Object)curr, (NutsElements)elems).asSafeObject(true).builder().set("latest", true).set("distinct", true).build(), session).build();
                } else if (this.isLatest() && !this.isDistinct()) {
                    NutsIterator curr = baseIterator;
                    baseIterator = IteratorBuilder.ofSupplier(() -> {
                        LinkedHashMap<String, ArrayList<NutsId>> visited = new LinkedHashMap<String, ArrayList<NutsId>>();
                        while (curr.hasNext()) {
                            NutsId old;
                            NutsId nutsId = (NutsId)curr.next();
                            String k = nutsId.getShortName();
                            List oldList = (List)visited.get(k);
                            NutsId nutsId2 = old = oldList == null ? null : (NutsId)oldList.get(0);
                            if (old == null || old.getVersion().isBlank() || old.getVersion().compareTo(nutsId.getVersion()) < 0) {
                                visited.put(k, new ArrayList<NutsId>(Arrays.asList(nutsId)));
                                continue;
                            }
                            if (old.getVersion().compareTo(nutsId.getVersion()) != 0) continue;
                            oldList.add(nutsId);
                        }
                        return IteratorBuilder.ofFlatMap(NutsIterator.of(visited.values().iterator(), (String)"visited"), session).build();
                    }, e -> NutsDescribables.resolveOrDestruct((Object)curr, (NutsElements)elems).asSafeObject(true).builder().set("latest", true).set("duplicates", true).build(), session).build();
                }
            }
            NutsIterator curr = baseIterator;
            baseIterator = IteratorBuilder.of(curr, session).flatMap(NutsFunction.of(x -> IteratorBuilder.of(this.toFetch().setId(x).setContent(false).setDependencies(true).getResultDefinition().getDependencies().transitiveWithSource().iterator(), session).build(), (String)"getDependencies")).map(NutsFunction.of(NutsDependency::toId, (String)"DependencyToId")).build();
        }
        if (this.isLatest() || this.isDistinct()) {
            if (!this.isLatest() && this.isDistinct()) {
                baseIterator = IteratorBuilder.of(baseIterator, session).distinct(NutsFunction.of(nutsId -> nutsId.getLongId().toString(), (String)"getLongId()")).iterator();
            } else if (this.isLatest() && this.isDistinct()) {
                NutsIterator curr = baseIterator;
                String fromName = curr.toString();
                baseIterator = IteratorBuilder.ofSupplier(() -> {
                    LinkedHashMap<String, NutsId> visited = new LinkedHashMap<String, NutsId>();
                    while (curr.hasNext()) {
                        NutsId nutsId = (NutsId)curr.next();
                        String k = nutsId.getShortName();
                        NutsId old = (NutsId)visited.get(k);
                        if (old != null && !old.getVersion().isBlank() && old.getVersion().compareTo(nutsId.getVersion()) >= 0) continue;
                        visited.put(k, nutsId);
                    }
                    return visited.values().iterator();
                }, e -> NutsDescribables.resolveOrDestruct((Object)curr, (NutsElements)elems).asSafeObject(true).builder().set("latest", true).set("distinct", true).build(), session).build();
            } else if (this.isLatest() && !this.isDistinct()) {
                NutsIterator curr = baseIterator;
                baseIterator = IteratorBuilder.ofSupplier(() -> {
                    LinkedHashMap<String, ArrayList<NutsId>> visited = new LinkedHashMap<String, ArrayList<NutsId>>();
                    while (curr.hasNext()) {
                        NutsId old;
                        NutsId nutsId = (NutsId)curr.next();
                        String k = nutsId.getShortName();
                        List oldList = (List)visited.get(k);
                        NutsId nutsId2 = old = oldList == null ? null : (NutsId)oldList.get(0);
                        if (old == null || old.getVersion().isBlank() || old.getVersion().compareTo(nutsId.getVersion()) < 0) {
                            visited.put(k, new ArrayList<NutsId>(Arrays.asList(nutsId)));
                            continue;
                        }
                        if (old.getVersion().compareTo(nutsId.getVersion()) != 0) continue;
                        oldList.add(nutsId);
                    }
                    return IteratorBuilder.ofFlatMap(NutsIterator.of(visited.values().iterator(), (String)"visited"), session).build();
                }, e -> NutsDescribables.resolveOrDestruct((Object)curr, (NutsElements)elems).asSafeObject(true).builder().set("latest", true).set("duplicates", true).build(), session).build();
            }
        }
        if (this.isSorted()) {
            baseIterator = IteratorUtils.sort(baseIterator, this.comparator, false);
        }
        return baseIterator;
    }
}

