/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.recom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.AbstractRecommendationConnector;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;

public class SimpleRecommendationConnector
extends AbstractRecommendationConnector {
    @Override
    public <T> T post(String url, RequestQueryInfo ri, Class<T> resultType, NutsSession session) {
        this.validateRequest(ri, session);
        try {
            URL url2 = new URL(ri.server + url);
            URLConnection con = url2.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            http.setRequestProperty("Accept", "*/*");
            String loc = session.getLocale();
            if (loc == null) {
                loc = Locale.getDefault().toString();
            }
            http.setRequestProperty("Accept-Language", loc);
            NutsElements elems = NutsElements.of((NutsSession)session);
            String out = elems.setValue((Object)ri.q).json().setNtf(false).format().filteredText();
            int length = out.length();
            http.setFixedLengthStreamingMode(length);
            http.connect();
            try (OutputStream os = http.getOutputStream();){
                os.write(out.getBytes(StandardCharsets.UTF_8));
            }
            return (T)elems.parse(http.getInputStream(), resultType);
        }
        catch (IOException ex) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"recommendations are not available : %s", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected error : %s", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
        }
    }
}

