/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.recom;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RecommendationConnector;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestAgent;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;

public abstract class AbstractRecommendationConnector
implements RecommendationConnector {
    private String localUserUUID;

    private String getLocalUserUUID(NutsSession session) {
        if (this.localUserUUID != null) {
            return this.localUserUUID;
        }
        Path userConfig = Paths.get(NutsUtilPlatforms.getWorkspaceLocation((NutsOsFamily)NutsOsFamily.getCurrent(), (boolean)false, null), new String[0]).getParent().resolve(".nuts-user-config");
        LinkedHashMap<String, String> m = null;
        NutsElements elems = NutsElements.of((NutsSession)session);
        String _uuid = null;
        if (Files.exists(userConfig, new LinkOption[0])) {
            try {
                m = (LinkedHashMap<String, String>)elems.json().parse(userConfig, Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (m != null) {
                _uuid = NutsUtilStrings.trimToNull(m.get("user") == null ? null : String.valueOf(m.get("user")));
            }
        }
        if (_uuid != null) {
            this.localUserUUID = _uuid;
        } else {
            if (m == null) {
                m = new LinkedHashMap<String, String>();
            }
            this.localUserUUID = UUID.randomUUID().toString();
            m.put("user", this.localUserUUID);
            try {
                elems.json().setValue(m).print(userConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.localUserUUID;
    }

    @Override
    public Map askInstallRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/install-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askUpdateRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/update-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askCompanionsRecommendations(RequestQueryInfo ri, NutsSession session) {
        if (ri.q.getId() == null) {
            ri.q.setId(session.getWorkspace().getApiId().toString());
        }
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/companion-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askInstallFailureRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/install-failure-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askUninstallFailureRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/uninstall-failure-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askBootstrapFailureRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/bootstrap-failure-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askUpdateFailureRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/update-failure-recommendations.json";
        return this.post(url, ri, Map.class, session);
    }

    @Override
    public Map askUninstallRecommendations(RequestQueryInfo ri, NutsSession session) {
        this.validateRequest(ri, session);
        NutsId id = NutsIdParser.of((NutsSession)session).setLenient(false).setAcceptBlank(false).parse(ri.q.getId());
        String url = "/repo/" + id.getGroupId().replace('.', '/') + '/' + id.getArtifactId() + '/' + id.getVersion() + "/alternatives.json";
        return this.post(url, ri, Map.class, session);
    }

    public abstract <T> T post(String var1, RequestQueryInfo var2, Class<T> var3, NutsSession var4);

    public void validateRequest(RequestQueryInfo ri, NutsSession session) {
        ri.server = ri.server == null || ri.server.trim().isEmpty() ? "https://thevpc.net/nuts" : ri.server;
        NutsWorkspaceEnvManager env = session.env();
        RequestAgent agent = ri.q.getAgent();
        NutsWorkspace ws = session.getWorkspace();
        if (agent.getApiVersion() == null) {
            agent.setApiVersion(ws.getApiVersion().toString());
        }
        if (agent.getRuntimeId() == null) {
            agent.setRuntimeId(ws.getRuntimeId().toString());
        }
        if (agent.getArch() == null) {
            agent.setArch(env.getArch().toString());
        }
        if (agent.getOs() == null) {
            agent.setOs(env.getOs().toString());
        }
        if (agent.getOsDist() == null) {
            agent.setOsDist(env.getOsDist().toString());
        }
        if (agent.getDesktop() == null) {
            agent.setDesktop(env.getDesktopEnvironment().toString());
        }
        if (agent.getPlatform() == null) {
            agent.setPlatform(env.getPlatform().toString());
        }
        if (agent.getShell() == null) {
            agent.setShell(env.getShellFamily().toString());
        }
        if (agent.getUserDigest() == null) {
            agent.setUserDigest(this.getLocalUserUUID(session));
        }
        if (agent.getUserLocale() == null) {
            String loc = session.getLocale();
            if (loc == null) {
                loc = Locale.getDefault().toString();
            }
            agent.setUserLocale(loc);
        }
        if (agent.getUserTimeZone() == null) {
            agent.setUserTimeZone(TimeZone.getDefault().getDisplayName());
        }
    }
}

