/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsInstallCommand;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStrategy;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsDependencyUtils;
import net.thevpc.nuts.runtime.standalone.stream.NutsListStream;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.AbstractNutsInstallCommand;

public class DefaultNutsInstallCommand
extends AbstractNutsInstallCommand {
    public DefaultNutsInstallCommand(NutsWorkspace ws) {
        super(ws);
    }

    private NutsDefinition _loadIdContent(NutsId id, NutsId forId, NutsSession session, boolean includeDeps, InstallIdList loaded, NutsInstallStrategy installStrategy) {
        installStrategy = loaded.validateStrategy(installStrategy);
        NutsId longNameId = id.getLongId();
        InstallIdInfo def = loaded.get(longNameId);
        if (def != null) {
            if (forId != null) {
                def.forIds.add(forId);
            }
            if (def.definition != null && (def.strategy != NutsInstallStrategy.REQUIRE || def.strategy == NutsInstallStrategy.REQUIRE && installStrategy == NutsInstallStrategy.REQUIRE)) {
                return def.definition;
            }
        } else {
            def = loaded.addForInstall(id, installStrategy, false);
            def.extra = true;
            def.doRequire = true;
            if (forId != null) {
                def.forIds.add(forId);
            }
        }
        NutsSession ss = session.copy();
        this.checkSession();
        try {
            def.definition = ss.fetch().setId(id).setSession(ss).setContent(true).setEffective(true).setDependencies(includeDeps).setFailFast(true).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(NutsDependencyFilters.of((NutsSession)session).byRunnable()).getResultDefinition();
        }
        catch (NutsNotFoundException ee) {
            if (!NutsDependencyUtils.isRequiredDependency(id.toDependency())) {
                includeDeps = false;
            }
            throw ee;
        }
        def.doRequire = true;
        if (includeDeps) {
            for (NutsDependency dependency : def.definition.getDependencies()) {
                this._loadIdContent(dependency.toId(), id, session, false, loaded, NutsInstallStrategy.REQUIRE);
            }
        }
        return def.definition;
    }

    private boolean doThis(NutsId id, InstallIdList list, NutsSession session) {
        ArrayList<String> cmdArgs = new ArrayList<String>(Arrays.asList(this.getArgs()));
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        InstallIdInfo info = list.get(id);
        if (info.doInstall) {
            this._loadIdContent(info.id, null, session, true, list, info.strategy);
            if (info.definition != null) {
                for (AbstractNutsInstallCommand.ConditionalArguments conditionalArgument : this.conditionalArguments) {
                    if (!conditionalArgument.getPredicate().test(info.definition)) continue;
                    cmdArgs.addAll(conditionalArgument.getArgs());
                }
            }
            dws.installImpl(info.definition, cmdArgs.toArray(new String[0]), null, session, info.doSwitchVersion);
            return true;
        }
        if (info.doRequire) {
            this._loadIdContent(info.id, null, session, true, list, info.strategy);
            dws.requireImpl(info.definition, session, info.doRequireDependencies, new NutsId[0]);
            return true;
        }
        if (info.doSwitchVersion) {
            dws.getInstalledRepository().setDefaultVersion(info.id, session);
            return true;
        }
        if (info.ignored) {
            return false;
        }
        throw new NutsUnexpectedException(this.getSession(), NutsMessage.cstyle((String)"unexpected", (Object[])new Object[0]));
    }

    public NutsStream<NutsDefinition> getResult() {
        this.checkSession();
        if (this.result == null) {
            this.run();
        }
        return new NutsListStream<NutsDefinition>(this.getSession(), this.ids.isEmpty() ? null : this.ids.keySet().toArray()[0].toString(), Arrays.asList(this.result), e -> e.ofString("InstallResult"));
    }

    /*
     * Exception decompiling
     */
    public NutsInstallCommand run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printList(NutsPrintStream out, String skind, String saction, List<NutsId> all) {
        if (all.size() > 0) {
            if (this.session.isPlainOut()) {
                NutsTexts text = NutsTexts.of((NutsSession)this.session);
                NutsTextStyled kind = text.ofStyled(skind, NutsTextStyle.primary2());
                NutsTextStyled action = text.ofStyled(saction, saction.equals("set as default") ? NutsTextStyle.primary3() : (saction.equals("ignored") ? NutsTextStyle.pale() : NutsTextStyle.primary1()));
                NutsSession session = this.getSession();
                NutsTextBuilder msg = NutsTexts.of((NutsSession)this.getSession()).builder();
                msg.append((Object)"the following ").append((NutsText)kind).append((Object)" ").append((Object)(all.size() > 1 ? "artifacts are" : "artifact is")).append((Object)" going to be ").append((NutsText)action).append((Object)" : ").appendJoined((Object)NutsTexts.of((NutsSession)session).ofPlain(", "), (Collection)all.stream().map(x -> NutsTexts.of((NutsSession)session).toText((Object)x.builder().omitImportedGroupId().build())).collect(Collectors.toList()));
                out.resetLine().println((NutsString)msg);
            } else {
                NutsElements elem = NutsElements.of((NutsSession)this.session);
                this.session.eout().add((NutsElement)elem.ofObject().set("command", "warning").set("artifact-kind", skind).set("action-warning", saction).set("artifacts", (NutsElement)elem.ofArray().addAll((String[])all.stream().map(x -> x.toString()).toArray(String[]::new)).build()).build());
            }
        }
    }

    private static /* synthetic */ boolean lambda$run$16(InstallIdInfo x) {
        return !x.ignored;
    }

    private static /* synthetic */ boolean lambda$run$15(InstallIdInfo x) {
        return !x.ignored;
    }

    private static /* synthetic */ boolean lambda$run$14(InstallIdInfo x) {
        return x.ignored;
    }

    private static /* synthetic */ boolean lambda$run$13(InstallIdInfo x) {
        return x.doSwitchVersion && x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$run$12(InstallIdInfo x) {
        return x.doInstall && x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$run$11(InstallIdInfo x) {
        return x.doInstall && x.isAlreadyRequired() && !x.isAlreadyInstalled();
    }

    private static /* synthetic */ boolean lambda$run$10(InstallIdInfo x) {
        return !x.doInstall && x.doRequire && x.isAlreadyRequired();
    }

    private static /* synthetic */ boolean lambda$run$9(InstallIdInfo x) {
        return x.doRequire && !x.doInstall && !x.isAlreadyExists();
    }

    private static /* synthetic */ boolean lambda$run$8(InstallIdInfo x) {
        return x.doInstall && !x.isAlreadyExists();
    }

    private static /* synthetic */ boolean lambda$run$7(InstallIdInfo x) {
        return !x.ignored;
    }

    private static /* synthetic */ String lambda$run$6(NutsSession session, NutsId x) {
        return NutsIdFormat.of((NutsSession)session).setOmitImportedGroupId(true).setValue(x.getLongId()).format().toString();
    }

    private static /* synthetic */ NutsId lambda$run$5(InstallIdInfo x) {
        return x.id;
    }

    private static /* synthetic */ String lambda$run$4(NutsSession session, NutsId x) {
        return NutsIdFormat.of((NutsSession)session).setOmitImportedGroupId(true).setValue(x.getLongId()).format().toString();
    }

    private static /* synthetic */ NutsId lambda$run$3(InstallIdInfo x) {
        return x.id;
    }

    private static /* synthetic */ String lambda$run$2(InstallIdInfo installIdInfo) {
        return installIdInfo.doError;
    }

    private static /* synthetic */ boolean lambda$run$1(InstallIdInfo x) {
        return x.doError != null;
    }

    private static class InstallIdList {
        boolean emptyCommand = true;
        NutsInstallStrategy defaultStrategy;
        Map<String, InstallIdInfo> visited = new LinkedHashMap<String, InstallIdInfo>();

        public InstallIdList(NutsInstallStrategy defaultStrategy) {
            this.defaultStrategy = defaultStrategy;
        }

        public boolean isVisited(NutsId id) {
            return this.visited.containsKey(this.normalizeId(id));
        }

        private String normalizeId(NutsId id) {
            return id.builder().setRepository(null).setProperty("optional", null).build().toString();
        }

        public List<NutsId> ids(Predicate<InstallIdInfo> filter) {
            return this.infos().stream().filter(filter).map(x -> x.id).collect(Collectors.toList());
        }

        public List<InstallIdInfo> infos(Predicate<InstallIdInfo> filter) {
            if (filter == null) {
                return this.infos();
            }
            return this.infos().stream().filter(filter).collect(Collectors.toList());
        }

        public List<InstallIdInfo> infos() {
            return new ArrayList<InstallIdInfo>(this.visited.values());
        }

        public NutsInstallStrategy validateStrategy(NutsInstallStrategy strategy) {
            if (strategy == null) {
                strategy = NutsInstallStrategy.DEFAULT;
            }
            if (strategy == NutsInstallStrategy.DEFAULT) {
                strategy = this.defaultStrategy;
            }
            return strategy;
        }

        public InstallIdInfo addForInstall(NutsId id, NutsInstallStrategy strategy, boolean forced) {
            this.emptyCommand = false;
            InstallIdInfo ii = new InstallIdInfo();
            ii.forced = forced;
            ii.id = id;
            ii.sid = this.normalizeId(id);
            ii.strategy = this.validateStrategy(strategy);
            this.visited.put(this.normalizeId(id), ii);
            return ii;
        }

        public InstallIdInfo get(NutsId id) {
            return this.visited.get(this.normalizeId(id));
        }
    }

    private static class InstallIdInfo {
        boolean extra;
        String sid;
        NutsId id;
        boolean forced;
        boolean doRequire;
        boolean doRequireDependencies;
        boolean doInstall;
        boolean ignored;
        boolean doSwitchVersion;
        NutsInstallStrategy strategy;
        String doError;
        NutsInstallStatus oldInstallStatus;
        Set<NutsId> forIds = new HashSet<NutsId>();
        NutsDefinition definition;

        private InstallIdInfo() {
        }

        public boolean isAlreadyRequired() {
            return this.oldInstallStatus.isRequired();
        }

        public boolean isAlreadyInstalled() {
            return this.oldInstallStatus.isInstalled();
        }

        public boolean isAlreadyExists() {
            return this.oldInstallStatus.isInstalled() || this.oldInstallStatus.isRequired();
        }

        public NutsInstallStatus getOldInstallStatus() {
            return this.oldInstallStatus;
        }
    }
}

