/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.install;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallCommand;
import net.thevpc.nuts.NutsInstallStrategy;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsWorkspaceCommandBase;

public abstract class AbstractNutsInstallCommand
extends NutsWorkspaceCommandBase<NutsInstallCommand>
implements NutsInstallCommand {
    protected boolean defaultVersion = true;
    protected NutsInstallStrategy companions;
    protected NutsInstallStrategy installed;
    protected NutsInstallStrategy strategy = NutsInstallStrategy.DEFAULT;
    protected List<String> args;
    protected List<ConditionalArguments> conditionalArguments = new ArrayList<ConditionalArguments>();
    protected final Map<NutsId, NutsInstallStrategy> ids = new LinkedHashMap<NutsId, NutsInstallStrategy>();
    protected NutsDefinition[] result;
    protected NutsId[] failed;

    public AbstractNutsInstallCommand(NutsWorkspace ws) {
        super(ws, "install");
    }

    public NutsInstallCommand addId(String id) {
        this.checkSession();
        return this.addId(id == null ? null : NutsId.of((String)id, (NutsSession)this.session));
    }

    public NutsInstallCommand setId(NutsId id) {
        return this.clearIds().addId(id);
    }

    public NutsInstallCommand setId(String id) {
        return this.clearIds().addId(id);
    }

    public NutsInstallCommand setIds(NutsId ... ids) {
        return this.clearIds().addIds(ids);
    }

    public NutsInstallCommand setIds(String ... ids) {
        return this.clearIds().addIds(ids);
    }

    public NutsInstallCommand addId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsNotFoundException(this.session, id);
        }
        this.ids.put(id, this.getStrategy());
        return this;
    }

    public NutsInstallCommand addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsInstallCommand addIds(NutsId ... ids) {
        for (NutsId id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsInstallCommand removeId(NutsId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    public NutsInstallCommand removeId(String id) {
        this.checkSession();
        if (id != null) {
            this.ids.remove(NutsId.of((String)id, (NutsSession)this.session));
        }
        return this;
    }

    public NutsInstallCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsInstallCommand clearArgs() {
        this.args = null;
        return this;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args.toArray(new String[0]);
    }

    public NutsInstallCommand addArg(String arg) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (arg == null) {
            throw new NullPointerException();
        }
        this.args.add(arg);
        return this;
    }

    public NutsInstallCommand addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    public NutsInstallCommand addConditionalArgs(Predicate<NutsDefinition> definition, String ... args) {
        this.conditionalArguments.add(new ConditionalArguments(definition, Arrays.asList(args)));
        return this;
    }

    public NutsInstallCommand addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) {
                    throw new NullPointerException();
                }
                this.args.add(arg);
            }
        }
        return this;
    }

    public NutsId[] getIds() {
        return this.ids == null ? new NutsId[]{} : this.ids.keySet().toArray(new NutsId[0]);
    }

    public Map<NutsId, NutsInstallStrategy> getIdMap() {
        return this.ids == null ? new LinkedHashMap<NutsId, NutsInstallStrategy>() : new LinkedHashMap<NutsId, NutsInstallStrategy>(this.ids);
    }

    public boolean isCompanions() {
        return this.companions != null;
    }

    public NutsInstallCommand setCompanions(boolean value) {
        this.companions = value ? this.getStrategy() : null;
        return this;
    }

    public NutsInstallStrategy getCompanions() {
        return this.companions;
    }

    public boolean isInstalled() {
        return this.installed != null;
    }

    public NutsInstallCommand setInstalled(boolean value) {
        this.installed = value ? this.getStrategy() : null;
        return this;
    }

    public NutsInstallStrategy getInstalled() {
        return this.installed;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public NutsInstallCommand setDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    public NutsInstallCommand defaultVersion(boolean defaultVersion) {
        return this.setDefaultVersion(defaultVersion);
    }

    public NutsInstallCommand defaultVersion() {
        return this.defaultVersion(true);
    }

    public NutsInstallCommand companions(boolean value) {
        return this.setCompanions(value);
    }

    public NutsInstallCommand companions() {
        return this.companions(true);
    }

    public NutsInstallCommand setStrategy(NutsInstallStrategy value) {
        if (value == null) {
            value = NutsInstallStrategy.DEFAULT;
        }
        this.strategy = value;
        return this;
    }

    public NutsInstallStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "-c": 
            case "--companions": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setCompanions(val);
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setInstalled(val);
                }
                return true;
            }
            case "-s": 
            case "--strategy": {
                String val = cmdLine.nextString(new String[0]).getString();
                if (enabled) {
                    this.setStrategy(CoreEnumUtils.parseEnumString(val, NutsInstallStrategy.class, false));
                }
                return true;
            }
            case "--reinstall": {
                cmdLine.skip();
                if (enabled) {
                    this.setStrategy(NutsInstallStrategy.REINSTALL);
                }
                return true;
            }
            case "--require": {
                cmdLine.skip();
                if (enabled) {
                    this.setStrategy(NutsInstallStrategy.REQUIRE);
                }
                return true;
            }
            case "--repair": {
                cmdLine.skip();
                if (enabled) {
                    this.setStrategy(NutsInstallStrategy.REPAIR);
                }
                return true;
            }
            case "-g": 
            case "--args": {
                cmdLine.skip();
                if (enabled) {
                    this.addArgs(cmdLine.toStringArray());
                }
                cmdLine.skipAll();
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.getString());
        return true;
    }

    protected static class ConditionalArguments {
        Predicate<NutsDefinition> predicate;
        List<String> args = new ArrayList<String>();

        public ConditionalArguments(Predicate<NutsDefinition> predicate, List<String> args) {
            this.predicate = predicate;
            this.args = args;
        }

        public Predicate<NutsDefinition> getPredicate() {
            return this.predicate;
        }

        public List<String> getArgs() {
            return this.args;
        }
    }
}

