/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.info;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInfoCommand;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspaceCommand;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.dependency.solver.NutsDependencySolverUtils;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreTimeUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsDebugString;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.spi.NutsDependencySolver;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsInfoCommand
extends DefaultFormatBase<NutsInfoCommand>
implements NutsInfoCommand {
    private final Map<String, String> extraProperties = new LinkedHashMap<String, String>();
    private boolean showRepositories = false;
    private boolean fancy = false;
    private List<String> requests = new ArrayList<String>();
    private Predicate<String> filter = NutsPredicates.always();
    private boolean lenient = false;

    public DefaultNutsInfoCommand(NutsSession session) {
        super(session, "info");
    }

    private static String key(String prefix, String key) {
        if (NutsBlankable.isBlank((String)prefix)) {
            return key;
        }
        return prefix + "." + key;
    }

    public NutsInfoCommand addProperty(String key, String value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
        return this;
    }

    public NutsInfoCommand addProperties(Map<String, String> customProperties) {
        if (customProperties != null) {
            for (Map.Entry<String, String> e : customProperties.entrySet()) {
                this.addProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public boolean isShowRepositories() {
        return this.showRepositories;
    }

    public NutsInfoCommand setShowRepositories(boolean enable) {
        this.showRepositories = true;
        return this;
    }

    public boolean isFancy() {
        return this.fancy;
    }

    public NutsInfoCommand setFancy(boolean fancy) {
        this.fancy = fancy;
        return this;
    }

    public NutsInfoCommand copySession() {
        NutsSession s = this.getSession();
        if (s != null) {
            s = s.copy();
        }
        return (NutsInfoCommand)this.setSession(s);
    }

    @Override
    public void print(NutsPrintStream w) {
        Map<String, Object> t;
        this.checkSession();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--escape-text=false");
        if (this.isFancy()) {
            args.add("--multiline-property=nuts-runtime-path=;");
            args.add("--multiline-property=java-classpath=" + File.pathSeparator);
            args.add("--multiline-property=java-library-path=" + File.pathSeparator);
            args.add("--multiline-property=nuts-boot-runtime-path=:|;");
            args.add("--multiline-property=java.class.path=" + File.pathSeparator);
            args.add("--multiline-property=java-class-path=" + File.pathSeparator);
            args.add("--multiline-property=java.library.path=" + File.pathSeparator);
        }
        Object result = null;
        if (this.requests.isEmpty()) {
            result = this.buildWorkspaceMap(this.isShowRepositories());
        } else if (this.requests.size() == 1) {
            String key;
            t = this.buildWorkspaceMap(true);
            Object v = t.get(key = this.requests.get(0));
            if (v != null) {
                result = v;
            } else if (!this.isLenient()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"property not found : %s", (Object[])new Object[]{key}));
            }
        } else {
            t = this.buildWorkspaceMap(true);
            LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>();
            result = e;
            for (String request : this.requests) {
                if (t.containsKey(request)) {
                    e.put(request, t.get(request));
                    continue;
                }
                if (this.isLenient()) continue;
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"property not found : %s", (Object[])new Object[]{request}));
            }
        }
        NutsSession session = this.getSession().copy();
        if (session.isPlainOut()) {
            session.setOutputFormat(NutsContentType.PROPS);
        }
        NutsObjectFormat.of((NutsSession)session).setValue(result).configure(true, args.toArray(new String[0])).print(w);
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "-r": 
            case "--repos": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setShowRepositories(val);
                }
                return true;
            }
            case "--fancy": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setFancy(val);
                }
                return true;
            }
            case "-l": 
            case "--lenient": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setLenient(val);
                }
                return true;
            }
            case "--add": {
                NutsPrimitiveElement aa = cmdLine.nextString(new String[0]).getValue();
                NutsArgument val = NutsArgument.of((String)aa.getString(), (NutsSession)this.getSession());
                if (enabled) {
                    this.extraProperties.put(val.getKey().getString(), val.getValue().getString());
                }
                return true;
            }
            case "-p": 
            case "--path": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("nuts-workspace");
                    for (NutsStoreLocation folderType : NutsStoreLocation.values()) {
                        this.requests.add("nuts-workspace-" + folderType.id());
                    }
                    this.requests.add("user-home");
                    this.requests.add("user-dir");
                }
                return true;
            }
            case "-e": 
            case "--env": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("platform");
                    this.requests.add("java-version");
                    this.requests.add("java-home");
                    this.requests.add("java-executable");
                    this.requests.add("java-classpath");
                    this.requests.add("os-name");
                    this.requests.add("os-family");
                    this.requests.add("os-dist");
                    this.requests.add("os-arch");
                    this.requests.add("user-name");
                }
                return true;
            }
            case "-c": 
            case "--cmd": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("command-line-long");
                    this.requests.add("command-line-short");
                    this.requests.add("inherited");
                    this.requests.add("inherited-nuts-boot-args");
                    this.requests.add("inherited-nuts-args");
                }
                return true;
            }
            case "-g": 
            case "--get": {
                NutsArgument p;
                String r = cmdLine.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    this.requests.add(r);
                }
                while ((p = cmdLine.peek()) != null && !p.isOption()) {
                    cmdLine.skip();
                    if (!enabled) continue;
                    this.requests.add(p.getString());
                }
                return true;
            }
        }
        return this.getSession().configureFirst(cmdLine);
    }

    private Map<String, Object> buildWorkspaceMap(boolean deep) {
        String prefix = null;
        FilteredMap props = new FilteredMap(this.filter);
        NutsSession session = this.getSession();
        NutsWorkspaceConfigManager rt = session.config();
        NutsWorkspaceOptions options = session.boot().getBootOptions();
        TreeSet<String> extraKeys = new TreeSet<String>(this.extraProperties.keySet());
        props.put("name", this.stringValue(session.getWorkspace().getName()));
        props.put("nuts-api-version", session.getWorkspace().getApiVersion());
        props.put("nuts-api-id", session.getWorkspace().getApiId());
        props.put("nuts-runtime-id", session.getWorkspace().getRuntimeId());
        props.put("nuts-app-id", session.getAppId());
        URL[] cl = session.boot().getBootClassWorldURLs();
        ArrayList<NutsPath> runtimeClassPath = new ArrayList<NutsPath>();
        if (cl != null) {
            for (URL url : cl) {
                if (url == null) continue;
                String s = url.toString();
                try {
                    s = Paths.get(url.toURI()).toFile().getPath();
                }
                catch (URISyntaxException ex) {
                    s = s.replace(":", "\\:");
                }
                runtimeClassPath.add(NutsPath.of((String)s, (NutsSession)session));
            }
        }
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        props.put("nuts-runtime-classpath", txt.builder().appendJoined((Object)";", runtimeClassPath));
        props.put("nuts-workspace-id", txt.ofStyled(this.stringValue(session.getWorkspace().getUuid()), NutsTextStyle.path()));
        props.put("nuts-store-layout", session.locations().getStoreLocationLayout());
        props.put("nuts-store-strategy", session.locations().getStoreLocationStrategy());
        props.put("nuts-repo-store-strategy", session.locations().getRepositoryStoreLocationStrategy());
        props.put("nuts-global", options.isGlobal());
        props.put("nuts-workspace", session.locations().getWorkspaceLocation());
        for (NutsStoreLocation folderType : NutsStoreLocation.values()) {
            props.put("nuts-workspace-" + folderType.id(), session.locations().getStoreLocation(folderType));
        }
        props.put("nuts-open-mode", options.getOpenMode() == null ? NutsOpenMode.OPEN_OR_CREATE : options.getOpenMode());
        props.put("nuts-secure", session.security().isSecure());
        props.put("nuts-gui", options.isGui());
        props.put("nuts-inherited", options.isInherited());
        props.put("nuts-recover", options.isRecover());
        props.put("nuts-reset", options.isReset());
        props.put("nuts-debug", NutsDebugString.of(options.getDebug(), this.getSession()));
        props.put("nuts-trace", options.isTrace());
        props.put("nuts-read-only", options.isReadOnly());
        props.put("nuts-skip-companions", options.isSkipCompanions());
        props.put("nuts-skip-welcome", options.isSkipWelcome());
        props.put("nuts-skip-boot", options.isSkipBoot());
        String ds = NutsDependencySolverUtils.resolveSolverName(options.getDependencySolver());
        String[] allDs = NutsDependencySolver.getSolverNames((NutsSession)session);
        props.put("nuts-solver", txt.ofStyled(ds, Arrays.stream(allDs).map(x -> NutsDependencySolverUtils.resolveSolverName(x)).anyMatch(x -> x.equals(ds)) ? NutsTextStyle.keyword() : NutsTextStyle.error()));
        props.put("nuts-solver-list", txt.builder().appendJoined((Object)";", (Collection)Arrays.stream(allDs).map(x -> txt.ofStyled(x, NutsTextStyle.keyword())).collect(Collectors.toList())));
        NutsBootTerminal b = session.boot().getBootTerminal();
        props.put("sys-terminal-flags", b.getFlags());
        NutsTerminalMode terminalMode = session.boot().getBootOptions().getTerminalMode();
        props.put("sys-terminal-mode", terminalMode == null ? "default" : terminalMode);
        props.put("java-version", NutsVersion.of((String)System.getProperty("java.version"), (NutsSession)session));
        props.put("platform", session.env().getPlatform());
        props.put("java-home", NutsPath.of((String)System.getProperty("java.home"), (NutsSession)session));
        props.put("java-executable", NutsPath.of((String)NutsJavaSdkUtils.of(session).resolveJavaCommandByHome(null, this.getSession()), (NutsSession)session));
        props.put("java-classpath", txt.builder().appendJoined((Object)";", (Collection)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x -> NutsPath.of((String)x, (NutsSession)session)).collect(Collectors.toList())));
        props.put("java-library-path", txt.builder().appendJoined((Object)";", (Collection)Arrays.stream(System.getProperty("java.library.path").split(File.pathSeparator)).map(x -> NutsPath.of((String)x, (NutsSession)session)).collect(Collectors.toList())));
        props.put("os-name", session.env().getOs());
        props.put("os-family", session.env().getOsFamily());
        if (session.env().getOsDist() != null) {
            props.put("os-dist", session.env().getOsDist());
        }
        props.put("os-arch", session.env().getArch());
        props.put("os-arch-family", session.env().getArchFamily());
        props.put("os-desktop", session.env().getDesktopEnvironment());
        props.put("os-desktops", session.env().getDesktopEnvironments());
        props.put("os-desktop-family", session.env().getDesktopEnvironmentFamily());
        props.put("os-desktop-families", session.env().getDesktopEnvironmentFamilies());
        props.put("os-desktop-path", session.env().getDesktopPath());
        props.put("os-desktop-integration", session.env().getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP));
        props.put("os-menu-integration", session.env().getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU));
        props.put("os-shortcut-integration", session.env().getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT));
        props.put("os-shell", session.env().getShellFamily());
        props.put("os-shells", session.env().getShellFamilies());
        props.put("user-name", this.stringValue(System.getProperty("user.name")));
        props.put("user-home", NutsPath.ofUserHome((NutsSession)session));
        props.put("user-dir", NutsPath.ofUserDirectory((NutsSession)session));
        props.put("command-line-long", session.boot().getBootOptions().formatter().setCompact(false).getBootCommandLine());
        props.put("command-line-short", session.boot().getBootOptions().formatter().setCompact(true).getBootCommandLine());
        props.put("inherited", session.boot().getBootOptions().isInherited());
        props.put("inherited-nuts-boot-args", NutsCommandLine.of((String)System.getProperty("nuts.boot.args"), (NutsShellFamily)NutsShellFamily.SH, (NutsSession)session).format());
        props.put("inherited-nuts-args", NutsCommandLine.of((String)System.getProperty("nuts.args"), (NutsShellFamily)NutsShellFamily.SH, (NutsSession)session).format());
        props.put("creation-started", Instant.ofEpochMilli(session.boot().getCreationStartTimeMillis()));
        props.put("creation-finished", Instant.ofEpochMilli(session.boot().getCreationFinishTimeMillis()));
        props.put("creation-within", CoreTimeUtils.formatPeriodMilli(session.boot().getCreationTimeMillis()).trim());
        props.put("repositories-count", session.repos().setSession(this.getSession()).getRepositories().length);
        for (String extraKey : extraKeys) {
            props.put(extraKey, this.extraProperties.get(extraKey));
        }
        if (deep) {
            LinkedHashMap<String, Map<String, Object>> repositories = new LinkedHashMap<String, Map<String, Object>>();
            props.put("repos", repositories);
            for (NutsRepository repository : session.repos().setSession(this.getSession()).getRepositories()) {
                repositories.put(repository.getName(), this.buildRepoRepoMap(repository, deep, prefix));
            }
        }
        return props.build();
    }

    private Map<String, Object> buildRepoRepoMap(NutsRepository repo, boolean deep, String prefix) {
        NutsSession ws = this.getSession();
        FilteredMap props = new FilteredMap(this.filter);
        props.put(DefaultNutsInfoCommand.key(prefix, "name"), this.stringValue(repo.getName()));
        props.put(DefaultNutsInfoCommand.key(prefix, "global-name"), repo.config().getGlobalName());
        props.put(DefaultNutsInfoCommand.key(prefix, "uuid"), this.stringValue(repo.getUuid()));
        props.put(DefaultNutsInfoCommand.key(prefix, "type"), NutsTexts.of((NutsSession)ws).ofStyled(repo.config().getType(), NutsTextStyle.option()));
        props.put(DefaultNutsInfoCommand.key(prefix, "speed"), repo.config().getSpeed());
        props.put(DefaultNutsInfoCommand.key(prefix, "enabled"), repo.config().isEnabled());
        props.put(DefaultNutsInfoCommand.key(prefix, "index-enabled"), repo.config().isIndexEnabled());
        props.put(DefaultNutsInfoCommand.key(prefix, "index-subscribed"), repo.config().setSession(this.getSession()).isIndexSubscribed());
        props.put(DefaultNutsInfoCommand.key(prefix, "location"), repo.config().getLocation());
        props.put(DefaultNutsInfoCommand.key(prefix, "deploy-order"), repo.config().getDeployWeight());
        props.put(DefaultNutsInfoCommand.key(prefix, "store-location-strategy"), repo.config().getStoreLocationStrategy());
        props.put(DefaultNutsInfoCommand.key(prefix, "store-location"), repo.config().getStoreLocation());
        for (NutsStoreLocation value : NutsStoreLocation.values()) {
            props.put(DefaultNutsInfoCommand.key(prefix, "store-location-" + value.id()), repo.config().getStoreLocation(value));
        }
        props.put(DefaultNutsInfoCommand.key(prefix, "supported-mirroring"), repo.config().isSupportedMirroring());
        if (repo.config().isSupportedMirroring()) {
            props.put(DefaultNutsInfoCommand.key(prefix, "mirrors-count"), !repo.config().setSession(this.getSession()).isSupportedMirroring() ? 0 : repo.config().setSession(this.getSession()).getMirrors().length);
        }
        if (deep && repo.config().isSupportedMirroring()) {
            LinkedHashMap<String, Map<String, Object>> mirrors = new LinkedHashMap<String, Map<String, Object>>();
            props.put("mirrors", mirrors);
            for (NutsRepository mirror : repo.config().setSession(this.getSession()).getMirrors()) {
                mirrors.put(mirror.getName(), this.buildRepoRepoMap(mirror, deep, null));
            }
        }
        return props.build();
    }

    private String stringValue(Object s) {
        return NutsTexts.of((NutsSession)this.getSession()).builder().append((Object)CoreStringUtils.stringValue(s)).toString();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsInfoCommand setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    @Override
    public NutsInfoCommand setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public NutsWorkspaceCommand run() {
        this.println();
        return this;
    }

    private static class FilteredMap {
        private Predicate<String> filter;
        private LinkedHashMap<String, Object> data = new LinkedHashMap();

        public FilteredMap(Predicate<String> filter) {
            this.filter = filter;
        }

        public boolean accept(String s) {
            return this.filter.test(s);
        }

        public void put(String s, Supplier<Object> v) {
            if (this.filter.test(s)) {
                this.data.put(s, v.get());
            }
        }

        public void putAnyway(String s, Object v) {
            this.data.put(s, v);
        }

        public void put(String s, Object v) {
            if (this.filter.test(s)) {
                this.data.put(s, v);
            }
        }

        public Map<String, Object> build() {
            return this.data;
        }
    }
}

