/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultInternalNutsExecutableCommand;

public class DefaultNutsHelpInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    private final NutsLogger LOG;

    public DefaultNutsHelpInternalExecutable(String[] args, NutsSession session) {
        super("help", args, session);
        this.LOG = NutsLogger.of(DefaultNutsHelpInternalExecutable.class, (NutsSession)session);
    }

    @Override
    public void execute() {
        ArrayList<String> helpFor = new ArrayList<String>();
        NutsSession session = this.getSession();
        NutsCommandLine cmdLine = NutsCommandLine.of((String[])this.args, (NutsSession)session);
        boolean helpColors = false;
        block12: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            if (a.isOption()) {
                switch (a.getKey().getString()) {
                    case "--colors": 
                    case "--ntf": {
                        NutsArgument c = cmdLine.nextBoolean(new String[0]);
                        if (!c.isActive()) continue block12;
                        helpColors = c.getBooleanValue();
                        break;
                    }
                    case "-h": 
                    case "--help": {
                        cmdLine.skip();
                        break;
                    }
                    default: {
                        session.configureLast(cmdLine);
                        break;
                    }
                }
                continue;
            }
            cmdLine.skip();
            helpFor.add(a.getString());
            helpFor.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
        }
        if (helpColors) {
            NutsTexts txt = NutsTexts.of((NutsSession)session);
            NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/ntf-help.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
            session.getTerminal().out().print(n == null ? "no help found for " + this.name : n.toString());
        }
        NutsContentType outputFormat = session.getOutputFormat();
        NutsMemoryPrintStream fout = NutsPrintStream.ofInMemory((NutsSession)session);
        if (!helpColors && helpFor.isEmpty()) {
            fout.println(NutsWorkspaceExt.of(session.getWorkspace()).getHelpText(session));
            fout.flush();
        }
        for (String arg : helpFor) {
            NutsExecutableInformation w = null;
            if (arg.equals("help")) {
                fout.println(arg + " :");
                this.showDefaultHelp();
                fout.flush();
                continue;
            }
            try {
                w = session.exec().addCommand(new String[]{arg}).which();
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to execute : {0}", (Object[])new Object[]{arg}));
            }
            if (w != null) {
                fout.println(arg + " :");
                fout.println(w.getHelpText());
                fout.flush();
                continue;
            }
            session.getTerminal().err().println(arg + " : Not found");
        }
        session.out().printlnf((Object)NutsString.of((String)fout.toString(), (NutsSession)session));
    }
}

