/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.dependency.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsDependencyUtils;
import net.thevpc.nuts.runtime.standalone.id.util.NutsIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.log.NutsLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsRepositoryAndFetchMode;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsRepositoryAndFetchModeTracker;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.AbstractNutsFetchCommand;
import net.thevpc.nuts.spi.NutsDependencySolver;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsFetchCommand
extends AbstractNutsFetchCommand {
    public DefaultNutsFetchCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsContent getResultContent() {
        try {
            NutsDefinition def = this.fetchDefinition(this.getId(), this.copy().setContent(true).setEffective(false), true, false);
            return def.getContent();
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsId getResultId() {
        try {
            this.checkSession();
            NutsWorkspace ws = this.getSession().getWorkspace();
            NutsDefinition def = this.fetchDefinition(this.getId(), this, false, false);
            if (this.isEffective()) {
                return NutsWorkspaceExt.of(ws).resolveEffectiveId(def.getEffectiveDescriptor(), this.getSession());
            }
            return def.getId();
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public String getResultContentHash() {
        try {
            this.checkSession();
            NutsSession ws = this.getSession();
            Path f = this.getResultDefinition().getFile();
            return NutsDigest.of((NutsSession)ws).setSource(f).computeString();
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public String getResultDescriptorHash() {
        try {
            this.checkSession();
            return NutsDigest.of((NutsSession)this.getSession()).setSource(this.getResultDescriptor()).computeString();
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsDefinition getResultDefinition() {
        try {
            return this.fetchDefinition(this.getId(), this, this.isContent(), true);
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsDescriptor getResultDescriptor() {
        try {
            NutsDefinition def = this.fetchDefinition(this.getId(), this.copy().setContent(false), false, false);
            if (this.isEffective()) {
                return def.getEffectiveDescriptor();
            }
            return def.getDescriptor();
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsInstallInformation getResultInstallInformation() {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        NutsInstallInformation ii = dws.getInstalledRepository().getInstallInformation(this.getId(), this.session);
        if (ii != null) {
            return ii;
        }
        return DefaultNutsInstallInfo.notInstalled(this.getId());
    }

    public Path getResultPath() {
        try {
            NutsDefinition def = this.fetchDefinition(this.getId(), this.copy().setContent(true).setEffective(false), true, false);
            Path p = def.getFile();
            if (this.getLocation() != null) {
                return this.getLocation();
            }
            return p;
        }
        catch (NutsNotFoundException ex) {
            if (!this.isFailFast()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsFetchCommand copy() {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        DefaultNutsFetchCommand b = new DefaultNutsFetchCommand(ws);
        b.copyFrom(this);
        return b;
    }

    public NutsFetchCommand run() {
        this.getResultDefinition();
        return this;
    }

    public NutsDefinition fetchDefinition(NutsId id, NutsFetchCommand options, boolean includeContent, boolean includeInstallInfo) {
        NutsDefinition d = this.fetchDefinitionNoCache(id, options, includeContent, includeInstallInfo);
        return d;
    }

    public NutsDefinition fetchDefinitionNoCache(NutsId id, NutsFetchCommand options, boolean includeContent, boolean includeInstallInfo) {
        DefaultNutsDefinition foundDefinition;
        block31: {
            long startTime = System.currentTimeMillis();
            this.checkSession();
            NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(this.session);
            wu.checkLongId(id, this.session);
            NutsSession _ws = this.getSession();
            NutsWorkspaceUtils.checkSession(this.ws, options.getSession());
            NutsWorkspaceExt dws = NutsWorkspaceExt.of(_ws);
            NutsFetchStrategy nutsFetchModes = NutsWorkspaceHelper.validate(_ws.getFetchStrategy());
            NutsRepositoryFilter repositoryFilter = this.getRepositoryFilter();
            if (!NutsBlankable.isBlank((String)id.getRepository())) {
                NutsRepositoryFilter repositoryFilter2 = NutsRepositoryFilters.of((NutsSession)_ws).byName(new String[]{id.getRepository()});
                repositoryFilter = repositoryFilter2.and(repositoryFilter);
            }
            NutsRepositoryAndFetchModeTracker descTracker = new NutsRepositoryAndFetchModeTracker(wu.filterRepositoryAndFetchModes(NutsRepositorySupportedAction.SEARCH, id, repositoryFilter, nutsFetchModes, this.session));
            foundDefinition = null;
            ArrayList<Exception> reasons = new ArrayList<Exception>();
            NutsRepositoryAndFetchMode successfulDescriptorLocation = null;
            NutsRepositoryAndFetchMode successfulContentLocation = null;
            try {
                id = wu.configureFetchEnv(id);
                DefaultNutsDefinition result = null;
                for (NutsRepositoryAndFetchMode location : descTracker.available()) {
                    try {
                        result = this.fetchDescriptorAsDefinition(id, this.session, nutsFetchModes, location.getFetchMode(), location.getRepository());
                        successfulDescriptorLocation = location;
                        break;
                    }
                    catch (NutsNotFoundException exc) {
                        descTracker.addFailure(location);
                    }
                    catch (Exception ex) {
                        this._LOGOP(this.getSession()).error((Throwable)ex).level(Level.SEVERE).log(NutsMessage.jstyle((String)"unexpected error while fetching descriptor for {0}", (Object[])new Object[]{id}));
                        if (this._LOG(this.getSession()).isLoggable(Level.FINEST)) {
                            NutsLogUtils.traceMessage(this._LOG(this.getSession()), nutsFetchModes, id.getLongId(), NutsLogVerb.FAIL, "fetch def", startTime);
                        }
                        descTracker.addFailure(location);
                    }
                }
                if ((foundDefinition = result) == null) break block31;
                if (options.isEffective() || this.isDependencies()) {
                    try {
                        foundDefinition.setEffectiveDescriptor(dws.resolveEffectiveDescriptor(foundDefinition.getDescriptor(), this.session));
                    }
                    catch (NutsNotFoundException ex) {
                        this._LOGOP(this.getSession()).level(Level.WARNING).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"artifact descriptor found, but its parent is not: {0} with parent {1}", (Object[])new Object[]{id.getLongName(), Arrays.toString(foundDefinition.getDescriptor().getParents())}));
                        foundDefinition = null;
                    }
                }
                if (foundDefinition != null) {
                    if (this.isDependencies()) {
                        foundDefinition.setDependencies(NutsDependencySolver.of((NutsSession)this.getSession()).setFilter(this.buildActualDependencyFilter()).add(id.toDependency(), (NutsDefinition)foundDefinition).solve());
                    }
                    NutsInstalledRepository installedRepository = dws.getInstalledRepository();
                    if (includeContent) {
                        boolean loadedFromInstallRepo = "<main>".equals(successfulDescriptorLocation.getRepository().getUuid());
                        NutsId id1 = NutsIdUtils.createContentFaceId(foundDefinition.getId(), foundDefinition.getDescriptor(), this.session);
                        Path copyTo = options.getLocation();
                        if (copyTo != null && Files.isDirectory(copyTo, new LinkOption[0])) {
                            copyTo = copyTo.resolve(_ws.locations().getDefaultIdFilename(id1));
                        }
                        boolean contentSuccessful = false;
                        NutsRepositoryAndFetchModeTracker contentTracker = new NutsRepositoryAndFetchModeTracker(descTracker.available());
                        contentSuccessful = this.fetchContent(id1, foundDefinition, successfulDescriptorLocation, copyTo, reasons);
                        if (contentSuccessful) {
                            successfulContentLocation = successfulDescriptorLocation;
                        } else {
                            contentTracker.addFailure(successfulDescriptorLocation);
                        }
                        if (!contentSuccessful && !loadedFromInstallRepo && successfulDescriptorLocation.getFetchMode() == NutsFetchMode.LOCAL) {
                            NutsRepositoryAndFetchMode finalSuccessfulDescriptorLocation = successfulDescriptorLocation;
                            NutsRepositoryAndFetchMode n = contentTracker.available().stream().filter(x -> x.getRepository().getUuid().equals(finalSuccessfulDescriptorLocation.getRepository().getUuid()) && x.getFetchMode() == NutsFetchMode.REMOTE).findFirst().orElse(null);
                            if (n != null) {
                                contentSuccessful = this.fetchContent(id1, foundDefinition, n, copyTo, reasons);
                                if (contentSuccessful) {
                                    successfulContentLocation = n;
                                } else {
                                    contentTracker.addFailure(n);
                                }
                            }
                        }
                        if (!contentSuccessful) {
                            for (NutsRepositoryAndFetchMode repoAndMode : contentTracker.available()) {
                                contentSuccessful = this.fetchContent(id1, foundDefinition, repoAndMode, copyTo, reasons);
                                if (contentSuccessful) {
                                    successfulContentLocation = repoAndMode;
                                    break;
                                }
                                contentTracker.addFailure(repoAndMode);
                            }
                        }
                        if (contentSuccessful && loadedFromInstallRepo && successfulContentLocation != successfulDescriptorLocation) {
                            NutsRepositorySPI installedRepositorySPI = wu.repoSPI(installedRepository);
                            installedRepositorySPI.deploy().setId(foundDefinition.getId()).setDescriptor(foundDefinition.getDescriptor()).setSession(this.session.copy().setConfirm(NutsConfirmationMode.YES)).setContent(foundDefinition.getContent().getFile()).run();
                        }
                        if (!contentSuccessful) {
                            NutsLogUtils.traceMessage(this._LOG(this.getSession()), nutsFetchModes, id.getLongId(), NutsLogVerb.FAIL, "fetched descriptor but failed to fetch artifact binaries", startTime);
                        }
                    }
                    if (foundDefinition != null && includeInstallInfo) {
                        NutsInstallInformation ii = installedRepository.getInstallInformation(id, this.session);
                        if (ii != null) {
                            foundDefinition.setInstallInformation(ii);
                        } else {
                            foundDefinition.setInstallInformation(DefaultNutsInstallInfo.notInstalled(id));
                        }
                    }
                }
            }
            catch (NutsNotFoundException ex) {
                reasons.add((Exception)((Object)ex));
                NutsLogUtils.traceMessage(this._LOG(this.getSession()), nutsFetchModes, id.getLongId(), NutsLogVerb.FAIL, "fetch definition", startTime);
                throw ex;
            }
            catch (RuntimeException ex) {
                NutsLogUtils.traceMessage(this._LOG(this.getSession()), nutsFetchModes, id.getLongId(), NutsLogVerb.FAIL, "[unexpected] fetch definition", startTime);
                throw ex;
            }
        }
        if (foundDefinition != null) {
            return foundDefinition;
        }
        throw new NutsNotFoundException(this.getSession(), id);
    }

    private NutsDependencyFilter buildActualDependencyFilter() {
        this.checkSession();
        NutsDependencyFilters ff = NutsDependencyFilters.of((NutsSession)this.getSession());
        return ff.byScope(this.getScope()).and(ff.byOptional(this.getOptional())).and(this.getDependencyFilter());
    }

    protected boolean fetchContent(NutsId id1, DefaultNutsDefinition foundDefinition, NutsRepository repo0, NutsFetchStrategy nutsFetchModes, Path copyTo, List<Exception> reasons) {
        NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(this.session).repoSPI(repo0);
        for (NutsFetchMode mode : nutsFetchModes) {
            try {
                NutsContent content = repoSPI.fetchContent().setId(id1).setDescriptor(foundDefinition.getDescriptor()).setLocalPath(copyTo == null ? null : copyTo.toString()).setSession(this.session).setFetchMode(mode).getResult();
                if (content == null) continue;
                if (content.getFile() == null) {
                    content = repoSPI.fetchContent().setId(id1).setDescriptor(foundDefinition.getDescriptor()).setLocalPath(copyTo == null ? null : copyTo.toString()).setSession(this.session).setFetchMode(mode).getResult();
                }
                foundDefinition.setContent(content);
                foundDefinition.setDescriptor(this.resolveExecProperties(foundDefinition.getDescriptor(), content.getFile()));
                return true;
            }
            catch (NutsNotFoundException ex) {
                reasons.add((Exception)((Object)ex));
            }
        }
        return false;
    }

    protected boolean fetchContent(NutsId id1, DefaultNutsDefinition foundDefinition, NutsRepositoryAndFetchMode repo, Path copyTo, List<Exception> reasons) {
        NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(this.getSession()).repoSPI(repo.getRepository());
        try {
            NutsContent content = repoSPI.fetchContent().setId(id1).setDescriptor(foundDefinition.getDescriptor()).setLocalPath(copyTo == null ? null : copyTo.toString()).setSession(this.session).setFetchMode(repo.getFetchMode()).getResult();
            if (content != null) {
                if (content.getFile() == null) {
                    content = repoSPI.fetchContent().setId(id1).setDescriptor(foundDefinition.getDescriptor()).setLocalPath(copyTo == null ? null : copyTo.toString()).setSession(this.session).setFetchMode(repo.getFetchMode()).getResult();
                }
                foundDefinition.setContent(content);
                foundDefinition.setDescriptor(this.resolveExecProperties(foundDefinition.getDescriptor(), content.getFile()));
                return true;
            }
        }
        catch (NutsNotFoundException ex) {
            reasons.add((Exception)((Object)ex));
        }
        return false;
    }

    protected NutsDescriptor resolveExecProperties(NutsDescriptor nutsDescriptor, Path jar) {
        this.checkSession();
        boolean executable = nutsDescriptor.isExecutable();
        boolean nutsApp = nutsDescriptor.isApplication();
        NutsSession session = this.getSession();
        if (jar.getFileName().toString().toLowerCase().endsWith(".jar") && Files.isRegularFile(jar, new LinkOption[0])) {
            NutsPath cachePath = session.locations().getStoreLocation(nutsDescriptor.getId(), NutsStoreLocation.CACHE).resolve(session.locations().getDefaultIdFilename(nutsDescriptor.getId().builder().setFace("info.cache").build()));
            LinkedHashMap<String, String> map = null;
            NutsElements elem = NutsElements.of((NutsSession)session);
            try {
                if (cachePath.isRegularFile()) {
                    map = (Map)elem.setSession(this.session).json().parse(cachePath, Map.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map != null) {
                executable = "true".equals(map.get("executable"));
                nutsApp = "true".equals(map.get("nutsApplication"));
            } else {
                try {
                    NutsExecutionEntry[] t = NutsExecutionEntries.of((NutsSession)session).setSession(this.getSession()).parse(jar);
                    if (t.length > 0) {
                        executable = true;
                        if (t[0].isApp()) {
                            nutsApp = true;
                        }
                    }
                    try {
                        map = new LinkedHashMap<String, String>();
                        map.put("executable", String.valueOf(executable));
                        map.put("nutsApplication", String.valueOf(nutsApp));
                        elem.json().setSession(this.getSession()).setValue(map).setNtf(false).print(cachePath);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        NutsDescriptorBuilder nb = nutsDescriptor.builder();
        if (executable) {
            nb.addFlag(NutsDescriptorFlag.EXEC);
        }
        if (nutsApp) {
            nb.addFlag(NutsDescriptorFlag.APP);
        }
        return nb.build();
    }

    protected DefaultNutsDefinition fetchDescriptorAsDefinition(NutsId id, NutsSession session, NutsFetchStrategy nutsFetchModes, NutsFetchMode mode, NutsRepository repo) {
        NutsRepositorySPI repoSPI;
        NutsDescriptor descriptor;
        NutsElements elem;
        NutsWorkspaceUtils wu;
        NutsPath cachePath;
        boolean withCache;
        NutsWorkspaceExt dws;
        block23: {
            this.checkSession();
            NutsWorkspaceUtils.checkSession(this.ws, session);
            dws = NutsWorkspaceExt.of(session);
            withCache = !(repo instanceof DefaultNutsInstalledRepository);
            cachePath = null;
            wu = NutsWorkspaceUtils.of(session);
            elem = NutsElements.of((NutsSession)this.getSession());
            if (withCache && (cachePath = session.locations().getStoreLocation(id, NutsStoreLocation.CACHE, repo.getUuid()).resolve(session.locations().getDefaultIdFilename(id.builder().setFace("def.cache").build()))).isRegularFile()) {
                try {
                    if (CoreIOUtils.isObsoletePath(session, cachePath)) {
                        cachePath.delete();
                        break block23;
                    }
                    DefaultNutsDefinition d = (DefaultNutsDefinition)elem.setSession(session).json().parse(cachePath, DefaultNutsDefinition.class);
                    if (d == null) break block23;
                    NutsRepositoryManager rr = session.copy().setTransitive(Boolean.valueOf(true)).repos();
                    NutsRepository repositoryById = rr.findRepositoryById(d.getRepositoryUuid());
                    NutsRepository repositoryByName = rr.findRepositoryByName(d.getRepositoryName());
                    if (repositoryById == null || repositoryByName == null) {
                        cachePath.delete();
                        break block23;
                    }
                    NutsLogUtils.traceMessage(this._LOG(this.getSession()), nutsFetchModes, id.getLongId(), NutsLogVerb.CACHE, "fetch definition", 0L);
                    return d;
                }
                catch (Exception d) {
                    // empty catch block
                }
            }
        }
        if ((descriptor = (repoSPI = wu.repoSPI(repo)).fetchDescriptor().setId(id).setSession(session).setFetchMode(mode).getResult()) != null) {
            Map q;
            String classifier;
            NutsId nutsId = dws.resolveEffectiveId(descriptor, session);
            NutsIdBuilder newIdBuilder = nutsId.builder();
            if (NutsBlankable.isBlank((String)newIdBuilder.getRepository())) {
                newIdBuilder.setRepository(repo.getName());
            }
            if (!NutsBlankable.isBlank((String)(classifier = id.getClassifier()))) {
                newIdBuilder.setClassifier(classifier);
            }
            if (!NutsDependencyScopes.isDefaultScope((String)(q = id.getProperties()).get("scope"))) {
                newIdBuilder.setProperty("scope", (String)q.get("scope"));
            }
            if (!NutsDependencyUtils.isDefaultOptional((String)q.get("optional"))) {
                newIdBuilder.setProperty("optional", (String)q.get("optional"));
            }
            NutsId newId = newIdBuilder.build();
            NutsId apiId0 = null;
            NutsId apiId = null;
            if (!this.getId().getShortName().equals("net.thevpc.nuts:nuts")) {
                apiId = null;
                for (NutsDependency dependency : descriptor.getDependencies()) {
                    if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts") || !NutsDependencyScopes.isCompileScope(dependency.getScope())) continue;
                    apiId0 = dependency.toId().getLongId();
                }
                if (apiId0 != null) {
                    if (this.getId().getShortName().equals("net.thevpc.nuts:nuts-runtime")) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NutsIdType.RUNTIME) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NutsIdType.EXTENSION) {
                        apiId = apiId0;
                    } else if (descriptor.getIdType() == NutsIdType.COMPANION) {
                        apiId = apiId0;
                    }
                }
            }
            DefaultNutsDefinition result = new DefaultNutsDefinition(repo.getUuid(), repo.getName(), newId.getLongId(), descriptor, null, null, apiId, session);
            if (withCache) {
                try {
                    elem.json().setSession(session).setValue((Object)result).setNtf(false).print(cachePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        throw new NutsNotFoundException(session, id);
    }

    public static class ScopePlusOptionsCache {
        public NutsDependencyScope[] scopes;
        public Boolean optional;

        public int keyHashCode() {
            int s = 0;
            if (this.scopes != null) {
                Arrays.sort(this.scopes);
                for (NutsDependencyScope element : this.scopes) {
                    s = 31 * s + (element == null ? 0 : element.id().hashCode());
                }
            }
            return s * 31 + (this.optional == null ? 0 : this.optional.hashCode());
        }
    }
}

