/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNutsQueryBaseOptions;

public abstract class AbstractNutsFetchCommand
extends DefaultNutsQueryBaseOptions<NutsFetchCommand>
implements NutsFetchCommand {
    private NutsId id;

    public AbstractNutsFetchCommand(NutsWorkspace ws) {
        super(ws, "fetch");
        this.setFailFast(true);
    }

    public NutsFetchCommand setId(String id) {
        this.checkSession();
        this.id = NutsId.of((String)id, (NutsSession)this.session);
        return this;
    }

    public NutsFetchCommand setNutsApi() {
        return this.setId(this.ws.getApiId());
    }

    public NutsFetchCommand setNutsRuntime() {
        return this.setId(this.ws.getRuntimeId());
    }

    public NutsFetchCommand setId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsParseException(this.session, NutsMessage.formatted((String)"invalid Id format : null"));
        }
        this.id = id;
        return this;
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsFetchCommand copyFrom(NutsFetchCommand other) {
        super.copyFromDefaultNutsQueryBaseOptions((DefaultNutsQueryBaseOptions)other);
        if (other != null) {
            NutsFetchCommand o = other;
            this.id = o.getId();
        }
        return this;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--not-installed": {
                cmdLine.skip();
                if (enabled) {
                    this.setRepositoryFilter(NutsRepositoryFilters.of((NutsSession)this.getSession()).installedRepo().neg().and(this.getRepositoryFilter()));
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                cmdLine.skip();
                if (enabled) {
                    this.setRepositoryFilter(NutsRepositoryFilters.of((NutsSession)this.session).installedRepo().and(this.getRepositoryFilter()));
                }
                return true;
            }
        }
        return super.configureFirst(cmdLine);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{failFast=" + this.isFailFast() + ", optional=" + this.getOptional() + ", scope=" + this.getScope() + ", content=" + this.isContent() + ", inlineDependencies=" + this.isInlineDependencies() + ", dependencies=" + this.isDependencies() + ", effective=" + this.isEffective() + ", location=" + this.getLocation() + ", repos=" + this.getRepositoryFilter() + ", displayOptions=" + this.getDisplayOptions() + ", id=" + this.getId() + ", session=" + this.getSession() + '}';
    }
}

