/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNutsExecutableCommand;

public class DefaultNutsSystemExecutable
extends AbstractNutsExecutableCommand {
    String[] cmd;
    String[] executorOptions;
    NutsSession session;
    NutsSession execSession;
    NutsExecCommand execCommand;
    private boolean showCommand = false;
    private final boolean inheritSystemIO;

    public DefaultNutsSystemExecutable(String[] cmd, String[] executorOptions, NutsSession session, NutsSession execSession, NutsExecCommand execCommand) {
        super(cmd[0], NutsCommandLine.of((String[])cmd, (NutsSession)session).toString(), NutsExecutableType.SYSTEM);
        this.inheritSystemIO = execCommand.isInheritSystemIO();
        this.cmd = cmd;
        this.execCommand = execCommand;
        this.executorOptions = executorOptions == null ? new String[]{} : executorOptions;
        this.session = session;
        this.execSession = execSession;
        NutsCommandLine cmdLine = NutsCommandLine.of((String[])this.executorOptions, (NutsSession)session);
        block6: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            switch (a.getKey().getString()) {
                case "--show-command": {
                    this.showCommand = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
    }

    public NutsId getId() {
        return null;
    }

    private ProcessExecHelper resolveExecHelper() {
        HashMap<String, String> e2 = null;
        Map env1 = this.execCommand.getEnv();
        if (env1 != null) {
            e2 = new HashMap<String, String>(env1);
        }
        return ProcessExecHelper.ofArgs(this.execCommand.getCommand(), e2, this.execCommand.getDirectory() == null ? null : NutsPath.of((String)this.execCommand.getDirectory(), (NutsSession)this.session).toFile(), this.session.getTerminal(), this.execSession.getTerminal(), this.showCommand, true, this.execCommand.getSleepMillis(), this.inheritSystemIO, false, null, null, this.execCommand.getRunAs(), this.session);
    }

    @Override
    public void execute() {
        this.resolveExecHelper().exec();
    }

    @Override
    public void dryExecute() {
        this.resolveExecHelper().dryExec();
    }

    @Override
    public String getHelpText() {
        switch (this.execSession.env().getOsFamily()) {
            case WINDOWS: {
                return "No help available. Try " + this.getName() + " /help";
            }
        }
        return "No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'";
    }

    public String toString() {
        return this.execCommand.getRunAs() + " " + NutsCommandLine.of((String[])this.cmd, (NutsSession)this.session).toString();
    }
}

