/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.NutsSysExecUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNutsExecutableCommand;

public class DefaultNutsOpenExecutable
extends AbstractNutsExecutableCommand {
    String[] cmd;
    String[] executorOptions;
    NutsSession session;
    NutsSession execSession;
    NutsExecCommand execCommand;
    private boolean showCommand = false;
    private String[] effectiveOpenExecutable;

    public DefaultNutsOpenExecutable(String[] cmd, String[] executorOptions, NutsSession session, NutsSession execSession, NutsExecCommand execCommand) {
        super(cmd[0], NutsCommandLine.of((String[])cmd, (NutsSession)session).toString(), NutsExecutableType.SYSTEM);
        this.cmd = cmd;
        this.execCommand = execCommand;
        this.executorOptions = executorOptions == null ? new String[]{} : executorOptions;
        this.session = session;
        this.execSession = execSession;
        NutsCommandLine cmdLine = NutsCommandLine.of((String[])this.executorOptions, (NutsSession)session);
        block11: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            switch (a.getKey().getString()) {
                case "--show-command": {
                    this.showCommand = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block11;
                }
            }
            cmdLine.skip();
        }
        switch (session.env().getOsFamily()) {
            case LINUX: {
                Path execPath = NutsSysExecUtils.sysWhich("xdg-open");
                if (execPath != null) {
                    this.effectiveOpenExecutable = new String[]{execPath.toString()};
                    break;
                }
                execPath = NutsSysExecUtils.sysWhich("gnome-open");
                if (execPath != null) {
                    this.effectiveOpenExecutable = new String[]{execPath.toString()};
                    break;
                }
                execPath = NutsSysExecUtils.sysWhich("cygstart");
                if (execPath == null) break;
                this.effectiveOpenExecutable = new String[]{execPath.toString()};
                break;
            }
            case WINDOWS: {
                this.effectiveOpenExecutable = new String[]{"cmd", "/c", "start"};
                break;
            }
            case MACOS: {
                Path execPath = NutsSysExecUtils.sysWhich("open");
                if (execPath == null) break;
                this.effectiveOpenExecutable = new String[]{execPath.toString()};
                break;
            }
        }
    }

    public NutsId getId() {
        return null;
    }

    private NutsExecCommand resolveExecHelper() {
        if (this.effectiveOpenExecutable == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unable to resolve viewer for %s", (Object[])new Object[]{this.cmd[0]}));
        }
        NutsExecCommand cc = this.execCommand.copy();
        cc.setExecutionType(NutsExecutionType.SYSTEM);
        ArrayList<String> ss = new ArrayList<String>(Arrays.asList(this.effectiveOpenExecutable));
        ss.addAll(Arrays.asList(this.cmd));
        cc.setCommand(ss);
        return cc;
    }

    @Override
    public void execute() {
        this.resolveExecHelper().setDry(false).run();
    }

    @Override
    public void dryExecute() {
        this.resolveExecHelper().setDry(true).run();
    }

    @Override
    public String getHelpText() {
        switch (this.execSession.env().getOsFamily()) {
            case WINDOWS: {
                return "No help available. Try " + this.getName() + " /help";
            }
        }
        return "No help available. Try 'man " + this.getName() + "' or '" + this.getName() + " --help'";
    }

    public String toString() {
        if (this.effectiveOpenExecutable == null) {
            return "FAIL TO OPEN " + NutsCommandLine.of((String[])this.cmd, (NutsSession)this.session).toString();
        }
        return "OPEN with " + this.effectiveOpenExecutable[0] + " : " + NutsCommandLine.of((String[])this.cmd, (NutsSession)this.session).toString();
    }
}

