/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsCommandExecOptions;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExceptionBase;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTooManyElementsException;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.standalone.executor.ArtifactExecutorComponent;
import net.thevpc.nuts.runtime.standalone.executor.system.NutsSysExecUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsExecutableInformationExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.DefaultNutsDeployInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNutsExecCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsArtifactExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsArtifactPathExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsExecInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsOpenExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsSystemExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultUnknownExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.DefaultNutsFetchInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.help.DefaultNutsHelpInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.info.DefaultNutsInfoInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.DefaultNutsInstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.DefaultNutsReinstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.license.DefaultNutsLicenseInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.push.DefaultNutsPushInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNutsSearchInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.DefaultNutsSettingsInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.alias.DefaultNutsAliasExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy.DefaultNutsUndeployInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall.DefaultNutsUninstallInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNutsCheckUpdatesInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNutsUpdateInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.version.DefaultNutsVersionInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.welcome.DefaultNutsWelcomeInternalExecutable;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.which.DefaultNutsWhichInternalExecutable;
import net.thevpc.nuts.spi.NutsExecutorComponent;

public class DefaultNutsExecCommand
extends AbstractNutsExecCommand {
    public DefaultNutsExecCommand(DefaultNutsWorkspace ws) {
        super(ws);
    }

    public NutsExecutableInformation which() {
        this.checkSession();
        NutsSession traceSession = this.getSession();
        NutsSession execSession = traceSession.copy();
        NutsSessionTerminal terminal = NutsSessionTerminal.of((NutsSessionTerminal)traceSession.getTerminal(), (NutsSession)execSession);
        if (this.in != null) {
            terminal.setIn(this.in);
        }
        if (this.out != null) {
            terminal.setOut(this.out);
        }
        if (this.isRedirectErrorStream()) {
            if (this.out != null) {
                terminal.setErr(this.out);
            } else {
                terminal.setErr(traceSession.getTerminal().out());
            }
        }
        terminal.out().flush();
        terminal.err().flush();
        if (this.command == null || this.command.size() == 0) {
            throw new NutsIllegalArgumentException(traceSession, NutsMessage.plain((String)"missing command"));
        }
        String[] ts = this.command.toArray(new String[0]);
        NutsExecutableInformationExt exec = null;
        execSession.setTerminal(terminal);
        NutsExecutionType executionType = this.getExecutionType();
        NutsRunAs runAs = this.getRunAs();
        if (executionType == null) {
            executionType = this.session.getExecutionType();
        }
        if (executionType == null) {
            executionType = NutsExecutionType.SPAWN;
        }
        switch (executionType) {
            case OPEN: {
                if (this.commandDefinition != null) {
                    throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to run open artifact", (Object[])new Object[0]));
                }
                exec = new DefaultNutsOpenExecutable(ts, this.getExecutorOptions(), traceSession, execSession, this);
                break;
            }
            case SYSTEM: {
                Path p;
                if (this.commandDefinition != null) {
                    throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)("unable to run artifact as " + executionType + "cmd"), (Object[])new Object[0]));
                }
                ArrayList<String> tsl = new ArrayList<String>(Arrays.asList(ts));
                if (CoreStringUtils.firstIndexOf(ts[0], new char[]{'/', '\\'}) < 0 && (p = NutsSysExecUtils.sysWhich(ts[0])) != null) {
                    tsl.set(0, p.toString());
                }
                exec = new DefaultNutsSystemExecutable(tsl.toArray(new String[0]), this.getExecutorOptions(), traceSession, execSession, this);
                break;
            }
            case SPAWN: 
            case EMBEDDED: {
                if (this.commandDefinition != null) {
                    return this.ws_execDef(this.commandDefinition, this.commandDefinition.getId().getLongName(), ts, this.getExecutorOptions(), this.env, this.directory, this.failFast, executionType, runAs, traceSession, execSession);
                }
                exec = this.execEmbeddedOrExternal(ts, this.getExecutorOptions(), traceSession, execSession);
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid execution type %s", (Object[])new Object[]{executionType}));
            }
        }
        return exec;
    }

    public NutsExecCommand run() {
        block7: {
            this.checkSession();
            NutsExecutableInformationExt exec = (NutsExecutableInformationExt)this.which();
            this.executed = true;
            try {
                if (this.dry) {
                    exec.dryExecute();
                } else {
                    exec.execute();
                }
            }
            catch (NutsExecutionException ex) {
                String p = this.getExtraErrorMessage();
                this.result = p != null ? new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"execution failed with code %s and message : %s", (Object[])new Object[]{ex.getExitCode(), p}), (Throwable)ex, ex.getExitCode()) : ex;
            }
            catch (Exception ex) {
                String p = this.getExtraErrorMessage();
                NutsExceptionBase ee = NutsExceptionBase.detectExceptionBase((Throwable)ex);
                int exitCode = 244;
                if (ee instanceof NutsExecutionException) {
                    exitCode = ((NutsExecutionException)ee).getExitCode();
                }
                if (exitCode == 0) break block7;
                this.result = p != null ? new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"execution failed with code %s and message :  of : %s ; error was : %s ; notes : %s", (Object[])new Object[]{244, exec, ex, p}), (Throwable)ex, exitCode) : new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"execution failed of : %s ; error was : %s", (Object[])new Object[]{exec, ex}), (Throwable)ex, exitCode);
            }
        }
        if (this.result != null && this.result.getExitCode() != 0 && this.failFast) {
            throw this.result;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NutsExecutableInformationExt execEmbeddedOrExternal(String[] cmd, String[] executorOptions, NutsSession prepareSession, NutsSession execSession) {
        if (cmd == null || cmd.length == 0) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing command", (Object[])new Object[0]));
        }
        String[] args = new String[cmd.length - 1];
        System.arraycopy(cmd, 1, args, 0, args.length);
        String cmdName = cmd[0];
        NutsExecutionType executionType = this.getExecutionType();
        if (executionType == null) {
            executionType = this.session.getExecutionType();
        }
        if (executionType == null) {
            executionType = NutsExecutionType.SPAWN;
        }
        NutsRunAs runAs = this.getRunAs();
        CmdKind cmdKind = null;
        NutsId goodId = null;
        String goodKw = null;
        boolean forceInstalled = false;
        if (cmdName.endsWith("!")) {
            goodId = NutsIdParser.of((NutsSession)this.session).setLenient(true).parse(cmdName.substring(0, cmdName.length() - 1));
            if (goodId != null) {
                forceInstalled = true;
            }
        } else {
            goodId = NutsIdParser.of((NutsSession)this.session).setLenient(true).parse(cmdName);
        }
        if (cmdName.contains("/") || cmdName.contains("\\")) {
            cmdKind = goodId != null ? CmdKind.ID : CmdKind.PATH;
        } else if (cmdName.contains(":") || cmdName.contains("#")) {
            if (goodId == null) throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"unable to resolve id %", (Object[])new Object[]{cmdName}));
            cmdKind = CmdKind.ID;
        } else {
            if (cmdName.endsWith("!")) {
                goodKw = cmdName.substring(0, cmdName.length() - 1);
                forceInstalled = true;
            } else {
                goodKw = cmdName;
            }
            cmdKind = CmdKind.KEYWORD;
        }
        switch (cmdKind) {
            case PATH: {
                return new DefaultNutsArtifactPathExecutable(cmdName, args, executorOptions, executionType, runAs, prepareSession, execSession, this, this.isInheritSystemIO());
            }
            case ID: {
                NutsId idToExec = this.findExecId(goodId, prepareSession, forceInstalled, true);
                if (idToExec == null) throw new NutsNotFoundException(this.getSession(), goodId);
                return this.ws_execId(idToExec, cmdName, args, executorOptions, executionType, runAs, prepareSession, execSession);
            }
            case KEYWORD: {
                switch (goodKw) {
                    case "update": {
                        return new DefaultNutsUpdateInternalExecutable(args, execSession);
                    }
                    case "check-updates": {
                        return new DefaultNutsCheckUpdatesInternalExecutable(args, execSession);
                    }
                    case "install": {
                        return new DefaultNutsInstallInternalExecutable(args, execSession);
                    }
                    case "reinstall": {
                        return new DefaultNutsReinstallInternalExecutable(args, execSession);
                    }
                    case "uninstall": {
                        return new DefaultNutsUninstallInternalExecutable(args, execSession);
                    }
                    case "deploy": {
                        return new DefaultNutsDeployInternalExecutable(args, execSession);
                    }
                    case "undeploy": {
                        return new DefaultNutsUndeployInternalExecutable(args, execSession);
                    }
                    case "push": {
                        return new DefaultNutsPushInternalExecutable(args, execSession);
                    }
                    case "fetch": {
                        return new DefaultNutsFetchInternalExecutable(args, execSession);
                    }
                    case "search": {
                        return new DefaultNutsSearchInternalExecutable(args, execSession);
                    }
                    case "version": {
                        return new DefaultNutsVersionInternalExecutable(args, execSession, this);
                    }
                    case "license": {
                        return new DefaultNutsLicenseInternalExecutable(args, execSession);
                    }
                    case "help": {
                        return new DefaultNutsHelpInternalExecutable(args, execSession);
                    }
                    case "welcome": {
                        return new DefaultNutsWelcomeInternalExecutable(args, execSession);
                    }
                    case "info": {
                        return new DefaultNutsInfoInternalExecutable(args, execSession);
                    }
                    case "which": {
                        return new DefaultNutsWhichInternalExecutable(args, execSession, this);
                    }
                    case "exec": {
                        return new DefaultNutsExecInternalExecutable(args, execSession, this);
                    }
                    case "settings": {
                        return new DefaultNutsSettingsInternalExecutable(args, execSession);
                    }
                }
                NutsWorkspaceCustomCommand command = null;
                command = prepareSession.commands().findCommand(goodKw);
                if (command != null) {
                    NutsCommandExecOptions o = new NutsCommandExecOptions().setExecutorOptions(executorOptions).setDirectory(this.directory).setFailFast(this.failFast).setExecutionType(executionType).setEnv(this.env);
                    return new DefaultNutsAliasExecutable(command, o, execSession, args);
                }
                NutsId idToExec = null;
                if (goodId != null) {
                    idToExec = this.findExecId(goodId, prepareSession, forceInstalled, true);
                }
                if (idToExec != null) return this.ws_execId(idToExec, cmdName, args, executorOptions, executionType, runAs, prepareSession, execSession);
                Path sw = NutsSysExecUtils.sysWhich(cmdName);
                if (sw != null) {
                    ArrayList<String> cmdArr = new ArrayList<String>();
                    cmdArr.add(sw.toString());
                    cmdArr.addAll(Arrays.asList(args));
                    return new DefaultNutsSystemExecutable(cmdArr.toArray(new String[0]), executorOptions, prepareSession, execSession, this);
                }
                ArrayList<String> cmdArr = new ArrayList<String>();
                cmdArr.add(cmdName);
                cmdArr.addAll(Arrays.asList(args));
                return new DefaultUnknownExecutable(cmdArr.toArray(new String[0]), execSession);
            }
        }
        throw new NutsNotFoundException(this.getSession(), goodId, NutsMessage.cstyle((String)"unable to resolve id %", (Object[])new Object[]{cmdName}));
    }

    protected NutsId findExecId(NutsId nid, NutsSession traceSession, boolean forceInstalled, boolean ignoreIfUserCommand) {
        NutsWorkspace ws = traceSession.getWorkspace();
        if (nid == null) {
            return null;
        }
        List ff = traceSession.search().addId(nid).setOptional(Boolean.valueOf(false)).setLatest(true).setFailFast(false).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)this.session).byDeployed(true)).getResultDefinitions().stream().sorted(Comparator.comparing(x -> !x.getInstallInformation().isDefaultVersion())).map(NutsDefinition::getId).collect(Collectors.toList());
        if (ff.isEmpty() && !forceInstalled) {
            if (ignoreIfUserCommand && this.isUserCommand(nid.toString())) {
                return null;
            }
            if (traceSession.isPlainTrace()) {
                traceSession.out().resetLine().printf("%s is %s, will search for it online. Type ```error CTRL^C``` to stop...\n", new Object[]{nid, NutsTexts.of((NutsSession)this.session).ofStyled("not installed", NutsTextStyle.error())});
                traceSession.out().flush();
            }
            ff = traceSession.search().addId(nid).setSession(traceSession.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setOptional(Boolean.valueOf(false)).setFailFast(false).setLatest(true).getResultIds().toList();
        }
        if (ff.isEmpty()) {
            return null;
        }
        List versions = ff.stream().map(NutsId::getVersion).distinct().collect(Collectors.toList());
        if (versions.size() > 1) {
            throw new NutsTooManyElementsException(this.getSession(), NutsMessage.cstyle((String)"%s can be resolved to all (%d) of %s", (Object[])new Object[]{nid, ff.size(), ff}));
        }
        return (NutsId)ff.get(0);
    }

    public boolean isUserCommand(String s) {
        this.checkSession();
        NutsSession ws = this.getSession();
        String p = System.getenv().get("PATH");
        if (p != null) {
            char r = File.pathSeparatorChar;
            block3: for (String z : p.split("" + r)) {
                Path t = Paths.get(z, new String[0]);
                switch (ws.env().getOsFamily()) {
                    case WINDOWS: {
                        if (Files.isRegularFile(t.resolve(s), new LinkOption[0])) {
                            return true;
                        }
                        if (Files.isRegularFile(t.resolve(s + ".exe"), new LinkOption[0])) {
                            return true;
                        }
                        if (!Files.isRegularFile(t.resolve(s + ".bat"), new LinkOption[0])) continue block3;
                        return true;
                    }
                    default: {
                        Path fp = t.resolve(s);
                        if (!Files.isRegularFile(fp, new LinkOption[0])) continue block3;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected NutsExecutableInformationExt ws_execId(NutsId goodId, String commandName, String[] appArgs, String[] executorOptions, NutsExecutionType executionType, NutsRunAs runAs, NutsSession session, NutsSession execSession) {
        NutsDefinition def = session.fetch().setId(goodId).setDependencies(true).setFailFast(true).setEffective(true).setContent(true).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(NutsDependencyFilters.of((NutsSession)session).byRunnable()).getResultDefinition();
        return this.ws_execDef(def, commandName, appArgs, executorOptions, this.env, this.directory, this.failFast, executionType, runAs, session, execSession);
    }

    protected NutsExecutableInformationExt ws_execDef(NutsDefinition def, String commandName, String[] appArgs, String[] executorOptions, Map<String, String> env, String dir, boolean failFast, NutsExecutionType executionType, NutsRunAs runAs, NutsSession traceSession, NutsSession execSession) {
        return new DefaultNutsArtifactExecutable(def, commandName, appArgs, executorOptions, env, dir, failFast, traceSession, execSession, executionType, runAs, this);
    }

    public void ws_execId(NutsDefinition def, String commandName, String[] appArgs, String[] executorOptions, Map<String, String> env, String dir, boolean failFast, boolean temporary, NutsSession session, NutsSession execSession, NutsExecutionType executionType, NutsRunAs runAs, boolean dry) {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        this.session.security().checkAllowed("exec", commandName);
        NutsWorkspaceUtils.checkSession(ws, execSession);
        NutsWorkspaceUtils.checkSession(ws, session);
        if (def != null && def.getFile() != null) {
            NutsId eid;
            NutsDescriptor descriptor = def.getDescriptor();
            if (!descriptor.isExecutable()) {
                // empty if block
            }
            NutsArtifactCall executorCall = descriptor.getExecutor();
            NutsExecutorComponent execComponent = null;
            ArrayList<String> executorArgs = new ArrayList<String>();
            Map execProps = null;
            if (executorCall != null && (eid = executorCall.getId()) != null) {
                if (eid.getGroupId() == null) {
                    if (eid.getArtifactId().equals("nuts")) {
                        eid = eid.builder().setGroupId("net.thevpc.nuts").build();
                    } else if (eid.getArtifactId().equals("nsh")) {
                        eid = eid.builder().setGroupId("net.thevpc.nuts.toolbox").build();
                    }
                }
                if (eid.getGroupId() != null) {
                    NutsStream q = this.getSession().search().addId(eid).setLatest(true).setDistinct(true).getResultDefinitions();
                    NutsDefinition[] availableExecutors = (NutsDefinition[])q.stream().limit(2L).toArray(NutsDefinition[]::new);
                    if (availableExecutors.length > 1) {
                        throw new NutsTooManyElementsException(this.session, NutsMessage.cstyle((String)"too many results for executor %s", (Object[])new Object[]{eid}));
                    }
                    if (availableExecutors.length == 1) {
                        execComponent = new ArtifactExecutorComponent(availableExecutors[0].getId(), this.session);
                    } else {
                        throw new NutsNotFoundException(this.session, eid, NutsMessage.cstyle((String)"executor not found %s", (Object[])new Object[]{eid}));
                    }
                }
            }
            if (execComponent == null) {
                execComponent = (NutsExecutorComponent)this.getSession().extensions().createSupported(NutsExecutorComponent.class, true, (Object)def);
            }
            if (executorCall != null) {
                executorArgs.addAll(Arrays.asList(executorCall.getArguments()));
                execProps = executorCall.getProperties();
            }
            executorArgs.addAll(Arrays.asList(executorOptions));
            NutsExecutionContextBuilder ecb = NutsWorkspaceExt.of(ws).createExecutionContext();
            NutsExecutionContext executionContext = ecb.setDefinition(def).setArguments(appArgs).setExecutorArguments(executorArgs.toArray(new String[0])).setEnv(env).setExecutorProperties(execProps).setCwd(dir).setWorkspace(session.getWorkspace()).setSession(session).setExecSession(execSession).setFailFast(failFast).setTemporary(temporary).setExecutionType(executionType).setRunAs(runAs).setCommandName(commandName).setSleepMillis(this.getSleepMillis()).setInheritSystemIO(this.isInheritSystemIO()).setRedirectOuputFile(this.getRedirectOutputFile()).setRedirectInpuFile(this.getRedirectInputFile()).build();
            if (dry) {
                execComponent.dryExec(executionContext);
            } else {
                execComponent.exec(executionContext);
            }
            return;
        }
        throw new NutsNotFoundException(this.getSession(), def == null ? null : def.getId());
    }

    static enum CmdKind {
        PATH,
        ID,
        KEYWORD;

    }
}

