/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NutsDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.io.util.URLBuilder;
import net.thevpc.nuts.runtime.standalone.io.util.ZipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNutsExecutableCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.CharacterizedExecFile;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsExecCommand;
import net.thevpc.nuts.spi.NutsDependencySolver;

public class DefaultNutsArtifactPathExecutable
extends AbstractNutsExecutableCommand {
    private final NutsLogger LOG;
    String cmdName;
    String[] args;
    String[] executorOptions;
    NutsExecutionType executionType;
    NutsRunAs runAs;
    NutsSession session;
    NutsSession execSession;
    DefaultNutsExecCommand execCommand;

    public DefaultNutsArtifactPathExecutable(String cmdName, String[] args, String[] executorOptions, NutsExecutionType executionType, NutsRunAs runAs, NutsSession session, NutsSession execSession, DefaultNutsExecCommand execCommand, boolean inheritSystemIO) {
        super(cmdName, NutsCommandLine.of((String[])args, (NutsSession)execSession).toString(), NutsExecutableType.ARTIFACT);
        this.LOG = NutsLogger.of(DefaultNutsArtifactPathExecutable.class, (NutsSession)session);
        this.runAs = runAs;
        this.cmdName = cmdName;
        this.args = args;
        this.executionType = executionType;
        this.session = session;
        this.execSession = execSession;
        this.execCommand = execCommand;
        ArrayList<String> executorOptionsList = new ArrayList<String>();
        for (String option : executorOptions) {
            NutsArgument a = NutsArgument.of((String)option, (NutsSession)session);
            executorOptionsList.add(option);
        }
        this.executorOptions = executorOptionsList.toArray(new String[0]);
    }

    public NutsId getId() {
        try (CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(NutsStreamOrPath.of(this.cmdName, this.session), this.session, this.executorOptions);){
            NutsId nutsId = c.descriptor == null ? null : c.descriptor.getId();
            return nutsId;
        }
    }

    @Override
    public void execute() {
        this.executeHelper(false);
    }

    @Override
    public void dryExecute() {
        this.executeHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeHelper(boolean dry) {
        try (CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(NutsStreamOrPath.of(this.cmdName, this.session), this.session, this.executorOptions);){
            if (c.descriptor == null) {
                throw new NutsNotFoundException(this.execSession, null, NutsMessage.cstyle((String)"unable to resolve a valid descriptor for %s", (Object[])new Object[]{this.cmdName}), null);
            }
            String tempFolder = NutsTmp.of((NutsSession)this.session).createTempFolder("exec-path-").toString();
            NutsId _id = c.descriptor.getId();
            DefaultNutsDefinition nutToRun = new DefaultNutsDefinition(null, null, _id.getLongId(), c.descriptor, (NutsContent)new NutsDefaultContent(NutsPath.of((Path)c.contentFile, (NutsSession)this.execSession), false, c.temps.size() > 0), DefaultNutsInstallInfo.notInstalled(_id), null, this.session);
            NutsDependencySolver resolver = NutsDependencySolver.of((NutsSession)this.session);
            NutsDependencyFilters ff = NutsDependencyFilters.of((NutsSession)this.session);
            resolver.setFilter(ff.byScope(NutsDependencyScopePattern.RUN));
            for (NutsDependency dependency : c.descriptor.getDependencies()) {
                resolver.add(dependency);
            }
            nutToRun.setDependencies(resolver.solve());
            try {
                this.execCommand.ws_execId(nutToRun, this.cmdName, this.args, this.executorOptions, this.execCommand.getEnv(), this.execCommand.getDirectory(), this.execCommand.isFailFast(), true, this.session, this.execSession, this.executionType, this.runAs, dry);
            }
            catch (Throwable throwable) {
                try {
                    CoreIOUtils.delete(this.session, Paths.get(tempFolder, new String[0]));
                }
                catch (UncheckedIOException | NutsIOException e) {
                    this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to delete temp folder created for execution : {0}", (Object[])new Object[]{tempFolder}));
                }
                throw throwable;
            }
            try {
                CoreIOUtils.delete(this.session, Paths.get(tempFolder, new String[0]));
            }
            catch (UncheckedIOException | NutsIOException e) {
                this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to delete temp folder created for execution : {0}", (Object[])new Object[]{tempFolder}));
            }
        }
    }

    public static CharacterizedExecFile characterizeForExec(NutsStreamOrPath contentFile, NutsSession session, String[] execOptions) {
        CharacterizedExecFile c;
        block32: {
            String classifier = null;
            c = new CharacterizedExecFile(session);
            try {
                c.streamOrPath = contentFile;
                Path fileSource = c.contentFile = CoreIOUtils.toPathInputSource(contentFile, c.temps, session);
                if (!Files.exists(fileSource, new LinkOption[0])) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"file does not exists %s", (Object[])new Object[]{fileSource}));
                }
                if (Files.isDirectory(fileSource, new LinkOption[0])) {
                    Path ext = fileSource.resolve("nuts.json");
                    c.descriptor = Files.exists(ext, new LinkOption[0]) ? NutsDescriptorParser.of((NutsSession)session).parse(ext) : NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.contentFile, execOptions, session);
                    if (c.descriptor == null) break block32;
                    if ("zip".equals(c.descriptor.getPackaging())) {
                        Path zipFilePath = NutsPath.of((String)(fileSource + ".zip"), (NutsSession)session).toAbsolute().toFile();
                        ZipUtils.zip(session, fileSource.toString(), new ZipOptions(), zipFilePath.toString());
                        c.contentFile = zipFilePath;
                        c.addTemp(zipFilePath);
                        break block32;
                    }
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid nuts folder source. expected 'zip' ext in descriptor", (Object[])new Object[0]));
                }
                if (Files.isRegularFile(fileSource, new LinkOption[0])) {
                    if (c.contentFile.getFileName().toString().endsWith("nuts.json")) {
                        try (InputStream in = Files.newInputStream(c.contentFile, new OpenOption[0]);){
                            c.descriptor = NutsDescriptorParser.of((NutsSession)session).parse(in);
                        }
                        c.contentFile = null;
                        if (c.streamOrPath.isPath() && c.streamOrPath.getPath().isURL()) {
                            URLBuilder ub = new URLBuilder(c.streamOrPath.getPath().toURL().toString());
                            try {
                                c.contentFile = CoreIOUtils.toPathInputSource(NutsStreamOrPath.of(ub.resolveSibling(session.locations().getDefaultIdFilename(c.descriptor.getId())).toURL(), session), c.temps, session);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (c.contentFile == null) {
                            for (NutsIdLocation location0 : c.descriptor.getLocations()) {
                                if (!CoreFilterUtils.acceptClassifier(location0, classifier)) continue;
                                String location = location0.getUrl();
                                if (NutsPath.of((String)location, (NutsSession)session).isHttp()) {
                                    try {
                                        c.contentFile = CoreIOUtils.toPathInputSource(NutsStreamOrPath.of(new URL(location), session), c.temps, session);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    URLBuilder ub = new URLBuilder(c.streamOrPath.getPath().toURL().toString());
                                    try {
                                        c.contentFile = CoreIOUtils.toPathInputSource(NutsStreamOrPath.of(ub.resolveSibling(session.locations().getDefaultIdFilename(c.descriptor.getId())).toURL(), session), c.temps, session);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (c.contentFile == null) break;
                            }
                        }
                        if (c.contentFile == null) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to locale package for %s", (Object[])new Object[]{c.streamOrPath}));
                        }
                        break block32;
                    }
                    c.descriptor = NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.contentFile, execOptions, session);
                    if (c.descriptor == null) {
                        CoreDigestHelper d = new CoreDigestHelper(session);
                        d.append(c.contentFile);
                        String artifactId = d.getDigest();
                        c.descriptor = NutsDescriptorBuilder.of((NutsSession)session).setId("temp:" + artifactId + "#1.0").setPackaging(CoreIOUtils.getFileExtension(contentFile.getName())).build();
                    }
                    break block32;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"path does not denote a valid file or folder %s", (Object[])new Object[]{c.streamOrPath}));
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        return c;
    }

    public String toString() {
        return "NUTS " + this.cmdName + " " + NutsCommandLine.of((String[])this.args, (NutsSession)this.execSession).toString();
    }
}

