/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.exec;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutableType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.app.util.NutsAppUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.AbstractNutsExecutableCommand;

public abstract class DefaultInternalNutsExecutableCommand
extends AbstractNutsExecutableCommand {
    protected String[] args;
    private NutsSession session;

    public DefaultInternalNutsExecutableCommand(String name, String[] args, NutsSession session) {
        super(name, name, NutsExecutableType.INTERNAL);
        this.args = args;
        this.session = session;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsId getId() {
        return null;
    }

    protected void showDefaultHelp() {
        this.session.out().println(this.getHelpText());
    }

    @Override
    public String getHelpText() {
        NutsTexts txt = NutsTexts.of((NutsSession)this.getSession());
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/command/" + this.name + ".ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        if (n == null) {
            return "no help found for " + this.name;
        }
        return n.toString();
    }

    @Override
    public void dryExecute() {
        NutsSession session = this.getSession();
        if (NutsAppUtils.processHelpOptions(this.args, this.getSession())) {
            if (this.getSession().isPlainOut()) {
                session.out().println("[dry] ==show-help==");
            } else {
                session.out().printlnf((Object)"[dry] ==show-help==");
            }
            return;
        }
        NutsTexts text = NutsTexts.of((NutsSession)session);
        if (this.getSession().isPlainOut()) {
            session.out().printlnf("[dry] %s%n", new Object[]{text.builder().append((Object)"internal", NutsTextStyle.pale()).append((Object)" ").append((Object)this.getName(), NutsTextStyle.primary5()).append((Object)" ").append((Object)NutsCommandLine.of((String[])this.args, (NutsSession)session))});
        } else {
            session.out().printlnf((Object)NutsMessage.cstyle((String)"[dry] %s", (Object[])new Object[]{text.builder().append((Object)"internal", NutsTextStyle.pale()).append((Object)" ").append((Object)this.getName(), NutsTextStyle.primary5()).append((Object)" ").append((Object)NutsCommandLine.of((String[])this.args, (NutsSession)session))}));
        }
    }

    public String toString() {
        return this.getName() + " " + NutsCommandLine.of((String[])this.args, (NutsSession)this.getSession()).toString();
    }
}

