/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDeployCommand;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryDisabledException;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NutsDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.id.util.NutsIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.io.util.ZipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.AbstractNutsDeployCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.CharacterizedDeployFile;

public class DefaultNutsDeployCommand
extends AbstractNutsDeployCommand {
    public DefaultNutsDeployCommand(NutsWorkspace ws) {
        super(ws);
    }

    private static CharacterizedDeployFile characterizeForDeploy(NutsStreamOrPath contentFile, NutsFetchCommand options, String[] parseOptions, NutsSession session) {
        CharacterizedDeployFile c;
        block12: {
            if (parseOptions == null) {
                parseOptions = new String[]{};
            }
            c = new CharacterizedDeployFile(session);
            try {
                c.baseFile = CoreIOUtils.toPathInputSource(contentFile, c.temps, session);
                c.contentStreamOrPath = contentFile;
                if (!Files.exists(c.baseFile, new LinkOption[0])) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"file does not exists %s", (Object[])new Object[]{c.baseFile}));
                }
                if (c.descriptor == null && c.contentStreamOrPath.isPath() && c.contentStreamOrPath.getPath().isURL()) {
                    try {
                        c.descriptor = NutsDescriptorParser.of((NutsSession)session).parse(c.contentStreamOrPath.getPath().resolve("nuts.json"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Files.isDirectory(c.baseFile, new LinkOption[0])) {
                    if (c.descriptor == null) {
                        Path ext = c.baseFile.resolve("nuts.json");
                        c.descriptor = Files.exists(ext, new LinkOption[0]) ? NutsDescriptorParser.of((NutsSession)session).parse(ext) : NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.baseFile, parseOptions, session);
                    }
                    if (c.descriptor == null) break block12;
                    if ("zip".equals(c.descriptor.getPackaging())) {
                        Path zipFilePath = Paths.get(NutsPath.of((String)(c.baseFile.toString() + ".zip"), (NutsSession)session).toAbsolute().toString(), new String[0]);
                        ZipUtils.zip(session, c.baseFile.toString(), new ZipOptions(), zipFilePath.toString());
                        c.contentStreamOrPath = NutsStreamOrPath.of(NutsPath.of((Path)zipFilePath, (NutsSession)session));
                        c.addTemp(zipFilePath);
                        break block12;
                    }
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid Nut Folder source. expected 'zip' ext in descriptor", (Object[])new Object[0]));
                }
                if (Files.isRegularFile(c.baseFile, new LinkOption[0])) {
                    if (c.descriptor == null) {
                        NutsPath ext = NutsPath.of((String)(c.baseFile.toString() + "." + "nuts.json"), (NutsSession)session).toAbsolute();
                        c.descriptor = ext.exists() ? NutsDescriptorParser.of((NutsSession)session).parse(ext) : NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(c.baseFile, parseOptions, session);
                    }
                    break block12;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"path does not denote a valid file or folder %s", (Object[])new Object[]{c.contentStreamOrPath}));
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        return c;
    }

    public NutsDeployCommand run() {
        this.checkSession();
        if (this.getContent() != null || this.getDescriptor() != null || this.getSha1() != null || this.getDescSha1() != null) {
            this.runDeployFile();
        }
        if (this.ids.size() > 0) {
            for (NutsId nutsId : this.session.search().setSession(this.getSession()).addIds(this.ids.toArray(new NutsId[0])).setLatest(true).setRepositoryFilter(this.fromRepository).getResultIds()) {
                NutsDefinition fetched = this.session.fetch().setContent(true).setId(nutsId).setSession(this.getSession()).getResultDefinition();
                if (fetched.getFile() == null) continue;
                this.runDeployFile(NutsStreamOrPath.of(NutsPath.of((Path)fetched.getFile(), (NutsSession)this.session)), fetched.getDescriptor(), null);
            }
        }
        if (this.result == null || this.result.isEmpty()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing package to deploy"));
        }
        if (this.getSession().isTrace()) {
            switch (this.getSession().getOutputFormat()) {
                case PLAIN: {
                    for (AbstractNutsDeployCommand.Result nid : this.result) {
                        this.getSession().getTerminal().out().resetLine().printf("%s deployed successfully as %s to %s%n", new Object[]{nid.source, nid.id, NutsTexts.of((NutsSession)this.session).ofStyled(nid.repository, NutsTextStyle.primary3())});
                    }
                    break;
                }
                default: {
                    this.getSession().out().printlnf((Object)this.result);
                }
            }
        }
        return this;
    }

    private NutsDeployCommand runDeployFile() {
        return this.runDeployFile(this.getContent(), this.getDescriptor(), this.getDescSha1());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NutsDeployCommand runDeployFile(NutsStreamOrPath content, Object descriptor0, String descSHA1) {
        block32: {
            this.checkSession();
            session = this.getSession();
            dws = NutsWorkspaceExt.of(session.getWorkspace());
            wu = NutsWorkspaceUtils.of(this.session);
            wu.checkReadOnly();
            tempFile = null;
            contentSource = content.toMultiRead(this.session);
            descriptor = this.buildDescriptor(descriptor0, descSHA1);
            characterizedFile = null;
            contentFile2 = null;
            try {
                block31: {
                    if (descriptor == null) {
                        p = this.session.fetch().setSession(session.copy().setTransitive(Boolean.valueOf(true)));
                        characterizedFile = DefaultNutsDeployCommand.characterizeForDeploy(contentSource, p, this.getParseOptions(), session);
                        if (characterizedFile.descriptor == null) {
                            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing descriptor", (Object[])new Object[0]));
                        }
                        descriptor = characterizedFile.descriptor;
                    }
                    name = this.session.locations().getDefaultIdFilename(descriptor.getId().builder().setFaceDescriptor().build());
                    tempFile = NutsTmp.of((NutsSession)this.session).createTempFile(name).toFile();
                    NutsCp.of((NutsSession)this.session).setSession(session).from(contentSource.getInputStream()).to(tempFile).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
                    contentFile0 = contentFile2 = tempFile;
                    repository = this.getTargetRepository();
                    wu.checkReadOnly();
                    contentFile = contentFile0;
                    tempFile2 = null;
                    try {
                        block34: {
                            block33: {
                                if (!Files.isDirectory(contentFile, new LinkOption[0])) break block33;
                                descFile = contentFile.resolve("nuts.json");
                                descriptor2 = Files.exists(descFile, new LinkOption[0]) != false ? NutsDescriptorParser.of((NutsSession)session).parse(descFile) : NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(contentFile, this.getParseOptions(), session);
                                if (descriptor == null) {
                                    descriptor = descriptor2;
                                } else if (descriptor2 != null && !descriptor2.equals(descriptor)) {
                                    descriptor.formatter().setSession(session).print(descFile);
                                }
                                if (descriptor != null) {
                                    if ("zip".equals(descriptor.getPackaging()) == false) throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid nuts folder source; expected 'zip' ext in descriptor", (Object[])new Object[0]));
                                    zipFilePath = Paths.get(NutsPath.of((String)(contentFile.toString() + ".zip"), (NutsSession)this.session).toAbsolute().toString(), new String[0]);
                                    try {
                                        ZipUtils.zip(session, contentFile.toString(), new ZipOptions(), new String[]{zipFilePath.toString()});
                                    }
                                    catch (IOException ex) {
                                        throw new NutsIOException(session, (Throwable)ex);
                                    }
                                    tempFile2 = contentFile = zipFilePath;
                                }
                                break block34;
                            }
                            if (descriptor == null) {
                                descriptor = NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(contentFile, this.getParseOptions(), session);
                            }
                        }
                        if (descriptor == null) {
                            throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"artifact not found at %s", (Object[])new Object[]{contentFile}));
                        }
                        if (NutsUtilStrings.trim((String)(descriptor = descriptor.builder().setId(descriptor.getId().builder().setRepository(null).build()).build()).getId().getVersion().getValue()).endsWith("-CHECKED-OUT")) {
                            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid version %s", (Object[])new Object[]{descriptor.getId().getVersion()}));
                        }
                        effId = dws.resolveEffectiveId(descriptor, session);
                        CorePlatformUtils.checkAcceptCondition(descriptor.getCondition(), false, session);
                        if (!NutsBlankable.isBlank((String)repository)) ** GOTO lbl-1000
                        descriptor2 = wu.filterRepositoriesDeploy(effId = NutsIdUtils.createContentFaceId(effId.builder().setProperties("").build(), descriptor, session), null).stream().filter((Predicate<NutsRepository>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$runDeployFile$0(net.thevpc.nuts.NutsRepository ), (Lnet/thevpc/nuts/NutsRepository;)Z)()).sorted(Comparator.comparingInt((ToIntFunction<NutsRepository>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$runDeployFile$1(net.thevpc.nuts.NutsRepository ), (Lnet/thevpc/nuts/NutsRepository;)I)())).collect(Collectors.toList()).iterator();
                        if (descriptor2.hasNext()) {
                            repo = (NutsRepository)descriptor2.next();
                            deployOrder = repo.config().getDeployWeight();
                            repoSPI = wu.repoSPI(repo);
                            repoSPI.deploy().setSession(session).setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                            this.addResult(effId, repo.getName(), (NutsString)NutsTexts.of((NutsSession)session).toText(content.getValue()));
                            var22_25 = this;
                            if (tempFile2 == null) break block31;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var24_27) {
                        if (tempFile2 == null) throw var24_27;
                        try {
                            Files.delete(tempFile2);
                            throw var24_27;
                        }
                        catch (IOException ex) {
                            throw new NutsIOException(session, (Throwable)ex);
                        }
                    }
                    try {
                        Files.delete(tempFile2);
                    }
                    catch (IOException ex) {
                        throw new NutsIOException(session, (Throwable)ex);
                    }
                }
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) return var22_25;
            }
            catch (Throwable var26_29) {
                if (characterizedFile != null) {
                    characterizedFile.close();
                }
                if (tempFile == null) throw var26_29;
                CoreIOUtils.delete(this.getSession(), tempFile);
                throw var26_29;
            }
            CoreIOUtils.delete(this.getSession(), tempFile);
            return var22_25;
lbl-1000:
            // 1 sources

            {
                repo = this.getSession().repos().getRepository(repository);
                if (repo == null) {
                    throw new NutsRepositoryNotFoundException(this.getSession(), repository);
                }
                if (!repo.config().isEnabled()) {
                    throw new NutsRepositoryDisabledException(this.getSession(), repository);
                }
                effId = NutsIdUtils.createContentFaceId(effId.builder().setProperties("").build(), descriptor, session);
                repoSPI = wu.repoSPI(repo);
                repoSPI.deploy().setSession(session).setId(effId).setContent(contentFile).setDescriptor(descriptor).run();
                this.addResult(effId, repo.getName(), (NutsString)NutsTexts.of((NutsSession)this.session).toText(content.getValue()));
                var20_22 = this;
                if (tempFile2 == null) break block32;
            }
            try {
                Files.delete(tempFile2);
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        if (characterizedFile != null) {
            characterizedFile.close();
        }
        if (tempFile == null) return var20_22;
        CoreIOUtils.delete(this.getSession(), tempFile);
        return var20_22;
lbl-1000:
        // 1 sources

        {
            throw new NutsRepositoryNotFoundException(this.getSession(), repository);
        }
    }

    /*
     * Exception decompiling
     */
    protected NutsDescriptor buildDescriptor(Object descriptor, String descSHA1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public NutsDeployCommand addIds(String ... values) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (values != null) {
            for (String s : values) {
                if (NutsBlankable.isBlank((String)s)) continue;
                this.ids.add(NutsId.of((String)s, (NutsSession)this.session));
            }
        }
        return this;
    }

    @Override
    public NutsDeployCommand addIds(NutsId ... value) {
        if (value != null) {
            for (NutsId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    @Override
    public NutsDeployCommand clearIds() {
        this.ids.clear();
        return this;
    }

    @Override
    public NutsDeployCommand addId(NutsId id) {
        if (id != null) {
            this.addId(id.toString());
        }
        return this;
    }

    private static /* synthetic */ int lambda$runDeployFile$1(NutsRepository x) {
        return x.config().getDeployWeight();
    }

    private static /* synthetic */ boolean lambda$runDeployFile$0(NutsRepository x) {
        return x.config().getDeployWeight() > 0;
    }
}

