/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCommand;
import net.thevpc.nuts.runtime.standalone.dependency.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsWorkspaceCommandBase;

public abstract class DefaultNutsQueryBaseOptions<T extends NutsWorkspaceCommand>
extends NutsWorkspaceCommandBase<T> {
    protected NutsDependencyFilter dependencyFilter;
    private boolean failFast = false;
    private Boolean optional = null;
    private Set<NutsDependencyScope> scope = EnumSet.noneOf(NutsDependencyScope.class);
    private boolean content = false;
    private boolean inlineDependencies = false;
    private boolean dependencies = false;
    private boolean effective = false;
    private Path location = null;
    private NutsFetchDisplayOptions displayOptions;
    private NutsRepositoryFilter repositoryFilter;

    public DefaultNutsQueryBaseOptions(NutsWorkspace ws, String name) {
        super(ws, name);
        this.displayOptions = new NutsFetchDisplayOptions(NutsWorkspaceUtils.defaultSession(ws));
    }

    public T copyFromDefaultNutsQueryBaseOptions(DefaultNutsQueryBaseOptions other) {
        if (other != null) {
            super.copyFromWorkspaceCommandBase(other);
            this.optional = other.getOptional();
            this.failFast = other.isFailFast();
            this.content = other.isContent();
            this.inlineDependencies = other.isInlineDependencies();
            this.dependencies = other.isDependencies();
            this.effective = other.isEffective();
            this.scope = EnumSet.copyOf(other.getScope());
            this.location = other.getLocation();
            this.dependencyFilter = other.getDependencyFilter();
            this.repositoryFilter = other.getRepositoryFilter();
        }
        return (T)this;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public T setOptional(Boolean acceptOptional) {
        this.optional = acceptOptional;
        return (T)this;
    }

    public T clearScopes() {
        this.scope = EnumSet.noneOf(NutsDependencyScope.class);
        return (T)this;
    }

    public T addScope(NutsDependencyScope scope) {
        this.scope = NutsDependencyScopes.add(this.scope, scope);
        return (T)this;
    }

    public T addScope(NutsDependencyScopePattern scope) {
        this.scope = NutsDependencyScopes.add(this.scope, scope);
        return (T)this;
    }

    public T addScopes(NutsDependencyScope ... scope) {
        this.scope = NutsDependencyScopes.add(this.scope, scope);
        return (T)this;
    }

    public T addScopes(NutsDependencyScopePattern ... scope) {
        this.scope = NutsDependencyScopes.add(this.scope, scope);
        return (T)this;
    }

    public T removeScopes(NutsDependencyScope ... scope) {
        this.scope = NutsDependencyScopes.remove(this.scope, scope);
        return (T)this;
    }

    public T removeScopes(NutsDependencyScopePattern ... scope) {
        this.scope = NutsDependencyScopes.remove(this.scope, scope);
        return (T)this;
    }

    public T removeScope(NutsDependencyScope scope) {
        this.scope = NutsDependencyScopes.remove(this.scope, scope);
        return (T)this;
    }

    public T removeScope(NutsDependencyScopePattern scope) {
        this.scope = NutsDependencyScopes.remove(this.scope, scope);
        return (T)this;
    }

    public Set<NutsDependencyScope> getScope() {
        return this.scope;
    }

    public T setScope(NutsDependencyScope scope) {
        return this.setScope(scope == null ? null : EnumSet.of(scope));
    }

    public T setScope(NutsDependencyScope ... scope) {
        return this.setScope(scope == null ? null : EnumSet.copyOf(Arrays.asList(scope)));
    }

    public T setScope(Collection<NutsDependencyScope> scope) {
        this.scope = scope == null ? EnumSet.noneOf(NutsDependencyScope.class) : EnumSet.copyOf(scope);
        return (T)this;
    }

    public boolean isContent() {
        return this.content;
    }

    public T setContent(boolean includeContent) {
        this.content = includeContent;
        return (T)this;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public T setEffective(boolean includeEffectiveDesc) {
        this.effective = includeEffectiveDesc;
        return (T)this;
    }

    public boolean isInlineDependencies() {
        return this.inlineDependencies;
    }

    public T setInlineDependencies(boolean include) {
        this.inlineDependencies = include;
        return (T)this;
    }

    public boolean isDependencies() {
        return this.dependencies;
    }

    public T setDependencies(boolean include) {
        this.dependencies = include;
        return (T)this;
    }

    public Path getLocation() {
        return this.location;
    }

    public T setLocation(Path location) {
        this.location = location;
        return (T)this;
    }

    public T setDefaultLocation() {
        this.location = null;
        return (T)this;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public T setFailFast(boolean enable) {
        this.failFast = enable;
        return (T)this;
    }

    public NutsFetchDisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (this.getDisplayOptions().configureFirst(cmdLine)) {
            return true;
        }
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--failfast": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setFailFast(val);
                }
                return true;
            }
            case "-r": 
            case "--repository": {
                String val = cmdLine.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    this.addRepositoryFilter(NutsRepositoryFilters.of((NutsSession)this.getSession()).byName(new String[]{val}));
                }
                return true;
            }
            case "--dependencies": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setDependencies(val);
                }
                return true;
            }
            case "--scope": {
                String s = cmdLine.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    NutsDependencyScopePattern p = NutsDependencyScopePattern.parseLenient((String)s, (NutsDependencyScopePattern)NutsDependencyScopePattern.API, (NutsDependencyScopePattern)NutsDependencyScopePattern.API);
                    this.addScope(p);
                }
                return true;
            }
            case "--optional": {
                NutsArgument v = cmdLine.nextString(new String[0]);
                if (enabled) {
                    this.setOptional(NutsUtilStrings.parseBoolean((String)v.getString(), null, null));
                }
                return true;
            }
            case "--effective": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setEffective(val);
                }
                return true;
            }
            case "--content": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setContent(val);
                }
                return true;
            }
            case "--location": {
                String location = cmdLine.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    this.setLocation(NutsBlankable.isBlank((String)location) ? null : Paths.get(location, new String[0]));
                }
                return true;
            }
        }
        return false;
    }

    public NutsRepositoryFilter getRepositoryFilter() {
        return this.repositoryFilter;
    }

    public T setRepositoryFilter(String filter) {
        this.checkSession();
        this.repositoryFilter = NutsBlankable.isBlank((String)filter) ? null : this.getSession().repos().filter().byName(new String[]{filter});
        return (T)this;
    }

    public T setRepositoryFilter(NutsRepositoryFilter filter) {
        this.repositoryFilter = filter;
        return (T)this;
    }

    public T addRepositoryFilter(NutsRepositoryFilter filter) {
        if (filter != null) {
            this.repositoryFilter = this.repositoryFilter == null ? filter : this.repositoryFilter.and(filter);
        }
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(failFast=" + this.failFast + ", optional=" + this.optional + ", scope=" + this.scope + ", content=" + this.content + ", dependencyFilter=" + this.dependencyFilter + ", inlineDependencies=" + this.inlineDependencies + ", dependencies=" + this.dependencies + ", effective=" + this.effective + ", location=" + this.location + ", displayOptions=" + this.displayOptions + ", session=" + this.getSession() + ')';
    }

    public T setDependencyFilter(NutsDependencyFilter filter) {
        this.dependencyFilter = filter;
        return (T)this;
    }

    public NutsDependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public T setDependencyFilter(String filter) {
        this.checkSession();
        this.dependencyFilter = (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).parse(filter);
        return (T)this;
    }
}

