/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd;

import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;

public class DefaultNutsExecutionContext
implements NutsExecutionContext {
    private NutsDefinition definition;
    private Map<String, String> env;
    private String[] executorArguments;
    private Map<String, String> executorProperties;
    private String[] arguments;
    private NutsSession execSession;
    private NutsSession session;
    private NutsWorkspace workspace;
    private NutsArtifactCall executorDescriptor;
    private String cwd;
    private String commandName;
    private boolean failFast;
    private boolean temporary;
    private long sleepMillis;
    private NutsExecutionType executionType;
    private NutsRunAs runAs;
    private boolean inheritSystemIO;
    private String redirectOutputFile;
    private String redirectInputFile;

    public DefaultNutsExecutionContext(NutsDefinition definition, String[] arguments, String[] executorArgs, Map<String, String> env, Map<String, String> executorProperties, String cwd, NutsSession session, NutsSession execSession, NutsWorkspace workspace, boolean failFast, boolean temporary, NutsExecutionType executionType, String commandName, long sleepMillis, boolean inheritSystemIO, String redirectOutputFile, String redirectInputFile) {
        if (arguments == null) {
            arguments = new String[]{};
        }
        if (executorArgs == null) {
            executorArgs = new String[]{};
        }
        if (executorProperties == null) {
            executorProperties = new LinkedHashMap<String, String>();
        }
        this.commandName = commandName;
        this.definition = definition;
        this.arguments = arguments;
        this.execSession = execSession;
        this.session = session;
        this.workspace = workspace;
        this.executorArguments = executorArgs;
        this.executorProperties = executorProperties;
        this.sleepMillis = sleepMillis;
        this.cwd = cwd;
        if (env == null) {
            env = new LinkedHashMap<String, String>();
        }
        this.env = env;
        this.failFast = failFast;
        this.temporary = temporary;
        this.executionType = executionType;
        this.executorDescriptor = definition.getDescriptor().getExecutor();
        this.inheritSystemIO = inheritSystemIO;
        this.redirectOutputFile = redirectOutputFile;
        this.redirectInputFile = redirectInputFile;
    }

    public DefaultNutsExecutionContext(NutsExecutionContext other) {
        this.commandName = other.getCommandName();
        this.definition = other.getDefinition();
        this.arguments = other.getArguments();
        this.execSession = other.getExecSession();
        this.session = other.getSession();
        this.workspace = other.getWorkspace();
        this.executorArguments = other.getExecutorArguments();
        this.executorProperties = other.getExecutorProperties();
        this.cwd = other.getCwd();
        this.env = other.getEnv();
        this.failFast = other.isFailFast();
        this.temporary = other.isTemporary();
        this.executionType = other.getExecutionType();
        this.executorDescriptor = other.getExecutorDescriptor();
        this.sleepMillis = other.getSleepMillis();
        this.inheritSystemIO = other.isInheritSystemIO();
        this.redirectOutputFile = other.getRedirectOutputFile();
        this.redirectInputFile = other.getRedirectInputFile();
    }

    public boolean isInheritSystemIO() {
        return this.inheritSystemIO;
    }

    public String getRedirectOutputFile() {
        return this.redirectOutputFile;
    }

    public String getRedirectInputFile() {
        return this.redirectInputFile;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String[] getExecutorArguments() {
        return this.executorArguments;
    }

    public Map<String, String> getExecutorProperties() {
        return this.executorProperties;
    }

    public NutsDefinition getDefinition() {
        return this.definition;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsArtifactCall getExecutorDescriptor() {
        return this.executorDescriptor;
    }

    public NutsSession getExecSession() {
        return this.execSession;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getCwd() {
        return this.cwd;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public NutsExecutionType getExecutionType() {
        return this.executionType;
    }

    public DefaultNutsExecutionContext setDefinition(NutsDefinition definition) {
        this.definition = definition;
        return this;
    }

    public DefaultNutsExecutionContext setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public DefaultNutsExecutionContext setExecutorArguments(String[] executorArguments) {
        this.executorArguments = executorArguments;
        return this;
    }

    public DefaultNutsExecutionContext setExecutorProperties(Map<String, String> executorProperties) {
        this.executorProperties = executorProperties;
        return this;
    }

    public DefaultNutsExecutionContext setArguments(String[] arguments) {
        this.arguments = arguments;
        return this;
    }

    public DefaultNutsExecutionContext setExecSession(NutsSession execSession) {
        this.execSession = execSession;
        return this;
    }

    public DefaultNutsExecutionContext setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public DefaultNutsExecutionContext setWorkspace(NutsWorkspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public DefaultNutsExecutionContext setExecutorDescriptor(NutsArtifactCall executorDescriptor) {
        this.executorDescriptor = executorDescriptor;
        return this;
    }

    public DefaultNutsExecutionContext setCwd(String cwd) {
        this.cwd = cwd;
        return this;
    }

    public DefaultNutsExecutionContext setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public DefaultNutsExecutionContext setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public DefaultNutsExecutionContext setTemporary(boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public DefaultNutsExecutionContext setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public NutsRunAs getRunAs() {
        return this.runAs;
    }

    public DefaultNutsExecutionContext setRunAs(NutsRunAs runAs) {
        this.runAs = runAs;
        return this;
    }
}

