/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ServerNutsWorkspaceArchetypeComponent
implements NutsWorkspaceArchetypeComponent {
    private NutsLogger LOG;

    public String getName() {
        return "server";
    }

    public void initializeWorkspace(NutsSession session) {
        this.LOG = NutsLogger.of(ServerNutsWorkspaceArchetypeComponent.class, (NutsSession)session);
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)session.config();
        NutsRepositoryLocation[] br = rm.getModel().resolveBootRepositoriesList(session).resolve(new NutsRepositoryLocation[]{NutsRepositoryLocation.of((String)"maven-local", null), NutsRepositoryLocation.of((String)"maven-central", null), NutsRepositoryLocation.of((String)"local", null)}, NutsRepositoryDB.of((NutsSession)session));
        NutsRepositoryManager repos = session.repos().setSession(session);
        for (NutsRepositoryLocation s : br) {
            repos.addRepository(s.toString());
        }
        NutsWorkspaceSecurityManager sec = session.security().setSession(session);
        sec.addUser("guest").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy"}).run();
        sec = session.security().setSession(session);
        sec.addUser("contributor").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy", "undeploy"}).run();
    }

    public void startWorkspace(NutsSession session) {
        Boolean skipCompanions;
        NutsBootManager boot = session.boot();
        boolean initializeAllPlatforms = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-platforms"});
        if (initializeAllPlatforms && boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-java"}).booleanValue()) {
            NutsWorkspaceUtils.of(session).installAllJVM();
        } else {
            NutsWorkspaceUtils.of(session).installCurrentJVM();
        }
        boolean initScripts = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-scripts"});
        boolean initLaunchers = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-launchers"});
        if (initScripts || initLaunchers) {
            NutsWorkspaceUtils.of(session).installLaunchers(initLaunchers);
        }
        if ((skipCompanions = session.boot().getBootOptions().getSkipCompanions()) == null) {
            skipCompanions = true;
        }
        if (!skipCompanions.booleanValue()) {
            NutsWorkspaceUtils.of(session).installCompanions();
        }
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 10;
    }
}

