/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class MinimalNutsWorkspaceArchetypeComponent
implements NutsWorkspaceArchetypeComponent {
    private NutsLogger LOG;

    public String getName() {
        return "minimal";
    }

    public void initializeWorkspace(NutsSession session) {
        this.LOG = NutsLogger.of(MinimalNutsWorkspaceArchetypeComponent.class, (NutsSession)session);
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)session.config();
        NutsRepositoryLocation[] br = rm.getModel().resolveBootRepositoriesList(session).resolve(new NutsRepositoryLocation[0], NutsRepositoryDB.of((NutsSession)session));
        NutsRepositoryManager repos = session.repos().setSession(session);
        for (NutsRepositoryLocation s : br) {
            repos.addRepository(s.toString());
        }
        NutsUpdateUserCommand uu = session.security().setSession(session).updateUser("anonymous");
        uu.run();
    }

    public void startWorkspace(NutsSession session) {
        Boolean skipCompanions;
        NutsBootManager boot = session.boot();
        boolean initializeAllPlatforms = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-platforms"});
        if (initializeAllPlatforms && boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-java"}).booleanValue()) {
            NutsWorkspaceUtils.of(session).installAllJVM();
        } else {
            NutsWorkspaceUtils.of(session).installCurrentJVM();
        }
        Boolean initScripts = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-scripts"});
        Boolean initLaunchers = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-launchers"});
        if (initScripts.booleanValue() || initLaunchers.booleanValue()) {
            NutsWorkspaceUtils.of(session).installLaunchers(initLaunchers);
        }
        if ((skipCompanions = session.boot().getBootOptions().getSkipCompanions()) == null) {
            skipCompanions = true;
        }
        if (!skipCompanions.booleanValue()) {
            NutsWorkspaceUtils.of(session).installCompanions();
        }
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 11;
    }
}

