/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DefaultNutsWorkspaceArchetypeComponent
implements NutsWorkspaceArchetypeComponent {
    private NutsLogger LOG;

    public String getName() {
        return "default";
    }

    public void initializeWorkspace(NutsSession session) {
        NutsRepositoryLocation[] br;
        this.LOG = NutsLogger.of(DefaultNutsWorkspaceArchetypeComponent.class, (NutsSession)session);
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)session.config();
        LinkedHashMap<String, NutsAddRepositoryOptions> def = new LinkedHashMap<String, NutsAddRepositoryOptions>();
        ArrayList<NutsRepositoryLocation> defaults = new ArrayList<NutsRepositoryLocation>();
        for (NutsAddRepositoryOptions d : rm.getDefaultRepositories()) {
            if (d.getConfig() != null) {
                def.put(NutsPath.of((String)d.getConfig().getLocation().getPath(), (NutsSession)session).toAbsolute().toString(), d);
            } else {
                def.put(NutsPath.of((String)d.getLocation(), (NutsSession)session).toAbsolute().toString(), d);
            }
            defaults.add(NutsRepositoryLocation.of((String)d.getName(), null));
        }
        defaults.add(NutsRepositoryLocation.of((String)"local", null));
        for (NutsRepositoryLocation s : br = rm.getModel().resolveBootRepositoriesList(session).resolve(defaults.toArray(new NutsRepositoryLocation[0]), NutsRepositoryDB.of((NutsSession)session))) {
            NutsAddRepositoryOptions oo = NutsRepositorySelectorHelper.createRepositoryOptions(s, false, session);
            String sloc = NutsPath.of((String)oo.getConfig().getLocation().getPath(), (NutsSession)session).toAbsolute().toString();
            if (def.containsKey(sloc)) {
                NutsAddRepositoryOptions r = ((NutsAddRepositoryOptions)def.get(sloc)).copy();
                if (!NutsBlankable.isBlank((String)s.getName())) {
                    r.setName(oo.getName());
                }
                session.repos().addRepository(r);
                def.remove(sloc);
                continue;
            }
            session.repos().addRepository(oo);
        }
        session.imports().addImports(new String[]{"net.thevpc.nuts.toolbox", "net.thevpc"});
        session.security().updateUser("anonymous").resetPermissions().run();
        session.security().setSession(session).addUser("user").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy", "undeploy", "push", "save"}).setRemoteIdentity("contributor").run();
    }

    public void startWorkspace(NutsSession session) {
        Boolean skipCompanions;
        NutsBootManager boot = session.boot();
        boolean initializeAllPlatforms = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-platforms"});
        if (initializeAllPlatforms && boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-java"}).booleanValue()) {
            NutsWorkspaceUtils.of(session).installAllJVM();
        } else {
            NutsWorkspaceUtils.of(session).installCurrentJVM();
        }
        Boolean initScripts = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-scripts"});
        Boolean initLaunchers = boot.getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-launchers"});
        if (initScripts.booleanValue() || initLaunchers.booleanValue()) {
            NutsWorkspaceUtils.of(session).installLaunchers(initLaunchers);
        }
        if ((skipCompanions = session.boot().getBootOptions().getSkipCompanions()) == null) {
            skipCompanions = false;
        }
        if (!skipCompanions.booleanValue()) {
            NutsWorkspaceUtils.of(session).installCompanions();
        }
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 12;
    }
}

