/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallEvent;
import net.thevpc.nuts.NutsInstallListener;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsReadOnlyException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryAlreadyRegisteredException;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUpdateEvent;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NutsPrintIterator;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepositoryManager;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.util.reflect.DefaultReflectRepository;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectConfigurationBuilder;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectPropertyAccessStrategy;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsRepositoryAndFetchMode;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsSessionAware;

public class NutsWorkspaceUtils {
    private NutsLogger LOG;
    private final NutsWorkspace ws;
    private final NutsSession session;

    private NutsWorkspaceUtils(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public static NutsWorkspaceUtils of(NutsSession session) {
        return new NutsWorkspaceUtils(session);
    }

    public static NutsSession defaultSession(NutsWorkspace ws) {
        return ((NutsWorkspaceExt)ws).defaultSession();
    }

    public static NutsSession bindSession(NutsWorkspace ws, NutsSession session) {
        if (ws != null && session != null && !Objects.equals(session.getWorkspace().getUuid(), ws.getUuid())) {
            return ws.createSession().copyFrom(session);
        }
        return session;
    }

    public static void checkSession(NutsWorkspace ws, NutsSession session) {
        if (session == null) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing session", (Object[])new Object[0]));
        }
        if (!Objects.equals(session.getWorkspace().getUuid(), ws.getUuid())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"invalid session %s != %s ; %s != %s ; %s != %s ; ", (Object[])new Object[]{session.getWorkspace().getName(), ws.getName(), session.getWorkspace().getLocation(), ws.getLocation(), session.getWorkspace().getUuid(), ws.getUuid()}));
        }
    }

    public static void checkNutsIdBase(NutsWorkspace ws, NutsId id) {
        if (id == null) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((String)id.getGroupId())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing group for %s", (Object[])new Object[]{id}));
        }
        if (NutsBlankable.isBlank((String)id.getArtifactId())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing name for %s", (Object[])new Object[]{id}));
        }
    }

    public static boolean setSession(Object o, NutsSession session) {
        if (o instanceof NutsSessionAware) {
            ((NutsSessionAware)o).setSession(session);
            return true;
        }
        return false;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(NutsWorkspaceUtils.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsRepositorySPI repoSPI(NutsRepository repo) {
        DefaultNutsRepositoryManager repos = (DefaultNutsRepositoryManager)this.session.repos().setSession(this.session);
        return repos.getModel().toRepositorySPI(repo);
    }

    public ReflectRepository getReflectRepository() {
        NutsWorkspaceEnvManager env = this.session.env();
        ReflectRepository o = (ReflectRepository)env.getProperties().get(ReflectRepository.class.getName());
        if (o == null) {
            o = new DefaultReflectRepository(ReflectConfigurationBuilder.create().setPropertyAccessStrategy(ReflectPropertyAccessStrategy.FIELD).setPropertyDefaultValueStrategy(ReflectPropertyDefaultValueStrategy.PROPERTY_DEFAULT).build());
            env.setProperty(ReflectRepository.class.getName(), (Object)o);
        }
        return o;
    }

    public NutsId createSdkId(String type, String version) {
        if (NutsBlankable.isBlank((String)type)) {
            throw new NutsException(this.session, NutsMessage.formatted((String)"missing sdk type"));
        }
        if (NutsBlankable.isBlank((String)version)) {
            throw new NutsException(this.session, NutsMessage.formatted((String)"missing version"));
        }
        if ("java".equalsIgnoreCase(type)) {
            return NutsJavaSdkUtils.of(this.ws).createJdkId(version, this.session);
        }
        return NutsIdBuilder.of((NutsSession)this.session).setArtifactId(type).setVersion(version).build();
    }

    public void checkReadOnly() {
        if (this.session.config().isReadOnly()) {
            throw new NutsReadOnlyException(this.session, this.session.locations().getWorkspaceLocation().toString());
        }
    }

    public NutsSession validateSession(NutsSession session) {
        if (session == null) {
            session = this.ws.createSession();
        } else if (session.getWorkspace() != this.ws) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"session was created with a different Workspace"));
        }
        return session;
    }

    public NutsId configureFetchEnv(NutsId id) {
        Map qm = id.getProperties();
        if (qm.get("face") == null && qm.get("arch") == null && qm.get("os") == null && qm.get("osdist") == null && qm.get("platform") == null && qm.get("desktop") == null) {
            NutsWorkspaceEnvManager env = this.session.env();
            qm.put("arch", env.getArchFamily().id());
            qm.put("os", env.getOs().toString());
            if (env.getOsDist() != null) {
                qm.put("osdist", env.getOsDist().toString());
            }
            if (env.getPlatform() != null) {
                qm.put("platform", env.getPlatform().toString());
            }
            if (env.getDesktopEnvironment() != null) {
                qm.put("desktop", env.getDesktopEnvironment().toString());
            }
            return id.builder().setProperties(qm).build();
        }
        return id;
    }

    public List<NutsRepository> filterRepositoriesDeploy(NutsId id, NutsRepositoryFilter repositoryFilter) {
        NutsRepositoryFilter f = NutsRepositoryFilters.of((NutsSession)this.session).installedRepo().neg().and(repositoryFilter);
        return this.filterRepositories(NutsRepositorySupportedAction.DEPLOY, id, f, NutsFetchMode.LOCAL);
    }

    public List<NutsRepositoryAndFetchMode> filterRepositoryAndFetchModes(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, NutsFetchStrategy fetchStrategy, NutsSession session) {
        ArrayList<NutsRepositoryAndFetchMode> ok = new ArrayList<NutsRepositoryAndFetchMode>();
        for (NutsFetchMode nutsFetchMode : fetchStrategy) {
            for (NutsRepository nutsRepositoryAndFetchMode : this.filterRepositories(fmode, id, repositoryFilter, nutsFetchMode)) {
                ok.add(new NutsRepositoryAndFetchMode(nutsRepositoryAndFetchMode, nutsFetchMode));
            }
        }
        return ok;
    }

    private List<NutsRepository> filterRepositories(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, NutsFetchMode mode) {
        return this.filterRepositories(fmode, id, repositoryFilter, true, null, mode);
    }

    private List<NutsRepository> filterRepositories(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, boolean sortByLevelDesc, Comparator<NutsRepository> postComp, NutsFetchMode mode) {
        ArrayList<RepoAndLevel> repos2 = new ArrayList<RepoAndLevel>();
        for (NutsRepository repository : this.session.repos().setSession(this.session).getRepositories()) {
            if (!repository.isEnabled() || fmode != NutsRepositorySupportedAction.SEARCH && !repository.isSupportedDeploy(this.session) || !this.repoSPI(repository).isAcceptFetchMode(mode, this.session) || repositoryFilter != null && !repositoryFilter.acceptRepository(repository)) continue;
            int d = 0;
            if (fmode == NutsRepositorySupportedAction.DEPLOY) {
                try {
                    d = NutsRepositoryHelper.getSupportDeployLevel(repository, fmode, id, mode, this.session.isTransitive(), this.session);
                }
                catch (Exception ex) {
                    this._LOGOP(this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to resolve support deploy level for : {0}", (Object[])new Object[]{repository.getName()}));
                }
            }
            NutsSpeedQualifier t = NutsSpeedQualifier.NORMAL;
            try {
                t = NutsRepositoryHelper.getSupportSpeedLevel(repository, fmode, id, mode, this.session.isTransitive(), this.session);
            }
            catch (Exception ex) {
                this._LOGOP(this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to resolve support speed level for : {0}", (Object[])new Object[]{repository.getName()}));
            }
            if (t == NutsSpeedQualifier.UNAVAILABLE) continue;
            repos2.add(new RepoAndLevel(repository, d, t, postComp));
        }
        if (sortByLevelDesc || postComp != null) {
            Collections.sort(repos2);
        }
        ArrayList<NutsRepository> ret = new ArrayList<NutsRepository>();
        NutsInstalledRepository installedRepository = NutsWorkspaceExt.of(this.ws).getInstalledRepository();
        if (mode == NutsFetchMode.LOCAL && fmode == NutsRepositorySupportedAction.SEARCH && (repositoryFilter == null || repositoryFilter.acceptRepository((NutsRepository)installedRepository))) {
            ret.add(installedRepository);
        }
        for (RepoAndLevel repoAndLevel : repos2) {
            ret.add(repoAndLevel.r);
        }
        return ret;
    }

    public void checkShortId(NutsId id) {
        if (id == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((String)id.getGroupId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing groupId for %s", (Object[])new Object[]{id}));
        }
        if (NutsBlankable.isBlank((String)id.getArtifactId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing artifactId for %s", (Object[])new Object[]{id}));
        }
    }

    public void checkLongId(NutsId id, NutsSession session) {
        this.checkShortId(id);
        if (NutsBlankable.isBlank((String)id.getVersion().toString())) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing version for %s", (Object[])new Object[]{id}));
        }
    }

    public void validateRepositoryName(String repositoryName, Set<String> registered, NutsSession session) {
        if (!repositoryName.matches("[a-zA-Z][.a-zA-Z0-9_-]*")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid repository id %s", (Object[])new Object[]{repositoryName}));
        }
        if (registered.contains(repositoryName)) {
            throw new NutsRepositoryAlreadyRegisteredException(session, repositoryName);
        }
    }

    public <T> NutsIterator<T> decoratePrint(NutsIterator<T> it, NutsSession session, NutsFetchDisplayOptions displayOptions) {
        NutsPrintStream out = this.validateSession(session).getTerminal().getOut();
        return new NutsPrintIterator<T>(it, this.ws, out, displayOptions, session);
    }

    public NutsDescriptor getEffectiveDescriptor(NutsDefinition def) {
        NutsDescriptor d = def.getEffectiveDescriptor();
        if (d == null) {
            return NutsWorkspaceExt.of(this.ws).resolveEffectiveDescriptor(def.getDescriptor(), null);
        }
        return d;
    }

    public void checkNutsId(NutsId id) {
        NutsWorkspaceUtils.checkNutsIdBase(this.ws, id);
        if (id.getVersion().isBlank()) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(this.ws), NutsMessage.cstyle((String)"missing version for %s", (Object[])new Object[]{id}));
        }
    }

    public Events events() {
        return new Events(this);
    }

    public void installAllJVM() {
        block10: {
            NutsWorkspaceEnvManager env = this.session.env();
            NutsWorkspaceConfigManager config = this.session.config();
            try {
                if (this.session.isPlainTrace()) {
                    this.session.out().resetLine().println("looking for java installations in default locations...");
                }
                NutsPlatformLocation[] found = env.platforms().searchSystemPlatforms(NutsPlatformFamily.JAVA);
                int someAdded = 0;
                for (NutsPlatformLocation java : found) {
                    if (!env.platforms().addPlatform(java)) continue;
                    ++someAdded;
                }
                NutsTexts factory = NutsTexts.of((NutsSession)this.session);
                if (this.session.isPlainTrace()) {
                    if (someAdded == 0) {
                        this.session.out().print("```error no new``` java installation locations found...\n");
                    } else if (someAdded == 1) {
                        this.session.out().printf("%s new java installation location added...\n", new Object[]{factory.ofStyled("1", NutsTextStyle.primary2())});
                    } else {
                        this.session.out().printf("%s new java installation locations added...\n", new Object[]{factory.ofStyled("" + someAdded, NutsTextStyle.primary2())});
                    }
                    this.session.out().println("you can always add another installation manually using 'nuts settings add java' command.");
                }
                if (!config.isReadOnly()) {
                    config.save();
                }
            }
            catch (Exception ex) {
                this._LOG(this.session).with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to resolve default JRE/JDK locations : {0}", (Object[])new Object[]{ex}));
                if (!this.session.isPlainTrace()) break block10;
                NutsPrintStream out = this.session.out();
                out.resetLine();
                out.printf("```unable to resolve default JRE/JDK locations``` :  %s%n", new Object[]{ex});
            }
        }
    }

    public void installCurrentJVM() {
        block12: {
            NutsWorkspaceEnvManager env = this.session.env();
            NutsWorkspaceConfigManager config = this.session.config();
            try {
                NutsPlatformLocation[] nutsPlatformLocationArray;
                NutsPlatformLocation found0;
                if (this.session.isPlainTrace()) {
                    this.session.out().resetLine().println("adding current JVM...");
                }
                if ((found0 = env.platforms().resolvePlatform(NutsPlatformFamily.JAVA, System.getProperty("java.home"), null)) == null) {
                    nutsPlatformLocationArray = new NutsPlatformLocation[]{};
                } else {
                    NutsPlatformLocation[] nutsPlatformLocationArray2 = new NutsPlatformLocation[1];
                    nutsPlatformLocationArray = nutsPlatformLocationArray2;
                    nutsPlatformLocationArray2[0] = found0;
                }
                NutsPlatformLocation[] found = nutsPlatformLocationArray;
                int someAdded = 0;
                for (NutsPlatformLocation java : found) {
                    if (!env.platforms().addPlatform(java)) continue;
                    ++someAdded;
                }
                NutsTexts factory = NutsTexts.of((NutsSession)this.session);
                if (this.session.isPlainTrace()) {
                    if (someAdded == 0) {
                        this.session.out().print("```error no new``` java installation locations found...\n");
                    } else if (someAdded == 1) {
                        this.session.out().printf("%s new java installation location added...\n", new Object[]{factory.ofStyled("1", NutsTextStyle.primary2())});
                    } else {
                        this.session.out().printf("%s new java installation locations added...\n", new Object[]{factory.ofStyled("" + someAdded, NutsTextStyle.primary2())});
                    }
                    this.session.out().println("you can always add another installation manually using 'nuts settings add java' command.");
                }
                if (!config.isReadOnly()) {
                    config.save();
                }
            }
            catch (Exception ex) {
                this._LOG(this.session).with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to resolve default JRE/JDK locations : {0}", (Object[])new Object[]{ex}));
                if (!this.session.isPlainTrace()) break block12;
                NutsPrintStream out = this.session.out();
                out.resetLine();
                out.printf("```unable to resolve default JRE/JDK locations``` :  %s%n", new Object[]{ex});
            }
        }
    }

    public void installLaunchers(boolean gui) {
        block2: {
            NutsWorkspaceEnvManager env = this.session.env();
            try {
                env.addLauncher(new NutsLauncherOptions().setId(this.session.getWorkspace().getApiId()).setCreateScript(true).setSystemWideConfig(Boolean.valueOf(this.session.boot().getBootOptions().isSwitchWorkspace())).setCreateDesktopShortcut(gui ? NutsSupportCondition.PREFERRED : NutsSupportCondition.NEVER).setCreateMenuShortcut(gui ? NutsSupportCondition.SUPPORTED : NutsSupportCondition.NEVER));
            }
            catch (Exception ex) {
                this._LOG(this.session).with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to install desktop launchers : {0}", (Object[])new Object[]{ex}));
                if (!this.session.isPlainTrace()) break block2;
                NutsPrintStream out = this.session.out();
                out.resetLine();
                out.printf("```error unable to install desktop launchers``` :  %s%n", new Object[]{ex});
            }
        }
    }

    public static boolean isUserDefaultWorkspace(NutsSession session) {
        String defaultWorkspaceLocation = NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)false, null);
        return defaultWorkspaceLocation.equals(session.getWorkspace().getLocation().toString());
    }

    public void installCompanions() {
        block4: {
            NutsTexts text = NutsTexts.of((NutsSession)this.session);
            Set companionIds = this.session.extensions().getCompanionIds();
            if (companionIds.isEmpty()) {
                return;
            }
            if (this.session.isPlainTrace()) {
                NutsPrintStream out = this.session.out();
                out.resetLine();
                out.printf("looking for recommended companion tools to install... detected : %s%n", new Object[]{text.builder().appendJoined((Object)text.ofPlain(","), (Collection)companionIds)});
            }
            try {
                this.session.install().companions().setSession(this.session.copy().setTrace(Boolean.valueOf(this.session.isTrace() && this.session.isPlainOut()))).run();
            }
            catch (Exception ex) {
                this._LOG(this.session).with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to install companions : {0}", (Object[])new Object[]{ex}));
                if (!this.session.isPlainTrace()) break block4;
                NutsPrintStream out = this.session.out();
                out.resetLine();
                out.printf("```error unable to install companion tools``` :  %s \nthis happens when none of the following repositories are able to locate them : %s\n", new Object[]{ex, text.builder().appendJoined((Object)text.ofPlain(", "), (Collection)Arrays.stream(this.session.repos().getRepositories()).map(x -> text.builder().append((Object)x.getName(), NutsTextStyle.primary3())).collect(Collectors.toList()))});
            }
        }
    }

    public static class Events {
        private final NutsWorkspaceUtils u;

        public Events(NutsWorkspaceUtils u) {
            this.u = u;
        }

        public void fireOnInstall(NutsInstallEvent event) {
            this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"installed {0}", (Object[])new Object[]{event.getDefinition().getId()}));
            for (NutsInstallListener listener : event.getSession().events().getInstallListeners()) {
                listener.onInstall(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onInstall(event);
            }
        }

        public void fireOnRequire(NutsInstallEvent event) {
            this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"required {0}", (Object[])new Object[]{event.getDefinition().getId()}));
            for (NutsInstallListener listener : event.getSession().events().getInstallListeners()) {
                listener.onRequire(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onRequire(event);
            }
        }

        public void fireOnUpdate(NutsUpdateEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                if (event.getOldValue() == null) {
                    this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).log(NutsMessage.jstyle((String)"updated {0}", (Object[])new Object[]{event.getNewValue().getId()}));
                } else {
                    this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).log(NutsMessage.jstyle((String)"updated {0} (old is {1})", (Object[])new Object[]{event.getOldValue().getId().getLongId(), event.getNewValue().getId().getLongId()}));
                }
            }
            for (NutsInstallListener listener : event.getSession().events().getInstallListeners()) {
                listener.onUpdate(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onUpdate(event);
            }
        }

        public void fireOnUninstall(NutsInstallEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.REMOVE).log(NutsMessage.jstyle((String)"uninstalled {0}", (Object[])new Object[]{event.getDefinition().getId()}));
            }
            for (NutsInstallListener listener : event.getSession().events().getInstallListeners()) {
                listener.onUninstall(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onUninstall(event);
            }
        }

        public void fireOnAddRepository(NutsWorkspaceEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.CONFIG)) {
                this.u._LOGOP(event.getSession()).level(Level.CONFIG).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"added repo ##{0}##", (Object[])new Object[]{event.getRepository().getName()}));
            }
            for (NutsWorkspaceListener listener : event.getSession().events().getWorkspaceListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsWorkspaceListener listener : (NutsWorkspaceListener[])event.getSession().getListeners(NutsWorkspaceListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NutsWorkspaceEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.REMOVE).log(NutsMessage.jstyle((String)"removed repo ##{0}##", (Object[])new Object[]{event.getRepository().getName()}));
            }
            for (NutsWorkspaceListener listener : event.getSession().events().getWorkspaceListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsWorkspaceListener listener : (NutsWorkspaceListener[])event.getSession().getListeners(NutsWorkspaceListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }

    private static class RepoAndLevel
    implements Comparable<RepoAndLevel> {
        NutsRepository r;
        int deployWeight;
        NutsSpeedQualifier speed;
        Comparator<NutsRepository> postComp;

        public RepoAndLevel(NutsRepository r, int deployWeight, NutsSpeedQualifier speed, Comparator<NutsRepository> postComp) {
            this.r = r;
            this.deployWeight = deployWeight;
            this.speed = speed;
            this.postComp = postComp;
        }

        @Override
        public int compareTo(RepoAndLevel o2) {
            int x = Integer.compare(this.deployWeight, o2.deployWeight);
            if (x != 0) {
                return x;
            }
            x = Integer.compare(o2.speed.ordinal(), this.speed.ordinal());
            if (x != 0) {
                return x;
            }
            if (this.postComp != null) {
                x = this.postComp.compare(this.r, o2.r);
            }
            return x;
        }
    }
}

