/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSession;

public class NutsWorkspaceHelper {
    public static NutsFetchStrategy validate(NutsFetchStrategy mode) {
        return mode == null ? NutsFetchStrategy.ONLINE : mode;
    }

    public static List<NutsRepository> _getEnabledRepositories(NutsRepository parent, NutsRepositoryFilter repositoryFilter, NutsSession session) {
        ArrayList<NutsRepository> repos = new ArrayList<NutsRepository>();
        if (parent.config().isSupportedMirroring()) {
            ArrayList<NutsRepository> subrepos = new ArrayList<NutsRepository>();
            boolean ok = false;
            for (NutsRepository repository : parent.config().setSession(session).getMirrors()) {
                if (!repository.config().isEnabled()) continue;
                if (repositoryFilter == null || repositoryFilter.acceptRepository(repository)) {
                    repos.add(repository);
                    ok = true;
                }
                if (ok) continue;
                subrepos.add(repository);
            }
            for (NutsRepository subrepo : subrepos) {
                repos.addAll(NutsWorkspaceHelper._getEnabledRepositories(subrepo, repositoryFilter, session));
            }
        }
        return repos;
    }
}

