/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsFactoryException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.extension.CoreServiceUtils;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsIdBuilder;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsIdParser;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.collections.ClassClassMap;
import net.thevpc.nuts.runtime.standalone.util.collections.ListMap;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersionParser;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsComponent;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.spi.NutsPrototype;
import net.thevpc.nuts.spi.NutsSingleton;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsWorkspaceFactory
implements NutsWorkspaceFactory {
    private final NutsLogger LOG;
    private final ListMap<Class, Object> instances = new ListMap();
    private final Map<Class, Object> singletons = new HashMap<Class, Object>();
    private final Map<NutsId, IdCache> discoveredCacheById = new HashMap<NutsId, IdCache>();
    private final Map<Class, CachedConstructor> cachedCtrls = new HashMap<Class, CachedConstructor>();
    private final HashMap<String, String> _alreadyLogger = new HashMap();
    private final NutsWorkspace workspace;

    public DefaultNutsWorkspaceFactory(NutsWorkspace ws) {
        this.workspace = ws;
        this.LOG = ((DefaultNutsWorkspace)ws).LOG;
    }

    @Override
    public Set<Class> discoverTypes(NutsId id, URL url, ClassLoader bootClassLoader, NutsSession session) {
        return this.discoverTypes(id, url, bootClassLoader, new Class[]{NutsComponent.class}, session);
    }

    @Override
    public Set<Class> discoverTypes(NutsId id, URL url, ClassLoader bootClassLoader, Class[] extensionPoints, NutsSession session) {
        if (!this.discoveredCacheById.containsKey(id)) {
            IdCache value = new IdCache(id, url, bootClassLoader, this.LOG, extensionPoints, session, this.workspace);
            this.discoveredCacheById.put(id, value);
            HashSet<Class> all = new HashSet<Class>();
            for (ClassClassMap m : value.classes.values()) {
                all.addAll(m.values());
            }
            return all;
        }
        return Collections.emptySet();
    }

    @Override
    public <T extends NutsComponent> T createSupported(Class<T> type, Object supportCriteria, boolean required, NutsSession session) {
        int bestSupportLevel = Integer.MIN_VALUE;
        NutsComponent bestObj = null;
        NutsDefaultSupportLevelContext context = new NutsDefaultSupportLevelContext(session, supportCriteria);
        for (NutsComponent t : this.createAll(type, session)) {
            int supportLevel = t.getSupportLevel((NutsSupportLevelContext)context);
            if (supportLevel <= 0 || bestObj != null && supportLevel <= bestSupportLevel) continue;
            bestSupportLevel = supportLevel;
            bestObj = t;
        }
        if (required && bestObj == null) {
            switch (type.getName()) {
                case "net.thevpc.nuts.NutsIdParser": {
                    return (T)new DefaultNutsIdParser(session);
                }
                case "net.thevpc.nuts.NutsIdBuilder": {
                    return (T)new DefaultNutsIdBuilder(session);
                }
                case "net.thevpc.nuts.NutsEnvConditionBuilder": {
                    return (T)new DefaultNutsEnvConditionBuilder(session);
                }
                case "net.thevpc.nuts.NutsVersionParser": {
                    return (T)new DefaultNutsVersionParser(session);
                }
            }
            throw new NutsExtensionNotFoundException(session, type, supportCriteria);
        }
        return (T)bestObj;
    }

    @Override
    public <T extends NutsComponent> List<T> createAllSupported(Class<T> type, Object supportCriteria, NutsSession session) {
        List<T> list = this.createAll(type, session);
        class TypeAndLevel {
            final T t;
            final int lvl;

            public TypeAndLevel(T t, int lvl) {
                this.t = t;
                this.lvl = lvl;
            }
        }
        ArrayList<TypeAndLevel> r = new ArrayList<TypeAndLevel>();
        NutsDefaultSupportLevelContext context = new NutsDefaultSupportLevelContext(session, supportCriteria);
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            NutsComponent t = (NutsComponent)iterator.next();
            int supportLevel = t.getSupportLevel((NutsSupportLevelContext)context);
            if (supportLevel <= 0) {
                iterator.remove();
                continue;
            }
            r.add(new TypeAndLevel(t, supportLevel));
        }
        return r.stream().sorted(Comparator.comparing(x -> -x.lvl)).map(x -> x.t).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> createAll(Class<T> type, NutsSession session) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Object obj : this.instances.getAll(type)) {
            all.add(obj);
        }
        for (Class c : this.getExtensionTypes(type, session)) {
            Object obj = null;
            try {
                obj = this.resolveInstance(c, type, session);
            }
            catch (Exception e) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0} for {1} : {2}", (Object[])new Object[]{c, type, e}));
            }
            if (obj == null) continue;
            all.add(obj);
        }
        return all;
    }

    @Override
    public <T> T createFirst(Class<T> type, NutsSession session) {
        Iterator<Object> iterator = this.instances.getAll(type).iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            return (T)obj;
        }
        iterator = this.getExtensionTypes(type, session).iterator();
        if (iterator.hasNext()) {
            Class c = (Class)iterator.next();
            return this.resolveInstance(c, type, session);
        }
        return null;
    }

    @Override
    public Set<Class> getExtensionTypes(Class type, NutsSession session) {
        LinkedHashSet<Class> all = new LinkedHashSet<Class>();
        for (IdCache v : this.discoveredCacheById.values()) {
            all.addAll(v.getExtensionTypes(type));
        }
        return all;
    }

    @Override
    public List<Object> getExtensionObjects(Class extensionPoint) {
        return new ArrayList<Object>(this.instances.getAll(extensionPoint));
    }

    @Override
    public boolean isRegisteredType(Class extensionPoint, String implementation, NutsSession session) {
        return this.findRegisteredType(extensionPoint, implementation, session) != null;
    }

    @Override
    public boolean isRegisteredInstance(Class extensionPoint, Object implementation, NutsSession session) {
        return this.instances.contains(extensionPoint, implementation);
    }

    @Override
    public <T> void registerInstance(Class<T> extensionPoint, T implementation, NutsSession session) {
        this.checkSession(session);
        if (this.isRegisteredInstance(extensionPoint, implementation, session)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"already registered Extension %s for %s", (Object[])new Object[]{implementation, extensionPoint.getName()}));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"bind    {0} for impl instance {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(extensionPoint.getSimpleName(), 40), implementation.getClass().getName()}));
        }
        this.instances.add(extensionPoint, implementation);
    }

    @Override
    public void registerType(Class extensionPoint, Class implementation, NutsId source, NutsSession session) {
        IdCache t;
        this.checkSession(session);
        if (this.isRegisteredType(extensionPoint, implementation.getName(), session)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"already registered Extension %s for %s", (Object[])new Object[]{implementation.getName(), extensionPoint.getName()}));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"bind    {0} for impl type {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(extensionPoint.getSimpleName(), 40), implementation.getName()}));
        }
        if ((t = this.discoveredCacheById.get(source)) == null) {
            t = new IdCache(source, this.workspace);
            this.discoveredCacheById.put(source, t);
        }
        t.add(NutsComponent.class, implementation);
    }

    @Override
    public boolean isRegisteredType(Class extensionPoint, Class implementation, NutsSession session) {
        return this.getExtensionTypes(extensionPoint, session).contains(implementation);
    }

    public Class findRegisteredType(Class extensionPoint, String implementation, NutsSession session) {
        for (Class cls : this.getExtensionTypes(extensionPoint, session)) {
            if (!cls.getName().equals(implementation)) continue;
            return cls;
        }
        return null;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
    }

    private Object resolveClassSource(Class implementation) {
        return null;
    }

    protected <T> CachedConstructor<T> getCtrl0(Class<T> t, NutsSession session) {
        CachedConstructor o = this.cachedCtrls.get(t);
        if (o != null) {
            return o;
        }
        try {
            final Constructor<T> ctrl = t.getDeclaredConstructor(NutsSession.class);
            ctrl.setAccessible(true);
            CachedConstructor r = new CachedConstructor<T>(){

                @Override
                public Constructor<T> ctrl() {
                    return ctrl;
                }

                @Override
                public Object[] args(NutsSession session) {
                    return new Object[]{session};
                }
            };
            this.cachedCtrls.put(t, r);
            return r;
        }
        catch (NoSuchMethodException ctrl) {
            try {
                final Constructor<T> ctrl2 = t.getDeclaredConstructor(NutsWorkspace.class);
                ctrl2.setAccessible(true);
                CachedConstructor r = new CachedConstructor<T>(){

                    @Override
                    public Constructor<T> ctrl() {
                        return ctrl2;
                    }

                    @Override
                    public Object[] args(NutsSession session) {
                        return new Object[]{session.getWorkspace()};
                    }
                };
                this.cachedCtrls.put(t, r);
                return r;
            }
            catch (NoSuchMethodException ctrl2) {
                try {
                    final Constructor<T> ctrl3 = t.getDeclaredConstructor(new Class[0]);
                    ctrl3.setAccessible(true);
                    CachedConstructor r = new CachedConstructor<T>(){

                        @Override
                        public Constructor<T> ctrl() {
                            return ctrl3;
                        }

                        @Override
                        public Object[] args(NutsSession session) {
                            return new Object[0];
                        }
                    };
                    this.cachedCtrls.put(t, r);
                    return r;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        }
    }

    protected <T> T instantiate0(Class<T> t, NutsSession session, Class apiType) {
        this.checkSession(session);
        T theInstance = null;
        CachedConstructor<T> ctrl = this.getCtrl0(t, session);
        if (ctrl == null) {
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed. missing constructor", (Object[])new Object[]{t}));
        }
        try {
            theInstance = ctrl.ctrl().newInstance(ctrl.args(session));
        }
        catch (InstantiationException | InvocationTargetException e) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NutsMessage.cstyle((String)"unable to instantiate %s as %s", (Object[])new Object[]{apiType, t}), e, session);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0}", (Object[])new Object[]{t}));
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), cause);
        }
        catch (IllegalAccessException e) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NutsMessage.cstyle((String)"unable to instantiate %s as %s", (Object[])new Object[]{apiType, t}), e, session);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0}", (Object[])new Object[]{t}));
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), (Throwable)e);
        }
        return theInstance;
    }

    protected <T> T instantiate0(Class<T> t, Class[] argTypes, Object[] args, Class apiType, NutsSession session) {
        this.checkSession(session);
        T t1 = null;
        try {
            t1 = t.getConstructor(argTypes).newInstance(args);
        }
        catch (InstantiationException e) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NutsMessage.cstyle((String)"unable to instantiate %s as %s", (Object[])new Object[]{apiType, t}), e, session);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0}", (Object[])new Object[]{t}));
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), cause);
        }
        catch (Exception e) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NutsMessage.cstyle((String)"unable to instantiate %s as %s", (Object[])new Object[]{apiType, t}), e, session);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0}", (Object[])new Object[]{t}));
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), (Throwable)e);
        }
        return t1;
    }

    protected <T> T resolveInstance(Class<T> implType, Class<T> apiType, NutsSession session) {
        if (implType == null) {
            return null;
        }
        NutsComponentScopeType scope = this.computeScope(implType, apiType, session);
        switch (scope) {
            case WORKSPACE: {
                Object o = this.singletons.get(implType);
                if (o == null && (o = this.instantiate0(implType, session, apiType)) != null) {
                    this.singletons.put(implType, o);
                    this.doLogInstantiation(apiType, o.getClass(), "singleton", session);
                }
                return (T)o;
            }
            case SESSION: {
                String key = "session-scoped:" + Integer.toHexString(System.identityHashCode(session)).toUpperCase() + ":" + implType.getName();
                Object o = session.getProperty(key);
                if (o == null && (o = this.instantiate0(implType, session, apiType)) != null) {
                    session.setProperty(key, o);
                    this.doLogInstantiation(apiType, o.getClass(), "session", session);
                }
                return (T)o;
            }
        }
        T o = this.instantiate0(implType, session, apiType);
        if (o != null) {
            this.doLogInstantiation(apiType, o.getClass(), "prototype", session);
        }
        return o;
    }

    private <T> NutsComponentScopeType computeScope(Class<T> implType, Class<T> apiType, NutsSession session) {
        NutsComponentScope apiScope = apiType.getAnnotation(NutsComponentScope.class);
        NutsComponentScope implScope = implType.getAnnotation(NutsComponentScope.class);
        NutsComponentScopeType scope = NutsComponentScopeType.PROTOTYPE;
        if (apiScope != null || implScope != null) {
            if (apiScope != null && implScope == null) {
                scope = apiScope.value();
            } else if (apiScope == null && implScope != null) {
                scope = implScope.value();
            } else if (apiScope.value() == implScope.value()) {
                scope = apiScope.value();
            } else {
                scope = apiScope.value();
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    switch (apiType.getName()) {
                        case "net.thevpc.nuts.NutsTexts": {
                            break;
                        }
                        default: {
                            this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"invalid scope {0} ; expected {1} for  {2}", (Object[])new Object[]{implScope.value(), apiScope.value(), implType.getName()}));
                        }
                    }
                }
            }
        }
        return scope;
    }

    public void safeLog(NutsMessage msg, Throwable any, NutsSession session) {
        PrintStream err = NutsWorkspaceExt.of((NutsSession)session).getModel().bootModel.getBootTerminal().getErr();
        if (err == null) {
            err = System.err;
        }
        err.println(msg.toString() + ":");
        any.printStackTrace();
    }

    public boolean isBootstrapLogType(Class apiType) {
        switch (apiType.getName()) {
            case "net.thevpc.nuts.spi.NutsPaths": 
            case "net.thevpc.nuts.NutsTexts": 
            case "net.thevpc.nuts.spi.NutsLogManager": 
            case "net.thevpc.nuts.NutsLogger": 
            case "net.thevpc.nuts.NutsLoggerOp": {
                return true;
            }
        }
        return false;
    }

    private void doLogInstantiation(Class baseType, Class implType, String scope, NutsSession session) {
        String old;
        if (this.isBootstrapLogType(baseType)) {
            return;
        }
        if (this.LOG.isLoggable(Level.CONFIG) && ((old = this._alreadyLogger.get(baseType.getName())) == null || !old.equals(implType.getName()))) {
            this._alreadyLogger.put(baseType.getName(), implType.getName());
            this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"resolve {0} to  ```underlined {1}``` {2}", (Object[])new Object[]{CoreStringUtils.alignLeft(baseType.getSimpleName(), 40), scope, implType.getName()}));
        }
    }

    private NutsSession validLogSession(NutsSession session) {
        if (session == null) {
            return NutsWorkspaceUtils.defaultSession(this.workspace);
        }
        if (session.getTerminal() == null) {
            return NutsWorkspaceUtils.defaultSession(this.workspace);
        }
        return session;
    }

    protected <T> T resolveInstance(Class<T> type, Class<T> apiType, Class[] argTypes, Object[] args, NutsSession session) {
        this.checkSession(session);
        if (type == null) {
            return null;
        }
        Boolean singleton = null;
        if (apiType.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (apiType.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (type.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (type.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (singleton == null) {
            singleton = false;
        }
        if (singleton.booleanValue()) {
            if (argTypes.length > 0) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"singletons should have no arg types", (Object[])new Object[0]));
            }
            Object o = this.singletons.get(type);
            if (o == null) {
                o = this.instantiate0(type, session, apiType);
                this.singletons.put(type, o);
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"resolve {0} to  ```underlined singleton``` {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(apiType.getSimpleName(), 40), o.getClass().getName()}));
                }
            }
            return (T)o;
        }
        T o = this.instantiate0(type, argTypes, args, apiType, session);
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"resolve {0} to  ```underlined prototype``` {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(apiType.getSimpleName(), 40), o.getClass().getName()}));
        }
        return o;
    }

    public <T> T create(Class<T> type, NutsSession session) {
        this.checkSession(session);
        Object one = this.instances.getOne(type);
        if (one != null) {
            if (this.LOG.isLoggable(Level.CONFIG)) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.FINEST).verb(NutsLogVerb.READ).log(NutsMessage.jstyle((String)"resolve {0} to singleton {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(type.getSimpleName(), 40), one.getClass().getName()}));
            }
            return (T)one;
        }
        Set<Class> extensionTypes = this.getExtensionTypes(type, session);
        Iterator<Class> iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class e = iterator.next();
            return this.resolveInstance(e, type, session);
        }
        iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class t = iterator.next();
            return this.instantiate0(t, session, type);
        }
        throw new NutsElementNotFoundException(session, NutsMessage.cstyle((String)"type %s not found", (Object[])new Object[]{type}));
    }

    public <T> List<T> createAll(Class<T> type, Class[] argTypes, Object[] args, NutsSession session) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Class c : this.getExtensionTypes(type, session)) {
            Object obj = null;
            try {
                obj = this.resolveInstance(c, type, argTypes, args, session);
            }
            catch (Exception e) {
                this.LOG.with().session(this.validLogSession(session)).level(Level.WARNING).verb(NutsLogVerb.FAIL).error((Throwable)e).log(NutsMessage.jstyle((String)"unable to instantiate {0} for {1} : {2}", (Object[])new Object[]{c, type, e}));
            }
            if (obj == null) continue;
            all.add(obj);
        }
        return all;
    }

    private static class IdCache {
        private final NutsId id;
        private final Map<Class, ClassClassMap> classes = new HashMap<Class, ClassClassMap>();
        private final Map<Class, Set<Class>> cacheExtensionTypes = new HashMap<Class, Set<Class>>();
        private final NutsWorkspace workspace;
        private URL url;

        public IdCache(NutsId id, NutsWorkspace workspace) {
            this.id = id;
            this.workspace = workspace;
        }

        public IdCache(NutsId id, URL url, ClassLoader bootClassLoader, NutsLogger LOG, Class[] extensionPoints, NutsSession session, NutsWorkspace workspace) {
            this.id = id;
            this.url = url;
            this.workspace = workspace;
            for (Class extensionPoint : extensionPoints) {
                ClassClassMap cc = new ClassClassMap();
                this.classes.put(extensionPoint, cc);
                Class<NutsComponent> serviceClass = NutsComponent.class;
                for (String n : CoreServiceUtils.loadZipServiceClassNames(url, serviceClass, session)) {
                    Class<?> c = null;
                    try {
                        c = Class.forName(n, false, bootClassLoader);
                    }
                    catch (ClassNotFoundException x) {
                        LOG.with().session(this.validLogSession(session)).verb(NutsLogVerb.WARNING).level(Level.FINE).error((Throwable)x).log(NutsMessage.jstyle((String)"not a valid type {0}", (Object[])new Object[]{c}));
                    }
                    if (c == null) continue;
                    if (!serviceClass.isAssignableFrom(c)) {
                        LOG.with().session(this.validLogSession(session)).verb(NutsLogVerb.WARNING).level(Level.FINE).log(NutsMessage.jstyle((String)"not a valid type {0} <> {1}, ignore...", (Object[])new Object[]{c, serviceClass}));
                        continue;
                    }
                    cc.add(c);
                }
            }
        }

        private NutsSession validLogSession(NutsSession session) {
            if (session == null) {
                return NutsWorkspaceUtils.defaultSession(this.workspace);
            }
            if (session.getTerminal() == null) {
                return NutsWorkspaceUtils.defaultSession(this.workspace);
            }
            return session;
        }

        private void add(Class extensionPoint, Class implementation) {
            ClassClassMap y = this.getClassClassMap(extensionPoint, true);
            if (!y.containsExactKey(implementation)) {
                y.add(implementation);
                this.invalidateCache();
            }
        }

        private void invalidateCache() {
            this.cacheExtensionTypes.clear();
        }

        private ClassClassMap getClassClassMap(Class extensionPoint, boolean create) {
            ClassClassMap r = this.classes.get(extensionPoint);
            if (r == null && create) {
                r = new ClassClassMap();
                this.classes.put(extensionPoint, r);
            }
            return r;
        }

        public NutsId getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public Set<Class> getExtensionPoints() {
            return new LinkedHashSet<Class>(this.classes.keySet());
        }

        public Set<Class> getExtensionTypes(Class extensionPoint) {
            Set<Class<Object>> r = this.cacheExtensionTypes.get(extensionPoint);
            if (r != null) {
                return r;
            }
            LinkedHashSet all = new LinkedHashSet();
            for (Map.Entry<Class, ClassClassMap> rr : this.classes.entrySet()) {
                if (!rr.getKey().isAssignableFrom(extensionPoint)) continue;
                all.addAll(Arrays.asList(rr.getValue().getAll(extensionPoint)));
            }
            r = Collections.unmodifiableSet(all);
            this.cacheExtensionTypes.put(extensionPoint, r);
            return r;
        }
    }

    private static final class ClassExtension {
        Class clazz;
        Object source;
        boolean enabled = true;

        public ClassExtension(Class clazz, Object source, boolean enabled) {
            this.clazz = clazz;
            this.source = source;
            this.enabled = enabled;
        }
    }

    private static interface CachedConstructor<T> {
        public Constructor<T> ctrl();

        public Object[] args(NutsSession var1);
    }
}

