/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLines;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsCustomCommandManager;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDeployCommand;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsHashName;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsImportManager;
import net.thevpc.nuts.NutsInfoCommand;
import net.thevpc.nuts.NutsInputStreams;
import net.thevpc.nuts.NutsInstallCommand;
import net.thevpc.nuts.NutsInstallException;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsParseEnumException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreams;
import net.thevpc.nuts.NutsPushCommand;
import net.thevpc.nuts.NutsReadOnlyException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTableModel;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUndeployCommand;
import net.thevpc.nuts.NutsUninstallCommand;
import net.thevpc.nuts.NutsUpdateCommand;
import net.thevpc.nuts.NutsUpdateStatisticsCommand;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFormat;
import net.thevpc.nuts.NutsWorkspaceAlreadyExistsException;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceEventManager;
import net.thevpc.nuts.NutsWorkspaceExtensionManager;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.NutsWorkspaceNotFoundException;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.boot.NutsApiUtils;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootManager;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootConfig;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvCondition;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsProperties;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NutsDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsInstallEvent;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsUpdateEvent;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEventManager;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEventModel;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNutsWorkspaceExtensionManager;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNutsWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.extension.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsId;
import net.thevpc.nuts.runtime.standalone.installer.CommandForIdNutsInstallerComponent;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogModel;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogger;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepositoryManager;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepositoryModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.runtime.standalone.session.DefaultNutsSession;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.standalone.text.util.NutsTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreTimeUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersion;
import net.thevpc.nuts.runtime.standalone.version.DefaultNutsVersionParser;
import net.thevpc.nuts.runtime.standalone.workspace.AbstractNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNutsExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsExecutionContextBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.deploy.DefaultNutsDeployCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsExecCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.fetch.DefaultNutsFetchCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.info.DefaultNutsInfoCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.install.DefaultNutsInstallCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.push.DefaultNutsPushCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.search.DefaultNutsSearchCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.updatestats.DefaultNutsUpdateStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy.DefaultNutsUndeployCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall.DefaultNutsUninstallCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.update.DefaultNutsUpdateCommand;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultCustomCommandManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultCustomCommandsModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceLocationModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceModel;
import net.thevpc.nuts.spi.NutsBootDescriptor;
import net.thevpc.nuts.spi.NutsBootId;
import net.thevpc.nuts.spi.NutsBootVersion;
import net.thevpc.nuts.spi.NutsBootWorkspaceFactory;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsInstallerComponent;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsRepositorySelectorList;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsTerminals;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsComponentScope(value=NutsComponentScopeType.PROTOTYPE)
public class DefaultNutsWorkspace
extends AbstractNutsWorkspace
implements NutsWorkspaceExt {
    public static final String VERSION_INSTALL_INFO_CONFIG = "0.8.0";
    public static final String VERSION_SDK_LOCATION = "0.8.0";
    public static final String VERSION_REPOSITORY_CONFIG = "0.8.0";
    public static final String VERSION_REPOSITORY_REF = "0.8.0";
    public static final String VERSION_WS_CONFIG_API = "0.8.0";
    public static final String VERSION_WS_CONFIG_BOOT = "0.8.0";
    public static final String VERSION_WS_CONFIG_MAIN = "0.8.0";
    public static final String VERSION_WS_CONFIG_RUNTIME = "0.8.0";
    public static final String VERSION_WS_CONFIG_SECURITY = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG_FACTORY = "0.8.0";
    public static final String VERSION_USER_CONFIG = "0.8.0";
    public NutsLogger LOG;
    private NutsWorkspaceModel wsModel;

    public DefaultNutsWorkspace(NutsBootOptions info) {
        this.initWorkspace(info);
    }

    private static Set<NutsBootId> toIds(NutsBootDescriptor[] all) {
        LinkedHashSet<NutsBootId> set = new LinkedHashSet<NutsBootId>();
        for (NutsBootDescriptor i : all) {
            set.add(i.getId());
            Collections.addAll(set, i.getDependencies());
        }
        return set;
    }

    private void initWorkspace(NutsBootOptions bOption0) {
        try {
            String n;
            this.wsModel = new NutsWorkspaceModel(this);
            this.wsModel.bootModel = new DefaultNutsBootModel(this, bOption0);
            this.LOG = new DefaultNutsLogger(this, this.defaultSession(), DefaultNutsWorkspace.class, true);
            CoreNutsBootOptions bOptions = this.wsModel.bootModel.getCoreBootOptions();
            NutsWorkspaceOptions options = bOptions.getOptions();
            this.wsModel.configModel = new DefaultNutsWorkspaceConfigModel(this);
            String workspaceLocation = bOptions.getWorkspaceLocation();
            String apiVersion = bOptions.getApiVersion();
            NutsBootId runtimeId = bOptions.getRuntimeId();
            String repositories = bOptions.getBootRepositories();
            NutsBootWorkspaceFactory bootFactory = bOptions.getBootWorkspaceFactory();
            ClassLoader bootClassLoader = bOptions.getClassWorldLoader();
            NutsWorkspaceConfigManager _config = this.defaultSession().config();
            NutsBootManager _boot = this.defaultSession().boot();
            NutsBootConfig cfg = new NutsBootConfig();
            cfg.setWorkspace(workspaceLocation);
            cfg.setApiVersion(apiVersion);
            cfg.setRuntimeId(runtimeId == null ? null : runtimeId.toString());
            cfg.setRuntimeBootDescriptor(bOptions.getRuntimeBootDescriptor());
            cfg.setExtensionBootDescriptors(bOptions.getExtensionBootDescriptors());
            DefaultNutsVersionParser vparser = new DefaultNutsVersionParser(this.defaultSession());
            this.wsModel.apiVersion = vparser.parse(Nuts.getVersion());
            this.wsModel.apiId = new DefaultNutsId("net.thevpc.nuts", "nuts", (NutsVersion)new DefaultNutsVersion(apiVersion, this.defaultSession()), null, (Map<String, String>)null, (NutsEnvCondition)new DefaultNutsEnvCondition(this.defaultSession()), this.defaultSession());
            this.wsModel.runtimeId = new DefaultNutsId(bOptions.getRuntimeId().getGroupId(), bOptions.getRuntimeId().getArtifactId(), vparser.parse(bOptions.getRuntimeId().getVersion().toString()), null, (Map<String, String>)null, (NutsEnvCondition)new DefaultNutsEnvCondition(this.defaultSession()), this.defaultSession());
            this.wsModel.extensionModel = new DefaultNutsWorkspaceExtensionModel(this, bootFactory, options.getExcludedExtensions(), this.defaultSession());
            this.wsModel.extensionModel.onInitializeWorkspace(bOptions, bootClassLoader, this.defaultSession());
            this.wsModel.logModel = new DefaultNutsLogModel(this, bOptions);
            this.wsModel.logModel.setDefaultSession(this.defaultSession());
            this.wsModel.filtersModel = new DefaultNutsFilterModel(this);
            this.wsModel.installedRepository = new DefaultNutsInstalledRepository(this, bOptions);
            this.wsModel.repositoryModel = new DefaultNutsRepositoryModel(this);
            this.wsModel.envModel = new DefaultNutsWorkspaceEnvManagerModel(this, this.defaultSession());
            this.wsModel.aliasesModel = new DefaultCustomCommandsModel(this);
            this.wsModel.importModel = new DefaultImportModel(this);
            this.wsModel.locationsModel = new DefaultNutsWorkspaceLocationModel(this, Paths.get(bOptions.getWorkspaceLocation(), new String[0]).toString());
            this.wsModel.eventsModel = new DefaultNutsWorkspaceEventModel(this);
            this.wsModel.textModel = new DefaultNutsTextManagerModel(this);
            this.wsModel.location = bOptions.getWorkspaceLocation();
            this.wsModel.bootModel.onInitializeWorkspace();
            NutsSystemTerminalBase termb = (NutsSystemTerminalBase)this.defaultSession().extensions().createSupported(NutsSystemTerminalBase.class, true, null);
            this.defaultSession().config().setSystemTerminal(termb).setDefaultTerminal(NutsSessionTerminal.of((NutsSession)this.defaultSession()));
            this.wsModel.bootModel.bootSession().setTerminal(NutsSessionTerminal.of((NutsSession)this.wsModel.bootModel.bootSession()));
            ((DefaultNutsLogger)this.LOG).resumeTerminal(this.defaultSession());
            NutsTexts text = NutsTexts.of((NutsSession)this.defaultSession());
            try {
                text.getTheme();
            }
            catch (Exception ex) {
                this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.FAIL).session(this.defaultSession()).log(NutsMessage.jstyle((String)"unable to load theme {0}. Reset to default!", (Object[])new Object[]{options.getTheme()}));
                text.setTheme("");
            }
            NutsLoggerOp LOGCRF = this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.READ).session(this.defaultSession());
            NutsLoggerOp LOGCSF = this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.START).session(this.defaultSession());
            NutsElements elems = NutsElements.of((NutsSession)this.defaultSession());
            if (this.LOG.isLoggable(Level.CONFIG)) {
                NutsCommandLines.of((NutsSession)this.defaultSession());
                NutsTerminals.of((NutsSession)this.defaultSession());
                NutsPrintStreams.of((NutsSession)this.defaultSession());
                NutsVersionFormat.of((NutsSession)this.defaultSession());
                NutsIdFormat.of((NutsSession)this.defaultSession());
                NutsInputStreams.of((NutsSession)this.defaultSession());
                NutsIdParser.of((NutsSession)this.defaultSession());
                LOGCSF.log(NutsMessage.jstyle((String)" ===============================================================================", (Object[])new Object[0]));
                String s = CoreIOUtils.loadString(this.getClass().getResourceAsStream("/net/thevpc/nuts/runtime/includes/standard-header.ntf"), true, this.defaultSession());
                s = s.replace("${nuts.workspace-runtime.version}", Nuts.getVersion());
                for (String s1 : s.split("\n")) {
                    LOGCSF.log(NutsMessage.jstyle((String)s1, (Object[])new Object[0]));
                }
                LOGCSF.log(NutsMessage.jstyle((String)" ", (Object[])new Object[0]));
                LOGCSF.log(NutsMessage.jstyle((String)" = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =", (Object[])new Object[0]));
                LOGCSF.log(NutsMessage.jstyle((String)" ", (Object[])new Object[0]));
                LOGCSF.log(NutsMessage.jstyle((String)"start ```sh nuts``` ```primary3 {0}``` at {1}", (Object[])new Object[]{Nuts.getVersion(), CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(options.getCreationTime()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"open Nuts Workspace               : {0}", (Object[])new Object[]{options.formatter().getBootCommandLine()}));
                LOGCRF.log(NutsMessage.jstyle((String)"open Nuts Workspace (compact)     : {0}", (Object[])new Object[]{options.formatter().setCompact(true).getBootCommandLine()}));
                LOGCRF.log(NutsMessage.jstyle((String)"open Workspace with config        : ", (Object[])new Object[0]));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-workspace-uuid            : {0}", (Object[])new Object[]{NutsTextUtils.desc(bOptions.getUuid(), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-workspace-name            : {0}", (Object[])new Object[]{NutsTextUtils.desc(bOptions.getName(), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-api-version               : {0}", (Object[])new Object[]{NutsVersion.of((String)Nuts.getVersion(), (NutsSession)this.defaultSession())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-api-url                   : {0}", (Object[])new Object[]{NutsPath.of((URL)this.getApiURL(), (NutsSession)this.defaultSession())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-api-digest                : {0}", (Object[])new Object[]{text.ofStyled(this.getApiDigest(), NutsTextStyle.version())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-boot-repositories         : {0}", (Object[])new Object[]{NutsTextUtils.desc(bOptions.getBootRepositories(), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-runtime                   : {0}", (Object[])new Object[]{this.getRuntimeId()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-runtime-digest            : {0}", (Object[])new Object[]{text.ofStyled(new CoreDigestHelper(this.defaultSession()).append(bOptions.getClassWorldURLs()).getDigest(), NutsTextStyle.version())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-runtime-dependencies      : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)text.ofStyled(";", NutsTextStyle.separator()), (Collection)Arrays.stream(bOptions.getRuntimeBootDescriptor().getDependencies()).map(x -> NutsId.of((String)x.toString(), (NutsSession)this.defaultSession())).collect(Collectors.toList()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-runtime-urls              : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)text.ofStyled(";", NutsTextStyle.separator()), (Collection)Arrays.stream(bOptions.getClassWorldURLs()).map(x -> NutsPath.of((String)x.toString(), (NutsSession)this.defaultSession())).collect(Collectors.toList()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-extension-dependencies    : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)text.ofStyled(";", NutsTextStyle.separator()), (Collection)DefaultNutsWorkspace.toIds(bOptions.getExtensionBootDescriptors()).stream().map(x -> NutsId.of((String)x.toString(), (NutsSession)this.defaultSession())).collect(Collectors.toList()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-workspace                 : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getWorkspace(), bOptions.getWorkspaceLocation())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-hash-name                 : {0}", (Object[])new Object[]{this.getHashName()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-apps                : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.APPS), bOptions.getStoreLocation(NutsStoreLocation.APPS))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-config              : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.CONFIG), bOptions.getStoreLocation(NutsStoreLocation.CONFIG))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-var                 : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.VAR), bOptions.getStoreLocation(NutsStoreLocation.VAR))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-log                 : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.LOG), bOptions.getStoreLocation(NutsStoreLocation.LOG))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-temp                : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.TEMP), bOptions.getStoreLocation(NutsStoreLocation.TEMP))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-cache               : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.CACHE), bOptions.getStoreLocation(NutsStoreLocation.CACHE))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-run                 : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.RUN), bOptions.getStoreLocation(NutsStoreLocation.RUN))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-lib                 : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocation(NutsStoreLocation.LIB), bOptions.getStoreLocation(NutsStoreLocation.LIB))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-strategy            : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocationStrategy(), bOptions.getStoreLocationStrategy())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-repos-store-strategy      : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getRepositoryStoreLocationStrategy(), bOptions.getRepositoryStoreLocationStrategy())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   nuts-store-layout              : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getStoreLocationLayout(), bOptions.getStoreLocationLayout() == null ? "system" : bOptions.getStoreLocationLayout())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   option-read-only               : {0}", (Object[])new Object[]{options.isReadOnly()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   option-trace                   : {0}", (Object[])new Object[]{options.isTrace()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   option-progress                : {0}", (Object[])new Object[]{NutsTextUtils.desc(options.getProgressOptions(), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   inherited                      : {0}", (Object[])new Object[]{options.isInherited()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   inherited-nuts-boot-args       : {0}", (Object[])new Object[]{System.getProperty("nuts.boot.args") == null ? NutsTextUtils.desc(null, text) : NutsTextUtils.desc(NutsCommandLine.of((String)System.getProperty("nuts.boot.args"), (NutsShellFamily)NutsShellFamily.SH, (NutsSession)this.defaultSession()), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   inherited-nuts-args            : {0}", (Object[])new Object[]{System.getProperty("nuts.args") == null ? NutsTextUtils.desc(null, text) : NutsTextUtils.desc(text.toText((Object)NutsCommandLine.of((String)System.getProperty("nuts.args"), (NutsShellFamily)NutsShellFamily.SH, (NutsSession)this.defaultSession())), text)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   option-open-mode               : {0}", (Object[])new Object[]{NutsTextUtils.formatLogValue(text, options.getOpenMode(), options.getOpenMode() == null ? NutsOpenMode.OPEN_OR_CREATE : options.getOpenMode())}));
                NutsBootTerminal b = this.getModel().bootModel.getBootTerminal();
                LOGCRF.log(NutsMessage.jstyle((String)"   sys-terminal-flags             : {0}", (Object[])new Object[]{String.join((CharSequence)", ", b.getFlags())}));
                NutsTerminalMode terminalMode = this.wsModel.bootModel.getBootOptions().getTerminalMode();
                LOGCRF.log(NutsMessage.jstyle((String)"   sys-terminal-mode              : {0}", (Object[])new Object[]{terminalMode == null ? "default" : terminalMode}));
                NutsWorkspaceEnvManager senv = this.defaultSession().env();
                LOGCRF.log(NutsMessage.jstyle((String)"   java-home                      : {0}", (Object[])new Object[]{System.getProperty("java.home")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   java-classpath                 : {0}", (Object[])new Object[]{System.getProperty("java.class.path")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   java-library-path              : {0}", (Object[])new Object[]{System.getProperty("java.library.path")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-name                        : {0}", (Object[])new Object[]{System.getProperty("os.name")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-family                      : {0}", (Object[])new Object[]{senv.getOsFamily()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-dist                        : {0}", (Object[])new Object[]{senv.getOsDist().getArtifactId()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-arch                        : {0}", (Object[])new Object[]{System.getProperty("os.arch")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-shell                       : {0}", (Object[])new Object[]{senv.getShellFamily()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-shells                      : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)",", Arrays.asList(senv.getShellFamilies()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktop                     : {0}", (Object[])new Object[]{senv.getDesktopEnvironment()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktop-family              : {0}", (Object[])new Object[]{senv.getDesktopEnvironmentFamily()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktops                    : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)",", Arrays.asList(senv.getDesktopEnvironments()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktop-families            : {0}", (Object[])new Object[]{text.builder().appendJoined((Object)",", Arrays.asList(senv.getDesktopEnvironmentFamilies()))}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktop-path                : {0}", (Object[])new Object[]{senv.getDesktopPath()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-desktop-integration         : {0}", (Object[])new Object[]{senv.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-menu-integration            : {0}", (Object[])new Object[]{senv.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-shortcut-integration        : {0}", (Object[])new Object[]{senv.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT)}));
                LOGCRF.log(NutsMessage.jstyle((String)"   os-version                     : {0}", (Object[])new Object[]{senv.getOsDist().getVersion()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   user-name                      : {0}", (Object[])new Object[]{System.getProperty("user.name")}));
                LOGCRF.log(NutsMessage.jstyle((String)"   user-dir                       : {0}", (Object[])new Object[]{NutsPath.of((String)System.getProperty("user.dir"), (NutsSession)this.defaultSession())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   user-home                      : {0}", (Object[])new Object[]{NutsPath.of((String)System.getProperty("user.home"), (NutsSession)this.defaultSession())}));
                LOGCRF.log(NutsMessage.jstyle((String)"   user-locale                    : {0}", (Object[])new Object[]{Locale.getDefault()}));
                LOGCRF.log(NutsMessage.jstyle((String)"   user-time-zone                 : {0}", (Object[])new Object[]{TimeZone.getDefault()}));
            }
            this.wsModel.securityModel = new DefaultNutsWorkspaceSecurityModel(this);
            long now = System.currentTimeMillis();
            if (options.getCreationTime() == 0L || options.getCreationTime() > now) {
                this.wsModel.configModel.setStartCreateTimeMillis(now);
            } else {
                this.wsModel.configModel.setStartCreateTimeMillis(options.getCreationTime());
            }
            boolean exists = NutsWorkspaceConfigManagerExt.of(_config).getModel().isValidWorkspaceFolder(this.defaultSession());
            NutsOpenMode openMode = options.getOpenMode();
            if (openMode != null) {
                switch (openMode) {
                    case OPEN_OR_ERROR: {
                        if (exists) break;
                        throw new NutsWorkspaceNotFoundException(workspaceLocation);
                    }
                    case CREATE_OR_ERROR: {
                        if (!exists) break;
                        throw new NutsWorkspaceAlreadyExistsException(workspaceLocation);
                    }
                }
            }
            this.wsModel.configModel.onExtensionsPrepared(this.defaultSession());
            boolean justInstalled = false;
            NutsWorkspaceArchetypeComponent justInstalledArchetype = null;
            if (!this.loadWorkspace(this.defaultSession(), options.getExcludedExtensions(), null)) {
                this.wsModel.bootModel.setFirstBoot(true);
                if (this.wsModel.uuid == null) {
                    this.wsModel.uuid = UUID.randomUUID().toString();
                }
                justInstalled = true;
                NutsWorkspaceUtils.of(this.defaultSession()).checkReadOnly();
                this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"creating {0} workspace at {1}", (Object[])new Object[]{text.ofStyled("new", NutsTextStyle.info()), this.defaultSession().locations().getWorkspaceLocation()}));
                NutsWorkspaceConfigBoot bconfig = new NutsWorkspaceConfigBoot();
                bconfig.setUuid(this.wsModel.uuid);
                NutsWorkspaceConfigApi aconfig = new NutsWorkspaceConfigApi();
                aconfig.setApiVersion(apiVersion);
                aconfig.setRuntimeId(runtimeId == null ? null : runtimeId.toString());
                aconfig.setJavaCommand(options.getJavaCommand());
                aconfig.setJavaOptions(options.getJavaOptions());
                NutsWorkspaceConfigRuntime rconfig = new NutsWorkspaceConfigRuntime();
                rconfig.setDependencies(Arrays.stream(bOptions.getRuntimeBootDescriptor().getDependencies()).map(NutsBootId::toString).collect(Collectors.joining(";")));
                rconfig.setId(runtimeId == null ? null : runtimeId.toString());
                bconfig.setBootRepositories(repositories);
                bconfig.setStoreLocationStrategy(options.getStoreLocationStrategy());
                bconfig.setRepositoryStoreLocationStrategy(options.getRepositoryStoreLocationStrategy());
                bconfig.setStoreLocationLayout(options.getStoreLocationLayout());
                bconfig.setGlobal(options.isGlobal());
                bconfig.setStoreLocations(new NutsStoreLocationsMap(options.getStoreLocations()).toMapOrNull());
                bconfig.setHomeLocations(new NutsHomeLocationsMap(options.getHomeLocations()).toMapOrNull());
                boolean namedWorkspace = CoreNutsUtils.isValidWorkspaceName(options.getWorkspace());
                if (bconfig.getStoreLocationStrategy() == null) {
                    bconfig.setStoreLocationStrategy(namedWorkspace ? NutsStoreLocationStrategy.EXPLODED : NutsStoreLocationStrategy.STANDALONE);
                }
                if (bconfig.getRepositoryStoreLocationStrategy() == null) {
                    bconfig.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                }
                bconfig.setName(CoreNutsUtils.resolveValidWorkspaceName(options.getWorkspace()));
                this.wsModel.configModel.setCurrentConfig(new DefaultNutsWorkspaceCurrentConfig(this).merge(aconfig, this.defaultSession()).merge(bconfig, this.defaultSession()).build(this.defaultSession().locations().getWorkspaceLocation(), this.defaultSession()));
                this.wsModel.configModel.setConfigBoot(bconfig, this.defaultSession());
                this.wsModel.configModel.setConfigApi(aconfig, this.defaultSession());
                this.wsModel.configModel.setConfigRuntime(rconfig, this.defaultSession());
                for (String customOption : options.getCustomOptions()) {
                    NutsArgument a = NutsArgument.of((String)customOption, (NutsSession)this.defaultSession());
                    if (!a.getKey().getString().startsWith("config.") || !a.isActive()) continue;
                    this.defaultSession().config().setConfigProperty(a.getKey().getString("").substring("config.".length()), a.getValue().getString());
                }
                justInstalledArchetype = this.initializeWorkspace(options.getArchetype(), this.defaultSession());
                if (!_config.isReadOnly()) {
                    _config.save();
                }
                NutsVersion nutsVersion = this.getRuntimeId().getVersion();
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"nuts workspace v{0} created.", (Object[])new Object[]{nutsVersion}));
                }
                if (this.defaultSession().isPlainTrace() && !_boot.getBootOptions().isSkipWelcome()) {
                    NutsPrintStream out = this.defaultSession().out();
                    out.resetLine();
                    StringBuilder version = new StringBuilder(nutsVersion.toString());
                    CoreStringUtils.fillString(' ', 25 - version.length(), version);
                    NutsTexts txt = text.setSession(this.defaultSession());
                    n = txt.parser().parseResource("/net/thevpc/nuts/runtime/includes/standard-header.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
                    out.println(n == null ? "no help found" : n.toString().trim());
                    if (NutsWorkspaceUtils.isUserDefaultWorkspace(this.defaultSession())) {
                        out.println((NutsString)txt.builder().append((Object)"location", NutsTextStyle.underlined()).append((Object)":").append((Object)this.defaultSession().locations().getWorkspaceLocation()).append((Object)" "));
                    } else {
                        out.println((NutsString)txt.builder().append((Object)"location", NutsTextStyle.underlined()).append((Object)":").append((Object)this.defaultSession().locations().getWorkspaceLocation()).append((Object)" ").append((Object)" (").append((Object)this.getHashName()).append((Object)")"));
                    }
                    NutsTableFormat.of((NutsSession)this.defaultSession()).setValue((Object)NutsTableModel.of((NutsSession)this.defaultSession()).addCell((Object)txt.builder().append((Object)" This is the very first time ").appendCode("sh", "nuts").append((Object)" has been launched for this workspace "))).println(out);
                    out.println();
                }
                this.wsModel.configModel.installBootIds(this.defaultSession().copy().setConfirm(NutsConfirmationMode.YES));
            } else {
                this.wsModel.bootModel.setFirstBoot(false);
                this.wsModel.uuid = this.wsModel.configModel.getStoreModelBoot().getUuid();
                if (NutsBlankable.isBlank((String)this.wsModel.uuid)) {
                    this.wsModel.uuid = UUID.randomUUID().toString();
                    this.wsModel.configModel.getStoreModelBoot().setUuid(this.wsModel.uuid);
                }
                if (options.isRecover()) {
                    this.wsModel.configModel.setBootApiVersion(cfg.getApiVersion(), this.defaultSession());
                    this.wsModel.configModel.setBootRuntimeId(cfg.getRuntimeId(), Arrays.stream(bOptions.getRuntimeBootDescriptor().getDependencies()).map(NutsBootId::toString).collect(Collectors.joining(";")), this.defaultSession());
                    this.wsModel.configModel.setBootRepositories(cfg.getBootRepositories(), this.defaultSession());
                    try {
                        this.defaultSession().install().setInstalled(true).setSession(this.defaultSession()).getResult();
                    }
                    catch (Exception ex) {
                        this.LOG.with().session(this.defaultSession()).level(Level.SEVERE).verb(NutsLogVerb.FAIL).error((Throwable)ex).log(NutsMessage.jstyle((String)"reinstall artifacts failed : {0}", (Object[])new Object[]{ex}));
                    }
                }
                if (this.defaultSession().repos().getRepositories().length == 0) {
                    this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"workspace has no repositories. Will re-create defaults", (Object[])new Object[0]));
                    justInstalledArchetype = this.initializeWorkspace(options.getArchetype(), this.defaultSession());
                }
                ArrayList transientRepositoriesSet = options.getRepositories() == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(options.getRepositories()));
                NutsRepositoryDB repoDB = NutsRepositoryDB.of((NutsSession)this.defaultSession());
                NutsRepositorySelectorList expected = NutsRepositorySelectorList.ofAll((String[])transientRepositoriesSet.toArray(new String[0]), (NutsRepositoryDB)repoDB, (NutsSession)this.defaultSession());
                for (NutsRepositoryLocation loc : expected.resolve(null, repoDB)) {
                    NutsAddRepositoryOptions d = NutsRepositorySelectorHelper.createRepositoryOptions(loc, false, this.defaultSession());
                    n = d.getName();
                    String ruuid = (NutsBlankable.isBlank((String)n) ? "temporary" : n) + "_" + UUID.randomUUID().toString().replace("-", "");
                    d.setName(ruuid);
                    d.setTemporary(true);
                    d.setEnabled(true);
                    d.setFailSafe(false);
                    if (d.getConfig() != null) {
                        d.getConfig().setName(NutsBlankable.isBlank((String)n) ? ruuid : n);
                        d.getConfig().setStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                    }
                    this.defaultSession().repos().addRepository(d);
                }
            }
            if (!_config.isReadOnly()) {
                _config.save(false);
            }
            this.wsModel.configModel.setEndCreateTimeMillis(System.currentTimeMillis());
            if (justInstalled) {
                try {
                    List recommendedCompanions;
                    Map rec = this.wsModel.recomm.askCompanionsRecommendations(new RequestQueryInfo(null, ""), this.defaultSession());
                    if (rec != null && rec.get("companions") instanceof List && (recommendedCompanions = (List)rec.get("companions")) != null) {
                        this.wsModel.recommendedCompanions.addAll(recommendedCompanions);
                    }
                }
                catch (Exception rec) {
                    // empty catch block
                }
                justInstalledArchetype.startWorkspace(this.defaultSession());
                DefaultNutsWorkspaceEvent workspaceCreatedEvent = new DefaultNutsWorkspaceEvent(this.defaultSession(), null, null, null, null);
                for (NutsWorkspaceListener workspaceListener : this.defaultSession().events().getWorkspaceListeners()) {
                    workspaceListener.onCreateWorkspace((NutsWorkspaceEvent)workspaceCreatedEvent);
                }
            }
            if (options.getUserName() != null && options.getUserName().trim().length() > 0) {
                char[] password = options.getCredentials();
                if (password == null || NutsBlankable.isBlank((String)new String(password))) {
                    password = this.defaultSession().config().getDefaultTerminal().readPassword("Password : ", new Object[0]);
                }
                this.defaultSession().security().setSession(this.defaultSession()).login(options.getUserName(), password);
            }
            this.wsModel.configModel.setEndCreateTimeMillis(System.currentTimeMillis());
            this.LOG.with().session(this.defaultSession()).level(Level.FINE).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"```sh nuts``` workspace loaded in ```error {0}```", (Object[])new Object[]{CoreTimeUtils.formatPeriodMilli(_boot.getCreationFinishTimeMillis() - _boot.getCreationStartTimeMillis())}));
            if (this.defaultSession().boot().getBootCustomBoolArgument(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), new String[]{"---perf"}).booleanValue()) {
                if (this.defaultSession().isPlainOut()) {
                    this.defaultSession().out().printf("```sh nuts``` workspace loaded in %s%n", new Object[]{text.ofStyled(CoreTimeUtils.formatPeriodMilli(_boot.getCreationFinishTimeMillis() - _boot.getCreationStartTimeMillis()), NutsTextStyle.error())});
                } else {
                    this.defaultSession().eout().add((NutsElement)elems.ofObject().set("workspace-loaded-in", (NutsElement)elems.ofObject().set("ms", (double)(_boot.getCreationFinishTimeMillis() - _boot.getCreationStartTimeMillis())).set("text", CoreTimeUtils.formatPeriodMilli(_boot.getCreationFinishTimeMillis() - _boot.getCreationStartTimeMillis())).build()).build());
                }
            }
        }
        catch (RuntimeException ex) {
            if (this.wsModel != null && this.wsModel.recomm != null) {
                try {
                    NutsSession s = this.defaultSession();
                    this.displayRecommendations(this.wsModel.recomm.askBootstrapFailureRecommendations(new RequestQueryInfo(null, ex), s), s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (this.wsModel.bootModel != null) {
                this.wsModel.bootModel.setInitializing(false);
            }
        }
    }

    private void displayRecommendations(Object r, NutsSession s) {
        if (s != null) {
            HashMap<String, Object> a = new HashMap<String, Object>();
            a.put("recommendations", r);
            s.out().printlnf(a);
        }
    }

    private URL getApiURL() {
        NutsBootId nid = new NutsBootId("net.thevpc.nuts", "nuts", NutsBootVersion.parse((String)Nuts.getVersion()));
        return NutsApiUtils.findClassLoaderJar((NutsBootId)nid, (URL[])NutsClassLoaderUtils.resolveClasspathURLs(Thread.currentThread().getContextClassLoader()));
    }

    private String getApiDigest() {
        if (NutsBlankable.isBlank((String)this.wsModel.apiDigest)) {
            this.wsModel.apiDigest = new CoreDigestHelper(this.defaultSession()).append(this.getApiURL()).getDigest();
        }
        return this.wsModel.apiDigest;
    }

    protected NutsDescriptor _resolveEffectiveDescriptor(NutsDescriptor descriptor, NutsSession session) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"resolve effective {0}", (Object[])new Object[]{descriptor.getId()}));
        this.checkSession(session);
        NutsId[] parents = descriptor.getParents();
        NutsDescriptor[] parentDescriptors = new NutsDescriptor[parents.length];
        for (int i = 0; i < parentDescriptors.length; ++i) {
            parentDescriptors[i] = this.resolveEffectiveDescriptor(session.fetch().setId(parents[i]).setEffective(false).setSession(session).getResultDescriptor(), session);
        }
        NutsDescriptorBuilder descrWithParents = descriptor.builder().applyParents(parentDescriptors);
        NutsDescriptorProperty[] properties = (NutsDescriptorProperty[])Arrays.stream(descrWithParents.getProperties()).filter(x -> CoreFilterUtils.acceptCondition(x.getCondition(), false, session)).toArray(NutsDescriptorProperty[]::new);
        if (properties.length > 0) {
            DefaultNutsProperties pp = new DefaultNutsProperties();
            ArrayList<NutsDescriptorProperty> n = new ArrayList<NutsDescriptorProperty>();
            pp.addAll(properties);
            for (String s : pp.keySet()) {
                NutsDescriptorProperty[] a = pp.getAll(s);
                if (a.length == 1) {
                    n.add(a[0].builder().setCondition((NutsEnvCondition)null).build());
                    continue;
                }
                NutsDescriptorProperty z = null;
                for (NutsDescriptorProperty zz : a) {
                    boolean wasZZ;
                    if (z == null) {
                        boolean wasZZ2;
                        z = zz;
                        boolean bl = wasZZ2 = zz.getCondition() == null || zz.getCondition().isBlank();
                        if (wasZZ2) continue;
                        break;
                    }
                    boolean wasZ = z.getCondition() == null || z.getCondition().isBlank();
                    boolean bl = wasZZ = zz.getCondition() == null || zz.getCondition().isBlank();
                    if (wasZ == wasZZ || !wasZ) {
                        z = zz;
                    }
                    if (!wasZZ) break;
                }
                if (z == null) continue;
                n.add(z.builder().setCondition((NutsEnvCondition)null).build());
            }
            properties = n.toArray(new NutsDescriptorProperty[0]);
        }
        descrWithParents.setProperties(properties);
        NutsDescriptor effectiveDescriptor = descrWithParents.applyProperties().build();
        NutsDependency[] oldDependencies = effectiveDescriptor.getDependencies();
        ArrayList<NutsDependency> newDeps = new ArrayList<NutsDependency>();
        boolean someChange = false;
        for (NutsDependency d : oldDependencies) {
            if (NutsBlankable.isBlank((String)d.getScope()) || d.getVersion().isBlank() || NutsBlankable.isBlank((String)d.getOptional())) {
                NutsDependency standardDependencyOk = null;
                for (NutsDependency standardDependency : effectiveDescriptor.getStandardDependencies()) {
                    if (!standardDependency.getSimpleName().equals(d.toId().getShortName())) continue;
                    standardDependencyOk = standardDependency;
                    break;
                }
                if (standardDependencyOk != null) {
                    if (NutsBlankable.isBlank((String)d.getScope()) && !NutsBlankable.isBlank((String)standardDependencyOk.getScope())) {
                        someChange = true;
                        d = d.builder().setScope(standardDependencyOk.getScope()).build();
                    }
                    if (NutsBlankable.isBlank((String)d.getOptional()) && !NutsBlankable.isBlank((String)standardDependencyOk.getOptional())) {
                        someChange = true;
                        d = d.builder().setOptional(standardDependencyOk.getOptional()).build();
                    }
                    if (d.getVersion().isBlank() && !standardDependencyOk.getVersion().isBlank()) {
                        someChange = true;
                        d = d.builder().setVersion(standardDependencyOk.getVersion()).build();
                    }
                }
            }
            if ("import".equals(d.getScope())) {
                someChange = true;
                newDeps.addAll(Arrays.asList(session.fetch().setId(d.toId()).setEffective(true).setSession(session).getResultDescriptor().getDependencies()));
                continue;
            }
            newDeps.add(d);
        }
        if (someChange) {
            effectiveDescriptor = effectiveDescriptor.builder().setDependencies(newDeps.toArray(new NutsDependency[0])).build();
        }
        return effectiveDescriptor;
    }

    @Override
    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 10;
    }

    @Override
    public String toString() {
        return "NutsWorkspace{" + this.wsModel.configModel + '}';
    }

    protected NutsWorkspaceArchetypeComponent initializeWorkspace(String archetype, NutsSession session) {
        this.checkSession(session);
        if (NutsBlankable.isBlank((String)archetype)) {
            archetype = "default";
        }
        NutsWorkspaceArchetypeComponent instance = null;
        TreeSet<String> validValues = new TreeSet<String>();
        for (NutsWorkspaceArchetypeComponent ac : session.extensions().setSession(session).createAllSupported(NutsWorkspaceArchetypeComponent.class, (Object)archetype)) {
            if (archetype.equals(ac.getName())) {
                instance = ac;
                break;
            }
            validValues.add(ac.getName());
        }
        if (instance == null) {
            throw new NutsException(session, NutsMessage.cstyle((String)"invalid archetype %s. Valid values are : %s", (Object[])new Object[]{archetype, validValues}));
        }
        session.security().setSession(session).updateUser("admin").setCredentials("admin".toCharArray()).run();
        instance.initializeWorkspace(session);
        return instance;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this, session);
    }

    private NutsId resolveApiId(NutsId id, Set<NutsId> visited, NutsSession session) {
        if (visited.contains(id.getLongId())) {
            return null;
        }
        visited.add(id.getLongId());
        if (id.getShortName().equals("net.thevpc.nuts:nuts")) {
            return id;
        }
        for (NutsDependency dependency : session.fetch().setId(id).getResultDescriptor().getDependencies()) {
            NutsId q = this.resolveApiId(dependency.toId(), visited, session);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    public void installOrUpdateImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean resolveInstaller, boolean updateDefaultVersion, InstallStrategy0 strategy0, boolean requireDependencies, NutsId[] forIds, NutsDependencyScope scope) {
        this.checkSession(session);
        if (def == null) {
            return;
        }
        try {
            Map rec = null;
            if (strategy0 == InstallStrategy0.INSTALL) {
                rec = this.wsModel.recomm.askInstallRecommendations(new RequestQueryInfo(def.getId().toString(), ""), session);
            } else if (strategy0 == InstallStrategy0.UPDATE) {
                rec = this.wsModel.recomm.askUpdateRecommendations(new RequestQueryInfo(def.getId().toString(), ""), session);
            }
        }
        catch (Exception rec) {
            // empty catch block
        }
        NutsDependencyFilter ndf = NutsDependencyFilters.of((NutsSession)session).byRunnable();
        if (!def.isSetEffectiveDescriptor() || def.getContent() == null) {
            NutsFetchCommand fetch2 = session.fetch().setSession(session).setId(def.getId()).setContent(true).setRepositoryFilter(session.repos().filter().installedRepo()).setFailFast(true);
            if (def.isSetDependencies()) {
                fetch2.setDependencyFilter(def.getDependencies().filter());
                fetch2.setDependencies(true);
            }
            def = fetch2.getResultDefinition();
        }
        boolean reinstall = false;
        NutsInstalledRepository installedRepository = this.getInstalledRepository();
        NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(session);
        if (session.isPlainTrace()) {
            NutsTexts text = NutsTexts.of((NutsSession)session);
            if (strategy0 == InstallStrategy0.UPDATE) {
                session.out().resetLine().printf("%s %s ...%n", new Object[]{text.ofStyled("update", NutsTextStyle.warn()), def.getId().getLongId()});
            } else if (strategy0 == InstallStrategy0.REQUIRE) {
                reinstall = def.getInstallInformation().getInstallStatus().isRequired();
                if (reinstall) {
                    // empty if block
                }
            } else {
                reinstall = def.getInstallInformation().getInstallStatus().isInstalled();
                if (reinstall) {
                    session.out().resetLine().printf("%s %s ...%n", new Object[]{text.ofStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()})), def.getId().getLongId()});
                } else {
                    session.out().resetLine().printf("%s %s ...%n", new Object[]{text.ofStyled("install", NutsTextStyle.success()), def.getId().getLongId()});
                }
            }
        }
        NutsRepositorySPI installedRepositorySPI = wu.repoSPI(installedRepository);
        boolean remoteRepo = true;
        if (resolveInstaller && installerComponent == null && def.getFile() != null) {
            installerComponent = this.getInstaller(def, session);
        }
        NutsDefinition oldDef = null;
        if (strategy0 == InstallStrategy0.UPDATE) {
            switch (def.getDescriptor().getIdType()) {
                case API: {
                    oldDef = session.fetch().setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setId("net.thevpc.nuts:nuts#" + Nuts.getVersion()).setFailFast(false).getResultDefinition();
                    break;
                }
                case RUNTIME: {
                    oldDef = session.fetch().setSession(session.copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setId(this.getRuntimeId()).setFailFast(false).getResultDefinition();
                    break;
                }
                default: {
                    oldDef = (NutsDefinition)session.search().setSession(session).addId(def.getId().getShortId()).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byDeployed(true)).setFailFast(false).getResultDefinitions().first();
                }
            }
        }
        NutsPrintStream out = session.out();
        out.flush();
        NutsInstallInformation newNutsInstallInformation = null;
        NutsWorkspaceConfigManager config = session.config().setSession(session);
        if (def.getFile() != null) {
            if (requireDependencies) {
                def.getDependencies();
                ArrayList<NutsDefinition> requiredDefinitions = new ArrayList<NutsDefinition>();
                for (NutsDependency dependency : def.getDependencies()) {
                    NutsDefinition dd;
                    if (ndf != null && !ndf.acceptDependency(def.getId(), dependency, session) || installedRepositorySPI.searchVersions().setId(dependency.toId()).setFetchMode(NutsFetchMode.LOCAL).setSession(session).getResult().hasNext() || (dd = (NutsDefinition)session.search().addId(dependency.toId()).setContent(true).setLatest(true).setEffective(true).getResultDefinitions().first()) == null) continue;
                    if (dd.getFile() == null) {
                        throw new NutsInstallException(session, def.getId(), NutsMessage.cstyle((String)"unable to install %s. required dependency content is missing for %s", (Object[])new Object[]{def.getId(), dependency.toId()}), null);
                    }
                    requiredDefinitions.add(dd);
                }
                for (NutsDefinition dd : requiredDefinitions) {
                    this.requireImpl(dd, session, false, new NutsId[]{def.getId()});
                }
            }
            NutsExecutionContextBuilder cc = this.createExecutionContext().setSession(session.copy()).setExecSession(session.copy()).setDefinition(def).setArguments(args).setFailFast(true).setTemporary(false).setExecutionType(session.boot().getBootOptions().getExecutionType()).setRunAs(NutsRunAs.currentUser());
            NutsArtifactCall installer = def.getDescriptor().getInstaller();
            if (installer != null) {
                cc.addExecutorArguments(installer.getArguments());
                cc.addExecutorProperties(installer.getProperties());
            }
            cc.setWorkspace(cc.getSession().getWorkspace());
            NutsExecutionContext executionContext = cc.build();
            if (strategy0 == InstallStrategy0.REQUIRE) {
                newNutsInstallInformation = installedRepository.require(executionContext.getDefinition(), true, forIds, scope, session);
            } else if (strategy0 == InstallStrategy0.UPDATE) {
                newNutsInstallInformation = installedRepository.install(executionContext.getDefinition(), session);
            } else if (strategy0 == InstallStrategy0.INSTALL) {
                newNutsInstallInformation = installedRepository.install(executionContext.getDefinition(), session);
            }
            if (updateDefaultVersion) {
                installedRepository.setDefaultVersion(def.getId(), session);
            }
            NutsFetchCommand fetch2 = session.fetch().setSession(session).setId(executionContext.getDefinition().getId()).setContent(true).setRepositoryFilter(session.repos().filter().installedRepo()).setFailFast(true);
            if (def.isSetDependencies()) {
                fetch2.setDependencyFilter(def.getDependencies().filter());
                fetch2.setDependencies(true);
            }
            NutsDefinition def2 = fetch2.getResultDefinition();
            cc.setDefinition(def2);
            executionContext = cc.build();
            NutsRepository rep = session.repos().findRepository(def.getRepositoryUuid());
            boolean bl = remoteRepo = rep == null || rep.isRemote();
            if (strategy0 != InstallStrategy0.REQUIRE) {
                if (strategy0 == InstallStrategy0.UPDATE) {
                    if (installerComponent != null) {
                        try {
                            installerComponent.update(executionContext);
                        }
                        catch (NutsReadOnlyException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            if (session.isPlainTrace()) {
                                out.resetLine().printf("%s ```error failed``` to update : %s.%n", new Object[]{def.getId(), ex});
                            }
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to update %s", (Object[])new Object[]{def.getId()}), (Throwable)ex);
                        }
                    }
                } else if (strategy0 == InstallStrategy0.INSTALL && installerComponent != null) {
                    try {
                        installerComponent.install(executionContext);
                    }
                    catch (NutsReadOnlyException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (session.isPlainTrace()) {
                            out.resetLine().printf("```error error: failed to install``` %s: %s.%n", new Object[]{def.getId(), ex});
                        }
                        try {
                            installedRepository.uninstall(executionContext.getDefinition(), session);
                        }
                        catch (Exception ex2) {
                            this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to uninstall  {0}", (Object[])new Object[]{executionContext.getDefinition().getId()}));
                            try {
                                Map rec = null;
                                if (strategy0 == InstallStrategy0.INSTALL) {
                                    rec = this.wsModel.recomm.askInstallFailureRecommendations(new RequestQueryInfo(def.getId().toString(), ""), session);
                                } else if (strategy0 == InstallStrategy0.UPDATE) {
                                    rec = this.wsModel.recomm.askUpdateFailureRecommendations(new RequestQueryInfo(def.getId().toString(), ""), session);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to install %s", (Object[])new Object[]{def.getId()}), (Throwable)ex);
                    }
                }
            }
        } else {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to install %s: unable to locate content", (Object[])new Object[]{def.getId()}), 101);
        }
        NutsId forId = forIds == null || forIds.length == 0 ? null : forIds[0];
        switch (def.getDescriptor().getIdType()) {
            case API: {
                this.wsModel.configModel.prepareBootClassPathConf(NutsIdType.API, def.getId(), forId, null, true, false, session);
                break;
            }
            case RUNTIME: 
            case EXTENSION: {
                this.wsModel.configModel.prepareBootClassPathConf(def.getDescriptor().getIdType(), def.getId(), forId, null, true, true, session);
            }
        }
        if (strategy0 == InstallStrategy0.UPDATE) {
            wu.events().fireOnUpdate(new DefaultNutsUpdateEvent(oldDef, def, session, reinstall));
        } else if (strategy0 == InstallStrategy0.REQUIRE) {
            wu.events().fireOnRequire(new DefaultNutsInstallEvent(def, session, forIds, reinstall));
        } else if (strategy0 == InstallStrategy0.INSTALL) {
            wu.events().fireOnInstall(new DefaultNutsInstallEvent(def, session, new NutsId[0], reinstall));
        }
        if (def.getDescriptor().getIdType() == NutsIdType.EXTENSION) {
            NutsWorkspaceConfigManagerExt wcfg = NutsWorkspaceConfigManagerExt.of(config);
            NutsExtensionListHelper h = new NutsExtensionListHelper(session.getWorkspace().getApiId(), wcfg.getModel().getStoredConfigBoot().getExtensions()).save();
            h.add(def.getId(), (NutsDependency[])def.getDependencies().transitiveWithSource().toArray(NutsDependency[]::new));
            wcfg.getModel().getStoredConfigBoot().setExtensions(h.getConfs());
            wcfg.getModel().fireConfigurationChanged("extensions", session, ConfigEventType.BOOT);
        }
        if (session.isPlainTrace()) {
            String installedString;
            String setAsDefaultString = "";
            NutsTexts text = NutsTexts.of((NutsSession)session);
            if (updateDefaultVersion) {
                setAsDefaultString = " set as " + text.builder().append((Object)"default", NutsTextStyle.primary1()) + ".";
            }
            if (newNutsInstallInformation != null && (newNutsInstallInformation.isJustInstalled() || newNutsInstallInformation.isJustRequired())) {
                installedString = null;
                if (newNutsInstallInformation != null) {
                    if (newNutsInstallInformation.isJustReInstalled()) {
                        installedString = text.ofStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()}));
                    } else if (newNutsInstallInformation.isJustInstalled()) {
                        installedString = text.ofStyled("install", NutsTextStyle.success());
                    } else if (newNutsInstallInformation.isJustReRequired()) {
                        installedString = text.ofStyled("re-require", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.info(), NutsTextStyle.underlined()}));
                    } else if (newNutsInstallInformation.isJustRequired()) {
                        installedString = text.ofStyled("require", NutsTextStyle.info());
                    }
                }
                if (installedString != null) {
                    if (!def.getContent().isCached()) {
                        if (def.getContent().isTemporary()) {
                            if (session.isPlainTrace()) {
                                out.resetLine().printf("%s %s from %s repository (%s) temporarily file %s.%s%n", new Object[]{installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getPath(), text.parse(setAsDefaultString)});
                            }
                        } else if (session.isPlainTrace()) {
                            out.resetLine().printf("%s %s from %s repository (%s).%s%n", new Object[]{installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.parse(setAsDefaultString)});
                        }
                    } else if (def.getContent().isTemporary()) {
                        if (session.isPlainTrace()) {
                            out.resetLine().printf("%s %s from %s repository (%s) temporarily file %s.%s%n", new Object[]{installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getPath(), text.parse(setAsDefaultString)});
                        }
                    } else if (session.isPlainTrace()) {
                        out.resetLine().printf("%s %s from %s repository (%s).%s%n", new Object[]{installedString, def.getId().getLongId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.parse(setAsDefaultString)});
                    }
                }
            } else {
                installedString = null;
                if (newNutsInstallInformation != null) {
                    if (newNutsInstallInformation.isJustReInstalled()) {
                        installedString = "re-installed";
                    } else if (newNutsInstallInformation.isJustInstalled()) {
                        installedString = "installed";
                    } else if (newNutsInstallInformation.isJustReRequired()) {
                        installedString = "re-required";
                    } else if (newNutsInstallInformation.isJustRequired()) {
                        installedString = "required";
                    }
                }
                if (installedString != null && session.isPlainTrace()) {
                    out.resetLine().printf("%s  %s %s.%s%n", new Object[]{installedString, def.getId().getLongId(), text.ofStyled("successfully", NutsTextStyle.success()), text.parse(setAsDefaultString)});
                }
            }
        }
    }

    public String resolveCommandName(NutsId id, NutsSession session) {
        this.checkSession(session);
        String nn = id.getArtifactId();
        NutsCustomCommandManager aliases = session.commands().setSession(session);
        NutsWorkspaceCustomCommand c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getGroupId() + "." + id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreFilterUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        throw new NutsElementNotFoundException(session, NutsMessage.cstyle((String)"unable to resolve command name for %s", (Object[])new Object[]{id}));
    }

    protected boolean loadWorkspace(NutsSession session, String[] excludedExtensions, String[] excludedRepositories) {
        this.checkSession(session);
        if (this.wsModel.configModel.loadWorkspace(session)) {
            for (NutsCommandFactoryConfig[] extensionId : session.extensions().setSession(session).getConfigExtensions()) {
                if (this.wsModel.extensionModel.isExcludedExtension((NutsId)extensionId)) continue;
                NutsSession sessionCopy = session.copy();
                this.wsModel.extensionModel.wireExtension((NutsId)extensionId, session.fetch().setSession(sessionCopy.copy().setFetchStrategy(NutsFetchStrategy.ONLINE).setTransitive(Boolean.valueOf(true))));
                if (sessionCopy.getTerminal() == session.getTerminal()) continue;
                session.setTerminal(sessionCopy.getTerminal());
            }
            NutsUserConfig adminSecurity = NutsWorkspaceConfigManagerExt.of(session.config()).getModel().getUser("admin", session);
            if (adminSecurity == null || NutsBlankable.isBlank((String)adminSecurity.getCredentials())) {
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"{0} user has no credentials. reset to default", (Object[])new Object[]{"admin"}));
                }
                session.security().updateUser("admin").credentials("admin".toCharArray()).run();
            }
            for (NutsCommandFactoryConfig commandFactory : session.commands().setSession(session).getCommandFactories()) {
                try {
                    session.commands().setSession(session).addCommandFactory(commandFactory);
                }
                catch (Exception e) {
                    this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to instantiate Command Factory {0}", (Object[])new Object[]{commandFactory}));
                }
            }
            DefaultNutsWorkspaceEvent worksppaeReloadedEvent = new DefaultNutsWorkspaceEvent(session, null, null, null, null);
            for (NutsWorkspaceListener listener : this.defaultSession().events().getWorkspaceListeners()) {
                listener.onReloadWorkspace((NutsWorkspaceEvent)worksppaeReloadedEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getWelcomeText(NutsSession session) {
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-welcome.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no welcome found" : n.toString();
    }

    @Override
    public String getHelpText(NutsSession session) {
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-help.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no help found" : n.toString();
    }

    @Override
    public String getLicenseText(NutsSession session) {
        NutsTexts txt = NutsTexts.of((NutsSession)session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-license.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no license found" : n.toString();
    }

    @Override
    public String resolveDefaultHelp(Class clazz, NutsSession session) {
        NutsId nutsId = NutsIdResolver.of((NutsSession)session).resolveId(clazz);
        if (nutsId != null) {
            String urlPath = "/" + nutsId.getGroupId().replace('.', '/') + "/" + nutsId.getArtifactId() + ".ntf";
            NutsTexts txt = NutsTexts.of((NutsSession)session);
            NutsText n = txt.parser().parseResource(urlPath, txt.parser().createLoader(this.getClass().getClassLoader()));
            return n == null ? "no license found" : n.toString();
        }
        return null;
    }

    @Override
    public NutsId resolveEffectiveId(NutsDescriptor descriptor, NutsSession session) {
        this.checkSession(session);
        if (descriptor == null) {
            throw new NutsNotFoundException(session, null);
        }
        NutsId thisId = descriptor.getId();
        String a = thisId.getArtifactId();
        String g = thisId.getGroupId();
        String v = thisId.getVersion().getValue();
        if (NutsBlankable.isBlank((String)g) || NutsBlankable.isBlank((String)v)) {
            NutsId[] parents;
            for (NutsId parent : parents = descriptor.getParents()) {
                NutsId p = session.fetch().setSession(session).setId(parent).setEffective(true).getResultId();
                if (NutsBlankable.isBlank((String)g)) {
                    g = p.getGroupId();
                }
                if (NutsBlankable.isBlank((String)v)) {
                    v = p.getVersion().getValue();
                }
                if (!NutsBlankable.isBlank((String)g) && !NutsBlankable.isBlank((String)v)) break;
            }
            if (NutsBlankable.isBlank((String)g) || NutsBlankable.isBlank((String)v)) {
                throw new NutsNotFoundException(session, thisId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{thisId, thisId}), null);
            }
        }
        if (CoreStringUtils.containsVars(g) || CoreStringUtils.containsVars(v) || CoreStringUtils.containsVars(a)) {
            Map<String, String> p = NutsDescriptorUtils.getPropertiesMap(descriptor.getProperties(), session);
            NutsId bestId = NutsIdBuilder.of((NutsSession)session).setGroupId(g).setArtifactId(thisId.getArtifactId()).setVersion(v).build();
            if (CoreNutsUtils.isEffectiveId(bestId = bestId.builder().apply(new MapToFunction<String, String>(p)).build())) {
                return bestId;
            }
            Stack<NutsId> all = new Stack<NutsId>();
            NutsId[] parents = descriptor.getParents();
            all.addAll(Arrays.asList(parents));
            while (!all.isEmpty()) {
                NutsId parent;
                parent = (NutsId)all.pop();
                NutsDescriptor dd = session.fetch().setSession(session).setId(parent).setEffective(true).getResultDescriptor();
                if (CoreNutsUtils.isEffectiveId(bestId = bestId.builder().apply(new MapToFunction<String, String>(NutsDescriptorUtils.getPropertiesMap(dd.getProperties(), session))).build())) {
                    return bestId;
                }
                all.addAll(Arrays.asList(dd.getParents()));
            }
            throw new NutsNotFoundException(session, bestId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{bestId, bestId}), null);
        }
        NutsId bestId = NutsIdBuilder.of((NutsSession)session).setGroupId(g).setArtifactId(thisId.getArtifactId()).setVersion(v).build();
        if (!CoreNutsUtils.isEffectiveId(bestId)) {
            throw new NutsNotFoundException(session, bestId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{thisId, bestId}), null);
        }
        return bestId;
    }

    @Override
    public NutsIdType resolveNutsIdType(NutsId id, NutsSession session) {
        NutsIdType idType = NutsIdType.REGULAR;
        String shortName = id.getShortName();
        if (shortName.equals("net.thevpc.nuts:nuts")) {
            idType = NutsIdType.API;
        } else if (shortName.equals("net.thevpc.nuts:nuts-runtime")) {
            idType = NutsIdType.RUNTIME;
        } else {
            for (NutsId companionTool : session.extensions().getCompanionIds()) {
                if (!companionTool.getShortName().equals(shortName)) continue;
                idType = NutsIdType.COMPANION;
            }
        }
        return idType;
    }

    @Override
    public NutsInstallerComponent getInstaller(NutsDefinition nutToInstall, NutsSession session) {
        this.checkSession(session);
        if (nutToInstall != null && nutToInstall.getFile() != null) {
            NutsInstallerComponent best;
            NutsDescriptor descriptor = nutToInstall.getDescriptor();
            NutsArtifactCall installerDescriptor = descriptor.getInstaller();
            NutsDefinition runnerFile = nutToInstall;
            if (installerDescriptor != null && installerDescriptor.getId() != null && installerDescriptor.getId() != null) {
                runnerFile = session.fetch().setId(installerDescriptor.getId()).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setOptional(Boolean.valueOf(false)).setContent(true).setDependencies(true).getResultDefinition();
            }
            if (runnerFile == null) {
                runnerFile = nutToInstall;
            }
            if ((best = (NutsInstallerComponent)session.extensions().setSession(session).createSupported(NutsInstallerComponent.class, false, (Object)runnerFile)) != null) {
                return best;
            }
        }
        return new CommandForIdNutsInstallerComponent();
    }

    @Override
    public void requireImpl(NutsDefinition def, NutsSession session, boolean withDependencies, NutsId[] forId) {
        this.installOrUpdateImpl(def, new String[0], null, session, true, false, InstallStrategy0.REQUIRE, withDependencies, forId, null);
    }

    @Override
    public void installImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean updateDefaultVersion) {
        this.installOrUpdateImpl(def, args, installerComponent, session, true, updateDefaultVersion, InstallStrategy0.INSTALL, true, null, null);
    }

    @Override
    public void updateImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean updateDefaultVersion) {
        this.installOrUpdateImpl(def, args, installerComponent, session, true, updateDefaultVersion, InstallStrategy0.UPDATE, true, null, null);
    }

    @Override
    public boolean requiresRuntimeExtension(NutsSession session) {
        boolean coreFound = false;
        for (NutsId ext : session.extensions().setSession(session).getConfigExtensions()) {
            if (!ext.equalsShortId(this.getRuntimeId())) continue;
            coreFound = true;
            break;
        }
        return !coreFound;
    }

    @Override
    public NutsDescriptor resolveEffectiveDescriptor(NutsDescriptor descriptor, NutsSession session) {
        String nn;
        NutsPath l;
        NutsPath eff = null;
        NutsWorkspaceLocationManager loc = session.locations().setSession(session);
        if (!descriptor.getId().getVersion().isBlank() && descriptor.getId().getVersion().isSingleValue() && descriptor.getId().toString().indexOf(36) < 0 && (eff = (l = loc.getStoreLocation(descriptor.getId(), NutsStoreLocation.CACHE)).resolve(nn = loc.getDefaultIdFilename(descriptor.getId().builder().setFace("eff-nuts.cache").build()))).isRegularFile()) {
            try {
                NutsDescriptor d = NutsDescriptorParser.of((NutsSession)session).parse(eff);
                if (d != null) {
                    return d;
                }
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to parse {0}", (Object[])new Object[]{eff}));
            }
        }
        NutsDescriptor effectiveDescriptor = this._resolveEffectiveDescriptor(descriptor, session);
        NutsDescriptorUtils.checkValidEffectiveDescriptor(effectiveDescriptor, session);
        if (eff == null) {
            NutsPath l2 = session.locations().getStoreLocation(effectiveDescriptor.getId(), NutsStoreLocation.CACHE);
            String nn2 = loc.getDefaultIdFilename(effectiveDescriptor.getId().builder().setFace("eff-nuts.cache").build());
            eff = l2.resolve(nn2);
        }
        try {
            effectiveDescriptor.formatter().setSession(session).setNtf(false).print(eff);
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to print {0}", (Object[])new Object[]{eff}));
        }
        return effectiveDescriptor;
    }

    @Override
    public NutsInstalledRepository getInstalledRepository() {
        return this.wsModel.installedRepository;
    }

    @Override
    public NutsInstallStatus getInstallStatus(NutsId id, boolean checkDependencies, NutsSession session) {
        NutsDefinition nutToInstall;
        try {
            nutToInstall = (NutsDefinition)session.search().addId(id).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setInlineDependencies(checkDependencies).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byDeployed(true)).setOptional(Boolean.valueOf(false)).getResultDefinitions().first();
            if (nutToInstall == null) {
                return NutsInstallStatus.NONE;
            }
        }
        catch (NutsNotFoundException e) {
            return NutsInstallStatus.NONE;
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error: %s", (Object[])new Object[]{ex}));
            return NutsInstallStatus.NONE;
        }
        return this.getInstalledRepository().getInstallStatus(nutToInstall.getId(), session);
    }

    @Override
    public NutsExecutionContextBuilder createExecutionContext() {
        return new DefaultNutsExecutionContextBuilder().setWorkspace(this);
    }

    @Override
    public void deployBoot(NutsSession session, NutsId id, boolean withDependencies) {
        HashMap<NutsId, NutsDefinition> defs = new HashMap<NutsId, NutsDefinition>();
        NutsDefinition m = session.fetch().setId(id).setContent(true).setDependencies(true).setFailFast(false).getResultDefinition();
        LinkedHashMap<String, Object> a = new LinkedHashMap<String, Object>();
        a.put("configVersion", Nuts.getVersion());
        a.put("id", id.getLongName());
        a.put("dependencies", m.getDependencies().transitive().map(NutsDependency::getLongName, "getLongName").collect(Collectors.joining(";")));
        defs.put(m.getId().getLongId(), m);
        if (withDependencies) {
            for (NutsDependency dependency : m.getDependencies()) {
                if (defs.containsKey(dependency.toId().getLongId())) continue;
                m = session.fetch().setId(id).setContent(true).setDependencies(true).setFailFast(false).getResultDefinition();
                defs.put(m.getId().getLongId(), m);
            }
        }
        for (NutsDefinition def : defs.values()) {
            NutsPath bootstrapFolder = session.locations().getStoreLocation(NutsStoreLocation.LIB).resolve("id");
            NutsId id2 = def.getId();
            NutsCp.of((NutsSession)session).from(def.getFile()).to(bootstrapFolder.resolve(session.locations().getDefaultIdBasedir(id2)).resolve(session.locations().getDefaultIdFilename(id2.builder().setFaceContent().setPackaging("jar").build()))).run();
            session.fetch().setId(id2).getResultDescriptor().formatter().setSession(session).setNtf(false).print(bootstrapFolder.resolve(session.locations().getDefaultIdBasedir(id2)).resolve(session.locations().getDefaultIdFilename(id2.builder().setFaceDescriptor().build())));
            LinkedHashMap<String, String> pr = new LinkedHashMap<String, String>();
            pr.put("file.updated.date", Instant.now().toString());
            pr.put("project.id", def.getId().getShortId().toString());
            pr.put("project.name", def.getId().getShortId().toString());
            pr.put("project.version", def.getId().getVersion().toString());
            NutsRepositoryDB repoDB = NutsRepositoryDB.of((NutsSession)session);
            pr.put("repositories", "~/.m2/repository;" + NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"vpc-public-maven", (NutsRepositoryDB)repoDB, (NutsSession)session), true, session).getConfig().getLocation() + ";" + NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"maven-central", (NutsRepositoryDB)repoDB, (NutsSession)session), true, session).getConfig().getLocation() + ";" + NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"vpc-public-nuts", (NutsRepositoryDB)repoDB, (NutsSession)session), true, session).getConfig().getLocation());
            pr.put("project.dependencies.compile", String.join((CharSequence)";", def.getDependencies().transitive().filter(x -> !x.isOptional() && NutsDependencyFilters.of((NutsSession)session).byRunnable().acceptDependency(def.getId(), x, session), "isOptional && runnable").map(x -> x.toId().getLongName(), "toId.getLongName").toList()));
            try {
                Writer writer = bootstrapFolder.resolve(session.locations().getDefaultIdBasedir(def.getId().getLongId())).resolve("nuts.properties").getWriter();
                Throwable throwable = null;
                try {
                    CoreIOUtils.storeProperties(pr, writer, false, session);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
    }

    @Override
    public NutsSession defaultSession() {
        if (this.wsModel.initSession != null) {
            return this.wsModel.initSession;
        }
        return this.wsModel.bootModel.bootSession();
    }

    @Override
    public NutsWorkspaceModel getModel() {
        return this.wsModel;
    }

    public String getUuid() {
        return this.wsModel.uuid;
    }

    public String getName() {
        return this.wsModel.name;
    }

    public String getHashName() {
        if (this.wsModel.hashName == null) {
            this.wsModel.hashName = NutsHashName.of((NutsSession)this.defaultSession()).getHashName((Object)this);
        }
        return this.wsModel.hashName;
    }

    public NutsVersion getApiVersion() {
        return this.wsModel.apiVersion;
    }

    public NutsId getApiId() {
        return this.wsModel.apiId;
    }

    public NutsId getRuntimeId() {
        return this.wsModel.runtimeId;
    }

    public NutsPath getLocation() {
        return NutsPath.of((String)this.wsModel.location, (NutsSession)this.wsModel.bootModel.bootSession());
    }

    public NutsSession createSession() {
        DefaultNutsSession nutsSession = new DefaultNutsSession(this);
        nutsSession.setTerminal(NutsSessionTerminal.of((NutsSession)nutsSession));
        nutsSession.setExpireTime(nutsSession.boot().getBootOptions().getExpireTime());
        return nutsSession;
    }

    public NutsSearchCommand search() {
        return new DefaultNutsSearchCommand(this);
    }

    public NutsFetchCommand fetch() {
        return new DefaultNutsFetchCommand(this);
    }

    public NutsDeployCommand deploy() {
        return new DefaultNutsDeployCommand(this);
    }

    public NutsUndeployCommand undeploy() {
        return new DefaultNutsUndeployCommand(this);
    }

    public NutsExecCommand exec() {
        return new DefaultNutsExecCommand(this);
    }

    public NutsInstallCommand install() {
        return new DefaultNutsInstallCommand(this);
    }

    public NutsUninstallCommand uninstall() {
        return new DefaultNutsUninstallCommand(this);
    }

    public NutsUpdateCommand update() {
        return new DefaultNutsUpdateCommand(this);
    }

    public NutsPushCommand push() {
        return new DefaultNutsPushCommand(this);
    }

    public NutsUpdateStatisticsCommand updateStatistics() {
        return new DefaultNutsUpdateStatisticsCommand(this);
    }

    public NutsInfoCommand info() {
        return new DefaultNutsInfoCommand(this.defaultSession());
    }

    public NutsWorkspaceExtensionManager extensions() {
        return new DefaultNutsWorkspaceExtensionManager(this.wsModel.extensionModel);
    }

    public NutsWorkspaceConfigManager config() {
        return new DefaultNutsWorkspaceConfigManager(this.wsModel.configModel);
    }

    public NutsRepositoryManager repos() {
        return new DefaultNutsRepositoryManager(this.wsModel.repositoryModel);
    }

    public NutsWorkspaceSecurityManager security() {
        return new DefaultNutsWorkspaceSecurityManager(this.wsModel.securityModel);
    }

    public NutsWorkspaceEventManager events() {
        return new DefaultNutsWorkspaceEventManager(this.wsModel.eventsModel);
    }

    public NutsImportManager imports() {
        return new DefaultImportManager(this.wsModel.importModel);
    }

    public NutsCustomCommandManager commands() {
        return new DefaultCustomCommandManager(this.wsModel.aliasesModel);
    }

    public NutsWorkspaceLocationManager locations() {
        return new DefaultNutsWorkspaceLocationManager(this.wsModel.locationsModel);
    }

    public NutsWorkspaceEnvManager env() {
        return new DefaultNutsWorkspaceEnvManager(this.wsModel.envModel);
    }

    public NutsBootManager boot() {
        return new DefaultNutsBootManager(this.wsModel.bootModel);
    }

    public DefaultNutsWorkspaceEnvManagerModel getEnvModel() {
        return this.wsModel.envModel;
    }

    public DefaultCustomCommandsModel getAliasesModel() {
        return this.wsModel.aliasesModel;
    }

    public DefaultNutsWorkspaceConfigModel getConfigModel() {
        return this.wsModel.configModel;
    }

    public DefaultImportModel getImportModel() {
        return this.wsModel.importModel;
    }

    public static enum InstallStrategy0 implements NutsEnum
    {
        INSTALL,
        UPDATE,
        REQUIRE;

        private final String id = this.name().toLowerCase().replace('_', '-');

        public static InstallStrategy0 parse(String value, NutsSession session) {
            return InstallStrategy0.parse(value, null, session);
        }

        public static InstallStrategy0 parse(String value, InstallStrategy0 emptyValue, NutsSession session) {
            InstallStrategy0 v = InstallStrategy0.parseLenient(value, emptyValue, null);
            if (v == null && !NutsBlankable.isBlank((String)value)) {
                throw new NutsParseEnumException(session, value, InstallStrategy0.class);
            }
            return v;
        }

        public static InstallStrategy0 parseLenient(String value) {
            return InstallStrategy0.parseLenient(value, null);
        }

        public static InstallStrategy0 parseLenient(String value, InstallStrategy0 emptyOrErrorValue) {
            return InstallStrategy0.parseLenient(value, emptyOrErrorValue, emptyOrErrorValue);
        }

        public static InstallStrategy0 parseLenient(String value, InstallStrategy0 emptyValue, InstallStrategy0 errorValue) {
            if ((value = value == null ? "" : value.toUpperCase().trim().replace('-', '_')).isEmpty()) {
                return emptyValue;
            }
            try {
                return InstallStrategy0.valueOf(value.toUpperCase());
            }
            catch (Exception notFound) {
                return errorValue;
            }
        }

        public String id() {
            return this.id;
        }
    }
}

