/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.NutsWorkspaceOptionsFormat;
import net.thevpc.nuts.runtime.standalone.app.cmdline.CoreNutsArgumentsParser;
import net.thevpc.nuts.runtime.standalone.format.CoreNutsWorkspaceOptionsFormat;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public final class CoreNutsWorkspaceOptions
implements Serializable,
Cloneable,
NutsWorkspaceOptionsBuilder,
NutsWorkspaceOptions {
    private static final long serialVersionUID = 1L;
    private final List<String> outputFormatOptions = new ArrayList<String>();
    private String[] customOptions;
    private String apiVersion = null;
    private String runtimeId;
    private String javaCommand;
    private String javaOptions;
    private String workspace = null;
    private String outLinePrefix = null;
    private String errLinePrefix = null;
    private String name = null;
    private Boolean skipCompanions;
    private Boolean skipWelcome;
    private Boolean skipBoot;
    private Boolean global;
    private Boolean gui;
    private String[] excludedExtensions;
    private String[] repositories;
    private String userName = null;
    private char[] credentials = null;
    private NutsTerminalMode terminalMode = null;
    private Boolean readOnly;
    private Boolean trace;
    private String progressOptions = null;
    private String dependencySolver = null;
    private NutsLogConfig logConfig;
    private NutsConfirmationMode confirm = null;
    private NutsContentType outputFormat = null;
    private String[] applicationArguments;
    private NutsOpenMode openMode = NutsOpenMode.OPEN_OR_CREATE;
    private long creationTime;
    private Boolean dry;
    private Supplier<ClassLoader> classLoaderSupplier;
    private String[] executorOptions;
    private Boolean recover;
    private Boolean reset;
    private Boolean commandVersion;
    private Boolean commandHelp;
    private String debug;
    private Boolean inherited;
    private NutsExecutionType executionType;
    private NutsRunAs runAs = NutsRunAs.CURRENT_USER;
    private String archetype;
    private Boolean switchWorkspace;
    private Map<NutsStoreLocation, String> storeLocations = new HashMap<NutsStoreLocation, String>();
    private Map<NutsHomeLocation, String> homeLocations = new HashMap<NutsHomeLocation, String>();
    private NutsOsFamily storeLocationLayout = null;
    private NutsStoreLocationStrategy storeLocationStrategy = null;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy = null;
    private NutsFetchStrategy fetchStrategy = NutsFetchStrategy.ONLINE;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean bot;
    private InputStream stdin = null;
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private ExecutorService executorService = null;
    private Instant expireTime = null;
    private NutsMessage[] errors = new NutsMessage[0];
    private Boolean skipErrors;
    private String locale;
    private String theme;
    private NutsSession session;

    public CoreNutsWorkspaceOptions(NutsSession session) {
        this.session = session;
    }

    public NutsWorkspaceOptionsBuilder copy() {
        try {
            CoreNutsWorkspaceOptions t = (CoreNutsWorkspaceOptions)this.clone();
            t.logConfig = this.logConfig == null ? null : t.logConfig;
            t.storeLocations = new LinkedHashMap<NutsStoreLocation, String>(this.storeLocations);
            t.homeLocations = new LinkedHashMap<NutsHomeLocation, String>(this.homeLocations);
            t.setExcludedExtensions(t.getExcludedExtensions() == null ? null : Arrays.copyOf(t.getExcludedExtensions(), t.getExcludedExtensions().length));
            t.setRepositories(t.getRepositories() == null ? null : Arrays.copyOf(t.getRepositories(), t.getRepositories().length));
            t.setApplicationArguments(t.getApplicationArguments() == null ? null : Arrays.copyOf(t.getApplicationArguments(), t.getApplicationArguments().length));
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("should never Happen", e);
        }
    }

    public NutsWorkspaceOptionsFormat formatter() {
        return new CoreNutsWorkspaceOptionsFormat(this.session, this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public NutsWorkspaceOptionsBuilder setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String[] getApplicationArguments() {
        return this.applicationArguments == null ? new String[]{} : Arrays.copyOf(this.applicationArguments, this.applicationArguments.length);
    }

    public NutsWorkspaceOptionsBuilder setApplicationArguments(String[] applicationArguments) {
        this.applicationArguments = applicationArguments;
        return this;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public NutsWorkspaceOptionsBuilder setArchetype(String archetype) {
        this.archetype = archetype;
        return this;
    }

    public Supplier<ClassLoader> getClassLoaderSupplier() {
        return this.classLoaderSupplier;
    }

    public NutsWorkspaceOptionsBuilder setClassLoaderSupplier(Supplier<ClassLoader> provider) {
        this.classLoaderSupplier = provider;
        return this;
    }

    public NutsConfirmationMode getConfirm() {
        return this.confirm;
    }

    public NutsWorkspaceOptionsBuilder setConfirm(NutsConfirmationMode confirm) {
        this.confirm = confirm;
        return this;
    }

    public boolean isDry() {
        return this.dry != null && this.dry != false;
    }

    public Boolean getDry() {
        return this.dry;
    }

    public NutsWorkspaceOptionsBuilder setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public NutsWorkspaceOptionsBuilder setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String[] getExcludedExtensions() {
        return this.excludedExtensions;
    }

    public NutsWorkspaceOptionsBuilder setExcludedExtensions(String[] excludedExtensions) {
        this.excludedExtensions = excludedExtensions;
        return this;
    }

    public NutsExecutionType getExecutionType() {
        return this.executionType;
    }

    public NutsWorkspaceOptionsBuilder setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public NutsRunAs getRunAs() {
        return this.runAs;
    }

    public NutsWorkspaceOptionsBuilder setRunAs(NutsRunAs runAs) {
        this.runAs = runAs == null ? NutsRunAs.CURRENT_USER : runAs;
        return this;
    }

    public String[] getExecutorOptions() {
        return this.executorOptions == null ? new String[]{} : this.executorOptions;
    }

    public NutsWorkspaceOptionsBuilder setExecutorOptions(String[] executorOptions) {
        this.executorOptions = executorOptions;
        return this;
    }

    public String getHomeLocation(NutsHomeLocation location) {
        return this.homeLocations.get(location);
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        return new LinkedHashMap<NutsHomeLocation, String>(this.homeLocations);
    }

    public NutsWorkspaceOptionsBuilder setHomeLocations(Map<NutsHomeLocation, String> homeLocations) {
        this.homeLocations.clear();
        if (homeLocations != null) {
            this.homeLocations.putAll(homeLocations);
        }
        return this;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public NutsWorkspaceOptionsBuilder setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public NutsWorkspaceOptionsBuilder setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public NutsLogConfig getLogConfig() {
        return this.logConfig;
    }

    public NutsWorkspaceOptionsBuilder setLogConfig(NutsLogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NutsWorkspaceOptionsBuilder setName(String workspaceName) {
        this.name = workspaceName;
        return this;
    }

    public NutsOpenMode getOpenMode() {
        return this.openMode;
    }

    public NutsWorkspaceOptionsBuilder setOpenMode(NutsOpenMode openMode) {
        this.openMode = openMode;
        return this;
    }

    public NutsContentType getOutputFormat() {
        return this.outputFormat;
    }

    public NutsWorkspaceOptionsBuilder setOutputFormat(NutsContentType outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public String[] getOutputFormatOptions() {
        return this.outputFormatOptions.toArray(new String[0]);
    }

    public NutsWorkspaceOptionsBuilder setOutputFormatOptions(String ... options) {
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    public char[] getCredentials() {
        return this.credentials;
    }

    public NutsWorkspaceOptionsBuilder setCredentials(char[] credentials) {
        this.credentials = credentials;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public NutsWorkspaceOptionsBuilder setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public NutsWorkspaceOptionsBuilder setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public String getStoreLocation(NutsStoreLocation folder) {
        return this.storeLocations.get(folder.id());
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        return new LinkedHashMap<NutsStoreLocation, String>(this.storeLocations);
    }

    public NutsWorkspaceOptionsBuilder setStoreLocations(Map<NutsStoreLocation, String> storeLocations) {
        this.storeLocations.clear();
        if (storeLocations != null) {
            this.storeLocations.putAll(storeLocations);
        }
        return this;
    }

    public NutsTerminalMode getTerminalMode() {
        return this.terminalMode;
    }

    public NutsWorkspaceOptionsBuilder setTerminalMode(NutsTerminalMode terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    public String[] getRepositories() {
        return this.repositories == null ? new String[]{} : this.repositories;
    }

    public NutsWorkspaceOptionsBuilder setRepositories(String[] repositories) {
        this.repositories = repositories;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public NutsWorkspaceOptionsBuilder setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public String getDebug() {
        return this.debug;
    }

    public NutsWorkspaceOptionsBuilder setDebug(String debug) {
        this.debug = debug;
        return this;
    }

    public boolean isGlobal() {
        return this.global != null && this.global != false;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public NutsWorkspaceOptionsBuilder setGlobal(Boolean global) {
        this.global = global;
        return this;
    }

    public boolean isGui() {
        return this.gui != null && this.gui != false;
    }

    public Boolean getGui() {
        return this.gui;
    }

    public NutsWorkspaceOptionsBuilder setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    public boolean isInherited() {
        return this.inherited != null && this.inherited != false;
    }

    public Boolean getInherited() {
        return this.inherited;
    }

    public NutsWorkspaceOptionsBuilder setInherited(Boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public NutsWorkspaceOptionsBuilder setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isRecover() {
        return this.recover != null && this.recover != false;
    }

    public Boolean getRecover() {
        return this.recover;
    }

    public NutsWorkspaceOptionsBuilder setRecover(Boolean recover) {
        this.recover = recover;
        return this;
    }

    public boolean isReset() {
        return this.reset != null && this.reset != false;
    }

    public Boolean getReset() {
        return this.reset;
    }

    public NutsWorkspaceOptionsBuilder setReset(Boolean reset) {
        this.reset = reset;
        return this;
    }

    public boolean isCommandVersion() {
        return this.commandVersion != null && this.commandVersion != false;
    }

    public Boolean getCommandVersion() {
        return this.commandVersion;
    }

    public NutsWorkspaceOptionsBuilder setCommandVersion(Boolean version) {
        this.commandVersion = version;
        return this;
    }

    public boolean isCommandHelp() {
        return this.commandHelp != null && this.commandHelp != false;
    }

    public Boolean getCommandHelp() {
        return this.commandHelp;
    }

    public NutsWorkspaceOptionsBuilder setCommandHelp(Boolean help) {
        this.commandHelp = help;
        return this;
    }

    public boolean isSkipCompanions() {
        return this.skipCompanions != null && this.skipCompanions != false;
    }

    public Boolean getSkipCompanions() {
        return this.skipCompanions;
    }

    public NutsWorkspaceOptionsBuilder setSkipCompanions(Boolean skipInstallCompanions) {
        this.skipCompanions = skipInstallCompanions;
        return this;
    }

    public boolean isSkipWelcome() {
        return this.skipWelcome != null && this.skipWelcome != false;
    }

    public Boolean getSkipWelcome() {
        return this.skipWelcome;
    }

    public NutsWorkspaceOptionsBuilder setSkipWelcome(Boolean skipWelcome) {
        this.skipWelcome = skipWelcome;
        return this;
    }

    public String getOutLinePrefix() {
        return this.outLinePrefix;
    }

    public NutsWorkspaceOptionsBuilder setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    public String getErrLinePrefix() {
        return this.errLinePrefix;
    }

    public NutsWorkspaceOptionsBuilder setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    public boolean isSkipBoot() {
        return this.skipBoot != null && this.skipBoot != false;
    }

    public Boolean getSkipBoot() {
        return this.skipBoot;
    }

    public NutsWorkspaceOptionsBuilder setSkipBoot(Boolean skipBoot) {
        this.skipBoot = skipBoot;
        return this;
    }

    public boolean isTrace() {
        return this.trace == null || this.trace != false;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public NutsWorkspaceOptionsBuilder setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    public String getProgressOptions() {
        return this.progressOptions;
    }

    public NutsWorkspaceOptionsBuilder setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    public boolean isCached() {
        return this.cached == null || this.cached != false;
    }

    public Boolean getCached() {
        return this.cached;
    }

    public NutsWorkspaceOptionsBuilder setCached(Boolean cached) {
        this.cached = cached;
        return this;
    }

    public boolean isIndexed() {
        return this.indexed == null || this.indexed != false;
    }

    public Boolean getIndexed() {
        return this.indexed;
    }

    public NutsWorkspaceOptionsBuilder setIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public boolean isTransitive() {
        return this.transitive == null || this.transitive != false;
    }

    public Boolean getTransitive() {
        return this.transitive;
    }

    public NutsWorkspaceOptionsBuilder setTransitive(Boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public boolean isBot() {
        return this.bot != null && this.bot != false;
    }

    public Boolean getBot() {
        return this.bot;
    }

    public NutsWorkspaceOptionsBuilder setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    public NutsFetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    public NutsWorkspaceOptionsBuilder setFetchStrategy(NutsFetchStrategy fetchStrategy) {
        this.fetchStrategy = fetchStrategy == null ? NutsFetchStrategy.ONLINE : fetchStrategy;
        return this;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public NutsWorkspaceOptionsBuilder setStdin(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public NutsWorkspaceOptionsBuilder setStdout(PrintStream stdout) {
        this.stdout = stdout;
        return this;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public NutsWorkspaceOptionsBuilder setStderr(PrintStream stderr) {
        this.stderr = stderr;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public NutsWorkspaceOptionsBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public NutsWorkspaceOptionsBuilder setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public boolean isSkipErrors() {
        return this.skipErrors != null && this.skipErrors != false;
    }

    public Boolean getSkipErrors() {
        return this.skipErrors;
    }

    public NutsWorkspaceOptionsBuilder setSkipErrors(Boolean value) {
        this.skipErrors = value;
        return this;
    }

    public boolean isSwitchWorkspace() {
        return this.switchWorkspace != null && this.switchWorkspace != false;
    }

    public Boolean getSwitchWorkspace() {
        return this.switchWorkspace;
    }

    public NutsWorkspaceOptionsBuilder setSwitchWorkspace(Boolean switchWorkspace) {
        this.switchWorkspace = switchWorkspace;
        return this;
    }

    public NutsMessage[] getErrors() {
        return Arrays.copyOf(this.errors, this.errors.length);
    }

    public NutsWorkspaceOptionsBuilder setErrors(NutsMessage[] errors) {
        this.errors = errors == null ? new NutsMessage[]{} : Arrays.copyOf(errors, errors.length);
        return this;
    }

    public String[] getCustomOptions() {
        return this.customOptions == null ? new String[]{} : this.customOptions;
    }

    public NutsWorkspaceOptionsBuilder setCustomOptions(String[] properties) {
        this.customOptions = properties == null ? new String[]{} : properties;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public NutsWorkspaceOptionsBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getTheme() {
        return this.theme;
    }

    public NutsWorkspaceOptionsBuilder setTheme(String theme) {
        this.theme = theme;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setAll(NutsBootOptions other) {
        this.setApiVersion(other.getApiVersion());
        this.setRuntimeId(other.getRuntimeId());
        this.setJavaCommand(other.getJavaCommand());
        this.setJavaOptions(other.getJavaOptions());
        this.setWorkspace(other.getWorkspace());
        this.setName(other.getName());
        this.setSkipCompanions(other.getSkipCompanions());
        this.setSkipWelcome(other.getSkipWelcome());
        this.setSkipBoot(other.getSkipBoot());
        this.setGlobal(other.getGlobal());
        this.setGui(other.getGui());
        this.setUsername(other.getUserName());
        this.setCredentials(other.getCredentials());
        this.setTerminalMode(other.getTerminalMode());
        this.setReadOnly(other.getReadOnly());
        this.setTrace(other.getTrace());
        this.setProgressOptions(other.getProgressOptions());
        this.setLogConfig(other.getLogConfig() == null ? null : new NutsLogConfig(other.getLogConfig()));
        this.setConfirm(other.getConfirm());
        this.setConfirm(other.getConfirm());
        this.setOutputFormat(other.getOutputFormat());
        this.setOutputFormatOptions(other.getOutputFormatOptions());
        this.setOpenMode(other.getOpenMode());
        this.setCreationTime(other.getCreationTime());
        this.setDry(other.getDry());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier());
        this.setExecutorOptions(other.getExecutorOptions());
        this.setRecover(other.getRecover());
        this.setReset(other.getReset());
        this.setCommandVersion(other.getCommandVersion());
        this.setCommandHelp(other.getCommandHelp());
        this.setDebug(other.getDebug());
        this.setInherited(other.getInherited());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        this.setArchetype(other.getArchetype());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setHomeLocations(other.getHomeLocations());
        this.setStoreLocations(other.getStoreLocations());
        this.setStoreLocationLayout(other.getStoreLocationLayout());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setRepositoryStoreLocationStrategy(other.getRepositoryStoreLocationStrategy());
        this.setFetchStrategy(other.getFetchStrategy());
        this.setCached(other.getCached());
        this.setIndexed(other.getIndexed());
        this.setTransitive(other.getTransitive());
        this.setBot(other.getBot());
        this.setStdin(other.getStdin());
        this.setStdout(other.getStdout());
        this.setStderr(other.getStderr());
        this.setExecutorService(other.getExecutorService());
        this.setExcludedExtensions(other.getExcludedExtensions() == null ? null : Arrays.copyOf(other.getExcludedExtensions(), other.getExcludedExtensions().length));
        this.setRepositories(other.getRepositories() == null ? null : Arrays.copyOf(other.getRepositories(), other.getRepositories().length));
        this.setApplicationArguments(other.getApplicationArguments() == null ? null : Arrays.copyOf(other.getApplicationArguments(), other.getApplicationArguments().length));
        this.setCustomOptions(other.getCustomOptions() == null ? null : Arrays.copyOf(other.getCustomOptions(), other.getCustomOptions().length));
        this.setExpireTime(other.getExpireTime());
        this.setErrors(other.getErrors());
        this.setSkipErrors(other.getSkipErrors());
        this.setSwitchWorkspace(other.getSwitchWorkspace());
        this.setLocale(other.getLocale());
        this.setTheme(other.getTheme());
        this.setDependencySolver(other.getDependencySolver());
        return this;
    }

    public NutsWorkspaceOptionsBuilder setAll(NutsWorkspaceOptions other) {
        this.setApiVersion(other.getApiVersion());
        this.setRuntimeId(other.getRuntimeId());
        this.setJavaCommand(other.getJavaCommand());
        this.setJavaOptions(other.getJavaOptions());
        this.setWorkspace(other.getWorkspace());
        this.setName(other.getName());
        this.setSkipCompanions(other.getSkipCompanions());
        this.setSkipWelcome(other.getSkipWelcome());
        this.setSkipBoot(other.getSkipBoot());
        this.setGlobal(other.getGlobal());
        this.setGui(other.getGui());
        this.setUsername(other.getUserName());
        this.setCredentials(other.getCredentials());
        this.setTerminalMode(other.getTerminalMode());
        this.setReadOnly(other.getReadOnly());
        this.setTrace(other.getTrace());
        this.setProgressOptions(other.getProgressOptions());
        this.setLogConfig(other.getLogConfig() == null ? null : new NutsLogConfig(other.getLogConfig()));
        this.setConfirm(other.getConfirm());
        this.setConfirm(other.getConfirm());
        this.setOutputFormat(other.getOutputFormat());
        this.setOutputFormatOptions(other.getOutputFormatOptions());
        this.setOpenMode(other.getOpenMode());
        this.setCreationTime(other.getCreationTime());
        this.setDry(other.getDry());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier());
        this.setExecutorOptions(other.getExecutorOptions());
        this.setRecover(other.getRecover());
        this.setReset(other.getReset());
        this.setCommandVersion(other.getCommandVersion());
        this.setCommandHelp(other.getCommandHelp());
        this.setDebug(other.getDebug());
        this.setInherited(other.getInherited());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        this.setArchetype(other.getArchetype());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setHomeLocations(other.getHomeLocations());
        this.setStoreLocations(other.getStoreLocations());
        this.setStoreLocationLayout(other.getStoreLocationLayout());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setRepositoryStoreLocationStrategy(other.getRepositoryStoreLocationStrategy());
        this.setFetchStrategy(other.getFetchStrategy());
        this.setCached(other.getCached());
        this.setIndexed(other.getIndexed());
        this.setTransitive(other.getTransitive());
        this.setBot(other.getBot());
        this.setStdin(other.getStdin());
        this.setStdout(other.getStdout());
        this.setStderr(other.getStderr());
        this.setExecutorService(other.getExecutorService());
        this.setExcludedExtensions(other.getExcludedExtensions() == null ? null : Arrays.copyOf(other.getExcludedExtensions(), other.getExcludedExtensions().length));
        this.setRepositories(other.getRepositories() == null ? null : Arrays.copyOf(other.getRepositories(), other.getRepositories().length));
        this.setApplicationArguments(other.getApplicationArguments() == null ? null : Arrays.copyOf(other.getApplicationArguments(), other.getApplicationArguments().length));
        this.setCustomOptions(other.getCustomOptions() == null ? null : Arrays.copyOf(other.getCustomOptions(), other.getCustomOptions().length));
        this.setExpireTime(other.getExpireTime());
        this.setErrors(other.getErrors());
        this.setSkipErrors(other.getSkipErrors());
        this.setSwitchWorkspace(other.getSwitchWorkspace());
        this.setLocale(other.getLocale());
        this.setTheme(other.getTheme());
        this.setDependencySolver(other.getDependencySolver());
        return this;
    }

    public NutsWorkspaceOptionsBuilder parseCommandLine(String commandLine) {
        return this.parseArguments(NutsCommandLine.of((String)commandLine, (NutsShellFamily)NutsShellFamily.SH, (NutsSession)this.session).toStringArray());
    }

    public NutsWorkspaceOptionsBuilder parseArguments(String[] args) {
        CoreNutsArgumentsParser.parseNutsArguments(this.session, args, this);
        return this;
    }

    public NutsWorkspaceOptionsBuilder setUsername(String username) {
        this.userName = username;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocation(NutsStoreLocation location, String value) {
        if (NutsBlankable.isBlank((String)value)) {
            this.storeLocations.remove(location);
        } else {
            this.storeLocations.put(location, value);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setHomeLocation(NutsHomeLocation location, String value) {
        if (NutsBlankable.isBlank((String)value)) {
            this.homeLocations.remove(location);
        } else {
            this.homeLocations.put(location, value);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (option == null || (option = NutsUtilStrings.trim((String)option)).isEmpty()) continue;
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    public NutsWorkspaceOptions build() {
        CoreNutsWorkspaceOptions c = new CoreNutsWorkspaceOptions(this.session);
        c.setAll(this);
        return c;
    }

    public String getDependencySolver() {
        return this.dependencySolver;
    }

    public NutsWorkspaceOptionsBuilder setDependencySolver(String dependencySolver) {
        this.dependencySolver = dependencySolver;
        return this;
    }

    public String toString() {
        return this.formatter().getBootCommandLine().toString();
    }

    public void setSession(NutsSession session) {
        this.session = session;
    }

    public NutsWorkspaceOptionsBuilder builder() {
        return new CoreNutsWorkspaceOptions(this.session).setAll(this);
    }

    public NutsBootOptions toBootOptions() {
        NutsBootOptions b = new NutsBootOptions();
        b.setApiVersion(this.getApiVersion());
        b.setRuntimeId(this.getRuntimeId());
        b.setJavaCommand(this.getJavaCommand());
        b.setJavaOptions(this.getJavaOptions());
        b.setWorkspace(this.getWorkspace());
        b.setName(this.getName());
        b.setSkipCompanions(this.getSkipCompanions());
        b.setSkipWelcome(this.getSkipWelcome());
        b.setSkipBoot(this.getSkipBoot());
        b.setGlobal(this.getGlobal());
        b.setGui(this.getGui());
        b.setUsername(this.getUserName());
        b.setCredentials(this.getCredentials());
        b.setTerminalMode(this.getTerminalMode());
        b.setReadOnly(this.getReadOnly());
        b.setTrace(this.getTrace());
        b.setProgressOptions(this.getProgressOptions());
        b.setLogConfig(this.getLogConfig() == null ? null : new NutsLogConfig(this.getLogConfig()));
        b.setConfirm(this.getConfirm());
        b.setConfirm(this.getConfirm());
        b.setOutputFormat(this.getOutputFormat());
        b.setOutputFormatOptions(this.getOutputFormatOptions());
        b.setOpenMode(this.getOpenMode());
        b.setCreationTime(this.getCreationTime());
        b.setDry(this.getDry());
        b.setClassLoaderSupplier(this.getClassLoaderSupplier());
        b.setExecutorOptions(this.getExecutorOptions());
        b.setRecover(this.getRecover());
        b.setReset(this.getReset());
        b.setCommandVersion(this.getCommandVersion());
        b.setCommandHelp(this.getCommandHelp());
        b.setDebug(this.getDebug());
        b.setInherited(this.getInherited());
        b.setExecutionType(this.getExecutionType());
        b.setRunAs(this.getRunAs());
        b.setArchetype(this.getArchetype());
        b.setStoreLocationStrategy(this.getStoreLocationStrategy());
        b.setHomeLocations(this.getHomeLocations());
        b.setStoreLocations(this.getStoreLocations());
        b.setStoreLocationLayout(this.getStoreLocationLayout());
        b.setStoreLocationStrategy(this.getStoreLocationStrategy());
        b.setRepositoryStoreLocationStrategy(this.getRepositoryStoreLocationStrategy());
        b.setFetchStrategy(this.getFetchStrategy());
        b.setCached(this.getCached());
        b.setIndexed(this.getIndexed());
        b.setTransitive(this.getTransitive());
        b.setBot(this.getBot());
        b.setStdin(this.getStdin());
        b.setStdout(this.getStdout());
        b.setStderr(this.getStderr());
        b.setExecutorService(this.getExecutorService());
        b.setExcludedExtensions(this.getExcludedExtensions() == null ? null : Arrays.copyOf(this.getExcludedExtensions(), this.getExcludedExtensions().length));
        b.setRepositories(this.getRepositories() == null ? null : Arrays.copyOf(this.getRepositories(), this.getRepositories().length));
        b.setApplicationArguments(this.getApplicationArguments() == null ? null : Arrays.copyOf(this.getApplicationArguments(), this.getApplicationArguments().length));
        b.setCustomOptions(this.getCustomOptions() == null ? null : Arrays.copyOf(this.getCustomOptions(), this.getCustomOptions().length));
        b.setExpireTime(this.getExpireTime());
        b.setErrors(this.getErrors());
        b.setSkipErrors(this.getSkipErrors());
        b.setSwitchWorkspace(this.getSwitchWorkspace());
        b.setLocale(this.getLocale());
        b.setTheme(this.getTheme());
        b.setDependencySolver(this.getDependencySolver());
        return b;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

