/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.security.ReadOnlyNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsWorkspaceOptions;
import net.thevpc.nuts.spi.NutsBootDescriptor;
import net.thevpc.nuts.spi.NutsBootId;
import net.thevpc.nuts.spi.NutsBootWorkspaceFactory;

public final class CoreNutsBootOptions {
    private ReadOnlyNutsWorkspaceOptions options;
    private String apiVersion;
    private NutsBootId runtimeId;
    private NutsBootDescriptor runtimeBootDescriptor;
    private NutsClassLoaderNode runtimeBootDependencyNode;
    private NutsBootDescriptor[] extensionBootDescriptors;
    private NutsClassLoaderNode[] extensionBootDependencyNodes;
    private NutsBootWorkspaceFactory bootWorkspaceFactory;
    private URL[] bootClassWorldURLs;
    private ClassLoader workspaceClassLoader;
    private String uuid;
    private String name;
    private String workspace;
    private LinkedHashSet<String> extensionsSet;
    private String bootRepositories;
    private String javaCommand;
    private String javaOptions;
    private NutsStoreLocationStrategy storeLocationStrategy;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy;
    private NutsOsFamily storeLocationLayout;
    private boolean global;
    private Map<NutsStoreLocation, String> storeLocations;
    private Map<NutsHomeLocation, String> homeLocations;
    private NutsSession session;
    private NutsWorkspace ws;

    public CoreNutsBootOptions(NutsBootOptions boot, NutsWorkspace ws, NutsSession session) {
        this.ws = ws;
        this.session = session;
        CoreNutsWorkspaceOptions optionsBuilder = new CoreNutsWorkspaceOptions(session);
        optionsBuilder.setAll(boot);
        this.options = new ReadOnlyNutsWorkspaceOptions(optionsBuilder.build(), session);
        this.apiVersion = boot.getApiVersion();
        this.runtimeId = NutsBootId.parse((String)boot.getRuntimeId());
        this.runtimeBootDescriptor = boot.getRuntimeBootDescriptor();
        this.runtimeBootDependencyNode = boot.getRuntimeBootDependencyNode();
        this.extensionBootDescriptors = boot.getExtensionBootDescriptors();
        this.extensionBootDependencyNodes = boot.getExtensionBootDependencyNodes();
        this.bootWorkspaceFactory = boot.getBootWorkspaceFactory();
        this.bootClassWorldURLs = boot.getClassWorldURLs();
        this.workspaceClassLoader = boot.getClassWorldLoader();
        this.uuid = boot.getUuid();
        this.name = boot.getName();
        this.workspace = boot.getWorkspace();
        this.extensionsSet = boot.getExtensionsSet() == null ? new LinkedHashSet() : new LinkedHashSet(boot.getExtensionsSet());
        this.bootRepositories = boot.getBootRepositories();
        this.javaCommand = boot.getJavaCommand();
        this.javaOptions = boot.getJavaOptions();
        this.storeLocationStrategy = boot.getStoreLocationStrategy();
        this.repositoryStoreLocationStrategy = boot.getRepositoryStoreLocationStrategy();
        this.storeLocationLayout = boot.getStoreLocationLayout();
        this.global = boot.isGlobal();
        this.storeLocations = boot.getStoreLocations() == null ? new LinkedHashMap<NutsStoreLocation, String>() : new LinkedHashMap(boot.getStoreLocations());
        this.homeLocations = boot.getHomeLocations() == null ? new LinkedHashMap<NutsHomeLocation, String>() : new LinkedHashMap(boot.getHomeLocations());
    }

    public NutsWorkspaceOptions getOptions() {
        return this.options;
    }

    public String getWorkspaceLocation() {
        return this.workspace;
    }

    public CoreNutsBootOptions setWorkspaceLocation(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public CoreNutsBootOptions setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public NutsBootId getRuntimeId() {
        return this.runtimeId;
    }

    public CoreNutsBootOptions setRuntimeId(NutsBootId runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public NutsBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public CoreNutsBootOptions setRuntimeBootDescriptor(NutsBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public NutsBootDescriptor[] getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public CoreNutsBootOptions setExtensionBootDescriptors(NutsBootDescriptor[] extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public CoreNutsBootOptions setBootRepositories(String repositories) {
        this.bootRepositories = repositories;
        return this;
    }

    public NutsBootWorkspaceFactory getBootWorkspaceFactory() {
        return this.bootWorkspaceFactory;
    }

    public CoreNutsBootOptions setBootWorkspaceFactory(NutsBootWorkspaceFactory bootWorkspaceFactory) {
        this.bootWorkspaceFactory = bootWorkspaceFactory;
        return this;
    }

    public URL[] getClassWorldURLs() {
        return this.bootClassWorldURLs;
    }

    public ClassLoader getClassWorldLoader() {
        return this.workspaceClassLoader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getApiId() {
        return "net.thevpc.nuts:nuts#" + this.apiVersion;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public CoreNutsBootOptions setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public CoreNutsBootOptions setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public CoreNutsBootOptions setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public CoreNutsBootOptions setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public CoreNutsBootOptions setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public String getStoreLocation(NutsStoreLocation location) {
        Map<NutsStoreLocation, String> s = this.storeLocations;
        if (s != null) {
            return s.get(location);
        }
        return null;
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        return this.storeLocations;
    }

    public void setStoreLocations(Map<NutsStoreLocation, String> storeLocations) {
        this.storeLocations = storeLocations;
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        return this.homeLocations;
    }

    public void setHomeLocations(Map<NutsHomeLocation, String> homeLocations) {
        this.homeLocations = homeLocations;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Set<String> getExtensionsSet() {
        return this.extensionsSet;
    }

    public void setExtensionsSet(Set<String> extensionsSet) {
        this.extensionsSet = extensionsSet == null ? new LinkedHashSet() : new LinkedHashSet<String>(extensionsSet);
    }

    public NutsClassLoaderNode getRuntimeBootDependencyNode() {
        return this.runtimeBootDependencyNode;
    }

    public CoreNutsBootOptions setRuntimeBootDependencyNode(NutsClassLoaderNode runtimeBootDependencyNode) {
        this.runtimeBootDependencyNode = runtimeBootDependencyNode;
        return this;
    }

    public NutsClassLoaderNode[] getExtensionBootDependencyNodes() {
        return this.extensionBootDependencyNodes;
    }

    public CoreNutsBootOptions setExtensionBootDependencyNodes(NutsClassLoaderNode[] extensionBootDependencyNodes) {
        this.extensionBootDependencyNodes = extensionBootDependencyNodes;
        return this;
    }

    public CoreNutsBootOptions setBootClassWorldURLs(URL[] bootClassWorldURLs) {
        this.bootClassWorldURLs = bootClassWorldURLs;
        return this;
    }

    public CoreNutsBootOptions setWorkspaceClassLoader(ClassLoader workspaceClassLoader) {
        this.workspaceClassLoader = workspaceClassLoader;
        return this;
    }

    public String getCacheBoot() {
        return this.getStoreLocation(NutsStoreLocation.CACHE) + File.separator + "id";
    }

    public String getLib() {
        return this.getStoreLocation(NutsStoreLocation.LIB) + File.separator + "id";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("NutsBootConfig{");
        if (!NutsBlankable.isBlank((String)this.apiVersion)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("apiVersion='").append(this.apiVersion).append('\'');
        }
        if (this.runtimeId != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeId='").append(this.runtimeId).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.bootRepositories)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("bootRepositories='").append(this.bootRepositories).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.javaCommand)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaCommand='").append(this.javaCommand).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.javaOptions)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaOptions='").append(this.javaOptions).append('\'');
        }
        if (!NutsBlankable.isBlank((String)this.workspace)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("workspace='").append(this.workspace).append('\'');
        }
        if (this.storeLocations != null && !this.storeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocations=").append(this.storeLocations);
        }
        if (this.homeLocations != null && !this.homeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("homeLocations=").append(this.homeLocations);
        }
        if (this.storeLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationStrategy=").append(this.storeLocationStrategy);
        }
        if (this.repositoryStoreLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("repositoryStoreLocationStrategy=").append(this.repositoryStoreLocationStrategy);
        }
        if (this.storeLocationLayout != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationLayout=").append(this.storeLocationLayout);
        }
        if (this.global) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("global");
        }
        sb.append('}');
        return sb.toString();
    }
}

